/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.yst.production.sale.service.shop;

import cn.hutool.core.lang.Assert;
import com.alibaba.fastjson.JSON;
import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.cloudt.common.annotation.SysCodeProc;
import com.elitescloud.cloudt.common.base.ApiCode;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.external.nuonuo.core.dto.req.BillingNewInvoiceDetailReqDTO;
import com.elitesland.external.nuonuo.core.dto.req.BillingNewOrderReqDTO;
import com.elitesland.external.nuonuo.core.dto.req.BillingNewReqDTO;
import com.elitesland.external.nuonuo.core.dto.resp.QueryInvoiceResultRespDTO;
import com.elitesland.yst.production.sale.api.dto.BipInvItemDTO;
import com.elitesland.yst.production.sale.api.service.ComSaleFileInfoService;
import com.elitesland.yst.production.sale.api.service.PriSalePriceService;
import com.elitesland.yst.production.sale.api.service.shop.BipCompanyManageService;
import com.elitesland.yst.production.sale.api.service.shop.BipCustUserBindService;
import com.elitesland.yst.production.sale.api.service.shop.BipInvService;
import com.elitesland.yst.production.sale.api.service.shop.BipOrderDService;
import com.elitesland.yst.production.sale.api.service.shop.BipOrderService;
import com.elitesland.yst.production.sale.api.vo.param.shop.BipInvCreateParam;
import com.elitesland.yst.production.sale.api.vo.param.shop.BipInvQueryParam;
import com.elitesland.yst.production.sale.api.vo.param.shop.BipInvViewAndDownParam;
import com.elitesland.yst.production.sale.api.vo.resp.com.ComSaleFileComVO;
import com.elitesland.yst.production.sale.api.vo.resp.shop.BipInvVO;
import com.elitesland.yst.production.sale.common.model.CurrentUserDTO;
import com.elitesland.yst.production.sale.convert.shop.BipInvConvert;
import com.elitesland.yst.production.sale.core.service.BaseServiceImpl;
import com.elitesland.yst.production.sale.core.service.UserService;
import com.elitesland.yst.production.sale.entity.BipInvDO;
import com.elitesland.yst.production.sale.entity.BipOrderDO;
import com.elitesland.yst.production.sale.entity.QBipInvDO;
import com.elitesland.yst.production.sale.repo.SalInvApplydRepoProc;
import com.elitesland.yst.production.sale.repo.shop.BipInvRepo;
import com.elitesland.yst.production.sale.repo.shop.BipInvRepoProc;
import com.elitesland.yst.production.sale.repo.shop.BipOrderDRepo;
import com.elitesland.yst.production.sale.repo.shop.BipOrderRepo;
import com.elitesland.yst.production.sale.rmi.ystorder.RmiOrderSalSoDService;
import com.elitesland.yst.production.sale.rmi.ystsupport.RmiOrgOuService;
import com.elitesland.yst.production.sale.rmi.ystsystem.RmiSettingService;
import com.elitesland.yst.production.sale.rmi.ystsystem.RmiSysNextNumberService;
import com.elitesland.yst.production.support.provider.org.dto.OrgOuRpcDTO;
import com.elitesland.yst.production.support.provider.org.service.OrgEmpRpcService;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.core.types.dsl.BooleanExpression;
import com.querydsl.jpa.impl.JPAQuery;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.domain.PageRequest;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

@Service
public class BipInvServiceImpl
extends BaseServiceImpl
implements BipInvService {
    private static final Logger log = LoggerFactory.getLogger(BipInvServiceImpl.class);
    private final BipInvRepo bipInvRepo;
    private final BipInvRepoProc bipInvRepoProc;
    private final PriSalePriceService priSalePriceService;
    private final BipOrderDService bipOrderDService;
    private final RmiOrgOuService rmiOrgOuService;
    private final BipOrderService bipOrderService;
    private static final QBipInvDO qBipInvDO = QBipInvDO.bipInvDO;
    private final RmiSysNextNumberService rmiSysNextNumberService;
    private final ComSaleFileInfoService comSaleFileInfoService;
    private final BipOrderDRepo bipOrderDRepo;
    private final BipOrderRepo bipOrderRepo;
    private final BipCustUserBindService bipCustUserBindService;
    private final BipCompanyManageService bipCompanyManageService;
    private final OrgEmpRpcService orgEmpRpcService;
    private final String taxnum = "339901999999516";
    private final RmiOrderSalSoDService rmiOrderSalSoDService;
    private final SalInvApplydRepoProc salInvApplydRepoProc;
    private final RmiSettingService rmiSettingService;

    @Transactional(rollbackFor={Exception.class})
    public ApiResult<List<String>> createInv(BipInvCreateParam param) {
        return null;
    }

    @Transactional(rollbackFor={Exception.class})
    public ApiResult<List<QueryInvoiceResultRespDTO.QueryInvoiceResultResultDTO>> nuoNuoEleQueryInvoiceResult(List<String> serialNos, List<BipInvDO> bipInvDOS) {
        Long ouId = this.queryItemByOrderId(bipInvDOS.get(0).getOrderId());
        ArrayList<Long> ouIds = new ArrayList<Long>();
        ouIds.add(ouId);
        List<OrgOuRpcDTO> ouDtoList = this.rmiOrgOuService.findOuDtoList(ouIds, null);
        if (CollectionUtils.isEmpty(ouDtoList)) {
            throw new BusinessException("\u9500\u552e\u65b9\u516c\u53f8\u6570\u636e\u672a\u627e\u5230,\u8bf7\u68c0\u67e5!!!");
        }
        String taxerCode = ouDtoList.get(0).getTaxerCode();
        ArrayList paperPdUrls = new ArrayList();
        return ApiResult.ok(null);
    }

    @SysCodeProc
    private List<BillingNewReqDTO> suppleBillInformation(BipInvCreateParam param) {
        BillingNewReqDTO billingNewReqDTO = new BillingNewReqDTO();
        List<BipInvItemDTO> bipInvItemFromOrderD = this.queryItemNumByOrderID(param.getOrderId());
        this.addFareItem(bipInvItemFromOrderD, param.getOrderId());
        List skuCodes = bipInvItemFromOrderD.stream().map(BipInvItemDTO::getSkuCode).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(skuCodes)) {
            throw new BusinessException("\u8be5\u8ba2\u5355\u5546\u54c1\u6ca1\u6709skuCodes");
        }
        Long ouId = this.queryItemByOrderId(param.getOrderId());
        Optional orderOPT = this.bipOrderRepo.findById(param.getOrderId());
        if (!orderOPT.isPresent()) {
            throw new BusinessException("\u8ba2\u5355\u4e0d\u5b58\u5728");
        }
        BillingNewOrderReqDTO billingNewOrderReqDTO = new BillingNewOrderReqDTO();
        ArrayList<Long> ouIds = new ArrayList<Long>();
        ouIds.add(ouId);
        List<OrgOuRpcDTO> ouDtoList = this.rmiOrgOuService.findOuDtoList(ouIds, null);
        if (CollectionUtils.isEmpty(ouDtoList)) {
            throw new BusinessException("\u9500\u552e\u65b9\u516c\u53f8\u6570\u636e\u672a\u627e\u5230,\u8bf7\u68c0\u67e5!!!");
        }
        OrgOuRpcDTO orgOuRpcDTO = ouDtoList.get(0);
        billingNewOrderReqDTO.setOrderNo(((BipOrderDO)orderOPT.get()).getDocNo());
        billingNewOrderReqDTO.setPushMode(param.getPushMode());
        billingNewOrderReqDTO.setBuyerPhone(param.getBuyerPhone());
        billingNewOrderReqDTO.setEmail(param.getEmail());
        billingNewOrderReqDTO.setBuyerName(param.getInvTitle());
        if (!StringUtils.isEmpty((Object)param.getTaxNo())) {
            billingNewOrderReqDTO.setBuyerTaxNum(param.getTaxNo());
            billingNewOrderReqDTO.setBuyerTel(param.getCompanyTel());
            billingNewOrderReqDTO.setBuyerAddress(param.getCompanyAddress());
            billingNewOrderReqDTO.setBuyerAccount(param.getBank() + param.getBankAccount());
        }
        billingNewOrderReqDTO.setSalerTaxNum(orgOuRpcDTO.getTaxerCode());
        billingNewOrderReqDTO.setSalerAccount(orgOuRpcDTO.getInvBankAcc());
        billingNewOrderReqDTO.setSalerTel(orgOuRpcDTO.getInvPicPhone());
        billingNewOrderReqDTO.setSalerAddress(orgOuRpcDTO.getInvAddress());
        billingNewOrderReqDTO.setClerk(orgOuRpcDTO.getInvPicName());
        billingNewOrderReqDTO.setInvoiceType("1");
        billingNewOrderReqDTO.setInvoiceLine(param.getInvoiceLine());
        billingNewOrderReqDTO.setInvoiceDate(param.getOrderTime().format(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss")));
        ArrayList<BillingNewReqDTO> billingNewReqDTOS = new ArrayList<BillingNewReqDTO>();
        List<BillingNewInvoiceDetailReqDTO> billingNewInvoiceDetailReqDTOS = this.buildInvoiceDetail(bipInvItemFromOrderD);
        log.info("\u8bfa\u8bfa\u5f00\u7968\u53d1\u7968\u660e\u7ec6" + JSON.toJSONString(billingNewInvoiceDetailReqDTOS));
        Assert.notNull((Object)param.getInvMultipleTax(), (String)"\u7a0e\u7387\u5206\u7ec4\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        if (param.getInvMultipleTax() == 1) {
            billingNewOrderReqDTO.setInvoiceDetail(billingNewInvoiceDetailReqDTOS);
            billingNewReqDTO.setOrder(billingNewOrderReqDTO);
            billingNewReqDTOS.add(billingNewReqDTO);
        } else {
            Map<String, List<BillingNewInvoiceDetailReqDTO>> stringListMap = billingNewInvoiceDetailReqDTOS.stream().collect(Collectors.groupingBy(BillingNewInvoiceDetailReqDTO::getTaxRate));
            for (String key : stringListMap.keySet()) {
                billingNewOrderReqDTO.setInvoiceDetail(stringListMap.get(key));
                billingNewReqDTO.setOrder(billingNewOrderReqDTO);
                billingNewReqDTOS.add(billingNewReqDTO);
            }
        }
        return billingNewReqDTOS;
    }

    private void addFareItem(List<BipInvItemDTO> bipInvItemFromOrderD, Long orderId) {
    }

    public PagingVO<BipInvVO> appFindAll(BipInvQueryParam param) {
        Long userId = BipInvServiceImpl.checkUser().getUserId();
        JPAQuery<BipInvVO> jpaQuery = this.bipInvRepoProc.findAllByUserId(userId);
        long count = jpaQuery.fetchCount();
        PageRequest pageRequest = this.wrapperPageRequest(param.getPageRequest(), null);
        this.appendPageAndSort(jpaQuery, pageRequest, qBipInvDO);
        return PagingVO.builder().total(count).records(jpaQuery.fetch()).build();
    }

    public ApiResult<Long> sendEmail(String to, Long invId) {
        CurrentUserDTO currentUserDTO = BipInvServiceImpl.checkUser();
        String userName = currentUserDTO.getDetail().getUsername();
        List fileByBusinessId = this.comSaleFileInfoService.findFileByBusinessId("B-INV", invId);
        List fileCodes = fileByBusinessId.stream().map(ComSaleFileComVO::getFileCode).collect(Collectors.toList());
        StringBuilder html = new StringBuilder();
        for (String fileCode : fileCodes) {
            html.append("<a href=\"").append(fileCode).append("\">\u53d1\u7968</a><br>");
        }
        return ApiResult.ok((Object)invId);
    }

    @SysCodeProc
    @Transactional
    public BipInvVO findByInvId(Long invId) {
        return null;
    }

    public PagingVO<BipInvVO> findAllByParam(BipInvQueryParam param) {
        if (param == null) {
            throw new BusinessException("\u67e5\u8be2\u6761\u4ef6\u4e0d\u80fd\u4e3aNull");
        }
        JPAQuery<BipInvVO> jpaQuery = this.bipInvRepoProc.select(param);
        long total = jpaQuery.fetchCount();
        PageRequest pageRequest = this.wrapperPageRequest(param.getPageRequest(), null);
        this.appendPageAndSort(jpaQuery, pageRequest, qBipInvDO);
        return PagingVO.builder().total(total).records(jpaQuery.fetch()).build();
    }

    public List<BipInvVO> findInvByOrderId(Long orderId) {
        List fetch = ((JPAQuery)((JPAQuery)this.jpaQueryFactory.select((Expression)Projections.bean(BipInvVO.class, (Expression[])new Expression[]{BipInvServiceImpl.qBipInvDO.id})).from((EntityPath)qBipInvDO)).where((Predicate)BipInvServiceImpl.qBipInvDO.orderId.eq((Object)orderId))).fetch();
        List<BipInvVO> results = fetch.stream().map(b -> this.findByInvId(b.getId())).collect(Collectors.toList());
        for (BipInvVO result : results) {
            List bipInvItemDTO = result.getBipInvItemDTO();
            BigDecimal tax = BigDecimal.ZERO;
            for (BipInvItemDTO invItemDTO : bipInvItemDTO) {
                tax = tax.add(invItemDTO.getTax());
            }
            if ("p".equals(result.getInvType())) {
                result.setInvType("\u666e\u901a\u53d1\u7968(\u7535\u7968)");
            }
            result.setTax(tax);
            result.setTaxRate(((BipInvItemDTO)bipInvItemDTO.get(0)).getTaxRate());
        }
        return results;
    }

    @Transactional(rollbackFor={Exception.class})
    public ApiResult<List<String>> viewAndDownload(BipInvViewAndDownParam bipInvViewAndDownParam) {
        BipInvQueryParam bipInvQueryParam = new BipInvQueryParam();
        if (!CollectionUtils.isEmpty((Collection)bipInvViewAndDownParam.getInvSerialNums())) {
            bipInvQueryParam.setInvSerialNums(bipInvViewAndDownParam.getInvSerialNums());
        } else {
            bipInvQueryParam.setOrderNos(bipInvViewAndDownParam.getInvSerialNums());
        }
        List<BipInvDO> bipInvDOS = this.selectInvByDocNosOrOrderId(bipInvQueryParam);
        List<String> serialNums = bipInvDOS.stream().map(BipInvDO::getInvSerialNum).collect(Collectors.toList());
        ApiResult<List<QueryInvoiceResultRespDTO.QueryInvoiceResultResultDTO>> result = this.nuoNuoEleQueryInvoiceResult(serialNums, bipInvDOS);
        for (QueryInvoiceResultRespDTO.QueryInvoiceResultResultDTO resultDTO : (List)result.getData()) {
            log.info("\u5f00\u7968\u72b6\u6001\u4fe1\u606f" + resultDTO.getStatusMsg());
            if (!"22".equals(resultDTO.getStatus()) && !"24".equals(resultDTO.getStatus())) continue;
            log.warn("\u5f00\u7968\u72b6\u6001\u4fe1\u606f" + resultDTO.getStatusMsg() + "  " + resultDTO.getFailCause());
            return ApiResult.fail((String)(resultDTO.getStatusMsg() + "  " + resultDTO.getFailCause()));
        }
        if (result.getCode() != 200) {
            throw new BusinessException("\u67e5\u8be2\u53d1\u7968\u5f02\u5e38,\u5f02\u5e38\u4fe1\u606f\u4e3a:" + result.getMsg());
        }
        List data = (List)result.getData();
        List collect = data.stream().map(QueryInvoiceResultRespDTO.QueryInvoiceResultResultDTO::getPdfUrl).collect(Collectors.toList());
        return ApiResult.ok(collect);
    }

    @Deprecated
    public ApiResult<String> findInvByInvSerialNum(String invSerialNum) {
        return ApiResult.ok();
    }

    @SysCodeProc
    public List<BillingNewInvoiceDetailReqDTO> buildInvoiceDetail(List<BipInvItemDTO> bipInvItemFromSale) {
        return null;
    }

    @Transactional
    public Long creditInv(Long orderId) {
        List invByOrderIdList = ((JPAQuery)((JPAQuery)this.jpaQueryFactory.select((Expression)qBipInvDO).from((EntityPath)qBipInvDO)).where((Predicate)BipInvServiceImpl.qBipInvDO.orderId.eq((Object)orderId).and((Predicate)BipInvServiceImpl.qBipInvDO.isRed.eq((Object)"0").or((Predicate)BipInvServiceImpl.qBipInvDO.isRed.isNull())))).fetch();
        List serialNumS = invByOrderIdList.stream().map(BipInvDO::getInvSerialNum).collect(Collectors.toList());
        Long ouId = this.queryItemByOrderId(orderId);
        ArrayList<Long> ouIds = new ArrayList<Long>();
        ouIds.add(ouId);
        List<OrgOuRpcDTO> ouDtoList = this.rmiOrgOuService.findOuDtoList(ouIds, null);
        if (CollectionUtils.isEmpty(ouDtoList)) {
            throw new BusinessException("\u9500\u552e\u65b9\u516c\u53f8\u6570\u636e\u672a\u627e\u5230,\u8bf7\u68c0\u67e5!!!");
        }
        String taxerCode = ouDtoList.get(0).getTaxerCode();
        BipInvDO bipInvDO = (BipInvDO)invByOrderIdList.get(0);
        BipInvConvert convert = BipInvConvert.INSTANCE;
        BipInvCreateParam param = convert.doToCreatParam(bipInvDO);
        param.setInvTitleType(bipInvDO.getInvTitleType());
        param.setInvTitle(bipInvDO.getInvTitle());
        param.setPushMode("0");
        param.setInvMultipleTax(bipInvDO.getInvMultipleTax());
        param.setOrderTime(bipInvDO.getOrderTime());
        param.setOrderId(bipInvDO.getOrderId());
        ArrayList<String> docNos = new ArrayList<String>();
        docNos.add(bipInvDO.getDocNo());
        param.setDocNos(docNos);
        param.setCustAccountId(bipInvDO.getCustAccountId());
        param.setId(null);
        param.setIsRed(null);
        param.setRedInvSerialNum(null);
        log.info("\u521b\u5efa\u65b0\u5355\u636e");
        this.createInv(param);
        return orderId;
    }

    @Transactional(rollbackFor={Exception.class})
    public Long uReditInv(Long orderId) {
        return null;
    }

    @Deprecated
    public ApiResult<BipInvVO> findCreditInv(String serialNo) {
        return ApiResult.ok();
    }

    private BillingNewReqDTO buildBillingNewOrderReqDTO(QueryInvoiceResultRespDTO.QueryInvoiceResultResultDTO result, List<BipInvDO> invByOrderIdList) {
        String serialNo = result.getSerialNo();
        BipInvDO inv = (BipInvDO)invByOrderIdList.stream().filter(i -> serialNo.equals(i.getInvSerialNum())).collect(Collectors.toList()).get(0);
        BillingNewReqDTO billingNewReqDTO = new BillingNewReqDTO();
        BillingNewOrderReqDTO billingNewOrderReqDTO = new BillingNewOrderReqDTO();
        billingNewOrderReqDTO.setBuyerName(result.getPayerName());
        billingNewOrderReqDTO.setBuyerTaxNum(result.getPayerTaxNo());
        billingNewOrderReqDTO.setBuyerTel(result.getTelephone());
        billingNewOrderReqDTO.setBuyerAddress(result.getAddress());
        billingNewOrderReqDTO.setBuyerAccount(result.getBankAccount());
        billingNewOrderReqDTO.setSalerTaxNum(result.getSalerTaxNum());
        billingNewOrderReqDTO.setSalerTel(result.getSalerTel());
        billingNewOrderReqDTO.setSalerAddress(result.getSalerAddress());
        billingNewOrderReqDTO.setSalerAccount(result.getSalerAccount());
        billingNewOrderReqDTO.setOrderNo(result.getOrderNo());
        billingNewOrderReqDTO.setInvoiceDate(inv.getOrderTime().format(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss")));
        billingNewOrderReqDTO.setInvoiceCode(result.getInvoiceCode());
        billingNewOrderReqDTO.setInvoiceNum(result.getInvoiceNo());
        billingNewOrderReqDTO.setInvoiceLine("p");
        billingNewOrderReqDTO.setInvoiceNum(result.getInvoiceNo());
        billingNewOrderReqDTO.setClerk(result.getClerk());
        billingNewOrderReqDTO.setPushMode("0");
        billingNewOrderReqDTO.setEmail(result.getNotifyEmail());
        billingNewOrderReqDTO.setInvoiceType("2");
        ArrayList<BillingNewInvoiceDetailReqDTO> details = new ArrayList<BillingNewInvoiceDetailReqDTO>();
        List invoiceItems = result.getInvoiceItems();
        for (QueryInvoiceResultRespDTO.QueryInvoiceResultResultDTO.InvoiceItems i2 : invoiceItems) {
            BillingNewInvoiceDetailReqDTO detail = new BillingNewInvoiceDetailReqDTO();
            detail.setGoodsName(i2.getItemName());
            detail.setGoodsCode(i2.getItemCode());
            BigDecimal price = new BigDecimal(i2.getItemPrice()).setScale(4, RoundingMode.HALF_UP);
            detail.setWithTaxFlag("1");
            BigDecimal tax = new BigDecimal(i2.getItemTaxAmount());
            detail.setTax("-" + tax);
            detail.setTaxRate(i2.getItemTaxRate());
            BigDecimal taxIncludedAmount = new BigDecimal(i2.getItemAmount());
            detail.setTaxIncludedAmount("-" + taxIncludedAmount);
            detail.setTaxExcludedAmount("-" + taxIncludedAmount.subtract(tax));
            detail.setUnit(i2.getItemUnit());
            BigDecimal itemAmount = new BigDecimal(i2.getItemAmount());
            BigDecimal itemTaxAmount = new BigDecimal(i2.getItemTaxAmount());
            BigDecimal taxExcludedAmount = itemAmount.subtract(itemTaxAmount).setScale(4, RoundingMode.HALF_UP);
            detail.setTaxExcludedAmount("-" + taxExcludedAmount.toString());
            detail.setInvoiceLineProperty("0");
            details.add(detail);
        }
        billingNewOrderReqDTO.setInvoiceDetail(details);
        billingNewReqDTO.setOrder(billingNewOrderReqDTO);
        return billingNewReqDTO;
    }

    public Long queryItemByOrderId(Long orderId) {
        return this.bipOrderService.queryItemByOrderId(orderId);
    }

    @Transactional(rollbackFor={Exception.class})
    public void updateItemOrderD(Long orderIds, boolean invoice, Integer offFlag) {
        this.bipOrderService.updateItemOrderD(orderIds, invoice, offFlag);
    }

    @Transactional(rollbackFor={Exception.class})
    public Long saveInv(BipInvCreateParam param) {
        BipInvConvert convert = BipInvConvert.INSTANCE;
        BipInvDO bipInvDO = convert.creatParamToDo(param);
        bipInvDO.setDocNo((String)param.getDocNos().get(0));
        bipInvDO.setOrderId(param.getOrderId());
        bipInvDO.setInvMultipleTax(param.getInvMultipleTax());
        BipInvDO save = (BipInvDO)this.bipInvRepo.save(bipInvDO);
        return save.getId();
    }

    public List<BipInvItemDTO> queryItemNumByOrderID(Long orderId) {
        return this.bipOrderDService.queryItemByOrderId(orderId);
    }

    public List<BipInvDO> selectInvByDocNosOrOrderId(BipInvQueryParam bipInvQueryParam) {
        if (ObjectUtils.isEmpty((Object)bipInvQueryParam)) {
            return new ArrayList<BipInvDO>(16);
        }
        BooleanExpression predicate = qBipInvDO.isNotNull();
        if (!CollectionUtils.isEmpty((Collection)bipInvQueryParam.getOrderNos())) {
            predicate = ExpressionUtils.and((Predicate)predicate, (Predicate)BipInvServiceImpl.qBipInvDO.docNo.in((Collection)bipInvQueryParam.getOrderNos()));
        }
        if (!CollectionUtils.isEmpty((Collection)bipInvQueryParam.getOrderIds())) {
            predicate = ExpressionUtils.and((Predicate)predicate, (Predicate)BipInvServiceImpl.qBipInvDO.orderId.in((Collection)bipInvQueryParam.getOrderIds()));
        }
        if (!CollectionUtils.isEmpty((Collection)bipInvQueryParam.getInvSerialNums())) {
            predicate = ExpressionUtils.and((Predicate)predicate, (Predicate)BipInvServiceImpl.qBipInvDO.invSerialNum.in((Collection)bipInvQueryParam.getInvSerialNums()));
        }
        return ((JPAQuery)((JPAQuery)this.jpaQueryFactory.select((Expression)qBipInvDO).from((EntityPath)qBipInvDO)).where((Predicate)predicate)).fetch();
    }

    public List<BipInvItemDTO> queryItemBySkuCodes(List<String> skuCodes) {
        return this.priSalePriceService.queryItemByItemCode(skuCodes);
    }

    private static CurrentUserDTO checkUser() {
        CurrentUserDTO currentUser = UserService.currentUser();
        if (currentUser == null) {
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u65e0\u6cd5\u5230\u83b7\u53d6\u5f53\u524d\u7528\u6237,\u8bf7\u5148\u767b\u5f55!");
        }
        return currentUser;
    }

    public BipInvServiceImpl(BipInvRepo bipInvRepo, BipInvRepoProc bipInvRepoProc, PriSalePriceService priSalePriceService, BipOrderDService bipOrderDService, RmiOrgOuService rmiOrgOuService, BipOrderService bipOrderService, RmiSysNextNumberService rmiSysNextNumberService, ComSaleFileInfoService comSaleFileInfoService, BipOrderDRepo bipOrderDRepo, BipOrderRepo bipOrderRepo, BipCustUserBindService bipCustUserBindService, BipCompanyManageService bipCompanyManageService, OrgEmpRpcService orgEmpRpcService, RmiOrderSalSoDService rmiOrderSalSoDService, SalInvApplydRepoProc salInvApplydRepoProc, RmiSettingService rmiSettingService) {
        this.bipInvRepo = bipInvRepo;
        this.bipInvRepoProc = bipInvRepoProc;
        this.priSalePriceService = priSalePriceService;
        this.bipOrderDService = bipOrderDService;
        this.rmiOrgOuService = rmiOrgOuService;
        this.bipOrderService = bipOrderService;
        this.rmiSysNextNumberService = rmiSysNextNumberService;
        this.comSaleFileInfoService = comSaleFileInfoService;
        this.bipOrderDRepo = bipOrderDRepo;
        this.bipOrderRepo = bipOrderRepo;
        this.bipCustUserBindService = bipCustUserBindService;
        this.bipCompanyManageService = bipCompanyManageService;
        this.orgEmpRpcService = orgEmpRpcService;
        this.rmiOrderSalSoDService = rmiOrderSalSoDService;
        this.salInvApplydRepoProc = salInvApplydRepoProc;
        this.rmiSettingService = rmiSettingService;
    }
}

