/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.yst.production.sale.service.shop;

import com.alibaba.fastjson.JSON;
import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.cloudt.common.base.ApiCode;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.yst.production.sale.api.service.shop.BipMessageService;
import com.elitesland.yst.production.sale.api.vo.param.shop.BipMessageQueryParamVO;
import com.elitesland.yst.production.sale.api.vo.resp.shop.BipMessageVO;
import com.elitesland.yst.production.sale.api.vo.resp.shop.app.BipFirstMessage;
import com.elitesland.yst.production.sale.api.vo.save.shop.BipMessageSaveVO;
import com.elitesland.yst.production.sale.common.constant.UdcEnum;
import com.elitesland.yst.production.sale.common.model.CurrentUserDTO;
import com.elitesland.yst.production.sale.convert.shop.BipMessageConvert;
import com.elitesland.yst.production.sale.core.service.UserService;
import com.elitesland.yst.production.sale.entity.BipCustUserBindDO;
import com.elitesland.yst.production.sale.entity.BipMessageDO;
import com.elitesland.yst.production.sale.repo.shop.BipCustUserBindRepoProc;
import com.elitesland.yst.production.sale.repo.shop.BipMessageRepo;
import com.elitesland.yst.production.sale.repo.shop.BipMessageRepoProc;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class BipMessageServiceImpl
implements BipMessageService {
    private static final Logger log = LoggerFactory.getLogger(BipMessageServiceImpl.class);
    private final BipMessageRepo bipMessageRepo;
    private final BipMessageRepoProc bipMessageRepoProc;
    private final BipCustUserBindRepoProc bipCustUserBindRepoProc;

    @Transactional(rollbackFor={Exception.class})
    public PagingVO<BipMessageVO> search(BipMessageQueryParamVO param) {
        Long userId = this.currentCust();
        param.setToCustId(userId);
        log.info("\u67e5\u8be2\u6d88\u606f:{}", (Object)JSON.toJSONString((Object)param));
        Page ret = this.bipMessageRepo.findAll(this.bipMessageRepoProc.where(param), (Pageable)param.getPageRequest());
        List collect = ret.getContent().stream().filter(message -> UdcEnum.MESSAGE_STATUS_NOTREAD.getValueCode().equals(message.getStatus())).peek(message -> message.setStatus(UdcEnum.MESSAGE_STATUS_READ.getValueCode())).collect(Collectors.toList());
        this.bipMessageRepo.saveAll(collect);
        List vos = ret.getContent().stream().map(BipMessageConvert.INSTANCE::doToVO).collect(Collectors.toList());
        return PagingVO.builder().total(ret.getTotalElements()).records(vos).build();
    }

    @Transactional(rollbackFor={Exception.class})
    public Long createOne(BipMessageSaveVO param) {
        BipMessageDO bipMessageDO = BipMessageConvert.INSTANCE.voToDo(param);
        log.info("\u6d88\u606f\u521b\u5efa\uff1a{}", (Object)JSON.toJSONString((Object)bipMessageDO));
        return ((BipMessageDO)this.bipMessageRepo.save(bipMessageDO)).getId();
    }

    @Transactional(rollbackFor={Exception.class})
    public void update(BipMessageSaveVO param) {
        BipMessageDO objDo = BipMessageConvert.INSTANCE.voToDo(param);
        Optional optional = this.bipMessageRepo.findById(objDo.getId());
        if (!optional.isPresent()) {
            throw new BusinessException(ApiCode.FAIL, "\u4fee\u6539\u5931\u8d25\uff0c\u6570\u636e\u4e0d\u5b58\u5728" + objDo.getId());
        }
        objDo.setId(((BipMessageDO)optional.get()).getId());
        this.bipMessageRepo.save(objDo);
    }

    @Transactional(rollbackFor={Exception.class})
    public void deleteOne(Long id) {
        this.bipMessageRepo.deleteById(id);
    }

    public BipFirstMessage firstMessage() {
        Long userID = this.currentCust();
        return this.bipMessageRepoProc.firstMessage(userID);
    }

    public ApiResult<String> allRead() {
        Long userID = this.currentCust();
        this.bipMessageRepo.allRead(UdcEnum.MESSAGE_STATUS_READ.getValueCode(), userID);
        return ApiResult.ok();
    }

    private Long currentCust() {
        CurrentUserDTO currentUserDTO = UserService.currentUser();
        BipCustUserBindDO bipCustUserBindDO = null;
        if (currentUserDTO == null) {
            throw new BusinessException("\u8bf7\u5148\u767b\u5f55!");
        }
        Long userId = currentUserDTO.getUserId();
        if (!Objects.nonNull(userId)) {
            throw new BusinessException("\u8bf7\u5148\u767b\u5f55!");
        }
        bipCustUserBindDO = this.bipCustUserBindRepoProc.getByUserId(userId);
        if (bipCustUserBindDO == null) {
            throw new BusinessException("\u8bf7\u7ed1\u5b9a\u516c\u53f8\u4fe1\u606f!");
        }
        if (!UdcEnum.BIP_CUST_USER_STATE_ACTIVE.getValueCode().equals(bipCustUserBindDO.getState())) {
            throw new BusinessException("\u8bf7\u7ed1\u5b9a\u516c\u53f8\u4fe1\u606f!");
        }
        if (bipCustUserBindDO.getCustId() == null) {
            throw new BusinessException("\u8bf7\u7ed1\u5b9a\u516c\u53f8\u4fe1\u606f!");
        }
        return userId;
    }

    public BipMessageServiceImpl(BipMessageRepo bipMessageRepo, BipMessageRepoProc bipMessageRepoProc, BipCustUserBindRepoProc bipCustUserBindRepoProc) {
        this.bipMessageRepo = bipMessageRepo;
        this.bipMessageRepoProc = bipMessageRepoProc;
        this.bipCustUserBindRepoProc = bipCustUserBindRepoProc;
    }
}

