package com.elitesland.yst.production.sale.common.constant;

/**
 * 销售中心的.
 *
 * @author Kaiser（wang shao）
 * @date 2021-05-10
 */
public enum UdcEnum {

    /**
     * 区域
     */
    CRM_CUST_REGION_HN_NORTH("yst-sale", "REGION", "区域", "HN_NORTH", "豫南"),
    CRM_CUST_REGION_HN_SOUTH("yst-sale", "REGION", "区域", "HN_SOUTH", "豫北"),
    CRM_CUST_REGION_ZJ_NORTH("yst-sale", "REGION", "区域", "ZJ_NORTH", "浙南"),
    CRM_CUST_REGION_ZJ_SOUTH("yst-sale", "REGION", "区域", "ZJ_SOUTH", "浙北"),

    /**
     * 业务员类型
     */
    SALE_SALESMAN_TYPE_CHIEF("yst-lm-supply", "SALESMAN_TYPE", "业务员类型", "CHIEF", "总监"),
    SALE_SALESMAN_TYPE_PRMANAGER("yst-lm-supply", "SALESMAN_TYPE", "业务员类型", "PRMANAGER", "省区经理"),
    SALE_SALESMAN_TYPE_REMANAGER("yst-lm-supply", "SALESMAN_TYPE", "业务员类型", "REMANAGER", "区域经理"),
    SALE_SALESMAN_TYPE_SALESMAN("yst-lm-supply", "SALESMAN_TYPE", "业务员类型", "SALESMAN", "二级业务员"),

    //客户状态
    CRM_CUST_STATUS_ACTIVE("CRM", "CUST_STATUS", "客户状态", "ACTIVE", "启用"),
    CRM_CUST_STATUS_CLOSED("CRM", "CUST_STATUS", "客户状态", "CLOSED", "禁用"),

    //员工类型
    CUST_TYPE_SALESMAN("yst-sys", "employeeType", "员工类型", "SALESMAN", "业务员"),

    // 价格申请类型、价格类型
    PRI_SALE_PRICE_TYPE_BASE("PRI", "SALE_PRICE_TYPE", "价格类型", "BASE", "基础价格"),
    PRI_SALE_PRICE_TYPE_CUST("PRI", "SALE_PRICE_TYPE", "价格类型", "CUST", "客户价格"),
    PRI_SALE_PRICE_TYPE_GROUP("PRI", "SALE_PRICE_TYPE", "价格类型", "GROUP", "客户等级价格"),
    PRI_SALE_PRICE_TYPE_CROSS("PRI", "SALE_PRICE_TYPE", "价格类型", "CROSS", "内部结算价格"),

    // 销售价格申请审批状态
    COM_APPR_STATUS_APPROVING("COM", "APPR_STATUS", "审批状态", "APPROVING", "审批中"),
    COM_APPR_STATUS_APPROVED("COM", "APPR_STATUS", "审批状态", "APPROVED", "已批准"),
    COM_APPR_STATUS_REJECTED("COM", "APPR_STATUS", "审批状态", "REJECTED", "已拒绝"),

    // 计量单位
    COM_UOM_BX("COM", "UOM999", "计量单位", "BX", "盒"),

    // 销售价格申请单状态
    PRI_APPLY_STATUS_DR("PRI", "SALE_APPLY_STATUS", "销售价格申请状态", "DR", "待提交"),
    PRI_APPLY_STATUS_APPING("PRI", "SALE_APPLY_STATUS", "销售价格申请状态", "APPING", "待审批"),
    PRI_APPLY_STATUS_CF("PRI", "SALE_APPLY_STATUS", "销售价格申请状态", "CF", "已审批"),
    PRI_APPLY_STATUS_CL("PRI", "SALE_APPLY_STATUS", "销售价格申请状态", "CL", "已取消"),
    PRI_APPLY_STATUS_RJ("PRI", "SALE_APPLY_STATUS", "销售价格申请状态", "RJ", "已拒绝"),

    // 销售报价单状态
    SAL_QUOTATION_STATUS_DRAFT("SAL", "QUOTATION_STATUS", "销售报价单状态", "DRAFT", "待提交"),
    SAL_QUOTATION_STATUS_REJECTED("SAL", "QUOTATION_STATUS", "销售报价单状态", "REJECTED", "已拒绝"),
    SAL_QUOTATION_STATUS_APPROVING("SAL", "QUOTATION_STATUS", "销售报价单状态", "APPROVING", "待审批"),
    SAL_QUOTATION_STATUS_APPROVED("SAL", "QUOTATION_STATUS", "销售报价单状态", "APPROVED", "已审批"),
    SAL_QUOTATION_STATUS_COMPLETED("SAL", "QUOTATION_STATUS", "销售报价单状态", "COMPLETED", "已转销售订单/"),
    SAL_QUOTATION_STATUS_CL("SAL", "QUOTATION_STATUS", "销售报价单状态", "CL", "已取消"),

    // 启停用状态
    COM_STATUS_ACTIVEORNO_ACTIVE("COM", "STATUS_ACTIVEORNO", "启用停用状态", "ACTIVE", "启用"),
    COM_STATUS_ACTIVEORNO_INACTIVE("COM", "STATUS_ACTIVEORNO", "启用停用状态", "INACTIVE", "停用"),

    // 轮播图
    COM_STATUS_RETAION_DRAFT("COM", "STATUS_ACTIVEORNO", "启用停用状态", "DRAFT", "草稿"),

    // 销售报价单
    COM_DOC_CLS_QUOT("COM", "DOC_CLS", "单据类别", "QUOT", "销售报价单"),

    // 是否
    COM_YESNO_YES("COM", "YESNO", "YESNO", "YES", "是"),
    COM_YESNO_NO("COM", "YESNO", "YESNO", "NO", "否"),

    // 客户分类
    CRM_CUST_TYPE_A("CRM", "CUST_TYPE", "客户类型", "A", "开发商"),
    CRM_CUST_TYPE_B("CRM", "CUST_TYPE", "客户类型", "B", "工程类客户"),
    CRM_CUST_TYPE_C("CRM", "CUST_TYPE", "客户类型", "C", "工商福大客户"),
    CRM_CUST_TYPE_D("CRM", "CUST_TYPE", "客户类型", "D", "小微客户"),
    //地址簿类型
    ORG_ADDR_TYPE_CUST("ORG", "ADDR_TYPE", "地址簿类型", "CUST", "客户"),
    ORG_ADDR_TYPE_SCUST("ORG", "ADDR_TYPE", "地址簿类型", "SCUST", "潜在客户"),
    // 客户归类
    CRM_CUST_TYPE2_A("CRM", "CUST_TYPE2", "客户归类", "A", "燃气客户"),
    CRM_CUST_TYPE2_B("CRM", "CUST_TYPE2", "客户归型", "B", "增值客户"),
    CRM_CUST_TYPE2_C("CRM", "CUST_TYPE2", "客户归类", "C", "内部公司"),
    CRM_CUST_TYPE2_D("CRM", "CUST_TYPE2", "客户归型", "D", "内部员工"),
    // 潜在客户状态
    CRM_SCUST_STATUS_A("CRM", "SCUST_STATUS", "潜在客户状态", "A", "潜在客户"),
    CRM_SCUST_STATUS_B("CRM", "SCUST_STATUS", "潜在客户状态", "B", "已转正式客户"),

    //客户来源
    CRM_CUST_SOURCE_A("CRM", "CUST_SOURCE", "客户来源", "A", "业务员录入"),
    CRM_CUST_SOURCE_B("CRM", "CUST_SOURCE", "客户来源", "B", "商城注册"),

    // 开票类型
    COM_INV_TYPE_VATS("CRM", "INV_TYPE", "发票类型", "VATS", "增值税专用发票"),
    COM_INV_TYPE_VANA("CRM", "INV_TYPE", "发票类型", "VANA", "普通发票"),

    // 账期检查类型
    CRM_ARDAYS_CHECK_TYPE_A("CRM", "ARDAYS_CHECK_TYPE", "账期检查类型", "A", "检查"),
    CRM_ARDAYS_CHECK_TYPE_B("CRM", "ARDAYS_CHECK_TYPE", "账期检查类型", "B", "不检查"),

    // 信贷检查类型
    CRM_CREDIT_CHECK_TYPE_A("CRM", "CREDIT_CHECK_TYPE", "信贷检查类型", "A", "检查"),
    CRM_CREDIT_CHECK_TYPE_B("CRM", "CREDIT_CHECK_TYPE", "信贷检查类型", "B", "不检查"),

    // 地址类型
    ORG_ADDRESS_TYPE_DEFAULT("ORG", "ADDRESS_TYPE", "地址类型", "DEFAULT", "默认地址"),
    ORG_ADDRESS_TYPE_RECEIVE("ORG", "ADDRESS_TYPE", "地址类型", "RECEIVE", "收货地址"),
    ORG_ADDRESS_TYPE_INVOICE("ORG", "ADDRESS_TYPE", "地址类型", "INVOICE", "开票地址"),
    ORG_ADDRESS_TYPE_OTHER("ORG", "ADDRESS_TYPE", "地址类型", "OTHER", "其他"),

    // 销售状态
    SAL_CONTRACT_STATUS_DRAFT("SAL", "CONTRACT_STATUS", "销售状态", "DRAFT", "待提交"),
    SAL_CONTRACT_STATUS_APPROVING("SAL", "CONTRACT_STATUS", "销售状态", "APPROVING", "待审批"),
    SAL_CONTRACT_STATUS_APPROVED("SAL", "CONTRACT_STATUS", "销售状态", "APPROVED", "已激活"),
    SAL_CONTRACT_STATUS_CLOSED("SAL", "CONTRACT_STATUS", "销售状态", "CLOSED", "已关闭"),
    SAL_CONTRACT_STATUS_REJECTED("SAL", "CONTRACT_STATUS", "销售状态", "REJECTED", "已拒绝"),

    //发票申请单状态
    SAL_BILL_STATUS_DRAFT("SAL", "BILL_STATUS", "发票申请单状态", "DRAFT", "待提交"),
    SAL_BILL_STATUS_APPROVING("SAL", "BILL_STATUS", "发票申请单状态", "APPROVING", "待审批"),
    SAL_BILL_STATUS_APPROVED("SAL", "BILL_STATUS", "发票申请单状态", "APPROVED", "已审批"),
    SAL_BILL_STATUS_REJECTED("SAL", "BILL_STATUS", "发票申请单状态", "REJECTED", "已拒绝"),
    SAL_BILL_STATUS_INVOICED("SAL", "BILL_STATUS", "发票申请单状态", "INVOICED", "已开票"),

    //收款单状态
    SAL_RECEIPT_STATUS_DRAFT("SAL", "RECEIPT_STATUS", "收款单状态", "DRAFT", "待提交"),
    SAL_RECEIPT_STATUS_APPROVING("SAL", "RECEIPT_STATUS", "收款单状态", "APPROVING", "待审批"),
    SAL_RECEIPT_STATUS_APPROVED("SAL", "RECEIPT_STATUS", "收款单状态", "APPROVED", "已审批"),
    SAL_RECEIPT_STATUS_REJECTED("SAL", "RECEIPT_STATUS", "收款单状态", "REJECTED", "已拒绝"),
    SAL_RECEIPT_STATUS_RECEIVED("SAL", "RECEIPT_STATUS", "收款单状态", "RECEIVED", "已收款"),
    SAL_RECEIPT_STATUS_RETURNED("SAL", "RECEIPT_STATUS", "收款单状态", "RETURNED", "押金已退回"),

    // 销售验收单状态
    SAL_AC_STATUS_DRAFT("SAL", "AC_STATUS", "验收单状态", "DRAFT", "待提交"),
    SAL_AC_STATUS_APPROVING("SAL", "AC_STATUS", "验收单状态", "APPROVING", "待审批"),
    SAL_AC_STATUS_APPROVED("SAL", "AC_STATUS", "验收单状态", "APPROVED", "已审批"),
    SAL_AC_STATUS_REJECTED("SAL", "AC_STATUS", "验收单状态", "REJECTED", "已拒绝"),
    SAL_AC_STATUS_CL("SAL", "AC_STATUS", "合同验收单状态", "CL", "已取消"),

    //财务属性
    CRM_FINANCIAL_ATTRIBUTE_20("CRM", "FINANCIAL_ATTRIBUTE", "财务属性", "20", "工业户"),
    CRM_FINANCIAL_ATTRIBUTE_30("CRM", "FINANCIAL_ATTRIBUTE", "财务属性", "30", "商业户"),
    CRM_FINANCIAL_ATTRIBUTE_40("CRM", "FINANCIAL_ATTRIBUTE", "财务属性", "40", "公福户"),
    CRM_FINANCIAL_ATTRIBUTE_50("CRM", "FINANCIAL_ATTRIBUTE", "财务属性", "50", "车船户"),
    CRM_FINANCIAL_ATTRIBUTE_60("CRM", "FINANCIAL_ATTRIBUTE", "财务属性", "60", "批发户"),
    CRM_FINANCIAL_ATTRIBUTE_70("CRM", "FINANCIAL_ATTRIBUTE", "财务属性", "70", "其他户"),



    //对账单状态
    SAL_SOA_STATUS_10("SAL", "SOA_STATUS", "对账单状态", "10", "新建"),
    SAL_SOA_STATUS_20("SAL", "SOA_STATUS", "对账单状态", "20", "客户已确认"),
    SAL_SOA_STATUS_30("SAL", "SOA_STATUS", "对账单状态", "30", "已作废"),

    //对账单开票状态
    SAL_SOA_INV_STATUS_10("SAL", "SOA_INV_STATUS", "对账单开票状态", "10", "待开票"),
    SAL_SOA_INV_STATUS_20("SAL", "SOA_INV_STATUS", "对账单开票状态", "20", "开票中"),
    SAL_SOA_INV_STATUS_30("SAL", "SOA_INV_STATUS", "对账单开票状态", "30", "已开票"),

    //对账单收款状态
    SAL_SOA_RECEIPT_STATUS_10("SAL", "SOA_RECEIPT_STATUS", "对账单收款状态", "10", "待收款"),
    SAL_SOA_RECEIPT_STATUS_20("SAL", "SOA_RECEIPT_STATUS", "对账单收款状态", "20", "收款中"),
    SAL_SOA_RECEIPT_STATUS_30("SAL", "SOA_RECEIPT_STATUS", "对账单收款状态", "30", "已收款"),

    //支付押金单状态
    SAL_PD_STATUS_DRAFT("SAL", "PD_STATUS", "押金单状态", "DRAFT", "待提交"),
    SAL_PD_STATUS_APPROVING("SAL", "PD_STATUS", "押金单状态", "APPROVING", "待审批"),
    SAL_PD_STATUS_APPROVED("SAL", "PD_STATUS", "押金单状态", "APPROVED", "已审批"),
    SAL_PD_STATUS_REJECTED("SAL", "PD_STATUS", "押金单状态", "REJECTED", "已拒绝"),

    //大B/小B
    CRM_CUST_GROUP2_10("CRM", "CUST_GROUP2", "大B/小B", "10", "大B"),
    CRM_CUST_GROUP2_20("CRM", "CUST_GROUP2", "大B/小B", "20", "小B"),
    CRM_CUST_GROUP2_30("CRM", "CUST_GROUP2", "大B/小B", "30", "2C虚拟户"),
    CRM_CUST_GROUP2_40("CRM", "CUST_GROUP2", "大B/小B", "40", "小B虚拟户"),

    //销售订单状态
    SAL_SO_STATUS_DR("SAL", "SO_STATUS", "销售订单状态", "DR", "草稿"),
    SAL_SO_STATUS_CL("SAL", "SO_STATUS", "销售订单状态", "CL", "已取消"),

    // 商品状态
    BIP_ITEM_STATE_DRAFT("SAL", "ITEM_STATE", "商品状态", "DRAFT", "草稿"),
    BIP_ITEM_STATE_APPR("SAL", "ITEM_STATE", "商品状态", "APPR", "待审批"),
    BIP_ITEM_STATE_REJECT("SAL", "ITEM_STATE", "商品状态", "REJECT", "已拒绝"),
    BIP_ITEM_STATE_SHELF("SAL", "ITEM_STATE", "商品状态", "SHELF", "已上架"),
    BIP_ITEM_STATE_OFF("SAL", "ITEM_STATE", "商品状态", "OFF", "已下架"),
    BIP_ITEM_STATE_TO_SHELF("SAL", "ITEM_STATE", "商品状态", "TO_SHELF", "待上架"),
    BIP_ITEM_STATE_TO_OFF("SAL", "ITEM_STATE", "商品状态", "TO_OFF", "待下架"),

    // 商品下架原因
    BIP_ITEM_OFF_SHELF_MANUAL("SAL", "ITEM_OFF_SHELF", "商品下架原因", "MANUAL", "手动下架"),
    BIP_ITEM_OFF_SHELF_AUTO("SAL", "ITEM_OFF_SHELF", "商品下架原因", "AUTO", "自动下架"),
    BIP_ITEM_OFF_SHELF_STOCK("SAL", "ITEM_OFF_SHELF", "商品下架原因", "STOCK", "库存不足"),
    BIP_ITEM_OFF_SHELF_FREEZE("SAL", "ITEM_OFF_SHELF", "商品下架原因", "FREEZE", "冻结下架"),

    //专区状态
    SAL_ZONE_STATUS_DRAFT("SAL", "ZONE_STATUS", "专区状态", "DRAFT", "草稿"),
    SAL_ZONE_STATUS_CLOSED("SAL", "ZONE_STATUS", "专区状态", "CLOSED", "禁用"),
    SAL_ZONE_STATUS_ACTIVE("SAL", "ZONE_STATUS", "专区状态", "ACTIVE", "激活"),

    //报价单客户状态
    SAL_QT_TYPE_A("SAL", "QT_TYPE", "报价单客户类型", "A", "潜在客户"),
    SAL_QT_TYPE_B("SAL", "QT_TYPE", "报价单客户类型", "B", "正式客户"),

    // 客户等级
    CRM_CUST_GROUP_A("CRM", "CUST_GROUP", "客户等级", "A", "A"),
    CRM_CUST_GROUP_B("CRM", "CUST_GROUP", "客户等级", "B", "B"),
    CRM_CUST_GROUP_C("CRM", "CUST_GROUP", "客户等级", "C", "C"),

    // 客户的绑定用户状态
    BIP_CUST_USER_STATE_UNBIND("SAL", "CUST_USER_STATE", "状态", "UNBIND", "未绑定"),
    BIP_CUST_USER_STATE_TO_APPR("SAL", "CUST_USER_STATE", "状态", "TO_APPR", "待审核"),
    BIP_CUST_USER_STATE_BIND_FAIL("SAL", "CUST_USER_STATE", "状态", "BIND_FAIL", "绑定失败"),
    BIP_CUST_USER_STATE_ACTIVE("SAL", "CUST_USER_STATE", "状态", "ACTIVE", "激活"),
    BIP_CUST_USER_STATE_DISABLE("SAL", "CUST_USER_STATE", "状态", "DISABLE", "禁用"),

    // 客户的绑定用户申请状态
    BIP_CUST_USER_APPLY_TO_APPR("SAL", "CUST_USER_APPLY", "申请绑定状态", "TO_APPR", "待审批"),
    BIP_CUST_USER_APPLY_REFUSE("SAL", "CUST_USER_APPLY", "申请绑定状态", "REFUSE", "审批拒绝"),
    BIP_CUST_USER_APPLY_PASSED("SAL", "CUST_USER_APPLY", "申请绑定状态", "PASSED", "审批通过"),

    // 促销条件类型
    MKT_DISCOUNT_OFFSET_TYPE_0("MKT", "DISCOUNT_OFFSET_TYPE", "促销条件类型", "0", "按数量"),
    MKT_DISCOUNT_OFFSET_TYPE_1("MKT", "DISCOUNT_OFFSET_TYPE", "促销条件类型", "1", "按金额"),

    // 促销状态
    MKT_DISCOUNT_OFFSET_STATUS_ENABLE("MKT", "DISCOUNT_OFFSET_STATUS", "促销状态", "ENABLE", "已启用"),
    MKT_DISCOUNT_OFFSET_STATUS_DISABLE("MKT", "DISCOUNT_OFFSET_STATUS", "促销状态", "DISABLE", "未启用"),


    //运送方式  TRANSPORT_TYPE EXPRESS
    SAL_TRANSPORT_TYPE_EXPRESS("SAL", "TRANSPORT_TYPE", "运送方式", "EXPRESS", "快递"),


    //优惠券状态
    SAL_COUPON_STATE_NOT_ACTIVE("SAL", "COUPON_STATUS", "优惠券状态", "NOT_ACTIVE", "未激活"),
    SAL_COUPON_STATE_ACTIVE("SAL", "COUPON_STATUS", "优惠券状态", "ACTIVE", "已激活"),
    SAL_COUPON_STATE_DISABLE("SAL", "COUPON_STATUS", "优惠券状态", "DISABLE", "禁用"),

    //优惠券使用状态
    SAL_COUPON_USE_STATUS_NOTUSED("SAL", "COUPON_USE_STATUS", "优惠券使用状态", "NOTUSED", "未使用"),
    SAL_COUPON_USE_STATUS_USED("SAL", "COUPON_USE_STATUS", "优惠券使用状态", "USED", "已使用"),
    SAL_COUPON_USE_STATUS_DEL("SAL", "COUPON_USE_STATUS", "优惠券使用状态", "DEL", "已删除"),
    SAL_COUPON_USE_STATUS_OVERDUE("SAL", "COUPON_USE_STATUS", "优惠券使用状态", "OVERDUE", "已过期"),

    //优惠券类型
    SAL_COUPON_TYPE_FULL("SAL", "COUPON_TYPE", "优惠券类型", "0", "满减"),
    SAL_COUPON_TYPE_IMMEDIATELY("SAL", "COUPON_TYPE", "优惠券类型", "1", "立减"),

    //优惠券使用类型
    SAL_COUPON_USE_TYPE_CATEGORY("SAL", "COUPON_USE_TYPE", "优惠券使用类型", "CATEGORY", "品类"),
    SAL_COUPON_USE_TYPE_COMMODITY("SAL", "COUPON_USE_TYPE", "优惠券使用类型", "COMMODITY", "商品"),

    //运费模板状态
    LOGISTICS_TEMPLATE_STATUS_ENABLE("SAL", "LOGISTICS_TEMPLATE_STATUS", "运费模板状态", "ENABLE", "启用"),
    LOGISTICS_TEMPLATE_STATUS_DISABLE("SAL", "LOGISTICS_TEMPLATE_STATUS", "运费模板状态", "DISABLE", "停用"),


    //首单特惠商品状态
    FIRST_SPECIAL_ITEM_STATUS_ACTIVE("SAL", "SPECIAL_STATUS", "首单特惠商品状态", "ACTIVE", "激活"),
    FIRST_SPECIAL_ITEM_STATUS_CLOSED("SAL", "SPECIAL_STATUS", "首单特惠商品状态", "CLOSED", "禁用"),

    //消息读取状态
    MESSAGE_STATUS_READ("SAL", "MESSAGE_STATUS", "消息读取状态", "READ", "已读"),
    MESSAGE_STATUS_NOTREAD("SAL", "MESSAGE_STATUS", "消息读取状态", "NOTREAD", "未读"),

    //订单状态
    SAL_ORDER_STATUS_CL("SAL", "ORDER_STATUS", "订单状态", "CL", "已取消"),
    SAL_ORDER_STATUS_CLOSE("SAL", "ORDER_STATUS", "订单状态", "CLOSE", "已关闭"),
    SAL_ORDER_STATUS_ALLOW("SAL", "ORDER_STATUS", "订单状态", "SHIP", "配货中"),
    SAL_ORDER_STATUS_SHIP("SAL", "ORDER_STATUS", "订单状态", "SHIP", "已发货"),
    SAL_ORDER_STATUS_SIGN("SAL", "ORDER_STATUS", "订单状态", "SIGN", "已签收"),

    //订单支付状态
    SAL_ORDER_PAY_STATUS_PW("SAL", "ORDER_PAY_STATUS", "订单支付状态", "PW", "待付款"),
    SAL_ORDER_PAY_STATUS_PD("SAL", "ORDER_PAY_STATUS", "订单支付状态", "PD", "已付款"),

    SAL_ORDER_PAY_WAY_ONLINE("SAL", "ORDER_PAY_WAY", "订单支付方式", "ONLINE", "线上支付"),
    SAL_ORDER_PAY_WAY_OFFLINE("SAL", "ORDER_PAY_WAY", "订单支付方式", "OFFLINE", "线下支付"),


    SAL_SEND_PARAM_ERR_BACK_ORDER("SAL", "SEND_PARAM_ERR", "调用接口错误类型", "BACK_ORDER", "退款失败"),

    // 订单评价状态
    SAL_ORDER_EVAL_STATUS_Y("SAL", "ORDER_EVAL_STATUS", "订单评价状态", "Y", "已评价"),
    SAL_ORDER_EVAL_STATUS_N("SAL", "ORDER_EVAL_STATUS", "订单评价状态", "N", "未评价"),
    // 商品类型
    ITM_ITM_TYPE_10("ITM", "ITEM_TYPE", "商品类型", "10", "商品"),
    ITM_ITM_TYPE_20("ITM", "ITEM_TYPE", "商品类型", "20", "配件"),
    ITM_ITM_TYPE_30("ITM", "ITEM_TYPE", "商品类型", "30", "赠品"),

    //订单退货类型状态
    SAL_ORDER_BACK_TYPE_A("SAL", "ORDER_BACK_TYPE", "退款类型", "I", "我要退款"),
    SAL_ORDER_PAY_STATUS_IA("SAL", "ORDER_BACK_TYPE", "退款类型", "IA", "我要退货退款"),
    SAL_ORDER_PAY_STATUS_C("SAL", "ORDER_BACK_TYPE", "退款类型", "C", "我要换货"),

    SAL_RSO_STATUS_DR("SAL", "RSO_STATUS", "退货单状态", "DR", "草稿"),
    SAL_RSO_STATUS_WH("SAL", "RSO_STATUS", "退货单状态", "WH", "待退货"),
    SAL_RSO_STATUS_WK("SAL", "RSO_STATUS", "退货单状态", "WK", "待退款"),
    SAL_RSO_STATUS_WP("SAL", "RSO_STATUS", "退货单状态", "WP", "退款中"),
    SAL_RSO_STATUS_RP("SAL", "RSO_STATUS", "退货单状态", "RP", "财务驳回"),
    SAL_RSO_STATUS_DONE("SAL", "RSO_STATUS", "退货单状态", "DONE", "已退款"),
    SAL_RSO_STATUS_CL("SAL", "RSO_STATUS", "退货单状态", "CL", "已取消"),
    SAL_RSO_STATUS_APPING("SAL", "RSO_STATUS", "退货单状态", "APPING", "审批中"),
    SAL_RSO_STATUS_RJ("SAL", "RSO_STATUS", "退货单状态", "RJ", "仓库驳回"),
    SAL_RSO_STATUS_REJECTED("SAL", "RSO_STATUS", "退货单状态", "REJECTED", "已拒绝"),
    SAL_RSO_STATUS_REJECT("SAL", "RSO_STATUS", "退货单状态", "REJECT", "商家拒绝售后"),
    SAL_RSO_STATUS_RTING("SAL", "RSO_STATUS", "退货单状态", "RTING", "买家退货中"),


    //退货类型
    SO_BACK_TYPE_10("SAL","SO_BACK_TYPE","销售订单退货类型","10","退货退款"),
    SO_BACK_TYPE_20("SAL","SO_BACK_TYPE","销售订单退货类型","20","仅退款"),
    SO_BACK_TYPE_30("SAL","SO_BACK_TYPE","销售订单退货类型","30","取消订单退款"),
    //帮助文档是否启用
    BIP_HELP_STATUS_TRUE("BOP","HELP_STATUS","文档是否启用","1","启用文档"),
    BIP_HELP_STATUS_FALSE("BOP","HELP_STATUS","文档是否启用","0","禁用文档"),

    //地址簿资质类型
    ORG_ADDR_QUALIFY_TYPE_10("ORG", "ADDR_QUALIFY_TYPE", "地址簿资质类型", "10", "法人营业执照"),
    ORG_ADDR_QUALIFY_TYPE_OTHER("ORG", "ADDR_QUALIFY_TYPE", "地址簿资质类型", "OTHER", "其它"),

    // 提成规则
    SAL_COMMISSION_RULE_RETURN("SAL", "COMMISSION_RULE", "提成规则", "10", "回款百分比"),
    SAL_COMMISSION_RULE_PROFIT("SAL", "COMMISSION_RULE", "提成规则", "20", "毛利百分比"),
    SAL_COMMISSION_RULE_PIECE("SAL", "COMMISSION_RULE", "提成规则", "30", "计件提成"),


    // B端udc
    COM_DOC_CLS_SO("COM","DOC_CLS","单据类别","SO","销售订单"),

    SAL_SO_STATUS_SHIP("SAL","SO_STATUS","销售订单状态","SHIP","已发货"),

    SAL_SO_TYPE2_B("SAL","SO_TYPE2","销售订单类型2","B","B端订单"),

    SAL_SO_TYPE_SOB1("SAL","SO_TYPE","销售订单类型","SOB1","B端商城常规线上订单"),

    SAL_SO_TYPE_SOB2("SAL","SO_TYPE","销售订单类型","SOB2","B端商城常规线下订单"),

    // 角色业务类型
    ROLE_BU_TYPE_NULL("yst-sale","ROLE_BU_TYPE","角色业务类型","NULL","无"),
    ROLE_BU_TYPE_PA("yst-sale","ROLE_BU_TYPE","角色业务类型","PA","配件"),
    ROLE_BU_TYPE_PAOR("yst-sale","ROLE_BU_TYPE","角色业务类型","PAOR","配件订货员"),
    ROLE_BU_TYPE_VE("yst-sale","ROLE_BU_TYPE","角色业务类型","VE","整车"),
    ROLE_BU_TYPE_VEPA("yst-sale","ROLE_BU_TYPE","角色业务类型","VEPA","整车配件"),
    ROLE_BU_TYPE_VEOR("yst-sale","ROLE_BU_TYPE","角色业务类型","VEOR","整车订货员"),
    ROLE_BU_TYPE_VEPAOR("yst-sale","ROLE_BU_TYPE","角色业务类型","VEPAOR","整车配件业务员"),
    ROLE_BU_TYPE_OR("yst-sale","ROLE_BU_TYPE","角色业务类型","OR","要货业务员"),

    //业务员任务管理的任务状态
    SALESMAN_TASK_STATUS_WRE("yst-sale", "SALESMAN_TASK_STATUS", "业务员任务状态", "WRE", "待发布"),
    SALESMAN_TASK_STATUS_WEE("yst-sale", "SALESMAN_TASK_STATUS", "业务员任务状态", "WEE", "待执行"),
    SALESMAN_TASK_STATUS_IPS("yst-sale", "SALESMAN_TASK_STATUS", "业务员任务状态", "IPS", "进行中"),
    SALESMAN_TASK_STATUS_CPD("yst-sale", "SALESMAN_TASK_STATUS", "业务员任务状态", "CPD", "已完成"),
    SALESMAN_TASK_STATUS_CCD("yst-sale", "SALESMAN_TASK_STATUS", "业务员任务状态", "CCD", "已取消"),
    SALESMAN_TASK_STATUS_CSD("yst-sale", "SALESMAN_TASK_STATUS", "业务员任务状态", "CSD", "已关闭"),
    //业务员任务管理的明细的完成状态
    SALESMAN_TASK_COMPLETION_STATUS_WRE("yst-sale", "TASK_COMPLETION_STATUS", "业务员任务明细完成状态", "WRE", "待发布"),
    SALESMAN_TASK_COMPLETION_STATUS_WEE("yst-sale", "TASK_COMPLETION_STATUS", "业务员任务明细完成状态", "WEE", "待执行"),
    SALESMAN_TASK_COMPLETION_STATUS_IPS("yst-sale", "TASK_COMPLETION_STATUS", "业务员任务明细完成状态", "IPS", "进行中"),
    SALESMAN_TASK_COMPLETION_STATUS_WAT("yst-sale", "TASK_COMPLETION_STATUS", "业务员任务明细完成状态", "WAT", "待审核"),
    SALESMAN_TASK_COMPLETION_STATUS_ARN("yst-sale", "TASK_COMPLETION_STATUS", "业务员任务明细完成状态", "ARN", "审核拒绝"),
    SALESMAN_TASK_COMPLETION_STATUS_CPD("yst-sale", "TASK_COMPLETION_STATUS", "业务员任务明细完成状态", "CPD", "已完成"),
    SALESMAN_TASK_COMPLETION_STATUS_CSD("yst-sale", "TASK_COMPLETION_STATUS", "业务员任务明细完成状态", "CSD", "已关闭"),
    SALESMAN_TASK_COMPLETION_STATUS_CCD("yst-sale", "TASK_COMPLETION_STATUS", "业务员任务明细完成状态", "CCD", "已取消"),
    //业务员任务管理的是否逾期
    SALESMAN_TASK_DELAY_FLAG_N("yst-sale", "TASK_DELAY_FLAG", "业务员任务是否逾期", "N", "未逾期"),
    SALESMAN_TASK_DELAY_FLAG_Y("yst-sale", "TASK_DELAY_FLAG", "业务员任务是否逾期", "Y", "已逾期"),
    //业务员任务管理的任务类型
    SALESMAN_TASK_TYPE_DST("yst-sale", "SALESMAN_TASK_TYPE", "业务员任务类型", "DST", "日常巡店"),
    SALESMAN_TASK_TYPE_SAS("yst-sale", "SALESMAN_TASK_TYPE", "业务员任务类型", "SAS", "门店活动"),
    SALESMAN_TASK_TYPE_SRG("yst-sale", "SALESMAN_TASK_TYPE", "业务员任务类型", "SRG", "门店提报"),
    //业务员任务管理的紧急程度
    SALESMAN_TASK_URGENCY_LEVEL_1("yst-sale", "TASK_URGENCY_LEVEL", "业务员任务紧急程度", "1", "较低"),
    SALESMAN_TASK_URGENCY_LEVEL_2("yst-sale", "TASK_URGENCY_LEVEL", "业务员任务紧急程度", "2", "一般"),
    SALESMAN_TASK_URGENCY_LEVEL_3("yst-sale", "TASK_URGENCY_LEVEL", "业务员任务紧急程度", "3", "紧急"),
    SALESMAN_TASK_URGENCY_LEVEL_4("yst-sale", "TASK_URGENCY_LEVEL", "业务员任务紧急程度", "4", "非常紧急"),
    //业务员任务管理的强制签到
    SALESMAN_TASK_FORCE_SIGN_FLAG_Y("yst-sale", "TASK_FORCE_SIGN_FLAG", "业务员任务强制签到", "Y", "是"),
    SALESMAN_TASK_FORCE_SIGN_FLAG_N("yst-sale", "TASK_FORCE_SIGN_FLAG", "业务员任务强制签到", "N", "否"),
    //业务员任务管理的明细的业务类型
    SALESMAN_TASK_BUSINESS_TYPE_STORE("yst-sale", "TASK_BUSINESS_TYPE", "业务员任务明细业务类型", "STORE", "门店"),
    SALESMAN_TASK_BUSINESS_TYPE_DEALER("yst-sale", "TASK_BUSINESS_TYPE", "业务员任务明细业务类型", "DEALER", "客户"),
    SALESMAN_TASK_BUSINESS_TYPE_SALESMAN("yst-sale", "TASK_BUSINESS_TYPE", "业务员任务明细业务类型", "SALESMAN", "业务员"),
    //业务员任务管理的重复设置的每周周几的值
    TASK_REPEAT_SET_WEEK_0("yst-sale", "TASK_REPEAT_SET_WEEK", "任务重复设置的每周周几的值", "0", "无"),
    TASK_REPEAT_SET_WEEK_1("yst-sale", "TASK_REPEAT_SET_WEEK", "任务重复设置的每周周几的值", "1", "周一"),
    TASK_REPEAT_SET_WEEK_2("yst-sale", "TASK_REPEAT_SET_WEEK", "任务重复设置的每周周几的值", "2", "周二"),
    TASK_REPEAT_SET_WEEK_3("yst-sale", "TASK_REPEAT_SET_WEEK", "任务重复设置的每周周几的值", "3", "周三"),
    TASK_REPEAT_SET_WEEK_4("yst-sale", "TASK_REPEAT_SET_WEEK", "任务重复设置的每周周几的值", "4", "周四"),
    TASK_REPEAT_SET_WEEK_5("yst-sale", "TASK_REPEAT_SET_WEEK", "任务重复设置的每周周几的值", "5", "周五"),
    TASK_REPEAT_SET_WEEK_6("yst-sale", "TASK_REPEAT_SET_WEEK", "任务重复设置的每周周几的值", "6", "周六"),
    TASK_REPEAT_SET_WEEK_7("yst-sale", "TASK_REPEAT_SET_WEEK", "任务重复设置的每周周几的值", "7", "周日"),
    //业务员任务管理的重复设置的每月几号的值
    TASK_REPEAT_SET_MONTH_0("yst-sale", "TASK_REPEAT_SET_MONTH", "任务重复设置的每月几号的值", "0", "无"),
    TASK_REPEAT_SET_MONTH_1("yst-sale", "TASK_REPEAT_SET_MONTH", "任务重复设置的每月几号的值", "1", "1"),
    TASK_REPEAT_SET_MONTH_2("yst-sale", "TASK_REPEAT_SET_MONTH", "任务重复设置的每月几号的值", "2", "2"),
    TASK_REPEAT_SET_MONTH_3("yst-sale", "TASK_REPEAT_SET_MONTH", "任务重复设置的每月几号的值", "3", "3"),
    TASK_REPEAT_SET_MONTH_4("yst-sale", "TASK_REPEAT_SET_MONTH", "任务重复设置的每月几号的值", "4", "4"),
    TASK_REPEAT_SET_MONTH_5("yst-sale", "TASK_REPEAT_SET_MONTH", "任务重复设置的每月几号的值", "5", "5"),
    TASK_REPEAT_SET_MONTH_6("yst-sale", "TASK_REPEAT_SET_MONTH", "任务重复设置的每月几号的值", "6", "6"),
    TASK_REPEAT_SET_MONTH_7("yst-sale", "TASK_REPEAT_SET_MONTH", "任务重复设置的每月几号的值", "7", "7"),
    TASK_REPEAT_SET_MONTH_8("yst-sale", "TASK_REPEAT_SET_MONTH", "任务重复设置的每月几号的值", "8", "8"),
    TASK_REPEAT_SET_MONTH_9("yst-sale", "TASK_REPEAT_SET_MONTH", "任务重复设置的每月几号的值", "9", "9"),
    TASK_REPEAT_SET_MONTH_10("yst-sale", "TASK_REPEAT_SET_MONTH", "任务重复设置的每月几号的值", "10", "10"),
    TASK_REPEAT_SET_MONTH_11("yst-sale", "TASK_REPEAT_SET_MONTH", "任务重复设置的每月几号的值", "11", "11"),
    TASK_REPEAT_SET_MONTH_12("yst-sale", "TASK_REPEAT_SET_MONTH", "任务重复设置的每月几号的值", "12", "12"),
    TASK_REPEAT_SET_MONTH_13("yst-sale", "TASK_REPEAT_SET_MONTH", "任务重复设置的每月几号的值", "13", "13"),
    TASK_REPEAT_SET_MONTH_14("yst-sale", "TASK_REPEAT_SET_MONTH", "任务重复设置的每月几号的值", "14", "14"),
    TASK_REPEAT_SET_MONTH_15("yst-sale", "TASK_REPEAT_SET_MONTH", "任务重复设置的每月几号的值", "15", "15"),
    TASK_REPEAT_SET_MONTH_16("yst-sale", "TASK_REPEAT_SET_MONTH", "任务重复设置的每月几号的值", "16", "16"),
    TASK_REPEAT_SET_MONTH_17("yst-sale", "TASK_REPEAT_SET_MONTH", "任务重复设置的每月几号的值", "17", "17"),
    TASK_REPEAT_SET_MONTH_18("yst-sale", "TASK_REPEAT_SET_MONTH", "任务重复设置的每月几号的值", "18", "18"),
    TASK_REPEAT_SET_MONTH_19("yst-sale", "TASK_REPEAT_SET_MONTH", "任务重复设置的每月几号的值", "19", "19"),
    TASK_REPEAT_SET_MONTH_20("yst-sale", "TASK_REPEAT_SET_MONTH", "任务重复设置的每月几号的值", "20", "20"),
    TASK_REPEAT_SET_MONTH_21("yst-sale", "TASK_REPEAT_SET_MONTH", "任务重复设置的每月几号的值", "21", "21"),
    TASK_REPEAT_SET_MONTH_22("yst-sale", "TASK_REPEAT_SET_MONTH", "任务重复设置的每月几号的值", "22", "22"),
    TASK_REPEAT_SET_MONTH_23("yst-sale", "TASK_REPEAT_SET_MONTH", "任务重复设置的每月几号的值", "23", "23"),
    TASK_REPEAT_SET_MONTH_24("yst-sale", "TASK_REPEAT_SET_MONTH", "任务重复设置的每月几号的值", "24", "24"),
    TASK_REPEAT_SET_MONTH_25("yst-sale", "TASK_REPEAT_SET_MONTH", "任务重复设置的每月几号的值", "25", "25"),
    TASK_REPEAT_SET_MONTH_26("yst-sale", "TASK_REPEAT_SET_MONTH", "任务重复设置的每月几号的值", "26", "26"),
    TASK_REPEAT_SET_MONTH_27("yst-sale", "TASK_REPEAT_SET_MONTH", "任务重复设置的每月几号的值", "27", "27"),
    TASK_REPEAT_SET_MONTH_28("yst-sale", "TASK_REPEAT_SET_MONTH", "任务重复设置的每月几号的值", "28", "28"),
    TASK_REPEAT_SET_MONTH_29("yst-sale", "TASK_REPEAT_SET_MONTH", "任务重复设置的每月几号的值", "29", "29"),
    TASK_REPEAT_SET_MONTH_30("yst-sale", "TASK_REPEAT_SET_MONTH", "任务重复设置的每月几号的值", "30", "30"),
    TASK_REPEAT_SET_MONTH_31("yst-sale", "TASK_REPEAT_SET_MONTH", "任务重复设置的每月几号的值", "31", "31"),




    //执行记录状态：草稿、待审核、审核拒绝、审核通过、已关闭
    EXECT_RECORD_STATUS_DR("yst-sale", "EXECT_RECORD_STATUS", "执行记录状态", "DR", "草稿"),
    EXECT_RECORD_STATUS_WAT("yst-sale", "EXECT_RECORD_STATUS", "执行记录状态", "WAT", "待审核"),
    EXECT_RECORD_STATUS_ARN("yst-sale", "EXECT_RECORD_STATUS", "执行记录状态", "ARN", "审核拒绝"),
    EXECT_RECORD_STATUS_CPD("yst-sale", "EXECT_RECORD_STATUS", "执行记录状态", "CPD", "审核通过"),
    EXECT_RECORD_STATUS_CSD("yst-sale", "EXECT_RECORD_STATUS", "执行记录状态", "CSD", "已关闭"),



    STATISTICS_TYPE_STORE("yst-sale", "STATISTICS_TYPE", "销售业绩类型", "STORE", "门店"),
    STATISTICS_TYPE_CUST("yst-sale", "STATISTICS_TYPE", "销售业绩类型", "CUST", "经销商"),

    STATISTICS_REGION_EMPTY_YES("yst-sale", "STATISTICS_REGION_EMPTY", "区域是否为空", "YES", "是"),
    STATISTICS_REGION_EMPTY_NO("yst-sale", "STATISTICS_REGION_EMPTY", "区域是否为空", "NO", "否"),
    STATISTICS_SALESMAN_PATH_EMPTY_YES("yst-sale", "STATISTICS_SALESMAN_PATH_EMPTY", "业务员是否为空", "YES", "是"),
    STATISTICS_SALESMAN_PATH_EMPTY_NO("yst-sale", "STATISTICS_SALESMAN_PATH_EMPTY", "业务员是否为空", "NO", "否"),


    // 经销售类型
    DEALER_TYPE_ONENET("yst-sale","DEALER_TYPE","经销商类型","ONENET","一网"),
    DEALER_TYPE_TWONET("yst-sale","DEALER_TYPE","经销商类型","TWONET","二网"),

    //文件上传类型
    UPLOAD_TYPE_IMAGE("yst-sale","UPLOAD_TYPE","经销商类型","IMAGE","图片"),

    //执行记录明细类型
    TEMP_FILE_UPLOAD("yst-sale","UPLOAD_TYPE","经销商类型","TEMP_FILE_UPLOAD","附件"),
    TEMP_IMAGE_UPLOAD("yst-sale","UPLOAD_TYPE","经销商类型","TEMP_IMAGE_UPLOAD","图片"),


    //收款核销状态
    SAL_RECEIPT_WRITEOFF_10("SAL", "RECEIPT_WRITEOFF", "收款核销状态", "10", "未核销"),
    SAL_RECEIPT_WRITEOFF_20("SAL", "RECEIPT_WRITEOFF", "收款核销状态", "20", "部分核销"),
    SAL_RECEIPT_WRITEOFF_30("SAL", "RECEIPT_WRITEOFF", "收款核销状态", "30", "已核销");


    private final String model;
    private final String code;
    private final String codeName;
    private final String valueCode;
    private final String valueCodeName;

    UdcEnum(final String model, final String code, final String codeName, final String valueCode, final String valueCodeName) {
        this.model = model;
        this.code = code;
        this.codeName = codeName;
        this.valueCode = valueCode;
        this.valueCodeName = valueCodeName;
    }

    public String getValueCodeName() {
        return valueCodeName;
    }

    public String getValueCode() {
        return valueCode;
    }

    public String getMsg() {
        return valueCodeName;
    }

    public String getModel() {
        return model;
    }

    public String getCode() {
        return code;
    }

    public String getCodeName() {
        return codeName;
    }

}
