package com.elitesland.yst.production.sale.controller.sal;

import com.elitescloud.boot.exception.BusinessException;
import com.elitesland.yst.production.sale.api.service.SalSoaService;
import com.elitesland.yst.production.sale.api.vo.param.pri.RmiDoDParam;
import com.elitesland.yst.production.sale.api.vo.param.sal.SalSoaExportPageParam;
import com.elitesland.yst.production.sale.api.vo.param.sal.SalSoaPageParam;
import com.elitesland.yst.production.sale.api.vo.resp.sal.RmiDoDVO;
import com.elitesland.yst.production.sale.api.vo.resp.sal.SalSoaRespVO;
import com.elitesland.yst.production.sale.controller.BaseController;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.yst.production.sale.core.util.excel.support.ExportColumnParam;
import com.github.xiaoymin.knife4j.annotations.ApiOperationSupport;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.MediaType;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletResponse;
import java.util.ArrayList;
import java.util.List;

/**
 * @auther JinXK
 * @date 2021/7/7 15:37
 */
@RestController
@RequestMapping(value = "/sal/soa", produces = MediaType.APPLICATION_JSON_VALUE)
@Api(tags = "客户对账单")
@Slf4j
public class SalSoaController extends BaseController {

    @Autowired
    private SalSoaService salSoaService;

    @PostMapping(value = "/query")
    @ApiOperation(value = "对账单分页查询")
    @ApiOperationSupport(order = 1)
    public ApiResult<PagingVO<SalSoaRespVO>> query(@RequestBody SalSoaPageParam pagingParam) {
        PagingVO<SalSoaRespVO> result = salSoaService.query(pagingParam);
        return ApiResult.ok(result);
    }

    @GetMapping(value = "/{id}")
    @ApiOperation(value = "对账单详情查询")
    @ApiOperationSupport(order = 2)
    public ApiResult<SalSoaRespVO> getById(@PathVariable Long id) {
        SalSoaRespVO result = salSoaService.getById(id);
        return ApiResult.ok(result);
    }

    @PostMapping(value = "/save")
    @ApiOperation(value = "对账单保存")
    @ApiOperationSupport(order = 3)
    public ApiResult<Object> save(@RequestBody SalSoaRespVO param) {
        return salSoaService.save(param);
    }

    @GetMapping(value = "/affirm/{id}")
    @ApiOperation(value = "对账单确认")
    @ApiOperationSupport(order = 3)
    public ApiResult<Object> affirm(@PathVariable Long id) {
        return salSoaService.affirm(id);
    }

    @GetMapping(value = "/obsolete/{id}")
    @ApiOperation(value = "对账单作废")
    @ApiOperationSupport(order = 3)
    public ApiResult<Object> obsolete(@PathVariable Long id) {
        return salSoaService.obsolete(id);
    }

    @PostMapping(value = "/selectDo")
    @ApiOperation(value = "发货单查询")
    @ApiOperationSupport(order = 4)
    public ApiResult<PagingVO<RmiDoDVO>> selectDo(@RequestBody RmiDoDParam param) {
        PagingVO<RmiDoDVO> result = salSoaService.selectDo(param);
        return ApiResult.ok(result);
    }

    @PostMapping(value = "/export")
    @ApiOperation(value = "对账单导出")
    @ApiOperationSupport(order = 5)
    public void SalSoaExport(HttpServletResponse response, @RequestBody SalSoaExportPageParam pageParam) {
        //导出列
        List<ExportColumnParam> columnParamList = new ArrayList<>(56);

        //确定导出字段
        columnParamList.add(new ExportColumnParam("docNo", "对账单号"));
        columnParamList.add(new ExportColumnParam("soaDate", "对账日期"));
        columnParamList.add(new ExportColumnParam("ouName", "公司名称"));
        columnParamList.add(new ExportColumnParam("custName", "客户名称"));
        columnParamList.add(new ExportColumnParam("custPic", "客户联系人"));
        columnParamList.add(new ExportColumnParam("custPicTel", "客户联系人电话"));

        columnParamList.add(new ExportColumnParam("soaAmt", "对账含税金额"));
        columnParamList.add(new ExportColumnParam("applyName", "对账人"));
        columnParamList.add(new ExportColumnParam("applyEmpTel", "对账联系人电话"));
        columnParamList.add(new ExportColumnParam("lineNo", "销售行号"));
        columnParamList.add(new ExportColumnParam("dodId", "发货单编号"));
        columnParamList.add(new ExportColumnParam("docTime", "发货日期"));

        columnParamList.add(new ExportColumnParam("confirmTime", "签收日期"));
        columnParamList.add(new ExportColumnParam("itemName", "商品名称"));
        columnParamList.add(new ExportColumnParam("itemSpec", "规格/型号"));
        columnParamList.add(new ExportColumnParam("doQty2", "发货数量"));
        columnParamList.add(new ExportColumnParam("confirmQty", "签收数量"));
        columnParamList.add(new ExportColumnParam("confirmAmt", "签收含税金额"));
        columnParamList.add(new ExportColumnParam("soUom", "计量单位"));
        columnParamList.add(new ExportColumnParam("doPrice", "含税单价"));

        log.info("对账单信息导出数据:{}",columnParamList);
        log.info("对账单导出方法参数:{}",pageParam);
        try {
            export(response, "对账单信息导出数据", columnParamList, salSoaService::searchForSalsoaExport, pageParam);
        } catch (Exception e) {
            throw new BusinessException("导出失败");
        }
    }

}
