package com.elitesland.yst.production.sale.entity;

import com.elitescloud.boot.model.entity.BaseModel;
import lombok.Data;
import lombok.experimental.Accessors;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;
import org.hibernate.annotations.Where;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import java.io.Serializable;

/**
 * Created with IntelliJ IDEA.
 *
 * @Author: wang yinghao
 * @Date: 2021/08/03/16:24
 * @Description:
 */

@Entity
@Table(name = "bip_special_area_item")
@org.hibernate.annotations.Table(appliesTo = "bip_special_area_item", comment = "专区商品关联表")
@Data
@DynamicInsert
@DynamicUpdate
@Accessors(chain = true)
@Where(clause = "delete_flag = 0 or delete_flag is null")
public class BipSpeciacAreaItemDo extends BaseModel implements Serializable {


    private static final long serialVersionUID = -4602850408569812336L;

    @Column(name = "special_area_id", columnDefinition = "varchar(20)  comment '专区id'" )
    private  Long specialAreaId;

    @Column(name = "special_area_code", columnDefinition = "varchar(32)  comment '专区编码'",nullable = false)
    private String specialAreaCode;

    @Column(name = "special_area_name", columnDefinition = "varchar(32)   comment '专区名称'")
    private String specialAreaName;

    @Column(name = "item_id", columnDefinition = "bigInt(20)   comment '商品id'")
    private Long itemId;

    @Column(name = "item_code", columnDefinition = "varchar(32)  comment '商品编码'",nullable = false)
    private String itemCode;


    @Column(name = "item_name", columnDefinition = "varchar(255)   comment '商品名称'")
    private String itemName;

}
