package com.elitesland.yst.production.sale.entity;

import com.elitescloud.boot.model.entity.BaseModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.experimental.Accessors;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;
import org.hibernate.annotations.Where;
import org.springframework.data.jpa.repository.config.EnableJpaAuditing;
import springfox.documentation.service.ApiListing;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import java.io.Serializable;

/**
 * <p>
 *
 * </p>
 *
 * @author zhao.zhi.hao
 * @since 2023/2/21 18:28
 */
@Entity
@Table(name = "de_account_purview", indexes = {
})
@org.hibernate.annotations.Table(appliesTo = "de_account_purview", comment = "权限集表")
@EnableJpaAuditing
@Data
@DynamicInsert
@DynamicUpdate
@Accessors(chain = true)
@Where(clause = "delete_flag = 0 or delete_flag is null")
public class DeAccountPurviewDO extends BaseModel implements Serializable {
    private static final long serialVersionUID = -7927481278200897333L;

    @ApiModelProperty("权限编码")
    @Column(name = "purview_code", columnDefinition = "varchar(64)   comment '权限编码'")
    private String purviewCode;

    @ApiModelProperty("权限名称")
    @Column(name = "purview_name", columnDefinition = "varchar(128)   comment '权限名称'")
    private String purviewName;
}
