package com.elitesland.yst.production.sale.entity;

import com.elitescloud.boot.model.entity.BaseModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.experimental.Accessors;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;
import org.hibernate.annotations.Where;
import org.springframework.data.jpa.repository.config.EnableJpaAuditing;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import java.io.Serializable;

@Entity
@Table(name = "first_special", indexes = {
})
@org.hibernate.annotations.Table(appliesTo = "first_special", comment = "首单特惠商品主表")
@EnableJpaAuditing
@Data
@DynamicInsert
@DynamicUpdate
@Accessors(chain = true)
@Where(clause = "delete_flag = 0 or delete_flag is null")
public class FirstSpecialDO  extends BaseModel implements Serializable {

    @Column(name = "ou_id", columnDefinition = "bigInt(20) not null  comment '公司id'")
    private Long ouId;

    @Column(name = "ou_code", columnDefinition = "varchar(32)   comment '公司编码'")
    private String ouCode;

    @Column(name = "ou_name", columnDefinition = "varchar(32)    comment '公司名称'")
    private String ouName;

    @Column(name = "item_id", columnDefinition = "bigInt(20) not null  comment '商品id'")
    private Long itemId;

    @Column(name = "item_code", columnDefinition = "varchar(32)    comment '商品编码'")
    private String itemCode;

    @Column(name = "item_name", columnDefinition = "varchar(256)  comment '商品名称'")
    private String itemName;

    @Column(name = "status", columnDefinition = "varchar(256)  comment '状态'")
    private String status;

    @ApiModelProperty("优先级")
    @Column(name = "sort", columnDefinition = "int(10) comment '排序'")
    private Integer sort;


}
