package com.elitesland.yst.production.sale.entity;

import com.elitescloud.boot.model.entity.BaseModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.experimental.Accessors;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import java.io.Serializable;
import java.math.BigDecimal;

/**
 * 物流运费模板明细
 */
@Entity
@Table(name = "logistics_template_d")
@org.hibernate.annotations.Table(appliesTo = "logistics_template_d", comment = "物流模板明细")
@Data
@DynamicInsert
@DynamicUpdate
@Accessors(chain = true)
public class LogisticsTemplateDDO extends BaseModel implements Serializable {

    @ApiModelProperty("物流运费模板id")
    @Column(name = "template_id", columnDefinition = "bigint(18)  comment '物流运费模板id'")
    private Long templateId;

    @ApiModelProperty("行号")
    @Column(name = "lin_no", columnDefinition = "int(10) comment '行号'")
    private Integer linNo;

    @ApiModelProperty("所属公司")
    @Column(name = "ou_id", columnDefinition = "bigint(18)  comment '所属公司'")
    private Long ouId;

    @ApiModelProperty("所属公司名称")
    @Column(name = "ou_name", columnDefinition = "varchar(256)  comment '所属公司名称'")
    private String ouName;

    @ApiModelProperty("方式")
    @Column(name = "mode", columnDefinition = "varchar(32)  comment '方式'")
    private String mode;

    @ApiModelProperty("发货省")
    @Column(name = "province_name", columnDefinition = "varchar(256)  comment '发货省'")
    private String provinceName;

    @ApiModelProperty("发货省代码")
    @Column(name = "province_code", columnDefinition = "varchar(256)  comment '发货省代码'")
    private String provinceCode;

    @ApiModelProperty("发货市")
    @Column(name = "city_name", columnDefinition = "varchar(256)  comment '发货市'")
    private String cityName;

    @ApiModelProperty("发货市代码")
    @Column(name = "city_code", columnDefinition = "varchar(256)  comment '发货市代码'")
    private String cityCode;

    @ApiModelProperty("区域")
    @Column(name = "area", columnDefinition = "varchar(32)  comment '区域'")
    private String area;

    @ApiModelProperty("默认件数")
    @Column(name = "piece_number", columnDefinition = "int(10) comment '件数'")
    private Integer pieceNumber;

    @ApiModelProperty("默认运费")
    @Column(name = "def_freight", columnDefinition = "decimal(20,8) comment '默认运费'")
    private BigDecimal defFreight;


    @ApiModelProperty("续件数")
    @Column(name = "continuyPiece_number", columnDefinition = "int(10) comment '续件数'")
    private Integer continuypieceNumber;

    @ApiModelProperty("增加运费")
    @Column(name = "add_freight", columnDefinition = "decimal(20,8) comment '增加运费'")
    private BigDecimal addFreight;


}
