package com.elitesland.yst.production.sale.event;

import lombok.Data;
import lombok.NoArgsConstructor;
import org.springframework.context.ApplicationEvent;

import java.math.BigDecimal;

/**
 * 商品降价事件.
 *
 * @author Kaiser（wang shao）
 * @date 2021/10/10
 */
public class ItemPriceReduceEvent extends ApplicationEvent {

    private static final long serialVersionUID = -1067577908281297049L;

    private String itemCode;

    private BigDecimal price;

    private String priceType;

    private String custLevel;

    public ItemPriceReduceEvent(Object source, String itemCode, BigDecimal price, String priceType, String custLevel) {
        super(source);
        this.itemCode = itemCode;
        this.price = price;
        this.priceType = priceType;
        this.custLevel = custLevel;
    }

    public String getItemCode() {
        return itemCode;
    }

    public void setItemCode(String itemCode) {
        this.itemCode = itemCode;
    }

    public BigDecimal getPrice() {
        return price;
    }

    public void setPrice(BigDecimal price) {
        this.price = price;
    }

    public String getPriceType() {
        return priceType;
    }

    public void setPriceType(String priceType) {
        this.priceType = priceType;
    }

    public String getCustLevel() {
        return custLevel;
    }

    public void setCustLevel(String custLevel) {
        this.custLevel = custLevel;
    }
}
