package com.elitesland.yst.production.sale.event.listener;

import cn.hutool.core.lang.Assert;
import com.elitesland.yst.production.sale.api.service.shop.BipItemEvalService;
import com.elitesland.yst.production.sale.api.service.shop.BipItemMngService;
import com.elitesland.yst.production.sale.event.ItemEvalChangeEvent;
import lombok.extern.slf4j.Slf4j;
import org.springframework.context.ApplicationListener;
import org.springframework.stereotype.Component;

import java.util.concurrent.CompletableFuture;

/**
 * .
 *
 * @author Kaiser（wang shao）
 * @date 2021/09/02
 */
@Component
@Slf4j
public class ItemEvalNumListener implements ApplicationListener<ItemEvalChangeEvent> {

    private final BipItemEvalService itemEvalService;
    private final BipItemMngService itemMngService;

    public ItemEvalNumListener(BipItemEvalService itemEvalService, BipItemMngService itemMngService) {
        this.itemEvalService = itemEvalService;
        this.itemMngService = itemMngService;
    }

    @Override
    public void onApplicationEvent(ItemEvalChangeEvent event) {
        if (event.getBipItemId() == null) {
            log.error("监听到商品评价变更事件，但商品ID为空");
            return;
        }

        log.debug("监听到商品【{}】的评价变更", event.getBipItemId());
        CompletableFuture.runAsync(() -> updateItemEvalNum(event.getBipItemId()))
                .exceptionally(e -> {
                    log.error("更新商品【" + event.getBipItemId() + "】评价数量发生异常", e);
                    return null;
                });
    }

    private void updateItemEvalNum(Long bipItemId) {
        // 总数量
        var totalResult = itemEvalService.countItemEval(bipItemId, null);
        Assert.isTrue(totalResult.isSuccess(), totalResult.getMsg());

        // 好评数量
        var goodResult = itemEvalService.countItemEval(bipItemId, 5);
        Assert.isTrue(goodResult.isSuccess(), goodResult.getMsg());

        itemMngService.updateEval(bipItemId, totalResult.getData(), goodResult.getData());

        // 分值
        var scoreResult = itemEvalService.countItemEvalScore(bipItemId);
        Assert.isTrue(scoreResult.isSuccess(), scoreResult.getMsg());
        itemMngService.updateEvalScore(bipItemId, scoreResult.getData());
    }
}
