package com.elitesland.yst.production.sale.ext.cpcn.param;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.io.Serializable;
import java.math.BigDecimal;

/**
 * @author Jason(zhao jun hui)
 * @date 2021/7/10
 */

@Data
@EqualsAndHashCode
@ApiModel(description = "中金提现参数")
public class CPCN4643Param implements Serializable {

    private static final long serialVersionUID = -2611962633551389109L;

    @ApiModelProperty("用户ID")
    public String userId;

    @ApiModelProperty("已绑定银行账号流水号")
    public String bindingTxSN;

    @ApiModelProperty("提现金额")
    public BigDecimal payAmount;

    @ApiModelProperty("确权方式")
    public String acceptanceConfirmType;

    @ApiModelProperty("回调地址")
    public String noticeURL;

    @ApiModelProperty("提现类型")
    public String arrivalType = "10";

    @ApiModelProperty("备注")
    public String remark;

    @ApiModelProperty("交易流水号")
    public String txSN;
}
