package com.elitesland.yst.production.sale.repo;

import com.elitesland.yst.production.sale.entity.QCrmCustOuDO;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.Predicate;
import com.querydsl.jpa.impl.JPAQueryFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;
import org.springframework.util.StringUtils;

/**
 * <p>
 *
 * </p>
 *
 * @author zhao.zhi.hao
 * @since 2021/6/27 15:35
 */
@Repository
public class CrmCustOuRepoProc {

    @Autowired
    private JPAQueryFactory jpaQueryFactory;
    private final QCrmCustOuDO qCrmCustOuDO = QCrmCustOuDO.crmCustOuDO;
    /**
     * 判断客户编码和所属公司是否已存在
     *
     * @param ouId     公司id
     * @param custCode 客户编码
     * @return 客户名称
     */
    public Boolean existsCodeAndOuId(String custCode, Long ouId) {
        Predicate predicate = qCrmCustOuDO.deleteFlag.eq(0).or(qCrmCustOuDO.deleteFlag.isNull());
        predicate = StringUtils.isEmpty(custCode) ? predicate : ExpressionUtils.and(predicate, qCrmCustOuDO.custCode.eq(custCode));
        predicate = StringUtils.isEmpty(ouId) ? predicate : ExpressionUtils.and(predicate, qCrmCustOuDO.ouId.eq(ouId));
        return jpaQueryFactory.select(qCrmCustOuDO)
                .from(qCrmCustOuDO)
                .where(predicate)
                .fetchCount() > 0;
    }
}
