package com.elitesland.yst.production.sale.repo;

import com.elitesland.yst.production.sale.common.constant.ConstantsSale;
import com.elitesland.yst.production.sale.entity.QCrmCustDO;
import com.elitesland.yst.production.sale.entity.QPriSalePriceAlterDO;
import com.querydsl.jpa.impl.JPAQueryFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

/**
 * @author Eric.li (Li Jia Zhe)
 * @date 2021/5/19 11:26
 */
@Repository
public class PriSalePriceAlterRepoProc {
    @Autowired
    private JPAQueryFactory jpaQueryFactory;
    private final QPriSalePriceAlterDO qPriSalePriceAlterDO = QPriSalePriceAlterDO.priSalePriceAlterDO;

    public Long getOuIdById(Long id) {
        return jpaQueryFactory.select(qPriSalePriceAlterDO.ouId)
                .from(qPriSalePriceAlterDO)
                .where(qPriSalePriceAlterDO.id.eq(id).and(qPriSalePriceAlterDO.deleteFlag.ne(ConstantsSale.COMMON_DELETE_YSE)))
                .fetchOne();
    }
}
