package com.elitesland.yst.production.sale.repo;

import com.elitesland.yst.production.sale.api.vo.param.sal.SalSoaPageParam;
import com.elitesland.yst.production.sale.api.vo.resp.sal.SalSoaRespVO;
import com.elitesland.yst.production.sale.entity.QSalSoaDDO;
import com.elitesland.yst.production.sale.entity.QSalSoaDO;
import com.elitescloud.cloudt.core.security.util.DataAuthJpaUtil;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.jpa.impl.JPAQuery;
import com.querydsl.jpa.impl.JPAQueryFactory;
import lombok.val;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;
import org.springframework.util.StringUtils;

/**
 * @auther JinXK
 * @date 2021/7/7 10:38
 */
@Repository
public class SalSoaRepoProc {
    @Autowired
    private JPAQueryFactory jpaQueryFactory;

    /**
     * 查询字段
     */
    public JPAQuery<SalSoaRespVO> select(SalSoaPageParam param) {
        val salSoaDO = QSalSoaDO.salSoaDO;
        val salSoaDDO = QSalSoaDDO.salSoaDDO;

        Predicate predicate = salSoaDO.isNotNull();
        val jpaQuery = jpaQueryFactory.select(Projections.bean(SalSoaRespVO.class,
                salSoaDO.id,
                salSoaDO.docNo,
                salSoaDO.custId,
                salSoaDO.custCode,
                salSoaDO.custName,
                salSoaDO.ouId,
                salSoaDO.ouCode,
                salSoaDO.ouName,
                salSoaDO.soaDate,
                salSoaDO.currCode,
                salSoaDO.soaStatus,
                salSoaDO.applyEmpId,
                salSoaDO.shippedAmt,
                salSoaDO.shippedNetAmt,
                salSoaDO.shippedTaxAmt,
                salSoaDO.confirmAmt,
                salSoaDO.confirmNetAmt,
                salSoaDO.confirmTaxAmt,
                salSoaDO.soaAmt,
                salSoaDO.soaNetAmt,
                salSoaDO.soaTaxAmt,
                salSoaDO.applyName,
                salSoaDO.applyDate,
                salSoaDO.receiptId,
                salSoaDO.receiptNo,
                salSoaDO.invApplyId,
                salSoaDO.invApplyNo,
                salSoaDO.soaInvStatus,
                salSoaDO.soaReceiptStatus,
                salSoaDO.applyDesc,
                salSoaDO.remark,
                salSoaDO.custPic,
                salSoaDO.custPicTel,
                salSoaDO.applyEmpTel,
                salSoaDO.buId,
                salSoaDO.buName,
                salSoaDO.invApplyAmt,
                salSoaDO.invApplyingAmt,
                salSoaDO.invApplyedAmt
                )).from(salSoaDO)
                .leftJoin(salSoaDDO).on(salSoaDDO.masId.eq(salSoaDO.id));
        if (param != null) {
            jpaQuery.where(where(param));
        }
        jpaQuery.where(predicate, salSoaDO.deleteFlag.eq(0).or(salSoaDO.deleteFlag.isNull()));
        jpaQuery.where(predicate, DataAuthJpaUtil.dataAuthJpaPredicate(salSoaDO.getMetadata()));
        jpaQuery.groupBy(salSoaDO.id);
        jpaQuery.orderBy(salSoaDO.modifyTime.desc());
        return jpaQuery;
    }

    /**
     * 条件查询
     *
     * @param param 查询条件
     */
    public Predicate where(SalSoaPageParam param){
        val salSoaDO = QSalSoaDO.salSoaDO;
        val salSoaDDO = QSalSoaDDO.salSoaDDO;
        Predicate predicate = salSoaDO.isNotNull().or(salSoaDO.isNull());
        if (!StringUtils.isEmpty(param.getId())) {
            predicate = ExpressionUtils.and(predicate, salSoaDO.id.eq(param.getId()));
        }
        if (!StringUtils.isEmpty(param.getOuId())) {
            predicate = ExpressionUtils.and(predicate, salSoaDO.ouId.eq(param.getOuId()));
        }
        if (!StringUtils.isEmpty(param.getSoaStatus())) {
            predicate = ExpressionUtils.and(predicate, salSoaDO.soaStatus.eq(param.getSoaStatus()));
        }
        if (!StringUtils.isEmpty(param.getSoaInvStatus())) {
            predicate = ExpressionUtils.and(predicate, salSoaDO.soaInvStatus.eq(param.getSoaInvStatus()));
        }
        if (!StringUtils.isEmpty(param.getSoaReceiptStatus())) {
            predicate = ExpressionUtils.and(predicate, salSoaDO.soaReceiptStatus.eq(param.getSoaReceiptStatus()));
        }
        if (!StringUtils.isEmpty(param.getDocNo())) {
            predicate = ExpressionUtils.and(predicate, salSoaDO.docNo.like("%"+param.getDocNo()+"%"));
        }
        if (!StringUtils.isEmpty(param.getCustName())) {
            predicate = ExpressionUtils.and(predicate, salSoaDO.custName.like("%"+param.getCustName()+"%"));
        }
        if (!StringUtils.isEmpty(param.getApplyName())) {
            predicate = ExpressionUtils.and(predicate, salSoaDO.applyName.like("%"+param.getApplyName()+"%"));
        }
        if (!StringUtils.isEmpty(param.getDoDocNo())) {
            predicate = ExpressionUtils.and(predicate, salSoaDDO.doDocNo.like("%"+param.getDoDocNo()+"%"));
        }
        if (!StringUtils.isEmpty(param.getSoNo())) {
            predicate = ExpressionUtils.and(predicate, salSoaDDO.soNo.like("%"+param.getSoNo()+"%"));
        }
        if (!StringUtils.isEmpty(param.getSoaDateStart())) {
            predicate = ExpressionUtils.and(predicate, salSoaDO.soaDate.after(param.getSoaDateStart()).or(salSoaDO.soaDate.eq(param.getSoaDateStart())));
        }
        if (!StringUtils.isEmpty(param.getSoaDateEnd())) {
            predicate = ExpressionUtils.and(predicate, salSoaDO.soaDate.before(param.getSoaDateEnd()));
        }
        if (!StringUtils.isEmpty(param.getTaxRate())) {
            predicate = ExpressionUtils.and(predicate, salSoaDDO.soTaxRate.eq(param.getTaxRate()));
        }
        return predicate;
    }
}
