package com.elitesland.yst.production.sale.repo;

import cn.hutool.core.collection.IterUtil;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.boot.jpa.common.BaseRepoProc;
import com.elitesland.yst.production.sale.api.vo.param.taskinfo.TaskInfoAppQueryVO;
import com.elitesland.yst.production.sale.api.vo.param.taskinfo.TaskInfoDtlQueryVO;
import com.elitesland.yst.production.sale.api.vo.resp.taskinfo.TaskInfoAppRespVO;
import com.elitesland.yst.production.sale.api.vo.resp.taskinfo.TaskInfoDtlRespVO;
import com.elitesland.yst.production.sale.common.constant.UdcEnum;
import com.elitesland.yst.production.sale.entity.QTaskInfoDO;
import com.elitesland.yst.production.sale.entity.QTaskInfoDtlDO;
import com.elitesland.yst.production.sale.entity.TaskInfoDtlDO;
import com.google.common.collect.Lists;
import com.querydsl.core.types.*;
import com.querydsl.core.types.dsl.BooleanExpression;
import com.querydsl.core.types.dsl.BooleanTemplate;
import com.querydsl.core.types.dsl.Expressions;
import com.querydsl.jpa.impl.JPAQuery;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

/**
 * <p>
 * 功能说明:业务员任务管理-明细
 * </p>
 *
 * @Author Darren
 * @Date 2023/04/10
 * @Version 1.0
 * @Content:
 */
@Component
public class TaskInfoDtlRepoProc extends BaseRepoProc<TaskInfoDtlDO> {

    @Autowired
    private TaskInfoDtlRepo taskInfoDtlRepo;
    private static final QTaskInfoDtlDO qTaskInfoDtlDO = QTaskInfoDtlDO.taskInfoDtlDO;
    private static final QTaskInfoDO qTaskInfoDO = QTaskInfoDO.taskInfoDO;

    /**
     * 业务员任务管理的是否逾期-已逾期
     */
    public static final String DELAY_FLAG_Y = UdcEnum.SALESMAN_TASK_DELAY_FLAG_Y.getValueCode();
    /**
     * 业务员任务管理的明细的完成状态-需要按照顺序
     * 全部时：先按照状态：进行中>待执行>审核拒绝>待审核>已完成；
     */
    public static final String COMPLETION_STATUS_LIST =  new StringBuilder()
            .append(UdcEnum.SALESMAN_TASK_COMPLETION_STATUS_IPS.getValueCode()+",")
            .append(UdcEnum.SALESMAN_TASK_COMPLETION_STATUS_WEE.getValueCode()+",")
            .append(UdcEnum.SALESMAN_TASK_COMPLETION_STATUS_ARN.getValueCode()+",")
            .append(UdcEnum.SALESMAN_TASK_COMPLETION_STATUS_WAT.getValueCode()+",")
            .append(UdcEnum.SALESMAN_TASK_COMPLETION_STATUS_CPD.getValueCode()).toString();

    /**
     * 业务员任务管理的明细的完成状态-需要按照顺序
     * 已逾期时：先按照状态：待执行>进行中>待审核>审核拒绝；
     */
    public static final String OVERDUE_COMPLETION_STATUS_LIST =  new StringBuilder()
            .append(UdcEnum.SALESMAN_TASK_COMPLETION_STATUS_WEE.getValueCode()+",")
            .append(UdcEnum.SALESMAN_TASK_COMPLETION_STATUS_IPS.getValueCode()+",")
            .append(UdcEnum.SALESMAN_TASK_COMPLETION_STATUS_WAT.getValueCode()+",")
            .append(UdcEnum.SALESMAN_TASK_COMPLETION_STATUS_ARN.getValueCode()).toString();

    /**
     * 业务员任务管理的紧急程度-需要按照顺序
     * 全部时：非常紧急、紧急、一般、较低；
     */
    public static final String URGENCY_LEVEL_LIST =  new StringBuilder()
            .append(UdcEnum.SALESMAN_TASK_URGENCY_LEVEL_4.getValueCode()+",")
            .append(UdcEnum.SALESMAN_TASK_URGENCY_LEVEL_3.getValueCode()+",")
            .append(UdcEnum.SALESMAN_TASK_URGENCY_LEVEL_2.getValueCode()+",")
            .append(UdcEnum.SALESMAN_TASK_URGENCY_LEVEL_1.getValueCode()).toString();

    protected TaskInfoDtlRepoProc() {
        super(qTaskInfoDtlDO);
    }

    public List<TaskInfoDtlRespVO> selectByQueryVO(TaskInfoDtlQueryVO queryVO) {
        List<Predicate> where = where(queryVO);
        JPAQuery<TaskInfoDtlRespVO> jpaQuery = select(TaskInfoDtlRespVO.class).where(ExpressionUtils.allOf(where));
        return jpaQuery.fetch();
    }

    public PagingVO<TaskInfoDtlRespVO> page(TaskInfoDtlQueryVO queryVO) {
        List<Predicate> where = where(queryVO);
        JPAQuery<TaskInfoDtlRespVO> query = select(TaskInfoDtlRespVO.class).where(ExpressionUtils.allOf(where));
        queryVO.setPaging(query);
        queryVO.fillOrders(query, qTaskInfoDtlDO);
        return PagingVO.<TaskInfoDtlRespVO>builder()
                .total(query.fetchCount())
                .records(query.fetch())
                .build();
    }

    private List<Predicate> where(TaskInfoDtlQueryVO queryVO) {
        List<Predicate> predicates = new ArrayList<>();
        //predicates.add(qTaskInfoDtlDO.deleteFlag.eq(0).or(qTaskInfoDtlDO.deleteFlag.isNull()));

        if (!Objects.isNull(queryVO.getId())) {
            predicates.add(qTaskInfoDtlDO.id.eq(queryVO.getId()));
        }
        if (!CollectionUtils.isEmpty(queryVO.getIds())) {
            predicates.add(qTaskInfoDtlDO.id.in(queryVO.getIds()));
        }
        if (!Objects.isNull(queryVO.getMasId())) {
            predicates.add(qTaskInfoDtlDO.masId.eq(queryVO.getMasId()));
        }
        if (!CollectionUtils.isEmpty(queryVO.getMasIds())) {
            predicates.add(qTaskInfoDtlDO.masId.in(queryVO.getMasIds()));
        }
        if (!Objects.isNull(queryVO.getLineNo())) {
            predicates.add(qTaskInfoDtlDO.lineNo.eq(queryVO.getLineNo()));
        }
        if (!StringUtils.isEmpty(queryVO.getBusinessType())) {
            predicates.add(qTaskInfoDtlDO.businessType.eq(queryVO.getBusinessType()));
        }
        if (!CollectionUtils.isEmpty(queryVO.getBusinessTypes())) {
            predicates.add(qTaskInfoDtlDO.businessType.in(queryVO.getBusinessTypes()));
        }
        if (!StringUtils.isEmpty(queryVO.getBusinessCode())) {
            predicates.add(qTaskInfoDtlDO.businessCode.eq(queryVO.getBusinessCode()));
        }
        if (!CollectionUtils.isEmpty(queryVO.getBusinessCodes())) {
            predicates.add(qTaskInfoDtlDO.businessCode.in(queryVO.getBusinessCodes()));
        }
        /*if (!StringUtils.isEmpty(queryVO.getBusinessCode())) {
            predicates.add(Expressions.booleanTemplate("FIND_IN_SET({0},{1}) >0", queryVO.getBusinessCode(), qTaskInfoDtlDO.businessCode));
        }
        if (!CollectionUtils.isEmpty(queryVO.getBusinessCodes())) {
            List<Predicate> booleanTemplateList = new ArrayList<>();
            for (String businessCode : queryVO.getBusinessCodes()) {
                BooleanTemplate booleanTemplate = Expressions.booleanTemplate("FIND_IN_SET({0},{1}) >0",businessCode, qTaskInfoDtlDO.businessCode);
                booleanTemplateList.add(booleanTemplate);
            }
            predicates.add(ExpressionUtils.anyOf(booleanTemplateList));
        }*/
        if (!StringUtils.isEmpty(queryVO.getBusinessKeyword())) {
            predicates.add(qTaskInfoDtlDO.businessCode.like("%" + queryVO.getBusinessKeyword() + "%").or(qTaskInfoDtlDO.businessName.like("%" + queryVO.getBusinessKeyword() + "%")));
        }

        if (!Objects.isNull(queryVO.getBusinessId())) {
            predicates.add(qTaskInfoDtlDO.businessId.eq(queryVO.getBusinessId()));
        }
        if (!StringUtils.isEmpty(queryVO.getBusinessName())) {
            predicates.add(qTaskInfoDtlDO.businessName.like("%" + queryVO.getBusinessName() + "%"));
        }
        if (!StringUtils.isEmpty(queryVO.getDealerCode())) {
            predicates.add(qTaskInfoDtlDO.dealerCode.eq(queryVO.getDealerCode()));
        }
        if (!CollectionUtils.isEmpty(queryVO.getDealerCodes())) {
            predicates.add(qTaskInfoDtlDO.dealerCode.in(queryVO.getDealerCodes()));
        }
        if (!Objects.isNull(queryVO.getDealerId())) {
            predicates.add(qTaskInfoDtlDO.dealerId.eq(queryVO.getDealerId()));
        }
        if (!StringUtils.isEmpty(queryVO.getDealerName())) {
            predicates.add(qTaskInfoDtlDO.dealerName.like("%" + queryVO.getDealerName() + "%"));
        }
        if (!Objects.isNull(queryVO.getExecutUserId())) {
            predicates.add(qTaskInfoDtlDO.executUserId.eq(queryVO.getExecutUserId()));
        }
        if (!StringUtils.isEmpty(queryVO.getExecutUser())) {
            predicates.add(qTaskInfoDtlDO.executUser.like("%" + queryVO.getExecutUser() + "%"));
        }
        if (!StringUtils.isEmpty(queryVO.getExecutUserCode())) {
            predicates.add(qTaskInfoDtlDO.executUserCode.eq(queryVO.getExecutUserCode()));
        }
        if (!CollectionUtils.isEmpty(queryVO.getExecutUserCodes())) {
            predicates.add(qTaskInfoDtlDO.executUserCode.in(queryVO.getExecutUserCodes()));
        }

        if (queryVO.getCompleteTimeS() != null && queryVO.getCompleteTimeE() != null) {
            predicates.add(qTaskInfoDtlDO.completeTime.between(queryVO.getCompleteTimeS(), queryVO.getCompleteTimeE()));
        } else {
            if (queryVO.getCompleteTimeS() != null) {
                predicates.add(qTaskInfoDtlDO.completeTime.goe(queryVO.getCompleteTimeS()));
            }
            if (queryVO.getCompleteTimeE() != null) {
                predicates.add(qTaskInfoDtlDO.completeTime.loe(queryVO.getCompleteTimeE()));
            }
        }
        if (!StringUtils.isEmpty(queryVO.getCompleteState())) {
            predicates.add(qTaskInfoDtlDO.completeState.eq(queryVO.getCompleteState()));
        }
        if (!CollectionUtils.isEmpty(queryVO.getCompleteStates())) {
            predicates.add(qTaskInfoDtlDO.completeState.in(queryVO.getCompleteStates()));
        }
        if (!StringUtils.isEmpty(queryVO.getNoCompleteState())) {
            predicates.add(qTaskInfoDtlDO.completeState.ne(queryVO.getNoCompleteState()));
        }
        if (!StringUtils.isEmpty(queryVO.getDelayFlag())) {
            predicates.add(qTaskInfoDtlDO.delayFlag.eq(queryVO.getDelayFlag()));
        }
        if (!StringUtils.isEmpty(queryVO.getExecutRecordCode())) {
            predicates.add(qTaskInfoDtlDO.executRecordCode.eq(queryVO.getExecutRecordCode()));
        }
        if (!CollectionUtils.isEmpty(queryVO.getExecutRecordCodes())) {
            predicates.add(qTaskInfoDtlDO.executRecordCode.in(queryVO.getExecutRecordCodes()));
        }
        if (!StringUtils.isEmpty(queryVO.getExecutRecordKeyword())) {
            predicates.add(qTaskInfoDtlDO.executRecordCode.like("%" + queryVO.getExecutRecordKeyword() + "%").or(qTaskInfoDtlDO.executRecordName.like("%" + queryVO.getExecutRecordKeyword() + "%")));
        }
        if (!Objects.isNull(queryVO.getExecutRecordId())) {
            predicates.add(qTaskInfoDtlDO.executRecordId.eq(queryVO.getExecutRecordId()));
        }
        if (!StringUtils.isEmpty(queryVO.getExecutRecordName())) {
            predicates.add(qTaskInfoDtlDO.executRecordName.like("%" + queryVO.getExecutRecordName() + "%"));
        }
        if (!Objects.isNull(queryVO.getEmployeeId())) {
            predicates.add(qTaskInfoDtlDO.employeeId.eq(queryVO.getEmployeeId()));
        }

        return predicates;
    }

    private <T> JPAQuery<T> select(Class<T> cls) {
        return jpaQueryFactory.select(Projections.bean(cls,
                qTaskInfoDtlDO.id,
                qTaskInfoDtlDO.masId,
                qTaskInfoDtlDO.lineNo,
                qTaskInfoDtlDO.businessType,
                qTaskInfoDtlDO.businessCode,
                qTaskInfoDtlDO.businessId,
                qTaskInfoDtlDO.custCode2,
                qTaskInfoDtlDO.businessName,
                qTaskInfoDtlDO.dealerId,
                qTaskInfoDtlDO.dealerCode,
                qTaskInfoDtlDO.dealerName,
                qTaskInfoDtlDO.businessTime,
                qTaskInfoDtlDO.country,
                qTaskInfoDtlDO.province,
                qTaskInfoDtlDO.city,
                qTaskInfoDtlDO.district,
                qTaskInfoDtlDO.address,
                qTaskInfoDtlDO.executUser,
                qTaskInfoDtlDO.executUserId,
                qTaskInfoDtlDO.executUserCode,
                qTaskInfoDtlDO.completeTime,
                qTaskInfoDtlDO.completeState,
                qTaskInfoDtlDO.delayFlag,
                qTaskInfoDtlDO.executRecordName,
                qTaskInfoDtlDO.executRecordId,
                qTaskInfoDtlDO.executRecordCode,
                qTaskInfoDtlDO.xLon.as("longitude"),
                qTaskInfoDtlDO.yLat.as("latitude"),
                qTaskInfoDtlDO.coordType,
                qTaskInfoDtlDO.employeeId,
                qTaskInfoDtlDO.remark,
                qTaskInfoDtlDO.createTime,
                qTaskInfoDtlDO.createUserId,
                qTaskInfoDtlDO.creator,
                qTaskInfoDtlDO.modifyTime,
                qTaskInfoDtlDO.modifyUserId,
                qTaskInfoDtlDO.updater,
                qTaskInfoDtlDO.tenantId,
                qTaskInfoDtlDO.deleteFlag
        )).from(qTaskInfoDtlDO);
    }

    public void updateDeleteFlag(Integer deleteFlag, Long masId) {
        jpaQueryFactory.update(qTaskInfoDtlDO)
                .set(qTaskInfoDtlDO.deleteFlag, deleteFlag)
                .where(qTaskInfoDtlDO.masId.eq(masId))
                .execute();
    }

    public void updateDeleteFlagBatch(Integer deleteFlag, List<Long> masIds) {
        jpaQueryFactory.update(qTaskInfoDtlDO)
                .set(qTaskInfoDtlDO.deleteFlag, deleteFlag)
                .where(qTaskInfoDtlDO.masId.in(masIds))
                .execute();
    }

    public void updateCompleteStateByMasId(String completeState, Long masId) {
        jpaQueryFactory.update(qTaskInfoDtlDO)
                .set(qTaskInfoDtlDO.completeState, completeState)
                .where(qTaskInfoDtlDO.masId.eq(masId))
                .execute();
    }

    public void updateCompleteStateAndCompleteTimeByMasId(String completeState, LocalDateTime completeTime, Long masId) {
        jpaQueryFactory.update(qTaskInfoDtlDO)
                .set(qTaskInfoDtlDO.completeState, completeState)
                .set(qTaskInfoDtlDO.completeTime, completeTime)
                .where(qTaskInfoDtlDO.masId.eq(masId))
                .execute();
    }

    public void updateCompleteStateById(String completeState, Long id) {
        jpaQueryFactory.update(qTaskInfoDtlDO)
                .set(qTaskInfoDtlDO.completeState, completeState)
                .where(qTaskInfoDtlDO.id.eq(id))
                .execute();
    }

    public void updateCompleteStateByIdBatch(String completeState, List<Long> ids) {
        jpaQueryFactory.update(qTaskInfoDtlDO)
                .set(qTaskInfoDtlDO.completeState, completeState)
                .where(qTaskInfoDtlDO.id.in(ids))
                .execute();
    }

    public void updateCompleteStateAndTimeByIdBatch(String completeState, LocalDateTime completeTime,List<Long> ids) {
        jpaQueryFactory.update(qTaskInfoDtlDO)
                .set(qTaskInfoDtlDO.completeState, completeState)
                .set(qTaskInfoDtlDO.completeTime, completeTime)
                .where(qTaskInfoDtlDO.id.in(ids))
                .execute();
    }

    public void updateCompleteStateAndTimeById(String completeState, LocalDateTime completeTime, Long id) {
        jpaQueryFactory.update(qTaskInfoDtlDO)
                .set(qTaskInfoDtlDO.completeState, completeState)
                .set(qTaskInfoDtlDO.completeTime, completeTime)
                .where(qTaskInfoDtlDO.id.eq(id))
                .execute();
    }

    public void updateExecuteUserByIdBatch(String executUser, Long executUserId, String executUserCode, Long employeeId,List<Long> ids) {
        jpaQueryFactory.update(qTaskInfoDtlDO)
                .set(qTaskInfoDtlDO.executUser, executUser)
                .set(qTaskInfoDtlDO.executUserId, executUserId)
                .set(qTaskInfoDtlDO.executUserCode, executUserCode)
                .set(qTaskInfoDtlDO.employeeId, employeeId)
                .where(qTaskInfoDtlDO.id.in(ids))
                .execute();
    }

    public void updateExecuteRecordById(String executRecordCode, Long executRecordId, String executRecordName, Long id) {
        jpaQueryFactory.update(qTaskInfoDtlDO)
                .set(qTaskInfoDtlDO.executRecordCode, executRecordCode)
                .set(qTaskInfoDtlDO.executRecordId, executRecordId)
                .set(qTaskInfoDtlDO.executRecordName, executRecordName)
                .where(qTaskInfoDtlDO.id.eq(id))
                .execute();
    }

    public void updateDelayFlagByIdBatch(String delayFlag, List<Long> ids) {
        jpaQueryFactory.update(qTaskInfoDtlDO)
                .set(qTaskInfoDtlDO.delayFlag, delayFlag)
                .where(qTaskInfoDtlDO.id.in(ids))
                .execute();
    }

    public PagingVO<TaskInfoAppRespVO> selectAppTask(TaskInfoAppQueryVO queryVO) {
        List<Predicate> where = whereApp(queryVO);
        JPAQuery<TaskInfoAppRespVO> jpaQuery = selectApp(TaskInfoAppRespVO.class).where(ExpressionUtils.allOf(where));

        OrderSpecifier orderSpecifier1 = new OrderSpecifier(Order.ASC,
                Expressions.stringTemplate("CASE WHEN {0} = '" + DELAY_FLAG_Y + "' THEN 1 ELSE 2 END ", qTaskInfoDtlDO.delayFlag));
        jpaQuery.orderBy(orderSpecifier1);
        OrderSpecifier orderSpecifier2 = new OrderSpecifier(Order.ASC,
                Expressions.stringTemplate("FIND_IN_SET({0},{1})", qTaskInfoDtlDO.completeState, COMPLETION_STATUS_LIST));
        jpaQuery.orderBy(orderSpecifier2);
        OrderSpecifier orderSpecifier3 = new OrderSpecifier(Order.ASC,
                Expressions.stringTemplate("FIND_IN_SET({0},{1})", qTaskInfoDO.urgencyLevel, URGENCY_LEVEL_LIST));
        jpaQuery.orderBy(orderSpecifier3);
        jpaQuery.orderBy(qTaskInfoDO.endTime.asc());
        queryVO.setPaging(jpaQuery);
        return PagingVO.<TaskInfoAppRespVO>builder()
                .total(jpaQuery.fetchCount())
                .records(jpaQuery.fetch())
                .build();
    }

    public PagingVO<TaskInfoAppRespVO> selectAppTaskComplete(TaskInfoAppQueryVO queryVO) {
        List<Predicate> where = whereApp(queryVO);
        JPAQuery<TaskInfoAppRespVO> jpaQuery = selectApp(TaskInfoAppRespVO.class).where(ExpressionUtils.allOf(where));

        jpaQuery.orderBy(qTaskInfoDO.createTime.desc());
        queryVO.setPaging(jpaQuery);
        return PagingVO.<TaskInfoAppRespVO>builder()
                .total(jpaQuery.fetchCount())
                .records(jpaQuery.fetch())
                .build();
    }

    public PagingVO<TaskInfoAppRespVO> selectAppTaskOverdue(TaskInfoAppQueryVO queryVO) {
        List<Predicate> where = whereApp(queryVO);
        JPAQuery<TaskInfoAppRespVO> jpaQuery = selectApp(TaskInfoAppRespVO.class).where(ExpressionUtils.allOf(where));

        OrderSpecifier orderSpecifier2 = new OrderSpecifier(Order.ASC,
                Expressions.stringTemplate("FIND_IN_SET({0},{1})", qTaskInfoDtlDO.completeState, OVERDUE_COMPLETION_STATUS_LIST));
        jpaQuery.orderBy(orderSpecifier2);
        OrderSpecifier orderSpecifier3 = new OrderSpecifier(Order.ASC,
                Expressions.stringTemplate("FIND_IN_SET({0},{1})", qTaskInfoDO.urgencyLevel, URGENCY_LEVEL_LIST));
        jpaQuery.orderBy(orderSpecifier3);
        jpaQuery.orderBy(qTaskInfoDO.endTime.asc());
        queryVO.setPaging(jpaQuery);
        return PagingVO.<TaskInfoAppRespVO>builder()
                .total(jpaQuery.fetchCount())
                .records(jpaQuery.fetch())
                .build();
    }

    public PagingVO<TaskInfoAppRespVO> selectAppTaskOther(TaskInfoAppQueryVO queryVO) {
        List<Predicate> where = whereApp(queryVO);
        JPAQuery<TaskInfoAppRespVO> jpaQuery = selectApp(TaskInfoAppRespVO.class).where(ExpressionUtils.allOf(where));

        OrderSpecifier orderSpecifier3 = new OrderSpecifier(Order.ASC,
                Expressions.stringTemplate("FIND_IN_SET({0},{1})", qTaskInfoDO.urgencyLevel, URGENCY_LEVEL_LIST));
        jpaQuery.orderBy(orderSpecifier3);
        jpaQuery.orderBy(qTaskInfoDO.endTime.asc());
        queryVO.setPaging(jpaQuery);
        return PagingVO.<TaskInfoAppRespVO>builder()
                .total(jpaQuery.fetchCount())
                .records(jpaQuery.fetch())
                .build();
    }

    private List<Predicate> whereApp(TaskInfoAppQueryVO queryVO) {
        List<Predicate> predicates = new ArrayList<>();

        if (!StringUtils.isEmpty(queryVO.getExecutUserCode())) {
            predicates.add(qTaskInfoDtlDO.executUserCode.eq(queryVO.getExecutUserCode()));
        }
        if (!CollectionUtils.isEmpty(queryVO.getExecutUserCodes())) {
            predicates.add(qTaskInfoDtlDO.executUserCode.in(queryVO.getExecutUserCodes()));
        }
        if (!StringUtils.isEmpty(queryVO.getCompleteState())) {
            predicates.add(qTaskInfoDtlDO.completeState.eq(queryVO.getCompleteState()));
        }
        if (!CollectionUtils.isEmpty(queryVO.getCompleteStates())) {
            predicates.add(qTaskInfoDtlDO.completeState.in(queryVO.getCompleteStates()));
        }
        if (!StringUtils.isEmpty(queryVO.getDelayFlag())) {
            predicates.add(qTaskInfoDtlDO.delayFlag.eq(queryVO.getDelayFlag()));
        }
        if (!StringUtils.isEmpty(queryVO.getType())) {
            predicates.add(qTaskInfoDO.type.eq(queryVO.getType()));
        }
        if (!CollectionUtils.isEmpty(queryVO.getTypeList())) {
            predicates.add(qTaskInfoDO.type.in(queryVO.getTypeList()));
        }
        if (!StringUtils.isEmpty(queryVO.getQueryKeyword())) {
            /*predicates.add(qTaskInfoDO.name.like("%" + queryVO.getQueryKeyword() + "%")
                    .or(qTaskInfoDtlDO.executUserCode.in(queryVO.getExecutUserCodeList())));*/
            List<Predicate> predicateList = new ArrayList<>();
            Predicate predicate1 = qTaskInfoDO.name.like("%" + queryVO.getQueryKeyword() + "%");
            predicateList.add(predicate1);
            if (!CollectionUtils.isEmpty(queryVO.getExecutUserCodeList())){
                Predicate predicate2 = qTaskInfoDtlDO.executUserCode.in(queryVO.getExecutUserCodeList());
                predicateList.add(predicate2);
            }
            predicates.add(ExpressionUtils.anyOf(predicateList));

           /* predicates.add(ExpressionUtils.or(qTaskInfoDO.name.like("%" + queryVO.getQueryKeyword() + "%"),
                    qTaskInfoDtlDO.executUserCode.in(queryVO.getExecutUserCodeList())));*/
        }
        if (!Objects.isNull(queryVO.getEmployeeId())) {
            predicates.add(qTaskInfoDtlDO.employeeId.eq(queryVO.getEmployeeId()));
        }
        if (!StringUtils.isEmpty(queryVO.getBusinessKeyword())) {
            predicates.add(qTaskInfoDtlDO.businessCode.like("%" + queryVO.getBusinessKeyword() + "%").or(qTaskInfoDtlDO.businessName.like("%" + queryVO.getBusinessKeyword() + "%")));
        }

        if (!StringUtils.isEmpty(queryVO.getExecutRecordKeyword())) {
            predicates.add(qTaskInfoDtlDO.executRecordCode.like("%" + queryVO.getExecutRecordKeyword() + "%").or(qTaskInfoDtlDO.executRecordName.like("%" + queryVO.getExecutRecordKeyword() + "%")));
        }
        return predicates;
    }

    private <T> JPAQuery<T> selectApp(Class<T> cls) {
        return jpaQueryFactory.select(Projections.bean(cls,
                qTaskInfoDtlDO.id,
                qTaskInfoDtlDO.businessType,
                qTaskInfoDtlDO.businessCode,
                qTaskInfoDtlDO.custCode2,
                qTaskInfoDtlDO.businessName,
                qTaskInfoDtlDO.country,
                qTaskInfoDtlDO.province,
                qTaskInfoDtlDO.city,
                qTaskInfoDtlDO.district,
                qTaskInfoDtlDO.address,
                qTaskInfoDtlDO.completeState,
                qTaskInfoDtlDO.delayFlag,
                qTaskInfoDtlDO.executRecordId,
                qTaskInfoDtlDO.executRecordCode,
                qTaskInfoDtlDO.executRecordName,
                qTaskInfoDtlDO.executUser,
                qTaskInfoDtlDO.executUserId,
                qTaskInfoDtlDO.executUserCode,
                qTaskInfoDtlDO.businessTime,
                qTaskInfoDtlDO.xLon.as("longitude"),
                qTaskInfoDtlDO.yLat.as("latitude"),
                qTaskInfoDtlDO.coordType,
                qTaskInfoDtlDO.employeeId,
                qTaskInfoDO.id.as("masId"),
                qTaskInfoDO.code,
                qTaskInfoDO.name,
                qTaskInfoDO.state,
                qTaskInfoDO.progress,
                qTaskInfoDO.type,
                qTaskInfoDO.urgencyLevel,
                qTaskInfoDO.startTime,
                qTaskInfoDO.endTime,
                qTaskInfoDO.forceSignFlag,
                qTaskInfoDO.signInRange,
                qTaskInfoDO.signOutRange,
                qTaskInfoDO.executTemplateCode,
                qTaskInfoDO.executTemplateName
        )).from(qTaskInfoDtlDO).leftJoin(qTaskInfoDO)
                .on(qTaskInfoDO.id.eq(qTaskInfoDtlDO.masId));
    }

    public List<TaskInfoDtlDO> getByMasId(Long masId){
        BooleanExpression e = qTaskInfoDtlDO.deleteFlag.eq(0).and(qTaskInfoDtlDO.masId.eq(masId));
        Iterable<TaskInfoDtlDO> iterable = taskInfoDtlRepo.findAll(e);
        if(IterUtil.isNotEmpty(iterable)){
            return Lists.newArrayList(iterable);
        }
        return new ArrayList<>();
    }

}
