package com.elitesland.yst.production.sale.repo;

import com.elitesland.yst.production.sale.api.vo.param.zone.ZoneSettingDetailPageParam;
import com.elitesland.yst.production.sale.api.vo.resp.zone.ZoneRecParam;
import com.elitesland.yst.production.sale.api.vo.resp.zone.ZoneSettingDVO;
import com.elitesland.yst.production.sale.entity.QZoneSettingDDO;
import com.elitesland.yst.production.sale.entity.QZoneSettingDO;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.core.types.dsl.BooleanExpression;
import com.querydsl.jpa.impl.JPAQuery;
import com.querydsl.jpa.impl.JPAQueryFactory;
import java.util.List;
import lombok.RequiredArgsConstructor;
import org.springframework.stereotype.Component;

import java.util.ArrayList;

@Component
@RequiredArgsConstructor
public class ZoneSettingDRepoProc {

    private final JPAQueryFactory jpaQueryFactory;

    private final QZoneSettingDDO qZoneSettingDDO = QZoneSettingDDO.zoneSettingDDO;

    private final QZoneSettingDO qZoneSettingDO = QZoneSettingDO.zoneSettingDO;


    public PagingVO<ZoneSettingDVO> findPagingResult(ZoneSettingDetailPageParam param){
        JPAQuery<ZoneSettingDVO> query = selectFromWhere(ZoneSettingDVO.class,param);
        param.setPaging(query);
        param.fillOrders(query,qZoneSettingDDO);
        return PagingVO.<ZoneSettingDVO>builder()
                .total(query.fetchCount())
                .records(query.fetch())
                .build();
    }


    private <T> JPAQuery<T> selectFromWhere(Class<T> cls, ZoneSettingDetailPageParam param){
        return jpaQueryFactory.select(Projections.bean(cls,
                qZoneSettingDDO.id,
                qZoneSettingDDO.zoneId,
                qZoneSettingDDO.ouId,
                qZoneSettingDDO.itemId,
                qZoneSettingDDO.itemName,
                qZoneSettingDDO.itemCode,
                qZoneSettingDDO.itemAttr,
                qZoneSettingDDO.barcode,
                qZoneSettingDDO.itemBrand,
                qZoneSettingDDO.sort)).from(qZoneSettingDDO).where(where(param));
    }

    public Predicate where(ZoneSettingDetailPageParam param){
        List<Predicate> predicate = new ArrayList<>();
        predicate.add(qZoneSettingDDO.ouId.eq(param.getOuId()));
        predicate.add(qZoneSettingDDO.zoneId.eq(param.getZoneId()));
        predicate.add(qZoneSettingDDO.deleteFlag.isNull().or(qZoneSettingDDO.deleteFlag.eq(0)));
        return ExpressionUtils.allOf(predicate);
    }


}
