package com.elitesland.yst.production.sale.rmi.ystsystem;

import com.elitescloud.cloudt.common.base.ApiCode;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.boot.core.base.SeqNumProvider;
import com.elitescloud.boot.core.base.UdcProvider;
import com.elitescloud.cloudt.system.provider.SysUserRpcService;
import com.elitescloud.cloudt.system.vo.SysUserDTO;

import com.elitesland.yst.production.sale.Application;
import lombok.extern.log4j.Log4j2;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * 用户服务接口.
 *
 * @author Kaiser（wang shao）
 * @date 2022/7/31
 */
@Component
@Log4j2
public class RmiSysUserRpcService {

    @Autowired
    private SysUserRpcService sysUserRpcService;

    @Autowired
    private UdcProvider udcProvider;

    @Autowired
    private SeqNumProvider sysNumberRuleService;
    /**
     * 根据用户名获取用户信息
     *
     * @param username
     * @return
     */
    public SysUserDTO getUserByUsername(String username) {
        ApiResult<SysUserDTO> result = null;
        try {
            result = sysUserRpcService.getUserByUsername(username);
        } catch (Exception e) {
            log.error("系统域服务异常：", e);
            throw new BusinessException("系统域服务异常", e);
        }

        if (result != null && result.isSuccess()) {
            return result.getData();
        }

        return null;
    }

    /**
     * udc翻译
     * @param domain
     * @param udc
     * @return
     */
    public Map<String, String> sysUdcGetCodeMap(String domain, String udc) {
        try {
            Map<String, String> codeMap = udcProvider.getValueMapByUdcCode(domain, udc);
            return codeMap ;
        } catch (Exception e) {
            log.error("findCodeBatch error:", e);
        }
        return new HashMap<>();
    }


    /**
     * 发号器发号
     * @param code
     * @param runtimeValues
     * @return
     */
    public String sysNumberRuleGenerateCode(String code, List<String> runtimeValues) {
        log.info("库存中心发号器调用：时间：{}，参数{},{}", LocalDateTime.now(),code,runtimeValues);
        String sys ="";
        List<String> list = new ArrayList<>();
        list.addAll(runtimeValues);
        try {
            sys =sysNumberRuleService.generateCode(Application.NAME,code, list);
        } catch (Exception e) {
            log.error("sysNumberRuleGenerateCode error:", e);
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "发号器发号失败");
        }
        return sys;
    }
}
