package com.elitesland.yst.production.sale.service;

import cn.hutool.core.codec.Base64;
import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.lang.Assert;
import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSON;
import com.elitescloud.boot.auth.util.SecurityContextUtil;
import com.elitescloud.boot.common.param.ComSearchParam;
import com.elitescloud.boot.core.base.UdcProvider;
import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.boot.threadpool.ThreadPoolAutoConfiguration;
import com.elitescloud.cloudt.common.annotation.SysCodeProc;
import com.elitescloud.cloudt.common.base.ApiCode;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.core.security.util.DataAuthJpaUtil;
import com.elitescloud.cloudt.security.entity.GeneralUserDetails;
import com.elitescloud.cloudt.system.dto.SysEmployeeDetailDTO;
import com.elitescloud.cloudt.system.dto.resp.SysAreaRespDTO;
import com.elitescloud.cloudt.system.dto.resp.SysCurrencyRespDTO;
import com.elitescloud.cloudt.system.provider.extend.SysAreaRpcService;
import com.elitescloud.cloudt.system.provider.org.EmployeeRpcService;
import com.elitescloud.cloudt.system.vo.SysUdcComboVO;
import com.elitescloud.cloudt.system.vo.SysUserDTO;
import com.elitesland.yst.production.sale.Application;
import com.elitesland.yst.production.sale.api.service.*;
import com.elitesland.yst.production.sale.api.vo.param.crm.*;
import com.elitesland.yst.production.sale.api.vo.resp.com.ComSaleFileComVO;
import com.elitesland.yst.production.sale.api.vo.resp.crm.*;
import com.elitesland.yst.production.sale.api.vo.resp.mdmSync.CrmCustMasterDataRespVO;
import com.elitesland.yst.production.sale.api.vo.resp.mdmSync.CrmCustMdmSyncRespVO;
import com.elitesland.yst.production.sale.api.vo.resp.mdmSync.CrmCustResponseDataRespVO;
import com.elitesland.yst.production.sale.api.vo.resp.sal.RmiOuDetailVO;
import com.elitesland.yst.production.sale.api.vo.resp.sal.RmiOuInfoByAddr;
import com.elitesland.yst.production.sale.api.vo.save.*;
import com.elitesland.yst.production.sale.api.vo.save.mdmSync.CrmCustMdmRequstSaveVO;
import com.elitesland.yst.production.sale.api.vo.save.mdmSync.CrmCustMdmSyncDataSaveVO;
import com.elitesland.yst.production.sale.api.vo.save.mdmSync.CrmCustMdmSyncSaveVO;
import com.elitesland.yst.production.sale.api.vo.save.mdmSync.CustSyncBaseDataLine;
import com.elitesland.yst.production.sale.common.constant.ConstantsSale;
import com.elitesland.yst.production.sale.common.constant.UdcEnum;
import com.elitesland.yst.production.sale.common.model.CurrentUserDTO;
import com.elitesland.yst.production.sale.convert.CrmCustConvert;
import com.elitesland.yst.production.sale.convert.CrmCustMdmSyncConvert;
import com.elitesland.yst.production.sale.convert.RmiOuInfoByAddrConvert;
import com.elitesland.yst.production.sale.core.service.BaseServiceImpl;
import com.elitesland.yst.production.sale.core.service.UserService;
import com.elitesland.yst.production.sale.dto.SalesmanInfoDTO;
import com.elitesland.yst.production.sale.dto.query.SalesmanQueryDTO;
import com.elitesland.yst.production.sale.entity.*;
import com.elitesland.yst.production.sale.repo.*;
import com.elitesland.yst.production.sale.repo.shop.BipCustUserBindRepo;
import com.elitesland.yst.production.sale.rmi.ystsupport.*;
import com.elitesland.yst.production.sale.rmi.ystsystem.RmiCommonService;
import com.elitesland.yst.production.sale.rmi.ystsystem.RmiSysNextNumberService;
import com.elitesland.yst.production.sale.rmi.ystsystem.RmiSysService;
import com.elitesland.yst.production.sale.rmi.ystsystem.RmiSysUserRpcService;
import com.elitesland.yst.production.support.provider.org.dto.*;
import com.elitesland.yst.production.support.provider.org.param.*;
import com.elitesland.yst.production.support.provider.org.service.OrgOuRpcService;
import com.google.common.collect.Lists;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.dsl.BooleanExpression;
import jodd.util.StringUtil;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.collections4.SetUtils;
import org.redisson.api.RedissonClient;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.core.task.TaskExecutor;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Sort;
import org.springframework.http.HttpHeaders;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

import java.text.SimpleDateFormat;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.*;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;

import static com.elitesland.yst.production.sale.convert.CrmCustConvert.INSTANCE;
import static com.elitesland.yst.production.sale.entity.QCrmCustDO.crmCustDO;

/**
 * .
 *
 * @author Kaiser（wang shao）
 * @date 2021-05-14
 */
@Service
@RequiredArgsConstructor
@Slf4j
public class CrmCustServiceImpl extends BaseServiceImpl implements CrmCustService {

    private static final QCrmCustDO qCrmCustDO = crmCustDO;

    private final CrmCustRepo crmCustRepo;

    private final CrmCustRepoProc crmCustRepoProc;

    private final CrmCustOuRepoProc crmCustOuRepoProc;

    private final ComSaleFileInfoService comSaleFileInfoService;

    private final RmiCityCodeService rmiCityCodeService;

    private final RmiOrgAddrService rmiOrgAddrService;

    private final RmiOrgEmpService rmiOrgEmpService;

    private final RmiOrgOuService rmiOrgOuService;

    private final RmiOrgBuService rmiOrgBuService;

    private final RmiSysNextNumberService rmiSysNextNumberService;

    private final RmiCommonService rmiCommonService;

    private final CrmCustOuService crmCustOuService;

    private final BipCustUserBindRepo bipCustUserBindRepo;


    private final CustAccountRepoProc custAccountRepoproc;

    private final CustAccountRepo custAccountRepo;

    @Autowired
    private SalesmanInfoService salesmanInfoService;

    private final SalesmanInfoRepo salesmanInfoRepo;

    private final OrgOuRpcService orgOuRpcService;

    private final CustBelongOuService custBelongOuService;

    private final SysAreaRpcService sysAreaRpcService;

    private final CrmCustExtendRepo crmCustExtendRepo;

    @Qualifier(ThreadPoolAutoConfiguration.BEAN_NAME)
    private final TaskExecutor taskExecutor;

    private final RmiSysUserRpcService rmiSysUserRpcService;

    private final RmiSysService rmiSysService;




//    private final RmiSysUserService rmiSysUserService;

    @Autowired
    private UdcProvider udcProvider;

    @Autowired
    private EmployeeRpcService employeeRpcService;


    // MDM同步日期格式
    private static final String DATEFORMAT = "yyyy-MM-dd HH:mm:ss";

    private static final String DATEFORMAT2 = "yyyyMMddHHmmss";

    private static final String IFACECODE_UP_DATA = "KHZSJ_DR";
    // 分发功能区分码
    private static final String IFACECODE_FIND = "KHZSJ";

    //判断是否是正式环境(走rest还是soa,动态赋值)
    private static String DISTRIBUTIONMDMURL;
    private static String IMPORTMDMURL;

    @Autowired
    public RedissonClient redissonClient; // redis 锁
    public static final Integer EXPIRE_TIME = 5; // 默认5分钟过期

//    @Override
//    public ApiResult<List<CheckCustResVO>> checkCustData(CheckCustParamVO param) {
//        return null;
//    }


    @Override
    public CustPrentInfoDTO getPrentCustByCode(String custCode) {
        return crmCustRepoProc.getPrentCust(custCode);
    }

    @Override
    public ApiResult<PagingVO<CrmCustSimpleVO>> query(ComSearchParam searchParam) {
        if (searchParam == null) {
            return ApiResult.fail("搜索参数为空");
        }
        PagingVO<CrmCustSimpleVO> pagingVO = querying(searchParam);
        return ApiResult.ok(pagingVO);
    }


    /**
     * 客户查询详细
     **/
    @Override
    @SysCodeProc
    public CrmCustDetailRespVO get(Long id) {
        if (id == null) {
            return null;
        }
        //流程一: 数据查询
        CrmCustDO crmCustDO = crmCustRepo.findById(id).orElse(null);
        if (crmCustDO == null) {
            return null;
//            throw new BusinessException("该客户信息不存在");
        }
        CrmCustDetailRespVO respVO = INSTANCE.doToDetailRespVO(crmCustDO);
        //流程二: 数据补充
        this.translateDetail(respVO);
        //账户信息
        CustAccountVO custAccountVO = this.getAccountByCustCode(crmCustDO.getCustCode());
        if(!ObjectUtils.isEmpty(custAccountVO)){
            respVO.setCustAccountVO(custAccountVO);
        }
        return respVO;
    }

    @Override
    public List<CrmCustBaseRespVO> getByAgentEmpId(Long agentEmpId) {
        List<CrmCustBaseRespVO> list = crmCustRepoProc.getCustByEmpId(agentEmpId);
        list.forEach(l ->{
            l.setAddress(this.findDefaultAddr(l.getAddrNo()));
            ApiResult<SalesmanInfoDTO> res = this.getSaleManInfo(agentEmpId);
            if(res.isSuccess() && !ObjectUtils.isEmpty(res) && !ObjectUtils.isEmpty(res.getData())){
                l.setAgentEmpName(res.getData().getFullName());
            }
        });
        return list;
    }

    public ApiResult<SalesmanInfoDTO> getSaleManInfo(Long agentEmpId){
        SalesmanQueryDTO salesmanQueryDTO = new SalesmanQueryDTO();
        salesmanQueryDTO.setSalesmanId(agentEmpId);
        return salesmanInfoService.querySalesmanInfo(salesmanQueryDTO);
    }

    public String findDefaultAddr(Long addrNo){
        ApiResult<OrgAddrDetailsRpcDTO> rpcDtoByAddrNo;
        rpcDtoByAddrNo = rmiOrgAddrService.findAddrByAddrNo(addrNo);
        Assert.isFalse(!rpcDtoByAddrNo.isSuccess(), rpcDtoByAddrNo.getMsg());
        OrgAddrDetailsRpcDTO orgAddr = rpcDtoByAddrNo.getData();
        if (!ObjectUtils.isEmpty(orgAddr) && !CollectionUtils.isEmpty(orgAddr.getOrgAddrAddressVos())) {
            //地址信息补充
            List<String> addrs = orgAddr.getOrgAddrAddressVos().stream().filter(o -> o.getDefaultFlag()).map(OrgAddrAddressRpcDTO:: getDetailAddr).collect(Collectors.toList());
            return addrs.get(0);
        }
        return null;
    }


    public CustAccountVO getAccountByCustCode(String custCode){
        return custAccountRepoproc.getAccountByCustCode(custCode);
    }

    private PagingVO<CrmCustSimpleVO> querying(ComSearchParam searchParam) {
        // 搜索条件
        Predicate predicate;
        if (StrUtil.isBlank(searchParam.getKeyword())) {
            predicate = qCrmCustDO.isNotNull();
        } else {
            String keyword = "%" + searchParam.getKeyword() + "%";
            predicate = qCrmCustDO.custCode.like(keyword)
                    .or(qCrmCustDO.custName.like(keyword));
        }
        predicate = appendCommon(predicate);

        var jpaQuery = jpaQueryFactory.select(qCrmCustDO.id, qCrmCustDO.custCode, qCrmCustDO.custName, qCrmCustDO.custAbbr)
                .from(qCrmCustDO)
                .where(predicate);
        long total = jpaQuery.fetchCount();
        if (total == 0) {
            // 没有符合的数据，则直接返回
            return PagingVO.<CrmCustSimpleVO>builder().build();
        }

        // 添加分页和排序
        PageRequest pageRequest = wrapperPageRequest(searchParam.getPageRequest(), Sort.by(Sort.Direction.ASC, qCrmCustDO.createTime.getMetadata().getName()));
        appendPageAndSort(jpaQuery, pageRequest, qCrmCustDO);

        // 转vo
        List<CrmCustSimpleVO> voList = jpaQuery.fetch().stream()
                .map(tuple -> {
                    CrmCustSimpleVO vo = new CrmCustSimpleVO();
                    vo.setId(tuple.get(qCrmCustDO.id));
                    vo.setCustCode(tuple.get(qCrmCustDO.custCode));
                    vo.setCustName(tuple.get(qCrmCustDO.custName));
                    vo.setCustAbbr(tuple.get(qCrmCustDO.custAbbr));

                    return vo;
                }).collect(Collectors.toList());
        return PagingVO.<CrmCustSimpleVO>builder()
                .total(total)
                .records(voList)
                .build();
    }

    /**
     * 添加通用的条件
     *
     * @param predicate 条件
     * @return 条件
     */
    private Predicate appendCommon(Predicate predicate) {
        return ExpressionUtils.and(predicate, qCrmCustDO.deleteFlag.eq(ConstantsSale.COMMON_DELETE_NO));
    }

    /**
     * 客户分页查询
     **/
    @Override
    @SysCodeProc
    public PagingVO<CrmCustPageRespVO> search(CrmCustQueryParamVO queryParamVO) {

        if (queryParamVO == null) {
            return null;
        }
        /*
         * 流程一: 通过客户联系人和联系人电话分页条件查询
         *  因为该信息存在地址簿中需要通过这两个条件找到对应的地址簿地址号(存在客户主表可以作为分页条件)
         */
//        OrgAddressRpcDtoParam orgAddressRpcDtoParam = new OrgAddressRpcDtoParam();
//        orgAddressRpcDtoParam.setContPerson(queryParamVO.getContPerson());
//        orgAddressRpcDtoParam.setMobile(queryParamVO.getContPersonMobile());
//        List<Long> addrNos;
//        List<OrgAddressRpcDTO> addrAddressRpcDtoByParam = rmiOrgAddrService.findAddrAddressListByParam(orgAddressRpcDtoParam);
//        addrNos = addrAddressRpcDtoByParam.stream().map(OrgAddressRpcDTO::getAddrNo).filter(Objects::nonNull).distinct().collect(Collectors.toList());
//        queryParamVO.setAddrNos(addrNos);
//        if (ObjectUtils.isEmpty(addrNos) && (!StringUtils.isEmpty(queryParamVO.getContPersonMobile()) || !StringUtils.isEmpty(queryParamVO.getContPerson()))) {
//            addrNos.add(1L);
//            queryParamVO.setAddrNos(addrNos);
//        }
        //流程二: 开始分页查询和数据处理
        Page<CrmCustDO> pagingDo = searching(queryParamVO);
        long total = pagingDo.getTotalElements();
        List<CrmCustDO> crmCustDOList = pagingDo.getContent();

        if (CollUtil.isEmpty(crmCustDOList)) {
            return new PagingVO<>(total, Collections.emptyList());
        }
        CrmCustConvert convert = INSTANCE;
        List<CrmCustPageRespVO> respVOList = crmCustDOList.stream().map(convert::doToPageRespVO).collect(Collectors.toList());
        /*
         * 流程三: 数据补充
         *     分页查询需要补充地址簿的联系人，电话，详细地址等信息，默认取第一条(后期可修改)
         *     分页查询补充业务员名称
         */
        this.translatePage(respVOList);
        return new PagingVO<>(total, respVOList);
    }


    /**
     * 客户下拉框查询
     * 对外提供接口:
     * 查询客户信息，对于客户多个地址的选择规则如下
     * 1.先判断其中是否有地址类型 = 收货地址 的,如果有多条，则看其中是否有默认(default_flag = true)的，如果有取这条，否则取收货地址中id最小的
     * 2.如果没有地址类型 = 收货地址 的，则取地址类型 = 默认地址的,如果有多条则取id最小的那条
     * 3.如果没有地址类型 = 默认地址 的,则取id最小的那条地址
     **/
    @Override
    public ApiResult<PagingVO<CrmCustPlugInRespVO>> queryCustPlugIn(CrmCustPlugInParamVO searchParam) {
        if (searchParam == null) {
            return ApiResult.fail("查询参数为空");
        }
        /* 流程一:
         *    分页条件查询客户数据(后期可能会根据条件查询不同客户信息，比如内部客户和外部客户)
         */
        Page<CrmCustDO> pagingDo = searchPlugIn(searchParam);
        long total = pagingDo.getTotalElements();
        List<CrmCustDO> crmCustDOList = pagingDo.getContent();
        if (CollUtil.isEmpty(crmCustDOList)) {
            return ApiResult.ok(new PagingVO<>(total, Collections.emptyList()));
        }
        CrmCustConvert convert = INSTANCE;
        List<CrmCustPlugInRespVO> respVOList = crmCustDOList.stream().map(t -> {
            CrmCustPlugInRespVO respVO = convert.doToPlugInRespVO(t);
            respVO.setCustId(t.getId());
            return respVO;
        }).collect(Collectors.toList());
        /* 流程二:
         *    数据补充(数据准备)，主要目的是为了减少数据库io操作提高效率
         *      主要的工作是对于员工、udc、地址接口
         */
        this.translateCustPlugIn(respVOList);
        this.udcTranslate(respVOList);
        return ApiResult.ok(new PagingVO<>(total, respVOList));
    }

    @Override
    public PagingVO<CustSalePredictionVO> queryCustSalePrediction(CustPredictionParamVO param) {
        PagingVO<CustSalePredictionVO> pagingVO = crmCustRepoProc.queryCustSalePrediction(param);
        if(pagingVO.isNotEmpty() && !pagingVO.getRecords().isEmpty()){
            List<CustSalePredictionVO> list = pagingVO.getRecords();
            Map<String, String> regionMap = udcProvider.getValueMapByUdcCode("yst-supp", "REGION");
            Map<String, String> custTypeUdc = udcProvider.getValueMapByUdcCode("yst-sale", "CUST_TYPE");
            list.forEach(l ->{
                if(!MapUtils.isEmpty(regionMap) && StringUtil.isNotBlank(l.getRegion())){
                    l.setRegionName(regionMap.get(l.getRegion()));
                }
                if(!MapUtils.isEmpty(custTypeUdc) && StringUtil.isNotBlank(l.getCustType())){
                    l.setCustTypeName(custTypeUdc.get(l.getCustType()));
                }
            });
            pagingVO.setRecords(list);
        }
        return pagingVO;
    }

    private void translateCustPlugIn(List<CrmCustPlugInRespVO> respVOList) {
        List<Long> agentEmpIds = respVOList.stream().map(CrmCustPlugInRespVO::getAgentEmpId).distinct().collect(Collectors.toList());
        OrgEmpRpcDtoParam orgEmpRpcDtoParam = new OrgEmpRpcDtoParam();
        List<OrgEmpRpcDTO> empDtoByParam = new ArrayList<>();
        if (!CollectionUtils.isEmpty(agentEmpIds)) {
            orgEmpRpcDtoParam.setEmpIds(agentEmpIds);
            empDtoByParam = rmiOrgEmpService.findEmpListByParam(orgEmpRpcDtoParam);
        }
        List<OrgAddressRpcDTO> addressRpcDto = new ArrayList<>();
        OrgAddressRpcDtoParam orgAddressRpcDtoParam = new OrgAddressRpcDtoParam();
        List<Long> addrNos = respVOList.stream().map(CrmCustPlugInRespVO::getRecvAddrNo).distinct().collect(Collectors.toList());
        if (!CollectionUtils.isEmpty(addrNos)) {
            orgAddressRpcDtoParam.setAddrNos(addrNos);
            addressRpcDto = rmiOrgAddrService.findAddrAddressListByParam(orgAddressRpcDtoParam);
        }
        /* 流程三:
         *    数据补充
         */
        List<OrgAddressRpcDTO> finalAddressRpcDto = addressRpcDto;
        List<OrgEmpRpcDTO> finalEmpDtoByParam = empDtoByParam;
        for (CrmCustPlugInRespVO respVo : respVOList) {
            if (!StringUtils.isEmpty(respVo.getRecvAddrNo())) {
                List<OrgAddressRpcDTO> orgAddressRpcDTOS = finalAddressRpcDto.stream().filter(addr -> addr.getAddrNo().equals(respVo.getRecvAddrNo())).sorted(Comparator.comparing(OrgAddressRpcDTO::getId)).collect(Collectors.toList());
                if (!CollectionUtils.isEmpty(orgAddressRpcDTOS)) {
                    List<String> recvRegion = new ArrayList<>();
                    List<OrgAddressRpcDTO> orgAddressRpcDTOS1 = orgAddressRpcDTOS.stream().filter(orgAddr -> UdcEnum.ORG_ADDRESS_TYPE_RECEIVE.getValueCode().equals(orgAddr.getAddressType())).sorted(Comparator.comparing(OrgAddressRpcDTO::getId)).collect(Collectors.toList());
                    List<OrgAddressRpcDTO> orgAddressRpcDTOS2 = orgAddressRpcDTOS.stream().filter(orgAddr -> UdcEnum.ORG_ADDRESS_TYPE_DEFAULT.getValueCode().equals(orgAddr.getAddressType())).sorted(Comparator.comparing(OrgAddressRpcDTO::getId)).collect(Collectors.toList());
                    OrgAddressRpcDTO orgAddressRpcDTO;
                    if (!CollectionUtils.isEmpty(orgAddressRpcDTOS1)) {
                        Optional<OrgAddressRpcDTO> orgAddressRpcDTOOptional = orgAddressRpcDTOS1.stream().filter(addr -> addr.getDefaultFlag().equals(true)).findFirst();
                        orgAddressRpcDTO = orgAddressRpcDTOOptional.orElseGet(() -> orgAddressRpcDTOS1.get(0));
                    } else if (!CollectionUtils.isEmpty(orgAddressRpcDTOS2)) {
                        Optional<OrgAddressRpcDTO> orgAddressRpcDTOOptional = orgAddressRpcDTOS2.stream().filter(addr -> addr.getDefaultFlag().equals(true)).findFirst();
                        orgAddressRpcDTO = orgAddressRpcDTOOptional.orElseGet(() -> orgAddressRpcDTOS2.get(0));
                    } else {
                        orgAddressRpcDTO = orgAddressRpcDTOS.get(0);
                    }
                    respVo.setCustContactName(orgAddressRpcDTO.getContPerson());
                    respVo.setCustContactEmail(orgAddressRpcDTO.getEmail());
                    respVo.setCustContactTel(orgAddressRpcDTO.getMobile());
                    respVo.setCustContactEmail(orgAddressRpcDTO.getEmail());
                    respVo.setRecvCountry(orgAddressRpcDTO.getCountry());
                    respVo.setRecvCity(orgAddressRpcDTO.getCity());
                    respVo.setRecvCityName(orgAddressRpcDTO.getCityName());
                    respVo.setRecvCounty(orgAddressRpcDTO.getCounty());
                    respVo.setRecvCountyName(orgAddressRpcDTO.getCountyName());
                    respVo.setReceiveStreet(orgAddressRpcDTO.getStreet());
                    respVo.setRecvProvince(orgAddressRpcDTO.getProvince());
                    respVo.setRecvProvinceName(orgAddressRpcDTO.getProvinceName());
                    respVo.setAddrDetail(orgAddressRpcDTO.getDetailAddr());
                    recvRegion.add(orgAddressRpcDTO.getProvince());
                    recvRegion.add(orgAddressRpcDTO.getCity());
                    recvRegion.add(orgAddressRpcDTO.getCounty());
                    respVo.setRecvRegion(recvRegion);
                    respVo.setAddrId(orgAddressRpcDTO.getId());
                }
            }
            if (!StringUtils.isEmpty(respVo.getAgentEmpId())) {
                finalEmpDtoByParam.stream().filter(emp -> emp.getId().equals(respVo.getAgentEmpId()))
                        .findFirst()
                        .ifPresent(agentEmp -> respVo.setAgentEmpName(agentEmp.getEmpName()));
            }
        }
    }

    private void udcTranslate(List<CrmCustPlugInRespVO> respVOList) {
        //获取UDC
//        List<SysUdcComboVO> custTypeUDCList = new ArrayList<>();
//        List<SysUdcComboVO> paymentTermUDCList = new ArrayList<>();
//        List<SysUdcComboVO> payMethodUDCList = new ArrayList<>();
//        List<SysUdcComboVO> regionUDCList = new ArrayList<>();
//        try {
//            custTypeUDCList = udcProvider.listCodeCombos("CRM", "CUST_TYPE");
//            paymentTermUDCList = sysUdcService.listCodeCombos("CRM", "PAYMENT_TERM");
//            payMethodUDCList = sysUdcService.listCodeCombos("CRM", "PAY_METHOD");
//            regionUDCList = sysUdcService.listCodeCombos("ORG", "OU_REGION");
//        } catch (Exception e) {
//            log.info("dubbo服务调用udc查询方法报错" + e);
//            throw new BusinessException("dubbo服务调用udc查询方法报错,请检查");
//        }
//
//        List<SysUdcComboVO> finalCustTypeUDCList = custTypeUDCList;
//        List<SysUdcComboVO> finalPaymentTermUDCList = paymentTermUDCList;
//        List<SysUdcComboVO> finalPayMethodUDCList = payMethodUDCList;
//        List<SysUdcComboVO> finalRegionUDCList = regionUDCList;
//        respVOList.forEach(respVo -> {
//            //UDC翻译
//            if (!StringUtils.isEmpty(respVo.getCustType())) {
//                finalCustTypeUDCList.stream()
//                        .filter(sysUdcComboVO -> sysUdcComboVO.getUdcVal().equals(respVo.getCustType()))
//                        .findAny().ifPresent(custTypeUDC -> respVo.setCustTypeName(custTypeUDC.getValDesc()));
//            }
//            if (!StringUtils.isEmpty(respVo.getPaymentTerm())) {
//                finalPaymentTermUDCList.stream()
//                        .filter(sysUdcComboVO -> sysUdcComboVO.getUdcVal().equals(respVo.getPaymentTerm()))
//                        .findAny().ifPresent(paymentTermUDC -> respVo.setPaymentTermName(paymentTermUDC.getValDesc()));
//            }
//            if (!StringUtils.isEmpty(respVo.getPaymentTerm())) {
//                finalPaymentTermUDCList.stream()
//                        .filter(sysUdcComboVO -> sysUdcComboVO.getUdcVal().equals(respVo.getPayMethod()))
//                        .findAny().ifPresent(paymentTermUDC -> respVo.setPaymentTermName(paymentTermUDC.getValDesc()));
//            }
//            if (!StringUtils.isEmpty(respVo.getPayMethod())) {
//                finalPayMethodUDCList.stream()
//                        .filter(sysUdcComboVO -> sysUdcComboVO.getUdcVal().equals(respVo.getPayMethod()))
//                        .findAny().ifPresent(payMethodUDC -> respVo.setPayMethodName(payMethodUDC.getValDesc()));
//            }
//            if (!StringUtils.isEmpty(respVo.getRegion())) {
//                finalRegionUDCList.stream()
//                        .filter(sysUdcComboVO -> sysUdcComboVO.getUdcVal().equals(respVo.getRegion()))
//                        .findAny().ifPresent(regionUDC -> respVo.setRegionName(regionUDC.getValDesc()));
//            }
//        });
    }

    /**
     * searchPlugIn 分页查询
     * 注意CustData() 关键字查询可能会传客户编码、或者是客户名称
     */
    private Page<CrmCustDO> searchPlugIn(CrmCustPlugInParamVO searchParam) {
        Predicate predicate = qCrmCustDO.isNotNull();
        if (!StringUtils.isEmpty(searchParam.getCustData())) {
            predicate = ExpressionUtils.and(predicate, qCrmCustDO.custCode.like("%" + searchParam.getCustData() + "%")
                    .or(qCrmCustDO.custName.like("%" + searchParam.getCustData() + "%")));
        }
//        if (!StringUtils.isEmpty(searchParam.getOuId())) {
//            predicate = ExpressionUtils.and(predicate, qCrmCustDO.ouId.eq(searchParam.getOuId()));
//        }
//        if (!StringUtils.isEmpty(searchParam.getAgentEmpId())) {
//            predicate = ExpressionUtils.and(predicate, qCrmCustDO.agentEmpId.eq(searchParam.getAgentEmpId()));
//        }
        if (!StringUtils.isEmpty(searchParam.getCustType())) {
            predicate = ExpressionUtils.and(predicate, qCrmCustDO.custType.eq(searchParam.getCustType()));
        }
        //客户类型
        if (!StringUtils.isEmpty(searchParam.getInnerFlag())) {
            if (searchParam.getInnerFlag().equals(Boolean.TRUE)) {
                predicate = ExpressionUtils.and(predicate, qCrmCustDO.custType2.eq(UdcEnum.CRM_CUST_TYPE2_C.getValueCode()));
                predicate = ExpressionUtils.or(predicate, qCrmCustDO.custType2.eq(UdcEnum.CRM_CUST_TYPE2_D.getValueCode()));
            } else {
                predicate = ExpressionUtils.and(predicate, qCrmCustDO.custType2.ne(UdcEnum.CRM_CUST_TYPE2_C.getValueCode()));
                predicate = ExpressionUtils.and(predicate, qCrmCustDO.custType2.ne(UdcEnum.CRM_CUST_TYPE2_D.getValueCode()));
            }
        }
        //业务员id
        if (!StringUtils.isEmpty(searchParam.getAgentEmpId())) {
            //通过公司Id查询客户公司拓展表,查到所有的客户编码
            CrmCustOuParamVO crmCustOuParamVO = new CrmCustOuParamVO();
            crmCustOuParamVO.setAgentEmpId(searchParam.getAgentEmpId());
            crmCustOuParamVO.setIfTrans(false);
            List<CrmCustOuSaveVO> custOuSaveVOS = crmCustOuService.search(crmCustOuParamVO);
            if (!CollectionUtils.isEmpty(custOuSaveVOS)) {
                List<String> custCodes = custOuSaveVOS.stream().map(CrmCustOuSaveVO::getCustCode).distinct().collect(Collectors.toList());
                if (!CollectionUtils.isEmpty(custCodes)) {
                    predicate = ExpressionUtils.and(predicate, qCrmCustDO.custCode.in(custCodes).or(qCrmCustDO.agentEmpId.eq(searchParam.getAgentEmpId())));
                } else {
                    predicate = ExpressionUtils.and(predicate, qCrmCustDO.agentEmpId.eq(searchParam.getAgentEmpId()));
                }
            } else {
                predicate = ExpressionUtils.and(predicate, qCrmCustDO.agentEmpId.eq(searchParam.getAgentEmpId()));
            }
        }
        //公司id
        if (!StringUtils.isEmpty(searchParam.getOuId())) {
            //通过公司Id查询客户公司拓展表,查到所有的客户编码
            CrmCustOuParamVO crmCustOuParamVO = new CrmCustOuParamVO();
            crmCustOuParamVO.setOuId(searchParam.getOuId());
            crmCustOuParamVO.setIfTrans(false);
            List<CrmCustOuSaveVO> custOuSaveVOS = crmCustOuService.search(crmCustOuParamVO);
            if (!CollectionUtils.isEmpty(custOuSaveVOS)) {
                List<String> custCodes = custOuSaveVOS.stream().map(CrmCustOuSaveVO::getCustCode).distinct().collect(Collectors.toList());
                if (!CollectionUtils.isEmpty(custCodes)) {
                    predicate = ExpressionUtils.and(predicate, qCrmCustDO.custCode.in(custCodes).or(qCrmCustDO.ouId.eq(searchParam.getOuId())));
                } else {
                    predicate = ExpressionUtils.and(predicate, qCrmCustDO.ouId.eq(searchParam.getOuId()));
                }
            } else {
                predicate = ExpressionUtils.and(predicate, qCrmCustDO.ouId.eq(searchParam.getOuId()));
            }
        }
        predicate = ExpressionUtils.and(predicate, qCrmCustDO.custStatus.ne(UdcEnum.CRM_CUST_STATUS_CLOSED.getValueCode()));
        predicate = ExpressionUtils.and(predicate, qCrmCustDO.deleteFlag.ne(ConstantsSale.COMMON_DELETE_YSE));
///        DataAuthJpaUtil.dataAuthJpaPredicate(qCrmCustDO.getMetadata());
        predicate = ExpressionUtils.and(predicate, DataAuthJpaUtil.dataAuthJpaPredicate(qCrmCustDO.getMetadata()));
        return crmCustRepo.findAll(predicate, wrapperPageRequest(searchParam.getPageRequest(), null));
    }

    /**
     * 内部方法，主要提供给域内业务调用,查询客户集合
     * 注意点: 为了保证方法的通用性和效率性, 设置transFlag 字段用来表明是否需要 翻译补充数据(transFlag = true : 需要补充, transFlag = false : 不需要补充)
     */
    @Override
    @SysCodeProc
    public List<CrmCustPageRespVO> searchList(CrmCustQueryParamVO queryParamVO) {
        if (queryParamVO == null) {
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "商品不存在");
        }
        List<CrmCustDO> crmCustDOList = searching1(queryParamVO);
        CrmCustConvert convert = INSTANCE;
        List<CrmCustPageRespVO> respVOList = crmCustDOList.stream().map(t -> {
            CrmCustPageRespVO crmCustPageRespVO = convert.doToPageRespVO(t);
            return crmCustPageRespVO;
        }).collect(Collectors.toList());
        //根据入参标识看是否进行数据补充
        if (!StringUtils.isEmpty(queryParamVO.getTransFlag()) && (queryParamVO.getTransFlag().equals(Boolean.TRUE))) {
            this.translatePage(respVOList);
        }
        return respVOList;
    }

    /**
     * 补充分页查询数据
     **/
    private void translatePage(List<CrmCustPageRespVO> respVOList) {
        /*
         * 流程一:
         *    补充数据查询、主要是调用支撑域的服务接口
         */
        List<Long> agentEmpIds = respVOList.stream().map(CrmCustPageRespVO::getAgentEmpId).filter(Objects::nonNull).distinct().collect(Collectors.toList());
        OrgEmpRpcDtoParam orgEmpRpcDtoParam = new OrgEmpRpcDtoParam();
        List<OrgEmpRpcDTO> empDtoByParam = new ArrayList<>();
        if (!CollectionUtils.isEmpty(agentEmpIds)) {
            orgEmpRpcDtoParam.setEmpIds(agentEmpIds);

            empDtoByParam = rmiOrgEmpService.findEmpListByParam(orgEmpRpcDtoParam);

        }
        OrgBuRpcDtoParam orgBuRpcDtoParam = new OrgBuRpcDtoParam();
        List<String> buCodes = respVOList.stream().map(CrmCustPageRespVO::getBuCode).filter(Objects::nonNull).distinct().collect(Collectors.toList());
        List<OrgBuRpcDTO> buDtoByParam = new ArrayList<>();
        if (!CollectionUtils.isEmpty(buCodes)) {
            orgBuRpcDtoParam.setBuCodes(buCodes);

            buDtoByParam = rmiOrgBuService.findBuDtoByParam(orgBuRpcDtoParam);

        }
        List<Long> addrNos = respVOList.stream().map(CrmCustPageRespVO::getAddrNo).filter(Objects::nonNull).distinct().collect(Collectors.toList());
        OrgAddressRpcDtoParam orgAddressRpcDtoParam = new OrgAddressRpcDtoParam();
        List<OrgAddressRpcDTO> addressRpcDto = new ArrayList<>();
        if (!CollectionUtils.isEmpty(addrNos)) {
            orgAddressRpcDtoParam.setAddrNos(addrNos);
            addressRpcDto = rmiOrgAddrService.findAddrAddressListByParam(orgAddressRpcDtoParam);
        }
        /*
         * 流程二:
         *    补充数据查询、这里地址默认取和明细一样
         */
        List<OrgEmpRpcDTO> finalEmpDtoByParam = empDtoByParam;
        List<OrgAddressRpcDTO> finalAddressRpcDto = addressRpcDto;
        List<OrgBuRpcDTO> finalBuDtoByParam = buDtoByParam;
        respVOList.forEach(respVo -> {
            //  this.financialHandle2(respVo);
            if (!StringUtils.isEmpty(respVo.getAddrNo())) {
                List<OrgAddressRpcDTO> orgAddressRpcDTOS = finalAddressRpcDto.stream().filter(addr -> addr.getAddrNo().equals(respVo.getAddrNo())).sorted(Comparator.comparing(OrgAddressRpcDTO::getId)).collect(Collectors.toList());
                if (!CollectionUtils.isEmpty(orgAddressRpcDTOS)) {
                    List<OrgAddressRpcDTO> orgAddressRpcDTOS1 = orgAddressRpcDTOS.stream().filter(orgAddr -> UdcEnum.ORG_ADDRESS_TYPE_RECEIVE.getValueCode().equals(orgAddr.getAddressType())).sorted(Comparator.comparing(OrgAddressRpcDTO::getId)).collect(Collectors.toList());
                    List<OrgAddressRpcDTO> orgAddressRpcDTOS2 = orgAddressRpcDTOS.stream().filter(orgAddr -> UdcEnum.ORG_ADDRESS_TYPE_DEFAULT.getValueCode().equals(orgAddr.getAddressType())).sorted(Comparator.comparing(OrgAddressRpcDTO::getId)).collect(Collectors.toList());
                    OrgAddressRpcDTO orgAddressRpcDTO;
                    if (!CollectionUtils.isEmpty(orgAddressRpcDTOS2)) {
                        Optional<OrgAddressRpcDTO> orgAddressRpcDTOOptional = orgAddressRpcDTOS2.stream().filter(addr -> addr.getDefaultFlag().equals(true)).findFirst();
                        orgAddressRpcDTO = orgAddressRpcDTOOptional.orElseGet(() -> orgAddressRpcDTOS2.get(0));
                    } else if (!CollectionUtils.isEmpty(orgAddressRpcDTOS1)) {
                        Optional<OrgAddressRpcDTO> orgAddressRpcDTOOptional = orgAddressRpcDTOS1.stream().filter(addr -> addr.getDefaultFlag().equals(true)).findFirst();
                        orgAddressRpcDTO = orgAddressRpcDTOOptional.orElseGet(() -> orgAddressRpcDTOS1.get(0));
                    } else {
                        orgAddressRpcDTO = orgAddressRpcDTOS.get(0);
                    }
                    respVo.setContPerson(orgAddressRpcDTO.getContPerson());
                    respVo.setContPersonEmail(orgAddressRpcDTO.getEmail());
                    respVo.setContPersonTel(orgAddressRpcDTO.getTel());
                    respVo.setContPersonMobile(orgAddressRpcDTO.getMobile());
                    respVo.setContPersonEmail(orgAddressRpcDTO.getEmail());
                    respVo.setStreet(orgAddressRpcDTO.getStreet());
                    respVo.setCountry(orgAddressRpcDTO.getCountry());
                    respVo.setContPersonFax(orgAddressRpcDTO.getFax());
                    List<String> contractCity = new ArrayList<>();
                    contractCity.add(orgAddressRpcDTO.getProvince());
                    contractCity.add(orgAddressRpcDTO.getCity());
                    contractCity.add(orgAddressRpcDTO.getCounty());
                    respVo.setContractCity(contractCity);
                    respVo.setContractCityName((orgAddressRpcDTO.getProvinceName() == null ? "/" : orgAddressRpcDTO.getProvinceName() + "/") +
                            (orgAddressRpcDTO.getCityName() == null ? "/" : orgAddressRpcDTO.getCityName() + "/") +
                            (orgAddressRpcDTO.getCounty() == null ? "" : orgAddressRpcDTO.getCountyName()));
                    respVo.setAddrDetail(orgAddressRpcDTO.getDetailAddr());
                }
            }
            if (!StringUtils.isEmpty(respVo.getAgentEmpId())) {
                finalEmpDtoByParam.stream().filter(emp -> emp.getId().equals(respVo.getAgentEmpId()))
                        .findFirst()
                        .ifPresent(agentEmp -> respVo.setAgentEmpName(agentEmp.getEmpName()));
            }
            if (!StringUtils.isEmpty(respVo.getBuCode())) {
                finalBuDtoByParam.stream().filter(bu -> bu.getBuCode().equals(respVo.getBuCode()))
                        .findFirst()
                        .ifPresent(buDto -> buDto.setBuName(buDto.getBuName()));
            }
        });
    }

    /**
     * 补充查询明细数据
     * 账户信息附件补充注意
     * 说明一下，因为目前的yst-sale 端共用一张附件存储表,且存储的信息一般为 业务id + 文件编码，
     * 为了防止多个业务间 业务id可能会重复的问题，故需要添加业务类型 如下面的 CUST(每一个业务场景需要统一查询会按照类型查询)
     **/
    private void translateDetail(CrmCustDetailRespVO respVO) {
        //补充父idCode 这里是用来关联客户(父id也是数据库中的客户id)
        if (!StringUtils.isEmpty(respVO.getPid())) {
            String pidName = crmCustRepoProc.getCustNameByPidCode(respVO.getPid());
            respVO.setPidName(pidName);
        }

        // 并非多因为有需求会有要求，补充以业务员编码为客户编码的业务员名称(前端需要拿到补充)
        //this.addInterCustName(respVO);

        CrmCustConvert crmCustConvert = INSTANCE;
//        if (!StringUtils.isEmpty(respVO.getAgentEmpId())) {
//            OrgEmpRpcDtoParam orgEmpRpcDtoParam = new OrgEmpRpcDtoParam();
//            List<OrgEmpRpcDTO> empDtoByParam;
//            List<Long> agentEmpId = new ArrayList<>();
//            agentEmpId.add(respVO.getAgentEmpId());
//            orgEmpRpcDtoParam.setEmpIds(agentEmpId);
//
//            empDtoByParam = rmiOrgEmpService.findEmpListByParam(orgEmpRpcDtoParam);
//
//            empDtoByParam.stream().filter(emp -> emp.getId().equals(respVO.getAgentEmpId())).findFirst().ifPresent(empD -> respVO.setAgentEmpName(empD.getEmpName()));
//        }
        // 主要是用来数据补充
        if(!ObjectUtils.isEmpty(respVO.getAgentEmpId())){
            ApiResult<SalesmanInfoDTO> res = this.getSaleManInfo(respVO.getAgentEmpId());
            if(res.isSuccess() && !ObjectUtils.isEmpty(res) && !ObjectUtils.isEmpty(res.getData())){
                respVO.setAgentEmpName(res.getData().getFullName());
            }
        }
        if(!ObjectUtils.isEmpty(respVO.getAgentEmpId2())){
            ApiResult<SalesmanInfoDTO> res = this.getSaleManInfo(respVO.getAgentEmpId2());
            if(res.isSuccess() && !ObjectUtils.isEmpty(res) && !ObjectUtils.isEmpty(res.getData())){
                respVO.setAgentEmpName2(res.getData().getFullName());
            }
        }
        if (!StringUtils.isEmpty(respVO.getAddrNo())) {
            ApiResult<OrgAddrDetailsRpcDTO> rpcDtoByAddrNo;
            rpcDtoByAddrNo = rmiOrgAddrService.findAddrByAddrNo(respVO.getAddrNo());
            Assert.isFalse(!rpcDtoByAddrNo.isSuccess(), rpcDtoByAddrNo.getMsg());
            OrgAddrDetailsRpcDTO orgAddr = rpcDtoByAddrNo.getData();
            if (!ObjectUtils.isEmpty(orgAddr) && !CollectionUtils.isEmpty(orgAddr.getOrgAddrAddressVos())) {
                respVO.setAddrId(orgAddr.getId());
                //地址信息补充
                List<CrmCustAddrRespVO> crmCustAddrRespVOS = orgAddr.getOrgAddrAddressVos().stream().map(addr -> {
                    CrmCustAddrRespVO crmCustAddrRespVO = crmCustConvert.addrRpcToAddrVo(addr);
                    crmCustAddrRespVO.setContEmail(addr.getEmail());
                    crmCustAddrRespVO.setContFax(addr.getFax());
                    crmCustAddrRespVO.setContMobile(addr.getMobile());
                    crmCustAddrRespVO.setCountry(addr.getCountry());
                    crmCustAddrRespVO.setCountryName(addr.getCountryName());
                    crmCustAddrRespVO.setContTel(addr.getTel());
                    crmCustAddrRespVO.setDetailaddr(addr.getDetailAddr());
                    crmCustAddrRespVO.setUpdater(addr.getUpdater());
                    crmCustAddrRespVO.setCreator(addr.getCreator());
                    crmCustAddrRespVO.setModifyTime(addr.getModifyTime());
                    crmCustAddrRespVO.setCreateTime(addr.getCreateTime());
                    return crmCustAddrRespVO;
                }).collect(Collectors.toList());
                respVO.setAddrList(crmCustAddrRespVOS);
//                if(!CollectionUtils.isEmpty(crmCustAddrRespVOS)){
//                    respVO.setContactPhone(crmCustAddrRespVOS.get(0).getContMobile());
//                    respVO.setContactName(crmCustAddrRespVOS.get(0).getContPerson());
//                }
            }
            if(!ObjectUtils.isEmpty(orgAddr) && !CollectionUtils.isEmpty(orgAddr.getOrgAddrBankAccVos())){
                respVO.setAddrId(orgAddr.getId());
                List<OrgAddrBankAccRespVO> orgAddrBankAccRespVOS = orgAddr.getOrgAddrBankAccVos().stream().map(bank ->{
                    if(StringUtil.isBlank(bank.getCreator())){
                        bank.setCreator(bank.getUpdater());
                    }
                    return crmCustConvert.bankRpcToAddrVo(bank);
                }).collect(Collectors.toList());
                respVO.setOrgAddrBankAccList(orgAddrBankAccRespVOS);
            }

            if (!ObjectUtils.isEmpty(orgAddr) && !CollectionUtils.isEmpty(orgAddr.getOrgAddrQualifyVos())) {
                respVO.setAddrId(orgAddr.getId());
                //账户信息补充
                List<String> qualifyFileNos = orgAddr.getOrgAddrQualifyVos().stream().map(OrgAddrQualifyRpcDTO::getQualifyNo).filter(Objects::nonNull).distinct().collect(Collectors.toList());
                List<ComSaleFileComVO> comSaleFileComVOS = comSaleFileInfoService.findFileByBusinessId("CUST", respVO.getId());
                List<CrmCustQualifyRespVO> custQualifyRespVOS = orgAddr.getOrgAddrQualifyVos().stream().map(qualify -> {
                    CrmCustQualifyRespVO crmCustQualifyRespVO = crmCustConvert.qualifyRpcToAddrVo(qualify);
                    if (!CollectionUtils.isEmpty(qualifyFileNos)) {
                        comSaleFileComVOS.stream().filter(cust -> cust.getQualifyNo().equals(qualify.getQualifyNo())).findFirst().ifPresent(crmCustQualifyRespVO::setEnclosure);
                    }
                    return crmCustQualifyRespVO;
                }).collect(Collectors.toList());
                respVO.setQualifyList(custQualifyRespVOS);
            }
        }
    }

//    private void financialHandle(CrmCustDetailRespVO respVO) {
//        if (UdcEnum.CRM_FINANCIAL_ATTRIBUTE_20.getValueCode().equals(respVO.getFinancialAttribute())) {
//            respVO.setFinancialAttribute32(respVO.getFinancialAttribute3());
//            respVO.setFinancialAttribute42(respVO.getFinancialAttribute4());
//        } else if (UdcEnum.CRM_FINANCIAL_ATTRIBUTE_30.getValueCode().equals(respVO.getFinancialAttribute())) {
//            respVO.setFinancialAttribute33(respVO.getFinancialAttribute3());
//            respVO.setFinancialAttribute43(respVO.getFinancialAttribute4());
//        } else if (UdcEnum.CRM_FINANCIAL_ATTRIBUTE_40.getValueCode().equals(respVO.getFinancialAttribute())) {
//            respVO.setFinancialAttribute34(respVO.getFinancialAttribute3());
//            respVO.setFinancialAttribute44(respVO.getFinancialAttribute4());
//        } else if (UdcEnum.CRM_FINANCIAL_ATTRIBUTE_50.getValueCode().equals(respVO.getFinancialAttribute())) {
//            respVO.setFinancialAttribute35(respVO.getFinancialAttribute3());
//        }
//    }

//    private void financialHandle2(CrmCustPageRespVO respVO) {
//        StringBuilder financialGroupName = new StringBuilder();
//        if (!ObjectUtils.isEmpty(respVO.getFinancialAttributeName())) {
//            financialGroupName.append(respVO.getFinancialAttributeName());
//        }
//        if (!ObjectUtils.isEmpty(respVO.getFinancialAttribute2Name())) {
//            financialGroupName.append("-" + respVO.getFinancialAttribute2Name());
//        }
//        if (!ObjectUtils.isEmpty(respVO.getFinancialAttribute3Name())) {
//            financialGroupName.append("-" + respVO.getFinancialAttribute3Name());
//        }
//        if (!ObjectUtils.isEmpty(respVO.getFinancialAttribute4Name())) {
//            financialGroupName.append("-" + respVO.getFinancialAttribute4Name());
//        }
//        if (UdcEnum.CRM_FINANCIAL_ATTRIBUTE_20.getValueCode().equals(respVO.getFinancialAttribute())) {
//            respVO.setFinancialAttribute32(respVO.getFinancialAttribute3());
//            respVO.setFinancialAttribute42(respVO.getFinancialAttribute4());
//        } else if (UdcEnum.CRM_FINANCIAL_ATTRIBUTE_30.getValueCode().equals(respVO.getFinancialAttribute())) {
//            respVO.setFinancialAttribute33(respVO.getFinancialAttribute3());
//            respVO.setFinancialAttribute43(respVO.getFinancialAttribute4());
//        } else if (UdcEnum.CRM_FINANCIAL_ATTRIBUTE_40.getValueCode().equals(respVO.getFinancialAttribute())) {
//            respVO.setFinancialAttribute34(respVO.getFinancialAttribute3());
//            respVO.setFinancialAttribute44(respVO.getFinancialAttribute4());
//        } else if (UdcEnum.CRM_FINANCIAL_ATTRIBUTE_50.getValueCode().equals(respVO.getFinancialAttribute())) {
//            respVO.setFinancialAttribute35(respVO.getFinancialAttribute3());
//        }
//    }

    private void addInterCustName(CrmCustDetailRespVO respVO) {

        if (UdcEnum.CRM_CUST_TYPE2_D.getValueCode().equals(respVO.getCustType2())) {
            OrgEmpRpcDtoParam orgEmpRpcDtoParam = new OrgEmpRpcDtoParam();
            List<OrgEmpRpcDTO> empDtoByParam;
            List<String> empCodes = new ArrayList<>();
            empCodes.add(respVO.getCustCode());
            orgEmpRpcDtoParam.setEmpCodes(empCodes);

            empDtoByParam = rmiOrgEmpService.findEmpListByParam(orgEmpRpcDtoParam);

            empDtoByParam.stream().filter(emp -> emp.getEmpCode().equals(respVO.getCustCode())).findFirst().ifPresent(empD -> respVO.setCustCodePopupName(empD.getEmpName()));
        }
        if (UdcEnum.CRM_CUST_TYPE2_C.getValueCode().equals(respVO.getCustType2())) {
            OrgOuRpcDtoParam orgOuRpcDtoParam = new OrgOuRpcDtoParam();
            List<OrgOuRpcDTO> ouDtoByParam;
            List<String> ouCodes = new ArrayList<>();
            ouCodes.add(respVO.getCustCode());
            orgOuRpcDtoParam.setOuCodes(ouCodes);
            ouDtoByParam = rmiOrgOuService.findOuDtoListByParam(orgOuRpcDtoParam);
            ouDtoByParam.stream().filter(ou -> ou.getOuCode().equals(respVO.getCustCode())).findFirst().ifPresent(ouD -> respVO.setCustCodePopupName(ouD.getOuName()));
        }
    }

    public String getRandom(){
        String BASIC = "123456789qwertyuiopasdfghjklzxcvbnm";
        char[] basicArray = BASIC.toCharArray();
        Random random = new Random();
        char[] result = new char[6];
        for (int i = 0; i < result.length; i++) {
            int index = random.nextInt(100) % (basicArray.length);
            result[i] = basicArray[index];
        }
        return new String(result);
    }

    /**
     * 客户保存方法
     **/
//    @Caching(
//            evict = {
//                    @CacheEvict(value = ConstantsCache.BIP_USER_BIND_CUST, key = "#result.data.id", condition = "#result.success && #result.data != null")
//            }
//    )

    @Override
    @Transactional(rollbackFor = Exception.class)
    public ApiResult<CrmCustDetailRespVO> save(CrmCustSaveVO saveVO) {
        /* 客户数据保存
         * 流程一: 数据校验:
         *   1.必填校验: 客户名称、销售组织、公司、区域、客户管理专员、客户分类
         *   2.字段重复校验: 客户名称(1.新增的时候检查客户名称是否存在 2.修改的时候如果是当前客户修改信息则通过,其他用户修改同名称报错)
         */
        if (StringUtils.isEmpty(saveVO.getCustCode())) {
            //因为生成客户编码调不通，所以临时随机生成
            String custCode = rmiSysNextNumberService.generateCode("yst-sale","C", new ArrayList<>());
            saveVO.setCustCode(custCode);
//            saveVO.setCustCode(getRandom());
        }
        checkForSave(saveVO);
        /*
         * 流程二: 地址簿信息存储:(原因:保存成功需要把地址号存在客户主表,故优于主表存储)
         *   1. 针对于修改操作(通过地址号)
         *   2. 批量处理地址簿信息(包括客户信息列表、身份信息(含附件)) 附件 本地建中间表存关联关系
         */
        List<ComSaleFileComVO> comSaleFileComVOS = new ArrayList<>();
        OrgAddrRpcSaveParam param = this.addrHandle(saveVO, comSaleFileComVOS);
        /*
         * 流程三:数据保存
         *   1.地址簿信息保存,这里先转换为DO
         *   2.地址簿信息保存,会返回adderNo地址号(需要保存到客户主表)
         *   3.获取客户主表id存在在附件关系表
         *   4.保存数据至MDM系统
         */
//        if (StringUtils.isEmpty(saveVO.getCreatedBy())) {
//            saveVO.setCreatedBy(0);
//        }
//        saveVO.setIntfStatus("N");
        // 添加权限字段配置
        saveVO.setSecBuId(saveVO.getBuId());
        saveVO.setSecOuId(saveVO.getOuId());
        saveVO.setSecUserId(saveVO.getAgentEmpId());
        CrmCustDO crmCustDO = saveVoDo(saveVO);

        ApiResult<Long> addrNo1 = rmiOrgAddrService.orgAddrSaveOrUpdateReturnAddrNo(param);
        Assert.isFalse(!addrNo1.isSuccess(), addrNo1.getMsg());
        Long addrNo = addrNo1.getData();
        crmCustDO.setAddrNo(addrNo);
        saveVO.setAddrNo(addrNo);

        CrmCustDO custDO = crmCustRepo.save(crmCustDO);
        comSaleFileComVOS.forEach(k -> k.setBusinessId(custDO.getId()));
        comSaleFileInfoService.comSaleFileHardSave("CUST", custDO.getId(), comSaleFileComVOS);

        this.saveCustAccount(custDO.getCustCode(),saveVO.getCustAccountVO(),saveVO.getBusinessTypeCust());
        //查询bip_cust_user_bind 并更新ouID
//        QBipCustUserBindDO qBipCustUserBindDO = QBipCustUserBindDO.bipCustUserBindDO;
//        BooleanExpression e = qBipCustUserBindDO.deleteFlag.eq(0).and(qBipCustUserBindDO.custCode.eq(saveVO.getCustCode()));
//        Optional<BipCustUserBindDO> optional = bipCustUserBindRepo.findOne(e);
//        if (optional.isPresent()) {
//            BipCustUserBindDO bipCustUserBindDO = optional.get();
//            bipCustUserBindDO.setOuId(saveVO.getOuId());
//            bipCustUserBindRepo.save(bipCustUserBindDO);
//        }
        return ApiResult.ok(INSTANCE.doToDetailRespVO(custDO));
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public ApiResult<CrmCustDetailRespVO> bcSave(CrmCustSaveVO saveVO) {
        /* 客户数据保存
         * 流程一: 数据校验:
         *   1.必填校验: 客户名称、销售组织、公司、区域、客户管理专员、客户分类
         *   2.字段重复校验: 客户名称(1.新增的时候检查客户名称是否存在 2.修改的时候如果是当前客户修改信息则通过,其他用户修改同名称报错)
         */
        if (StringUtils.isEmpty(saveVO.getCustCode())) {
            String custCode = rmiSysNextNumberService.generateCode(Application.NAME,"C", null);
            saveVO.setCustCode(custCode);
        }
        checkForSave(saveVO);
        /*
         * 流程二: 地址簿信息存储:(原因:保存成功需要把地址号存在客户主表,故优于主表存储)
         *   1. 针对于修改操作(通过地址号)
         *   2. 批量处理地址簿信息(包括客户信息列表、身份信息(含附件)) 附件 本地建中间表存关联关系
         */
        List<ComSaleFileComVO> comSaleFileComVOS = new ArrayList<>();
        OrgAddrRpcSaveParam param = this.addrHandle(saveVO, comSaleFileComVOS);
        /*
         * 流程三:数据保存
         *   1.地址簿信息保存,这里先转换为DO
         *   2.地址簿信息保存,会返回adderNo地址号(需要保存到客户主表)
         *   3.获取客户主表id存在在附件关系表
         *   4.保存数据至MDM系统
         */
        if (StringUtils.isEmpty(saveVO.getCreatedBy())) {
            saveVO.setCreatedBy(0);
        }
        saveVO.setIntfStatus("N");
        // 添加权限字段配置
        saveVO.setSecBuId(saveVO.getBuId());
        saveVO.setSecOuId(saveVO.getOuId());
        saveVO.setSecUserId(saveVO.getAgentEmpId());
        CrmCustDO crmCustDO = saveVoDo(saveVO);

        Long addrNo;
        if (!"C".equals(saveVO.getCustType2())){
            ApiResult<Long> addrNo1 = rmiOrgAddrService.orgAddrSaveOrUpdate(param);
            Assert.isFalse(!addrNo1.isSuccess(), addrNo1.getMsg());
            addrNo = addrNo1.getData();
        } else { //内部公司
            addrNo = saveVO.getAddrNo();
        }

        crmCustDO.setAddrNo(addrNo);
        saveVO.setAddrNo(addrNo);

        CrmCustDO custDO = crmCustRepo.save(crmCustDO);
//        if (!CollectionUtils.isEmpty(comSaleFileComVOS)) {
        comSaleFileComVOS.forEach(k -> k.setBusinessId(custDO.getId()));
        comSaleFileInfoService.comSaleFileHardSave("CUST", custDO.getId(), comSaleFileComVOS);
//        }
        /* MDM客户同步
         * 流程一: 调用MDM系统，首次访问建立连接获取批次号
         *
         * 流程二: 数据查询(参数中添加首次查询的批次号作为入参条件)
         *    1.如果存在:获取主数据信息，更新CRM系统客户主数据
         *    2.如果不存在:CRM系统客户主数据不补充
         *
         * 流程三: 数据同步(需要将CRM主数据内容补充到MDM系统)
         *    1.字段需要确认,补充到MDM系统
         *    2.针对于MDM系统补充的数据返回的客户编码补充到主数据的外部客户编码
         */
//        CompletableFuture.runAsync(()->{
//            //请求头
//            HttpHeaders headers = new HttpHeaders();
//            RestTemplate restTemplate = new RestTemplate();
//            headers.add("Accept", "application/json");
//            headers.add("Content-Type", "application/json;charset=UTF-8");
////            IF_PRODUCTION = "true";
//            if (IF_PRODUCTION.equals("true")) {
//                restTemplate.getInterceptors().add(new BasicAuthenticationInterceptor(USERNAME_SOA, PASSWORD_SOA));
//                headers.add("authorization",
//                        "Basic " +
//                                java.util.Base64.encode((USERNAME_SOA + ":" + PASSWORD_SOA).getBytes()));
//            }
//
//            this.custCheckAndSynchron2(headers, custDO.getId(), saveVO);
//        });

        //查询bip_cust_user_bind 并更新ouID
        QBipCustUserBindDO qBipCustUserBindDO = QBipCustUserBindDO.bipCustUserBindDO;
        BooleanExpression e = qBipCustUserBindDO.deleteFlag.eq(0).and(qBipCustUserBindDO.custCode.eq(saveVO.getCustCode()));
        Optional<BipCustUserBindDO> optional = bipCustUserBindRepo.findOne(e);
        if (!optional.isEmpty()) {
            BipCustUserBindDO bipCustUserBindDO = optional.get();
            bipCustUserBindDO.setOuId(saveVO.getOuId());
            bipCustUserBindDO.setAgentEmpId(saveVO.getAgentEmpId());
            bipCustUserBindRepo.save(bipCustUserBindDO);
        }
        return ApiResult.ok(CrmCustConvert.INSTANCE.doToDetailRespVO(custDO));
    }

    /**
     * 导入业务员
     * @param datas
     */
    @Override
    public ApiResult<Object> updateAgentEmpId(List<CustImportEmpDTO> datas) {
        List<CrmCustDO> res = new ArrayList<>();
        List<String> empCodes = datas.stream().map(CustImportEmpDTO :: getEmpCode).collect(Collectors.toList());
        empCodes.removeAll(Collections.singletonList(null));
        if(!CollectionUtils.isEmpty(empCodes)){
            for(int i=0;i<datas.size();i++){
                int row = i + 1;
                CustImportEmpDTO d = datas.get(i);
                ApiResult<SalesmanInfoDTO> saleMan = getSaleManInfoByEmpCode(d.getEmpCode());
                if(saleMan.isSuccess() && !ObjectUtils.isEmpty(saleMan.getData())){
                    CrmCustDO cust = crmCustRepoProc.getCustInfoByCode(d.getCustCode());
                    if(ObjectUtils.isEmpty(cust)){
                        return ApiResult.fail("第"+ row +"行,客户编号为" + d.getCustCode() + "的客户不存在");
                    }
//                    cust.setAgentEmpId2(cust.getAgentEmpId());
                    cust.setAgentEmpId(saleMan.getData().getId());
                    //查询传过来的业务员ID
                    Long agentEmpId2 = this.excuteAgentEmpId2(saleMan.getData().getId(),d.getCustCode());
                    if(null != agentEmpId2){
                        cust.setAgentEmpId2(agentEmpId2);
                    }
                    res.add(cust);
                }else {
                    return ApiResult.fail("编号为：" + d.getEmpCode() + "的员工不存在");
                }
            }
        }
        crmCustRepo.saveAll(res);
        return ApiResult.ok();
    }


    public ApiResult<SalesmanInfoDTO> getSaleManInfoByEmpCode(String agentEmpCode){
        SalesmanQueryDTO salesmanQueryDTO = new SalesmanQueryDTO();
        salesmanQueryDTO.setSalesmanCode(agentEmpCode);
        return salesmanInfoService.querySalesmanInfo(salesmanQueryDTO);
    }

    public void saveCustAccount(String custCode,CustAccountVO custAccountVO,String bussinessTypeCust){
        //查询是否绑定过账号 如果没有发送到系统域 可以让其修改，如果已经生成过账户则账户信息不允许修改
        CustAccountVO custAccount = custAccountRepoproc.getAccountByCustCode(custCode);
        //账户信息没有保存过 直接保存
        if(ObjectUtils.isEmpty(custAccount)){
            custAccountRepoproc.saveAccountCust(custCode,custAccountVO);
        }
        //账户信息已经存在，且没有生成过账号的可以修改
        if(!ObjectUtils.isEmpty(custAccount) && custAccount.getIsOpenAccount().equals(Boolean.FALSE)){
            custAccountVO.setId(custAccount.getId());
            custAccountRepoproc.saveAccountCust(custCode,custAccountVO);
        }

    }



    private void innerUpdateSyncDate(HttpHeaders headers, CrmCustMdmSyncRespVO crmCustMdmSyncRespVO, CrmCustSaveVO crmCustSaveVO) {

        CrmCustConvert crmCustConvert = INSTANCE;
        if (!ObjectUtils.isEmpty(crmCustMdmSyncRespVO) && crmCustMdmSyncRespVO.getCode().equals("0")) {
            String queryResponse = crmCustMdmSyncRespVO.getData();
            String str1 = Base64.decodeStr(queryResponse);
            CrmCustResponseDataRespVO parseObject = JSON.parseObject(str1, CrmCustResponseDataRespVO.class);
            List<CrmCustMasterDataRespVO> custMasterDataIntfList = parseObject.getCustMasterDataIntfList();
            Optional<CrmCustMasterDataRespVO> masterDataRespVO = custMasterDataIntfList.stream().filter(cust -> crmCustSaveVO.getTaxRegNo().equals(cust.getLicenseNo2())).findFirst();
            if (masterDataRespVO.isPresent()) {
//                CrmCustMasterDataRespVO crmCustMasterDataRespVO = masterDataRespVO.get();
//                if (ObjectUtils.isEmpty(crmCustSaveVO.getCustType2())) {
//                    crmCustSaveVO.setCustCode2(crmCustMasterDataRespVO.getCustNo());
//                }
            }
//            crmCustSaveVO.setIntfStatus("Y");
            CrmCustDO crmCustDO = new CrmCustDO();
            crmCustConvert.copyVoToDo(crmCustSaveVO, crmCustDO);
            crmCustRepo.save(crmCustDO);
        } else {
            throw new BusinessException("内部客户Mdm同步异常");
        }
    }

    private void addAndUpdateSyncDate(HttpHeaders headers, CrmCustMdmSyncRespVO crmCustMdmSyncRespVO, CrmCustSaveVO crmCustSaveVO) {

        AtomicReference<Boolean> ifExtis = new AtomicReference<>(false);
        CrmCustConvert crmCustConvert = INSTANCE;
        CrmCustMdmSyncConvert crmCustMdmSyncConvert = CrmCustMdmSyncConvert.INSTANCE;

        //获取当前登录人(确定修改人信息)
        CurrentUserDTO currentUserDTO = UserService.currentUser();
        String userName = (Objects.isNull(currentUserDTO) || Objects.isNull(currentUserDTO.getUserName())) ? "admin" : currentUserDTO.getUserName();

        if (!ObjectUtils.isEmpty(crmCustMdmSyncRespVO) && crmCustMdmSyncRespVO.getCode().equals("0")) {
            String queryResponse = crmCustMdmSyncRespVO.getData();
            String str1 = Base64.decodeStr(queryResponse);
            CrmCustResponseDataRespVO parseObject = JSON.parseObject(str1, CrmCustResponseDataRespVO.class);
            List<CrmCustMasterDataRespVO> custMasterDataIntfList = parseObject.getCustMasterDataIntfList();
            Optional<CrmCustMasterDataRespVO> masterDataRespVO = custMasterDataIntfList.stream().filter(cust -> crmCustSaveVO.getTaxRegNo().equals(cust.getLicenseNo2())).findFirst();
            if (masterDataRespVO.isPresent()) {
//                CrmCustMasterDataRespVO crmCustMasterDataRespVO = masterDataRespVO.get();
//                crmCustSaveVO.setCreatedBy(2);
                CrmCustDO crmCustDO = new CrmCustDO();
                crmCustConvert.copyVoToDo(crmCustSaveVO, crmCustDO);
                crmCustRepo.save(crmCustDO);
            } else {

//                String custCode2 = rmiSysNextNumberService.generateCode("yst-sale","CN", null);
//
//                SimpleDateFormat sdfSave = new SimpleDateFormat(DATEFORMAT2);
//                CrmCustMdmSyncSaveVO crmCustMdmSyncSaveVO = new CrmCustMdmSyncSaveVO();
//                crmCustMdmSyncSaveVO.setApplicationCode(APPLICATION_CODE);
//                crmCustMdmSyncSaveVO.setAuth(AUTH);
//                crmCustMdmSyncSaveVO.setBatch("");
//                crmCustMdmSyncSaveVO.setIfaceCode(IFACECODE_UP_DATA);
//                String requestSaveID = sdfSave.format(new Date());
//                crmCustMdmSyncSaveVO.setRequestID(requestSaveID);
//
//                CrmCustMdmRequstSaveVO crmCustMdmRequstSaveVO = new CrmCustMdmRequstSaveVO();
//                crmCustMdmRequstSaveVO.setApplicationCode(APPLICATION_CODE);
//                crmCustMdmRequstSaveVO.setIfaceCode(IFACECODE_UP_DATA);
//                crmCustMdmRequstSaveVO.setVersion("");
//                List<CrmCustMdmSyncDataSaveVO> dataSaveVOS = new ArrayList<>();
//                //数据转换
//                CrmCustMdmSyncDataSaveVO custMdmSyncDataSaveVO = crmCustMdmSyncConvert.saveVo2SyncSaveVo(crmCustSaveVO);
//                custMdmSyncDataSaveVO.setCustNo(custCode2);
//                if (UdcEnum.CRM_CUST_STATUS_ACTIVE.getValueCode().equals(crmCustSaveVO.getCustStatus())) {
//                    custMdmSyncDataSaveVO.setCustStat("Y");
//                } else {
//                    custMdmSyncDataSaveVO.setCustStat("N");
//                }
//
//                //补充时间
//                DateTimeFormatter dtf = DateTimeFormatter.ofPattern(DATEFORMAT);
//                custMdmSyncDataSaveVO.setUpdateTime(LocalDateTime.now().format(dtf));
//                if (!StringUtils.isEmpty(crmCustSaveVO.getCreateTime())) {
//                    custMdmSyncDataSaveVO.setCrtDate(crmCustSaveVO.getCreateTime().format(dtf));
//                } else {
//                    custMdmSyncDataSaveVO.setCrtDate(LocalDateTime.now().format(dtf));
//                }
//                if (!StringUtils.isEmpty(crmCustSaveVO.getCreator())) {
//                    custMdmSyncDataSaveVO.setCrtName(crmCustSaveVO.getCreator());
//                } else {
//                    custMdmSyncDataSaveVO.setCrtName(userName);
//                }
//                custMdmSyncDataSaveVO.setLstupdtName(userName);
//                custMdmSyncDataSaveVO.setLstupdtDate(LocalDateTime.now().format(dtf));
//                custMdmSyncDataSaveVO.setDataType("新增");
//                //添加明细行数据用作拓展数据
//                List<CustSyncBaseDataLine> custSyncBaseDataLines = new ArrayList<>();
//                CustSyncBaseDataLine custSyncBaseDataLine = new CustSyncBaseDataLine();
//                custSyncBaseDataLine.setLineType("LXR");
//                custSyncBaseDataLine.setLicenseNo2(crmCustSaveVO.getTaxRegNo());
//                CustSyncBaseDataLine custSyncBaseDataLine2 = new CustSyncBaseDataLine();
//                custSyncBaseDataLine2.setLineType("YH");
//                custSyncBaseDataLine2.setLicenseNo2(crmCustSaveVO.getTaxRegNo());
//                CustSyncBaseDataLine custSyncBaseDataLine3 = new CustSyncBaseDataLine();
//                custSyncBaseDataLine3.setLineType("DZ");
//                custSyncBaseDataLine3.setLicenseNo2(crmCustSaveVO.getTaxRegNo());
//                custSyncBaseDataLines.add(custSyncBaseDataLine);
//                custSyncBaseDataLines.add(custSyncBaseDataLine2);
//                custSyncBaseDataLines.add(custSyncBaseDataLine3);
//                custMdmSyncDataSaveVO.setCustMasterDataLineImpTemp(custSyncBaseDataLines);
//
//                dataSaveVOS.add(custMdmSyncDataSaveVO);
//                crmCustMdmRequstSaveVO.setCustMasterDataList(dataSaveVOS);
//                String saveQueryJson = JSON.toJSONString(crmCustMdmRequstSaveVO);
//                String requestSaveData = Base64.encode(saveQueryJson);
//                crmCustMdmSyncSaveVO.setRequestData(requestSaveData);
//
//                if ("Y".equals(custMdmSyncDataSaveVO.getCustStat())) {
//                    CrmCustMdmSyncRespVO custMdmSyncRespVO = null;
//                    try {
//                        String json = objectMapper.writeValueAsString(crmCustMdmSyncSaveVO);
//                        log.info("mdm上传请求数据{}", json);
//                        custMdmSyncRespVO = new RestTemplate().postForEntity(IMPORTMDMURL, new HttpEntity<>(json, headers), CrmCustMdmSyncRespVO.class).getBody();
//                        log.info("mdm上传请求结果{}", custMdmSyncRespVO);
//                    } catch (Exception e) {
//                        log.info("mdm上传数据调用异常" + e);
//                        throw new BusinessException("mdm上传数据调用异常" + e);
//                    }
//                    //这部分逻辑要动
//                    if (!ObjectUtils.isEmpty(custMdmSyncRespVO) && custMdmSyncRespVO.getCode().equals("0")) {
//
//                        String result = custMdmSyncRespVO.getData();
//                        String strResult = Base64.decodeStr(result);
//                        JSONObject jsonObject = JSONObject.parseObject(strResult);
//                        if (jsonObject.getString("code").equals("0")) {
////                            crmCustSaveVO.setCustCode2(custCode2);
////                            crmCustSaveVO.setIntfStatus("Y");
//                            crmCustSaveVO.setCreatedBy(1);
//                            CrmCustDO crmCustDO = new CrmCustDO();
//                            crmCustConvert.copyVoToDo(crmCustSaveVO, crmCustDO);
//                            crmCustRepo.save(crmCustDO);
//                        } else {
//                            // 获得Data中的custMasterDataImportReturnDetailDTOs中的msg抛出
//                            String str = custMdmSyncRespVO.getData();
//                            String decodeStr = Base64.decodeStr(str);
//                            JSONObject jsonObj = JSON.parseObject(decodeStr);
//                            JSONObject jsonData = (JSONObject) jsonObj.get("data");
//                            JSONArray jsonArray = (JSONArray) jsonData.get("custMasterDataImportReturnDetailDTOs");
//                            JSONObject object = (JSONObject) jsonArray.get(0);
//                            log.info("同步失败数据{}", object.get("msg"));
//                            throw new BusinessException("同步失败0" + object.get("msg"));
//                        }
//                    } else {
//                        log.info("同步失败数据1{}", JSON.toJSONString(custMdmSyncRespVO));
//                        throw new BusinessException("同步失败1" + JSON.toJSONString(custMdmSyncRespVO));
//                    }
//                } else {
//                    throw new BusinessException("禁用客户不能同步至MDM");
//                }
            }
        } else {
            log.info("同步失败数据2{}", JSON.toJSONString(crmCustMdmSyncRespVO));
            throw new BusinessException("同步失败2" + JSON.toJSONString(crmCustMdmSyncRespVO));
        }
    }

    // 同步数据当 createdBy 为 1 时,该数据已经同步，且为NRP方的数据，故只需要我们这边进行推送更改操作
    private void updateNRPSyncDate(HttpHeaders headers, CrmCustMdmSyncRespVO crmCustMdmSyncRespVO, CrmCustSaveVO crmCustSaveVO) {

        AtomicReference<Boolean> ifExtis = new AtomicReference<>(false);
        CrmCustConvert crmCustConvert = INSTANCE;
        CrmCustMdmSyncConvert crmCustMdmSyncConvert = CrmCustMdmSyncConvert.INSTANCE;

        //获取当前登录人(确定修改人信息)
        CurrentUserDTO currentUserDTO = UserService.currentUser();
        String userName = (Objects.isNull(currentUserDTO) || Objects.isNull(currentUserDTO.getUserName())) ? "admin" : currentUserDTO.getUserName();

        if (!ObjectUtils.isEmpty(crmCustMdmSyncRespVO) && crmCustMdmSyncRespVO.getCode().equals("0")) {
            String queryResponse = crmCustMdmSyncRespVO.getData();
            String str1 = Base64.decodeStr(queryResponse);
            CrmCustResponseDataRespVO parseObject = JSON.parseObject(str1, CrmCustResponseDataRespVO.class);
            List<CrmCustMasterDataRespVO> custMasterDataIntfList = parseObject.getCustMasterDataIntfList();
            Optional<CrmCustMasterDataRespVO> masterDataRespVO = custMasterDataIntfList.stream().filter(cust -> crmCustSaveVO.getTaxRegNo().equals(cust.getLicenseNo2())).findFirst();
            if (masterDataRespVO.isPresent() && crmCustSaveVO.getCustCode().equals(masterDataRespVO.get().getOrgnCustNo())) {
                // 跟新数据
                CrmCustMasterDataRespVO crmCustMasterDataRespVO = masterDataRespVO.get();
                SimpleDateFormat sdfSave = new SimpleDateFormat(DATEFORMAT2);
                CrmCustMdmSyncSaveVO crmCustMdmSyncSaveVO = new CrmCustMdmSyncSaveVO();
//                crmCustMdmSyncSaveVO.setApplicationCode(APPLICATION_CODE);
//                crmCustMdmSyncSaveVO.setAuth(AUTH);
                crmCustMdmSyncSaveVO.setBatch("");
                crmCustMdmSyncSaveVO.setIfaceCode(IFACECODE_UP_DATA);
                String requestSaveID = sdfSave.format(new Date());
                crmCustMdmSyncSaveVO.setRequestID(requestSaveID);

                CrmCustMdmRequstSaveVO crmCustMdmRequstSaveVO = new CrmCustMdmRequstSaveVO();
                //        crmCustMdmRequstSaveVO.setApplicationCode(APPLICATION_CODE);
                crmCustMdmRequstSaveVO.setIfaceCode(IFACECODE_UP_DATA);
                crmCustMdmRequstSaveVO.setVersion("");
                List<CrmCustMdmSyncDataSaveVO> dataSaveVOS = new ArrayList<>();
                //将获取的数据和我传进来的数据进行同步
                CrmCustMdmSyncDataSaveVO custMdmSyncDataSaveVO = crmCustMdmSyncConvert.responseToSaveVo(crmCustMasterDataRespVO);
//                custMdmSyncDataSaveVO.setCustNo(crmCustSaveVO.getCustCode2());
                custMdmSyncDataSaveVO.setCustName(crmCustSaveVO.getCustName());
                //同步修改数据
                if (UdcEnum.CRM_CUST_STATUS_ACTIVE.getValueCode().equals(crmCustSaveVO.getCustStatus())) {
                    custMdmSyncDataSaveVO.setCustStat("Y");
                } else {
                    custMdmSyncDataSaveVO.setCustStat("N");
                }
                //补充时间
                DateTimeFormatter dtf = DateTimeFormatter.ofPattern(DATEFORMAT);
                custMdmSyncDataSaveVO.setUpdateTime(LocalDateTime.now().format(dtf));
                if (!StringUtils.isEmpty(crmCustSaveVO.getCreateTime())) {
                    custMdmSyncDataSaveVO.setCrtDate(crmCustSaveVO.getCreateTime().format(dtf));
                } else {
                    custMdmSyncDataSaveVO.setCrtDate(LocalDateTime.now().format(dtf));
                }
                if (!StringUtils.isEmpty(crmCustSaveVO.getCreator())) {
                    custMdmSyncDataSaveVO.setCrtName(crmCustSaveVO.getCreator());
                } else {
                    custMdmSyncDataSaveVO.setCrtName(userName);
                }
                custMdmSyncDataSaveVO.setLstupdtName(userName);
                custMdmSyncDataSaveVO.setLstupdtDate(LocalDateTime.now().format(dtf));
                custMdmSyncDataSaveVO.setDataType("更新");
                //添加明细行数据用作拓展数据
                List<CustSyncBaseDataLine> custSyncBaseDataLines = new ArrayList<>();
                CustSyncBaseDataLine custSyncBaseDataLine = new CustSyncBaseDataLine();
                custSyncBaseDataLine.setLineType("LXR");
                custSyncBaseDataLine.setLicenseNo2(crmCustSaveVO.getTaxRegNo());
                CustSyncBaseDataLine custSyncBaseDataLine2 = new CustSyncBaseDataLine();
                custSyncBaseDataLine2.setLineType("YH");
                custSyncBaseDataLine2.setLicenseNo2(crmCustSaveVO.getTaxRegNo());
                CustSyncBaseDataLine custSyncBaseDataLine3 = new CustSyncBaseDataLine();
                custSyncBaseDataLine3.setLineType("DZ");
                custSyncBaseDataLine3.setLicenseNo2(crmCustSaveVO.getTaxRegNo());
                custSyncBaseDataLines.add(custSyncBaseDataLine);
                custSyncBaseDataLines.add(custSyncBaseDataLine2);
                custSyncBaseDataLines.add(custSyncBaseDataLine3);
                custMdmSyncDataSaveVO.setCustMasterDataLineImpTemp(custSyncBaseDataLines);

                dataSaveVOS.add(custMdmSyncDataSaveVO);
                //将获取的数据和我传进来的数据进行同步
                crmCustMdmRequstSaveVO.setCustMasterDataList(dataSaveVOS);
                String saveQueryJson = JSON.toJSONString(crmCustMdmRequstSaveVO);
                String requestSaveData = Base64.encode(saveQueryJson);
                crmCustMdmSyncSaveVO.setRequestData(requestSaveData);

                CrmCustMdmSyncRespVO custMdmSyncRespVO = null;
//                try {
//                    String json = objectMapper.writeValueAsString(crmCustMdmSyncSaveVO);
//                    log.info("NRP方mdm上传请求数据{}", json);
//                    custMdmSyncRespVO = new RestTemplate().postForEntity(IMPORTMDMURL, new HttpEntity<>(json, headers), CrmCustMdmSyncRespVO.class).getBody();
//                    log.info("NRP方mdm上传请求结果{}", custMdmSyncRespVO);
//                } catch (Exception e) {
//                    log.info("NRP方mdm上传调用异常" + e);
//                    throw new BusinessException("NRP方mdm上传调用异常" + e);
//                }
                if (!ObjectUtils.isEmpty(custMdmSyncRespVO) && custMdmSyncRespVO.getCode().equals("0")) {
//                    crmCustSaveVO.setIntfStatus("Y");
                    CrmCustDO crmCustDO = new CrmCustDO();
                    crmCustConvert.copyVoToDo(crmCustSaveVO, crmCustDO);
                    crmCustRepo.save(crmCustDO);
                } else {
//                    String str = custMdmSyncRespVO.getData();
//                    String decodeStr = Base64.decodeStr(str);
//                    JSONObject jsonObj = JSON.parseObject(decodeStr);
//                    JSONObject jsonData = (JSONObject) jsonObj.get("data");
//                    JSONArray jsonArray = (JSONArray) jsonData.get("custMasterDataImportReturnDetailDTOs");
//                    JSONObject object = (JSONObject) jsonArray.get(0);
//                    log.info("同步失败数据{}", object.get("msg"));
//                    throw new BusinessException("mdm同步失败数据异常" + object.get("msg"));
                }
                ifExtis.set(true);
            }
        }
    }

    // 当createdBy为2时表示该数据已经被同步了，且数据为ERP方数据,我方只要去将其的数据同步到我方NRP系统就ok
    private void updateERPSyncDate(HttpHeaders headers, CrmCustMdmSyncRespVO crmCustMdmSyncRespVO, CrmCustSaveVO crmCustSaveVO) {

        CrmCustConvert crmCustConvert = INSTANCE;

        if (!ObjectUtils.isEmpty(crmCustMdmSyncRespVO) && crmCustMdmSyncRespVO.getCode().equals("0")) {
            String queryResponse = crmCustMdmSyncRespVO.getData();
            String str1 = Base64.decodeStr(queryResponse);
            CrmCustResponseDataRespVO parseObject = JSON.parseObject(str1, CrmCustResponseDataRespVO.class);
            List<CrmCustMasterDataRespVO> custMasterDataIntfList = parseObject.getCustMasterDataIntfList();
            Optional<CrmCustMasterDataRespVO> masterDataRespVO = custMasterDataIntfList.stream().filter(cust -> crmCustSaveVO.getTaxRegNo().equals(cust.getLicenseNo2())).findFirst();
            if (masterDataRespVO.isPresent()) {
                if (!crmCustSaveVO.getCustCode().equals(masterDataRespVO.get().getOrgnCustNo())) {
                    CrmCustMasterDataRespVO crmCustMasterDataRespVO = masterDataRespVO.get();
//                    crmCustSaveVO.setCustCode2(crmCustMasterDataRespVO.getCustNo());
//                    crmCustSaveVO.setIntfStatus("Y");
                    CrmCustDO crmCustDO = new CrmCustDO();
                    crmCustConvert.copyVoToDo(crmCustSaveVO, crmCustDO);
                    crmCustRepo.save(crmCustDO);
                }
            }
        }
    }

    //地址信息处理
    private OrgAddrRpcSaveParam addrHandle (CrmCustSaveVO saveVO, List<ComSaleFileComVO> comSaleFileComVOS) {
        OrgAddrRpcSaveParam param = new OrgAddrRpcSaveParam();
        //批量处理地址簿信息
        CrmCustConvert crmCustConvert = INSTANCE;
        param.setId(saveVO.getAddrId());
        param.setAddrNo(saveVO.getAddrNo());
        param.setAddrName(saveVO.getCustName());
        param.setAddrType(UdcEnum.ORG_ADDR_TYPE_CUST.getValueCode());
        param.setDataSources(Collections.singletonList(UdcEnum.ORG_ADDR_TYPE_CUST.getValueCode()));
        if (!CollectionUtils.isEmpty(saveVO.getAddrList())) {
            List<CrmCustAddrSaveVO> custAddrSaveVOS = saveVO.getAddrList();
            List<OrgAddrAddressRpcSaveParam> addrAddressRpcSaveParams = custAddrSaveVOS.stream().map(add -> {
                OrgAddrAddressRpcSaveParam orgAddrAddress = crmCustConvert.saveVoToAddrRpc(add);
                if(StringUtil.isBlank(add.getAddressType())){
                    orgAddrAddress.setAddressType(UdcEnum.ORG_ADDRESS_TYPE_DEFAULT.getValueCode());
                }
                orgAddrAddress.setId(add.getId());
                orgAddrAddress.setMobile(add.getContMobile());
                orgAddrAddress.setTel(add.getContTel());
                orgAddrAddress.setFax(add.getContFax());
                orgAddrAddress.setEmail(add.getContEmail());
                orgAddrAddress.setDetailAddr(add.getDetailaddr());
                orgAddrAddress.setDataSource(UdcEnum.ORG_ADDR_TYPE_CUST.getValueCode());
                return orgAddrAddress;
            }).collect(Collectors.toList());
            param.setOrgAddrAddressSaveParams(addrAddressRpcSaveParams);
        }
        //银行信息
        if(!CollectionUtils.isEmpty(saveVO.getOrgAddrBankAccList())){
            List<OrgAddrBankAccSaveVO> bankAccSaveVOS = saveVO.getOrgAddrBankAccList();
            List<OrgAddrBankAccRpcSaveParam> bankAccRpcSaveParams = bankAccSaveVOS.stream().map(add ->{
                add.setDataSource(UdcEnum.ORG_ADDR_TYPE_CUST.getValueCode());
                return crmCustConvert.saveVoToBankRpc(add);
            }).collect(Collectors.toList());
            param.setOrgAddrBankAccSaveParams(bankAccRpcSaveParams);
        }

        //批量处理账户信息
        if (!CollectionUtils.isEmpty(saveVO.getQualifyList())) {
            List<CrmCustQualifySaveVO> crmCustQualifySaveVOS = saveVO.getQualifyList();
            List<OrgAddrQualifyRpcSaveParam> addrQualifyRpcSaveParams = crmCustQualifySaveVOS.stream().map(qualify -> {
                OrgAddrQualifyRpcSaveParam orgAddrQualify = crmCustConvert.saveVoToQualifyRpc(qualify);
                orgAddrQualify.setDataSource(UdcEnum.ORG_ADDR_TYPE_CUST.getValueCode());
                ComSaleFileComVO comSaleFileComVO = new ComSaleFileComVO();
                orgAddrQualify.setQualifyFileId(qualify.getQualifyOuId());
                if (!ObjectUtils.isEmpty(qualify.getEnclosure())) {
                    comSaleFileComVO.setQualifyNo(qualify.getQualifyNo());
                    comSaleFileComVO.setFileCode(qualify.getEnclosure().getFileCode());
                    comSaleFileComVO.setOriginalName(qualify.getEnclosure().getOriginalName());
                    comSaleFileComVOS.add(comSaleFileComVO);
                }
                comSaleFileInfoService.comSaleFileHardSave("CUST", qualify.getQualifyNo(), List.of(comSaleFileComVO));
                return orgAddrQualify;
            }).collect(Collectors.toList());
            param.setOrgAddrQualifySaveParams(addrQualifyRpcSaveParams);
        }
        return param;
    }

    /**
     * 启用禁用方法
     **/
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void switchStatusByIds(CustSwitchStatusParamVO paramVO) {

        if (ObjectUtils.isEmpty(paramVO) && CollectionUtils.isEmpty(paramVO.getCustIds())) {
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "未选择客户");
        }
        List<CrmCustDetailRespVO> custDetailRespVOS = this.findIdBatch(paramVO.getCustIds());
        //目前暂时是启用和禁用之间的转换(这里现在是写死，目前业务的范围之内)
        custDetailRespVOS.forEach(cust -> cust.setCustStatus(paramVO.getCustStatus()));
        List<CrmCustDO> crmCustDOS = custDetailRespVOS.stream().map(INSTANCE::detailVoToDo).collect(Collectors.toList());
        crmCustRepo.saveAll(crmCustDOS);
    }

    /**
     * 客户信息导入
     **/
    @Override
    @Transactional(rollbackFor = Exception.class)
    public ApiResult<List<CrmCustImportSaveVO>> custImportData(List<CrmCustImportSaveVO> parseData) {

        //数据校验
//        ApiResult<List<CrmCustImportSaveVO>> crmCustImportData = this.checkAndHandleImportData(parseData);
//        //数据处理(如果是数据重复然后修改(需要确定字段))
//        if (!CollectionUtils.isEmpty(crmCustImportData.getData())) {
//            List<CrmCustDO> crmCustDOS = crmCustImportData.getData().stream().map(INSTANCE::importVoToDo).collect(Collectors.toList());
//            List<String> custCodes = crmCustDOS.stream().map(CrmCustDO::getCustCode).collect(Collectors.toList());
//            CrmCustQueryParamVO crmCustQueryParamVO = new CrmCustQueryParamVO();
//            crmCustQueryParamVO.setCustCodes(custCodes);
//            crmCustQueryParamVO.setTransFlag(false);
//            List<CrmCustPageRespVO> crmCustPageRespVOS = this.searchList(crmCustQueryParamVO);
//            crmCustDOS.forEach(cust -> {
//                //数据处理如果导入数据有相同的进行修改
//                crmCustPageRespVOS.stream().filter(cust1 -> cust1.getCustCode().equals(cust.getCustCode())).findFirst()
//                        .ifPresent(crm -> cust.setId(crm.getId()));
//                cust.setCustStatus(UdcEnum.CRM_CUST_STATUS_ACTIVE.getValueCode());
//                cust.setFinancialGroup(cust.getFinancialAttribute() + "-" + cust.getFinancialAttribute2() + "-" + cust.getFinancialAttribute3() + "-" + cust.getFinancialAttribute4());
////                cust.setIntfStatus("N");
//                cust.setCreatedBy(0);
//                cust.setSecOuId(cust.getOuId());
//                cust.setSecBuId(cust.getBuId());
//                cust.setSecUserId(cust.getAgentEmpId());
//            });
//            List<CrmCustDO> crmCustDOList = crmCustRepo.saveAll(crmCustDOS);
//            crmCustDOList.forEach(cust -> {
//                //导入的地址信息
//            });
//            return ApiResult.ok(crmCustImportData.getData());
//        }
        return ApiResult.fail();
    }


    /**
     * 客户地址导入
     **/
    @Override
    @Transactional(rollbackFor = Exception.class)
    public ApiResult<List<CrmAddrImplSaveVO>> custaddrImportData(List<CrmAddrImplSaveVO> parseData) {
        CrmCustConvert crmCustConvert = INSTANCE;
        //数据校验
        ApiResult<List<CrmAddrImplSaveVO>> crmCustImportData = this.checkAndHandleAddrImportData(parseData);
        List<CrmAddrImplSaveVO> custImportDataData = crmCustImportData.getData();
        //通过客户编码去查客户
        List<String> custCodes = custImportDataData.stream().map(CrmAddrImplSaveVO::getCustCode).distinct().collect(Collectors.toList());
        CrmCustQueryParamVO crmCustQueryParamVO = new CrmCustQueryParamVO();
        crmCustQueryParamVO.setCustCodes(custCodes);
        crmCustQueryParamVO.setTransFlag(false);
        List<CrmCustSaveVO> crmCustSaveVOS = this.searching1(crmCustQueryParamVO).stream().map(INSTANCE::doToSaveVO).collect(Collectors.toList());
        //根据客户的编码进行分组处理
        Map<String, List<CrmAddrImplSaveVO>> importListMap = parseData.stream().collect(Collectors.groupingBy(CrmAddrImplSaveVO::getCustCode));
        List<CrmCustDO> crmCustDOS = new ArrayList<>();
        for (String key : importListMap.keySet()) {
            CrmCustSaveVO crmCustSaveVO = crmCustSaveVOS.stream().filter(resp -> resp.getCustCode().equals(key))
                    .findFirst()
                    .orElseThrow(new BusinessException("客户编码为【" + key + "】的数据不存在,请检查"));
            //如果客户地址号存在
            OrgAddrRpcSaveParam param = new OrgAddrRpcSaveParam();
            param.setId(null);
            param.setAddrNo(crmCustSaveVO.getAddrNo());
            param.setAddrName(crmCustSaveVO.getCustName());
            param.setAddrType(UdcEnum.ORG_ADDR_TYPE_CUST.getValueCode());
            List<OrgAddrAddressRpcSaveParam> orgAddrAddressRpcSaveParams = new ArrayList<>();
            for (CrmAddrImplSaveVO crmAddrImplSaveVO : importListMap.get(key)) {
                OrgAddrAddressRpcSaveParam orgAddrAddressRpcSaveParam = INSTANCE.addrImportVoToDo(crmAddrImplSaveVO);
                orgAddrAddressRpcSaveParams.add(orgAddrAddressRpcSaveParam);
            }
            param.setOrgAddrAddressSaveParams(orgAddrAddressRpcSaveParams);

            ApiResult<Long> addrNo = rmiOrgAddrService.orgAddrSaveOrUpdate(param);
            Assert.isFalse(!addrNo.isSuccess(), addrNo.getMsg());
            crmCustSaveVO.setAddrNo(addrNo.getData());
            CrmCustDO crmCustDO = new CrmCustDO();
            crmCustConvert.copyVoToDo(crmCustSaveVO, crmCustDO);
            crmCustDOS.add(crmCustDO);
        }
        crmCustRepo.saveAll(crmCustDOS);
        return ApiResult.ok(parseData);
    }

    /**
     * 分配业务员
     * 这里直接使用sql语句修改
     **/
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void empAssign(CrmEmpAssignParamVO crmEmpAssignParamVO) {
        Assert.notNull(crmEmpAssignParamVO, "更新信息为空");
        crmCustRepo.updateCustAgentEmp(crmEmpAssignParamVO.getAgentEmpId(), crmEmpAssignParamVO.getCustIds());
    }

    /**
     * 通过查询条件查询客户地址信息
     *
     * @param crmCustAddrParamVO crmCustAddrParamVO
     * @return 客户地址集合
     */
    @Override
    public List<CrmCustAddrRespVO> findAddrsByParam(CrmCustAddrParamVO crmCustAddrParamVO) {
        if (StringUtils.isEmpty(crmCustAddrParamVO.getAddrNo())) {
            return new ArrayList<>();
        }
        List<OrgAddrAddressRpcDTO> orgAddrAddressRpcDTOS = new ArrayList<>();
        ApiResult<OrgAddrDetailsRpcDTO> addrByAddrNo = rmiOrgAddrService.findAddrByAddrNo(crmCustAddrParamVO.getAddrNo());
        if (addrByAddrNo.isSuccess() && !ObjectUtils.isEmpty(addrByAddrNo.getData())) {
            orgAddrAddressRpcDTOS = addrByAddrNo.getData().getOrgAddrAddressVos();
        }
        List<CrmCustAddrRespVO> custAddrRespVOS = new ArrayList<>();
        if (!CollectionUtils.isEmpty(orgAddrAddressRpcDTOS)) {
            custAddrRespVOS = orgAddrAddressRpcDTOS.stream().map(INSTANCE::addrRpcToAddrVo).collect(Collectors.toList());
        }
        if (!StringUtils.isEmpty(crmCustAddrParamVO.getContPerson())) {
            custAddrRespVOS = custAddrRespVOS.stream().filter(cust -> cust.getContPerson().contains(crmCustAddrParamVO.getContPerson())).collect(Collectors.toList());
        }
        return custAddrRespVOS;
    }


    @Override
    @Transactional(rollbackFor = Exception.class)
    public ApiResult<CrmCustDetailRespVO> saveLm(CrmCustSaveVO saveVO) {
        /* 客户数据保存
         * 流程一: 数据校验:
         *   1.必填校验: 客户名称、销售组织、公司、区域、客户管理专员、客户分类
         *   2.字段重复校验: 客户名称(1.新增的时候检查客户名称是否存在 2.修改的时候如果是当前客户修改信息则通过,其他用户修改同名称报错)
         */
        String firstCustCode = saveVO.getCustCode();
        if (StringUtils.isEmpty(saveVO.getCustCode())) {
            if(StringUtil.isNotBlank(saveVO.getContactPhone())){
                //查询账号是否存在
                Boolean isExistsUserName = this.isExistsMobile(saveVO.getContactPhone(),saveVO.getBusinessTypeCust());
                if(isExistsUserName){
                    return ApiResult.fail("手机号已存在请修改手机号");
                }
            }
            //因为生成客户编码调不通，所以临时随机生成
            String custCode = rmiSysNextNumberService.generateCode("yst-sale","C", new ArrayList<>());
            saveVO.setCustCode(custCode);
//            saveVO.setCustCode(getRandom());
        }else {
            //处理上一个业务员id
            Long agentEmpId2 = this.excuteAgentEmpId2(saveVO.getAgentEmpId(),saveVO.getCustCode());
            if(null != agentEmpId2){
                saveVO.setAgentEmpId2(agentEmpId2);
            }
        }


        checkForSave(saveVO);
        /*
         * 流程二: 地址簿信息存储:(原因:保存成功需要把地址号存在客户主表,故优于主表存储)
         *   1. 针对于修改操作(通过地址号)
         *   2. 批量处理地址簿信息(包括客户信息列表、身份信息(含附件)) 附件 本地建中间表存关联关系
         */
        List<ComSaleFileComVO> comSaleFileComVOS = new ArrayList<>();
        OrgAddrRpcSaveParam param = this.addrHandle(saveVO, comSaleFileComVOS);
        /*
         * 流程三:数据保存
         *   1.地址簿信息保存,这里先转换为DO
         *   2.地址簿信息保存,会返回adderNo地址号(需要保存到客户主表)
         *   3.获取客户主表id存在在附件关系表
         */
//        if (StringUtils.isEmpty(saveVO.getCreatedBy())) {
//            saveVO.setCreatedBy(0);
//        }
//        saveVO.setIntfStatus("N");
        // 添加权限字段配置
        saveVO.setSecBuId(saveVO.getBuId());
        saveVO.setSecOuId(saveVO.getOuId());
        //     saveVO.setSecUserId(saveVO.getAgentEmpId());
        CrmCustDO crmCustDO = saveVoDo(saveVO);

        ApiResult<Long> addrNo1 = rmiOrgAddrService.orgAddrSaveOrUpdateReturnAddrNo(param);
        Assert.isFalse(!addrNo1.isSuccess(), addrNo1.getMsg());
        Long addrNo = addrNo1.getData();
        crmCustDO.setAddrNo(addrNo);
        saveVO.setAddrNo(addrNo);

        //生成账号信息
//        if(StringUtil.isBlank(saveVO.getCustCode())){
//            //新增  直接调用创建账号功能
//
//        }else {
//            //修改账号信息，判断业务员是否更改  查询老的客户信息
//
//        }

        CrmCustDO custDO = crmCustRepo.save(crmCustDO);
        comSaleFileComVOS.forEach(k -> k.setBusinessId(custDO.getId()));
        comSaleFileInfoService.comSaleFileHardSave("CUST", custDO.getId(), comSaleFileComVOS);

        return ApiResult.ok(INSTANCE.doToDetailRespVO(custDO));
    }

    @Override
    public List<LmSaveCustRespVO> getCustInfoByRegion(List<String> region) {
        return crmCustRepoProc.getCustInfoByRegion(region);

    }

    public Boolean isExistsUserName(String userName){
        QCustAccountDO qCustAccountDO = QCustAccountDO.custAccountDO;
        BooleanExpression e = qCustAccountDO.userName.eq(userName).and(qCustAccountDO.deleteFlag.eq(0));
        Long count = custAccountRepo.count(e);
        if(count == 0L){
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    public Boolean isExistsMobile(String mobile,String businessTypeCust){
        QCustAccountDO qCustAccountDO = QCustAccountDO.custAccountDO;
        BooleanExpression e = qCustAccountDO.mobile.eq(mobile).and(qCustAccountDO.deleteFlag.eq(0)).and(qCustAccountDO.dealerType.in("ONE","TWO"))
                .and(qCustAccountDO.businessTypeCust.eq(businessTypeCust))
                ;
        Long count = custAccountRepo.count(e);
        if(count == 0L){
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }


    public Long excuteAgentEmpId2(Long agentEmpId,String custCode){
        //查询客户信息
        if(null != agentEmpId){
            Long oldAgentEmpId = crmCustRepoProc.getAgentEmpId(custCode);
            if(null != oldAgentEmpId && !agentEmpId.equals(oldAgentEmpId)){
                return oldAgentEmpId;
            }
        }
        return null;
    }

//    public void saveCustAccountLm(String custCode,String userName,){
//        CrmCustAccountParam
//    }


    @Override
    public void custMdmSync(Long id) {

    }

//    @Override
//    public void custMdmSync(Long id) {
//        //请求头
//        HttpHeaders headers = new HttpHeaders();
//        RestTemplate restTemplate = new RestTemplate();
//        headers.add("Accept", "application/json");
//        headers.add("Content-Type", "application/json;charset=UTF-8");
//        if (IF_PRODUCTION.equals("true")) {
////            restTemplate.getInterceptors().add(new BasicAuthenticationInterceptor(USERNAME_SOA,PASSWORD_SOA));
//            headers.add("authorization",
//                    "Basic " +
//                            Base64.encode((USERNAME_SOA + ":" + PASSWORD_SOA).getBytes()));
//        }
//        this.custCheckAndSynchron2(headers, id, null);
//    }

    @Override
    public Boolean findCustByCode(String custCode) {
        return crmCustRepoProc.existsCode(custCode, null);
    }

    @Override
    public List<CrmCustAddrRespVO> findAddrsByCustCode(String custCode) {
        Long addrNo = crmCustRepoProc.getaddrNoByCode(custCode);
        CrmCustAddrParamVO crmCustAddrParamVO = new CrmCustAddrParamVO();
        crmCustAddrParamVO.setAddrNo(addrNo);
        return this.findAddrsByParam(crmCustAddrParamVO);
    }

    @Override
    public PagingVO<CrmCustSimpleVO> checkQuery(CrmCustCheckParamVO paramVO) {

        Predicate predicate = qCrmCustDO.isNotNull();
        predicate = appendCommon(predicate);

        // erp编码为空
//        predicate = ExpressionUtils.and(predicate, qCrmCustDO.custCode2.isNull());

        if (null != paramVO.getOuId()) {
            predicate = ExpressionUtils.and(predicate, qCrmCustDO.ouId.eq(paramVO.getOuId()));
        }

        Page<CrmCustDO> res = crmCustRepo.findAll(predicate, wrapperPageRequest(paramVO.getPageRequest(), null));
        Long total = res.getTotalElements();
        List<CrmCustDO> crmCustDOList = res.getContent();

        CrmCustConvert crmCustConvert = INSTANCE;

        List<CrmCustSimpleVO> respVOList = crmCustDOList.stream().map(t -> {
            CrmCustSimpleVO respVO = crmCustConvert.do2SimpleVo(t);
            return respVO;
        }).collect(Collectors.toList());

        return new PagingVO<>(total, respVOList);
    }

//    @Override
//    public String getMdmCustCode(String taxRegNo) {
//        return null;
//    }

    @Override
    public RmiOuInfoByAddr getOuByAddr(Long addrNo) {
        Assert.notNull(addrNo,"地址号不能为空！");

        ApiResult<OrgAddrDetailsRpcDTO> result = rmiOrgAddrService.findAddrByAddrNo(addrNo);
        OrgAddrDetailsRpcDTO data = result.getData();
        RmiOuInfoByAddr addr = new RmiOuInfoByAddr();
        if (data==null){
            return addr;
        }

        List<OrgAddrAddressRpcDTO> orgAddrAddressVos = data.getOrgAddrAddressVos();
        List<OrgAddrBankAccRpcDTO> orgAddrBankAccVos = data.getOrgAddrBankAccVos();
        List<OrgAddrQualifyRpcDTO> orgAddrQualifyVos = data.getOrgAddrQualifyVos();

        RmiOuInfoByAddrConvert convert = RmiOuInfoByAddrConvert.INSTANCE;

        if (!CollUtil.isEmpty(orgAddrAddressVos)){
            addr.setOrgAddrAddressVos(convert.addrDTO2VOS(orgAddrAddressVos));
        }
        if (!CollUtil.isEmpty(orgAddrBankAccVos)){
            addr.setOrgAddrBankAccVos(convert.bankDTO2VOS(orgAddrBankAccVos));
        }
        if (!CollUtil.isEmpty(orgAddrQualifyVos)){
            addr.setOrgAddrQualifyVos(convert.qualifyDTO2VOS(orgAddrQualifyVos));
        }

        return addr;
    }

    @Override
    public RmiOuDetailVO getOuByCode(String ouCode) {
        Assert.notNull(ouCode,"公司编码不能为空！");
        OrgOuRpcDtoParam param = new OrgOuRpcDtoParam();
        param.setOuCodes(Collections.singletonList(ouCode));
        List<OrgOuRpcDTO> ouDtoListByParam = rmiOrgOuService.findOuDtoListByParam(param);

        if (ouDtoListByParam==null || ouDtoListByParam.size()==0){
            return null;
        }

        OrgOuRpcDTO ouRpcDTO = ouDtoListByParam.get(0);
        RmiOuInfoByAddrConvert convert = RmiOuInfoByAddrConvert.INSTANCE;

        return convert.ouDTO2VO(ouRpcDTO);
    }

    @Override
    public Object updateContactPhone(CrmCustFixPhoneParamVO crmCustFixPhoneParamVO) {
        QBipCustUserBindDO qBipCustUserBindDO = QBipCustUserBindDO.bipCustUserBindDO;
        BooleanExpression expression = qBipCustUserBindDO.userId.eq(crmCustFixPhoneParamVO.getUserId()).and(qBipCustUserBindDO.deleteFlag.eq(0));
        Optional<BipCustUserBindDO> optional = bipCustUserBindRepo.findOne(expression);
        if(!optional.isEmpty()){
            BipCustUserBindDO bind = optional.get();
            Long custId = bind.getCustId();
            if(!StringUtils.isEmpty(custId)){
                Optional<CrmCustDO> crmCust = crmCustRepo.findById(custId);
                if(!crmCust.isEmpty()){
                    CrmCustDO crmCustDO = crmCust.get();
                    crmCustDO.setContactPhone(crmCustFixPhoneParamVO.getNewMobile());
                    crmCustRepo.save(crmCustDO);
                }
            }
        }
        return null;
    }

    @Override
    public SevenCustVo select(SevenCustDto custDto, String token, String tokenId) {
        //token校验
        /*byte[] bytes = tokenId.getBytes();
        boolean flag = JWTUtil.verify(token, bytes);//key是密钥*/
        if (custDto == null && token == null && tokenId == null){
            return null;
        }
        SevenCustVo sevenCustVo = new SevenCustVo();
        //1.查询公司
        OrgOuRpcDtoParam orgOuRpcDtoParam = new OrgOuRpcDtoParam();
        orgOuRpcDtoParam.setOuIds(Collections.singletonList(custDto.getOuId()));
        List<OrgOuRpcDTO> ouDtoListByParam = rmiOrgOuService.findOuDtoListByParam(orgOuRpcDtoParam);

        if (ouDtoListByParam==null || ouDtoListByParam.size()==0){
            return null;
        }
        for (OrgOuRpcDTO dto : ouDtoListByParam){
            sevenCustVo.setOuName(dto.getOuName());
        }
        //2.查询客户
        //通过客户编码去查客户
        CrmCustQueryParamVO crmCustQueryParamVO = new CrmCustQueryParamVO();
        crmCustQueryParamVO.setCustCodes(Collections.singletonList(custDto.getCustCode()));
        crmCustQueryParamVO.setTransFlag(false);
        List<CrmCustSaveVO> crmCustSaveVOS = this.searching1(crmCustQueryParamVO).stream().map(INSTANCE::doToSaveVO).collect(Collectors.toList());
        for (CrmCustSaveVO custSaveVO : crmCustSaveVOS){
            sevenCustVo.setCustName(custSaveVO.getCustName());
            sevenCustVo.setTaxRegNo(custSaveVO.getTaxRegNo());
            sevenCustVo.setCustType(custSaveVO.getCustType());
            sevenCustVo.setContactName(custSaveVO.getContactName());
            sevenCustVo.setContactPhone(custSaveVO.getContactPhone());
        }
        return sevenCustVo;
    }

    @Override
    public List<CrmCustAddrRespVO> queryCustAddr() {
        Long addrNo = this.getAddrNo();
        ApiResult<OrgAddrDetailsRpcDTO> rpcDtoByAddrNo;
        rpcDtoByAddrNo = rmiOrgAddrService.findAddrByAddrNo(addrNo);
        Assert.isFalse(!rpcDtoByAddrNo.isSuccess(), rpcDtoByAddrNo.getMsg());
        OrgAddrDetailsRpcDTO orgAddr = rpcDtoByAddrNo.getData();
        if (!ObjectUtils.isEmpty(orgAddr) && !CollectionUtils.isEmpty(orgAddr.getOrgAddrAddressVos())) {
            CrmCustConvert crmCustConvert = INSTANCE;
            //地址信息补充
            List<CrmCustAddrRespVO> crmCustAddrRespVOS = orgAddr.getOrgAddrAddressVos().stream().map(addr -> {
                CrmCustAddrRespVO crmCustAddrRespVO = crmCustConvert.addrRpcToAddrVo(addr);
                crmCustAddrRespVO.setContEmail(addr.getEmail());
                crmCustAddrRespVO.setContFax(addr.getFax());
                crmCustAddrRespVO.setContMobile(addr.getMobile());
                crmCustAddrRespVO.setContTel(addr.getTel());
                crmCustAddrRespVO.setDetailaddr(addr.getDetailAddr());
                //     crmCustAddrRespVO.setDetailAddr(addr.getDetailAddr());
                return crmCustAddrRespVO;
            }).collect(Collectors.toList());
            return crmCustAddrRespVOS;
        }
        return new ArrayList<>();
    }

    public Long getAddrNo(){
        //获取当前用户  通过当前用户账号查询客户信息 取出来地址号
        GeneralUserDetails userDetails = SecurityContextUtil.currentUser();
        if(Objects.isNull(userDetails) || Objects.isNull(userDetails.getUser())){
            throw new BusinessException("获取当前用户信息失败");
        }
        SysUserDTO sysUser = userDetails.getUser();
        String userName = sysUser.getUsername();
        //查询客户编号  通过客户编号查询地址号  通过地址号查询地址信息
        CustAccountVO custAccount = custAccountRepoproc.getAccountByUserName(userName);
        Long addrNo = crmCustRepoProc.getAddrNo(custAccount.getCustCode());
        return addrNo;
    }


    @Override
    public Long saveCustAddr(OrgAddrAddressSaveParam param) {
        GeneralUserDetails userDetails = SecurityContextUtil.currentUser();
        //SysUserDTO sysUser = rmiSysUserService.currentUser();
        if(Objects.isNull(userDetails) || Objects.isNull(userDetails.getUser())){
            throw new BusinessException("获取当前用户信息失败");
        }
        SysUserDTO sysUser = userDetails.getUser();
        if(Objects.isNull(sysUser)){
            throw new BusinessException("获取当前用户信息失败");
        }
        String userName = sysUser.getUsername();
        //查询客户编号  通过客户编号查询地址号  通过地址号查询地址信息
        CustAccountVO custAccount = custAccountRepoproc.getAccountByUserName(userName);
        Long addrNo = crmCustRepoProc.getAddrNo(custAccount.getCustCode());
        OrgAddrAddressRpcSaveParam rpcSave = new OrgAddrAddressRpcSaveParam();
        BeanUtils.copyProperties(param,rpcSave);
        rpcSave.setDetailAddr(param.getDetailaddr());
        rpcSave.setAddrNo(addrNo);
        rpcSave.setDataSource("CUST");
        rpcSave.setMobile(param.getContMobile());
        ApiResult<Long> addrId = rmiOrgAddrService.orgAddrAddressSaveOrUpdate(rpcSave);
        if(addrId.isSuccess()){
            return addrId.getData();
        }
        throw new BusinessException("修改/新增地址信息失败");
    }

    @Override
    public void delCustAddr(Long id) {
        rmiOrgAddrService.orgAddrAddressDelete(id);
    }

    @Override
    public CrmCustDetailRespVO getByUserName(String userName) {
        if(StringUtil.isBlank(userName)){
            throw new BusinessException("用户名为空");
        }
        CustAccountDO custAccountDO = custAccountRepoproc.getByUserName(userName);
        if (custAccountDO == null || StringUtil.isBlank(custAccountDO.getCustCode())) {
            return null;
        }
        //流程一: 数据查询
        CrmCustDO crmCustDO = crmCustRepoProc.getCustInfoByCode(custAccountDO.getCustCode());
        if (crmCustDO == null) {
            return null;
//            throw new BusinessException("该客户信息不存在");
        }
        CrmCustDetailRespVO respVO = INSTANCE.doToDetailRespVO(crmCustDO);
        //流程二: 数据补充
        this.translateDetail(respVO);
        return respVO;
    }

    @Override
    public CrmCustDetailRespVO getByUserId(Long userId) {
        if(ObjectUtils.isEmpty(userId)){
            throw new BusinessException("用户名为空");
        }
        CustAccountDO custAccountDO = custAccountRepoproc.getByUserId(userId);
        if (custAccountDO == null || StringUtil.isBlank(custAccountDO.getCustCode())) {
            return null;
        }
        //流程一: 数据查询
        CrmCustDO crmCustDO = crmCustRepoProc.getCustInfoByCode(custAccountDO.getCustCode());
        if (crmCustDO == null) {
            return null;
//            throw new BusinessException("该客户信息不存在");
        }
        CrmCustDetailRespVO respVO = INSTANCE.doToDetailRespVO(crmCustDO);
        //流程二: 数据补充
        this.translateDetail(respVO);
        return respVO;
    }

    @Override
    public String getRegionByCustCode(String custCode) {
        return crmCustRepoProc.getCustRegion(custCode);
    }

    @Override
    public String getcustStatusByCode(String custCode) {
        return crmCustRepoProc.getCustStatusByCode(custCode);
    }

    @Override
    public LmSaveCustRespVO getCustInfoByCustCode(String custCode) {
        return crmCustRepoProc.getCustInfoByCustCode(custCode);
    }

    @Override
    public List<LmSaveCustRespVO> getCustInfoByPid(String custCode) {
        return crmCustRepoProc.getCustInfoByPid(custCode);
    }

    @Override
    public List<LmSaveCustRespVO> getCustInfoByCustCodes(List<String> custCode) {
        return crmCustRepoProc.getCustInfoByCustCodes(custCode);
    }

    @Override
    public List<LmSaveCustRespVO> getCustInfoByCustCode2s(List<String> custCode2s) {
        return crmCustRepoProc.getCustInfoByCustCode2s(custCode2s);
    }

    @Override
    public List<LmSaveCustRespVO> getCustSimpleByParam(CrmCustSimpleParam param) {
        return crmCustRepoProc.getCustInfoByCustCodes(param);
    }

    @Override
    public PagingVO<CrmCustBasePageVO> getCustBasePage(CrmCustBaseParamVO crmCustBaseParamVO) {
        PagingVO<CrmCustBasePageVO> page = crmCustRepoProc.getCustBasePage(crmCustBaseParamVO);
        //业务员信息
        if(!page.isEmpty() && !ObjectUtils.isEmpty(page.getRecords()) && !CollectionUtils.isEmpty(page.getRecords())){
            Map<String, String> regionMap = udcProvider.getValueMapByUdcCode("yst-supp", "REGION");
            Map<String, String> custTypeUdc = rmiSysUserRpcService.sysUdcGetCodeMap("yst-sale", "CUST_TYPE");

            List<Long> agentEmpIds = page.getRecords().stream().filter(a -> !ObjectUtils.isEmpty(a.getAgentEmpId())).map(CrmCustBasePageVO :: getAgentEmpId).collect(Collectors.toList());
            List<SalesmanInfoDO> salesmanInfos = salesmanInfoRepo.findAllById(agentEmpIds);
            Map<Long,SalesmanInfoDO> salesmanMap = new HashMap<>();
            Map<String,SysEmployeeDetailDTO> empMap = new HashMap<>();
            if(!CollectionUtils.isEmpty(salesmanInfos)){
                salesmanMap = salesmanInfos.stream().collect(Collectors.toMap(SalesmanInfoDO :: getId,t->t,(t1,t2) ->t1));
                List<String> empCodes = salesmanInfos.stream().filter(a -> StringUtil.isNotBlank(a.getSalesmanNo())).map(SalesmanInfoDO :: getSalesmanNo).collect(Collectors.toList());
                Set<String> set = new HashSet<>(empCodes);
                ApiResult<List<SysEmployeeDetailDTO>> apiResult = employeeRpcService.getDetailListByCode(set);
                if(apiResult.isSuccess() && !ObjectUtils.isEmpty(apiResult.getData()) && !CollectionUtils.isEmpty(apiResult.getData())){
                    empMap = apiResult.getData().stream().collect(Collectors.toMap(SysEmployeeDetailDTO :: getCode, t->t , (t1,t2) -> t1));
                }
            }
            Map<Long, SalesmanInfoDO> finalSalesmanMap = salesmanMap;
            Map<String, SysEmployeeDetailDTO> finalEmpMap = empMap;
            List<Long> addrNos = page.getRecords().stream().filter(a -> !ObjectUtils.isEmpty(a.getAddrNo())).map(CrmCustBasePageVO :: getAddrNo).collect(Collectors.toList());
            //查询地址信息
            Map<Long,List<OrgAddressRpcDTO>> addrsMap = this.getAddrs(addrNos);
            page.getRecords().forEach(p ->{
                if(MapUtils.isNotEmpty(regionMap) && StringUtil.isNotBlank(p.getRegion())){
                    p.setRegionName(regionMap.get(p.getRegion()));
                }
                if(MapUtils.isNotEmpty(custTypeUdc) && StringUtil.isNotBlank(p.getCustType())){
                    p.setCustTypeName(custTypeUdc.get(p.getCustType()));
                }
                if(!ObjectUtils.isEmpty(p.getCancelCustFlag())){
                    p.setCancelCustFlagName(p.getCancelCustFlag()?"是":"否");
                }
                //补全业务员
                if(!ObjectUtils.isEmpty(p.getAgentEmpId()) && MapUtils.isNotEmpty(finalSalesmanMap) && !ObjectUtils.isEmpty(finalSalesmanMap.get(p.getAgentEmpId()))){
                    SalesmanInfoDO salesmanInfo = finalSalesmanMap.get(p.getAgentEmpId());
                    if(!ObjectUtils.isEmpty(salesmanInfo.getSalesmanNo()) && MapUtils.isNotEmpty(finalEmpMap) && !ObjectUtils.isEmpty(finalEmpMap.get(salesmanInfo.getSalesmanNo()))){
                        SysEmployeeDetailDTO emp = finalEmpMap.get(salesmanInfo.getSalesmanNo());
                        p.setAgentEmpCode(emp.getCode());
                        p.setAgentEmpName(emp.getFullName());
                    }
                }
                if(!ObjectUtils.isEmpty(p.getAddrNo()) && MapUtils.isNotEmpty(addrsMap) && !CollectionUtils.isEmpty(addrsMap.get(p.getAddrNo()))){
                    List<OrgAddressRpcDTO> addrs = addrsMap.get(p.getAddrNo());
                    OrgAddressRpcDTO addr = this.getDefaultOrgAddr(addrs);
                    if(!ObjectUtils.isEmpty(addr)){
                        p.setProvince(addr.getProvince());
                        p.setProvinceName(addr.getProvinceName());
                        p.setCity(addr.getCity());
                        p.setCityName(addr.getCityName());
                        p.setCounty(addr.getCounty());
                        p.setCountyName(addr.getCountyName());
                        p.setDetailAddr(addr.getDetailAddr());
                    }
                }
            });
        }
        return page;
    }

    @Override
    public ApiResult<Object> syncSyncToOu(List<Long> ids) {
        List<String> custTypes = Lists.newArrayList("ONE", "TWO");
        //新增需求 如果是二网经销商的话需要生成对应的一网经销商公司 所以要把需要处理的数据全部查出来
//        List<CrmCustPageLmVO> list = lmCrmCustRepoProc.getByCustId(ids);
//        if(CollectionUtils.isEmpty(list)){
//            return ApiResult.fail("没有可以生成公司的数据");
//        }
//        List<Long> custIds = list.stream().map(CrmCustPageLmVO :: getId).collect(Collectors.toList());
//        list.forEach(l ->{
//            if(l.getCustType().equals("TWO") && StringUtils.isNotBlank(l.getPid())){
//                //上级PID对应的经销商
//                CrmCustPageLmVO custByCode = lmCrmCustRepoProc.getCustByCode(l.getPid());
//                custIds.add(custByCode.getId());
//            }
//        });

        CompletableFuture<Void> future1 = CompletableFuture.supplyAsync(() -> {
            ids.forEach(i -> {
                CrmCustDetailRespVO respVO = this.getCustDetail(i);
                //   if (StringUtils.isNotBlank(respVO.getCustCode()) && (ObjectUtils.isEmpty(respVO.getIsCreateOu()) || !respVO.getIsCreateOu().equals(1))) {
                if (org.apache.commons.lang3.StringUtils.isNotBlank(respVO.getCustCode())) {
                    //查询custCode对应的公司是否存在 如果存在给个错误提示
                    OrgOuRpcDtoParam orgOuRpcDtoParam = new OrgOuRpcDtoParam();
                    orgOuRpcDtoParam.setOuCodes(Collections.singletonList(respVO.getCustCode()));
                    List<OrgOuRpcDTO> ouDtoByParam = orgOuRpcService.findOuDtoByParam(orgOuRpcDtoParam);
                    if (!CollectionUtils.isEmpty(ouDtoByParam)) {
                        this.updateIsCreateOu(respVO.getCustCode(), 0, "客户对应的公司的客户编码已存在！");
                        return;
                    }
                    if ("TWO".equals(respVO.getCustType())) {
//                        二网经销商 、向立马订货为是：使用归属公司作为上级；
//                        二网经销商 、向立马订货为否：使用父项客户号作为上级；
//                        二网经销商 、向立马订货为是：使用归属公司作为上级； 所属公司为空
//                        二网经销商 、向立马订货为否：使用父项客户号作为上级； 绑定一网经销商就行吧
                        String orderSignx = respVO.getOrderSignx();
                        String pid = respVO.getPid();
                        // "1"向立马订货 “0”：否
                        if (org.apache.commons.lang3.StringUtils.isNotBlank(orderSignx) && "0".equals(orderSignx)) {
                            if (!org.apache.commons.lang3.StringUtils.isBlank(pid)) {
                                CustCorOuResVO corOu = crmCustRepoProc.getCustCorOu(pid);
                                if (ObjectUtils.isEmpty(corOu) || org.apache.commons.lang3.StringUtils.isBlank(corOu.getCorOu())) {
                                    this.updateIsCreateOu(respVO.getCustCode(), 0, "上级对应公司为空");
                                }
                                // 查询公司
                                List<OrgOuRpcDTO> ouList = this.getOuInfo(null, Collections.singletonList(corOu.getCorOu()));
                                if (CollectionUtils.isEmpty(ouList)) {
                                    this.updateIsCreateOu(respVO.getCustCode(), 0, "查询公司为空，编码为：" + corOu.getCorOu());
                                }
                                OrgOuRpcDTO ou = ouList.get(0);
                                OrgOuRpcSaveParam ouParam = this.excuteSaveOuParam(respVO, ou);
                                String ouId = orgOuRpcService.createOu(ouParam);
                                this.updateIsCreateOu(ouParam.getOuCode(), 1, "同步成功");
                            } else {
                                this.updateIsCreateOu(respVO.getCustCode(), 0, "二网经销商对应上级经销商不存在");
                            }
                        } else if ("1".equals(orderSignx)) {
                            excuteCreateOu(respVO, custTypes);
                        }
                    } else {
                        excuteCreateOu(respVO, custTypes);
                    }
                }
            });
            return null;
        }, taskExecutor);
        return ApiResult.ok();
    }

    public void excuteCreateOu(CrmCustDetailRespVO respVO, List<String> custTypes) {
        List<CustBelongOuVO> belongOus = custBelongOuService.getByCustCode(respVO.getCustCode());
        if (!CollectionUtils.isEmpty(belongOus)) {
            respVO.setBelongOus(belongOus);
            if (!ObjectUtils.isEmpty(respVO) && !org.apache.commons.lang3.StringUtils.isEmpty(respVO.getCustType()) && custTypes.contains(respVO.getCustType())) {
                List<Long> ouIds = belongOus.stream().map(CustBelongOuVO::getOuId).collect(Collectors.toList());
                List<OrgOuRpcDTO> ouList = this.getOuInfo(ouIds, null);
                OrgOuRpcDTO ou = this.filterOuType(ouList);
                log.info("客户生成公司查询所属公司的ou信息----" + JSON.toJSONString(ou));
                if (!ObjectUtils.isEmpty(ou) && !ObjectUtils.isEmpty(ou.getBuId())) {
                    //归属公司里面是否有贸易公司
                    OrgOuRpcSaveParam ouParam = this.excuteSaveOuParam(respVO, ou);
                    try {
                        String ouId = orgOuRpcService.createOu(ouParam);
                        if (org.apache.commons.lang3.StringUtils.isBlank(ouId)) {
                            this.updateIsCreateOu(respVO.getCustCode(), 0, "调用基础域创建公司失败");
                        }
                        this.updateIsCreateOu(ouParam.getOuCode(), 1, "同步成功");
                    } catch (Exception e) {
                        this.updateIsCreateOu(respVO.getCustCode(), 0, "调用基础域创建公司失败");
                    }
                } else {
                    this.updateIsCreateOu(respVO.getCustCode(), 0, "归属公司所属组织为空");
                }
            } else {
                this.updateIsCreateOu(respVO.getCustCode(), 0, "客户类型为一网、二网经销商才能生成公司");
            }
        } else {
            this.updateIsCreateOu(respVO.getCustCode(), 0, "所属公司为空");
        }
    }


    public OrgOuRpcSaveParam excuteSaveOuParam(CrmCustDetailRespVO respVO, OrgOuRpcDTO ou) {
        OrgOuRpcSaveParam ouParam = new OrgOuRpcSaveParam();
        ouParam.setOuCode(respVO.getCustCode());
        ouParam.setOuName(respVO.getCustName());
        ouParam.setOuType2("OUTER");
        if (respVO.getCustType().equals("ONE")) {
            //一网
            ouParam.setOuType("1-NET");
        } else {
            ouParam.setOuType("2-NET");
        }
        if (!org.apache.commons.lang3.StringUtils.isEmpty(respVO.getCertNo())) {
            ouParam.setIcRegisterNo(respVO.getCertNo());
        } else {
            ouParam.setIcRegisterNo(respVO.getCustCode());
        }
        ouParam.setAddrNo(respVO.getAddrNo());
        ouParam.setPid(ou.getBuId());
        ouParam.setOuStatus("ACTIVE");
        ouParam.setInvType(respVO.getInvType());
        ouParam.setInvAddress(respVO.getInvAddress());
        ouParam.setInvBankAcc(respVO.getInvBankAcc());
        ouParam.setInvBankName(respVO.getInvBankName());
        ouParam.setInvTel(respVO.getInvTel());
        ouParam.setInvPicPhone(respVO.getInvPicPhone());
        ouParam.setInvPicName(respVO.getInvPicName());
        ouParam.setOuCurr("CNY");
        ouParam.setSelectedCreateOu(Boolean.TRUE);
        return ouParam;
    }

    public OrgOuRpcDTO filterOuType(List<OrgOuRpcDTO> list) {
        if (!CollectionUtils.isEmpty(list)) {
            List<OrgOuRpcDTO> ous = list.stream().filter(l -> l.getOuType().equals("TRADE") || l.getOuType().equals("TRADE_A")).collect(Collectors.toList());
            if (!CollectionUtils.isEmpty(ous)) {
                return ous.get(0);
            }
        }
        return new OrgOuRpcDTO();
    }

    public void updateIsCreateOu(String custCode, Integer isCreateOu, String msg) {
        QCrmCustDO qCrmCustDO = QCrmCustDO.crmCustDO;
        BooleanExpression e = qCrmCustDO.deleteFlag.eq(0).and(qCrmCustDO.custCode.eq(custCode));
        Optional<CrmCustDO> optional = crmCustRepo.findOne(e);
        if (!optional.isEmpty()) {
            CrmCustDO crmCustDO = optional.get();
            crmCustDO.setIsCreateOu(isCreateOu);
            crmCustDO.setCorOu(crmCustDO.getCustCode());
            crmCustDO.setEs1(msg);
            crmCustRepo.save(crmCustDO);
        }
    }

    public List<OrgOuRpcDTO> getOuInfo(List<Long> ouIds, List<String> ouCodes) {
        OrgOuRpcDtoParam orgOuRpcDtoParam = new OrgOuRpcDtoParam();
        orgOuRpcDtoParam.setOuIds(ouIds);
        orgOuRpcDtoParam.setOuCodes(ouCodes);
        return orgOuRpcService.findOuDtoByParam(orgOuRpcDtoParam);
    }

    @Override
    public CrmCustDetailRespVO getCustDetail(Long id) {
        CrmCustDetailRespVO crmCustDetailRespVO = get(id);
        CrmCustDetailRespVO resp = crmCustDetailRespVO;
        if (!ObjectUtils.isEmpty(resp) && org.apache.commons.lang3.StringUtils.isNotBlank(resp.getProvinceCode())) {
            ApiResult<List<SysAreaRespDTO>> listByAreaCodes = sysAreaRpcService.listByAreaCodes(SetUtils.hashSet(resp.getProvinceCode()));
            if (listByAreaCodes.isSuccess() && !CollectionUtils.isEmpty(listByAreaCodes.getData())) {
                resp.setProvinceName(listByAreaCodes.getData().get(0).getShortName());
            }
        }
        //客户编号 查询的时候要展示客户号
        if ( org.apache.commons.lang3.StringUtils.isNotBlank(crmCustDetailRespVO.getPid())) {
            LmSaveCustRespVO lmSaveCustRespVO = getCustInfoByCustCode(crmCustDetailRespVO.getPid());
            if (!ObjectUtils.isEmpty(lmSaveCustRespVO)) {
                resp.setPid2(lmSaveCustRespVO.getCustCode2());
                resp.setPid2Abbr(lmSaveCustRespVO.getCustAbbr());
            }
        }
        Optional<CrmCustExtendDO> optional = this.findCustByCustCode(crmCustDetailRespVO.getCustCode());
        if (optional.isPresent()) {
            resp.setInvCustCode(optional.get().getInvCustCode());
            if (org.apache.commons.lang3.StringUtils.isNotBlank(optional.get().getInvCustCode())) {
                List<String> invCustCodes = List.of(optional.get().getInvCustCode().split(";"));
                List<LmSaveCustRespVO> list = getCustInfoByCustCodes(invCustCodes);
                if (!CollectionUtils.isEmpty(list)) {
                    List<String> custCode2 = list.stream().filter(a -> org.apache.commons.lang3.StringUtils.isNotBlank(a.getCustCode2())).map(LmSaveCustRespVO::getCustCode2).collect(Collectors.toList());
                    resp.setInvCustCode2(String.join(";", custCode2));
                }
            }
            resp.setOrderSignx(optional.get().getOrderSignx());
            resp.setAdjustSignx(optional.get().getAdjustSignx());
        }
        this.translateCustDetail(resp);
        return resp;
    }

    @Override
    public ApiResult<LmSaveCustRespVO> saveCustLm(LmCrmCustSaveVO save) {
        CrmCustConvert crmCustConvert = CrmCustConvert.INSTANCE;
        CrmCustSaveVO custSaveVO = crmCustConvert.saveLmToVo(save);
        ApiResult<CrmCustDetailRespVO> crmCustDetailResp = this.saveLm(custSaveVO);
        if(crmCustDetailResp.isSuccess() && !Objects.isNull(crmCustDetailResp)){
            CrmCustDetailRespVO crmCustDetailRespVO = crmCustDetailResp.getData();
            LmSaveCustRespVO res = new LmSaveCustRespVO();
            res.setId(crmCustDetailRespVO.getId());
            res.setCustCode(crmCustDetailRespVO.getCustCode());
            res.setCustName(crmCustDetailRespVO.getCustName());
            return ApiResult.ok(res);
        }
        return ApiResult.fail(crmCustDetailResp.getMsg());
    }
    public void translateCustDetail(CrmCustDetailRespVO resp) {
        if (!org.apache.commons.lang3.StringUtils.isEmpty(resp.getCustCurr())) {
            Map<String, String> map = this.getCurr(SetUtils.hashSet(resp.getCustCurr()));
            if (!MapUtils.isEmpty(map)) {
                resp.setCustCurrName(map.get(resp.getCustCurr()));
            }
        }
        if (org.apache.commons.lang3.StringUtils.isNotBlank(resp.getProvinceCode())) {
            ApiResult<List<SysAreaRespDTO>> listByAreaCodes = sysAreaRpcService.listByAreaCodes(SetUtils.hashSet(resp.getProvinceCode()));
            if (listByAreaCodes.isSuccess() && !CollectionUtils.isEmpty(listByAreaCodes.getData())) {
                resp.setProvinceName(listByAreaCodes.getData().get(0).getShortName());
            }
        }
        if(org.apache.commons.lang3.StringUtils.isNotBlank(resp.getCountry())){
            ApiResult<List<SysAreaRespDTO>> listByAreaCodes = sysAreaRpcService.listByAreaCodes(SetUtils.hashSet(resp.getCountry()));
            if (listByAreaCodes.isSuccess() && !CollectionUtils.isEmpty(listByAreaCodes.getData())) {
                resp.setCountryName(listByAreaCodes.getData().get(0).getAreaName());
            }
        }
        Map<String, String> custType2Udc = rmiSysUserRpcService.sysUdcGetCodeMap("yst-sale", "CUST_TYPE2");
        Map<String, String> custTypeUdc = rmiSysUserRpcService.sysUdcGetCodeMap("yst-sale", "CUST_TYPE");
        Map<String, String> custGroupUdc = rmiSysUserRpcService.sysUdcGetCodeMap("yst-sale", "CUST_GROUP");
        Map<String, String> custStatusUdc = rmiSysUserRpcService.sysUdcGetCodeMap("yst-sale", "CUST_STATUS");
        Map<String, String> custLevelUdc = rmiSysUserRpcService.sysUdcGetCodeMap("yst-sale", "CUST_LEVEL");
        Map<String, String> custRegion2Udc = rmiSysUserRpcService.sysUdcGetCodeMap("yst-supp", "REGION");
        Map<String, String> taxpayerTypeUdc = rmiSysUserRpcService.sysUdcGetCodeMap("yst-sale", "TAXPAYER_TYPE");
        Map<String, String> invTypeUdc = rmiSysUserRpcService.sysUdcGetCodeMap("yst-sale", "INV_TYPE");
        Map<String, String> paymentTermUdc = rmiSysUserRpcService.sysUdcGetCodeMap("yst-sale", "PAYMENT_TERM");
//        Map<String, String> orderSignxUdc = rmiSysUserRpcService.sysUdcGetCodeMap("yst-sale", "ORDER_SIGNX");
//        Map<String, String> adjustSignxUdc = rmiSysUserRpcService.sysUdcGetCodeMap("yst-sale", "ADJUST_SIGNX");
        if (!MapUtils.isEmpty(custType2Udc) && org.apache.commons.lang3.StringUtils.isNotBlank(resp.getCustType2())) {
            resp.setCustType2Name(custType2Udc.get(resp.getCustType2()));
        }
        if (!MapUtils.isEmpty(custTypeUdc) && org.apache.commons.lang3.StringUtils.isNotBlank(resp.getCustType())) {
            resp.setCustTypeName(custTypeUdc.get(resp.getCustType()));
        }


        if (!MapUtils.isEmpty(custGroupUdc) && org.apache.commons.lang3.StringUtils.isNotBlank(resp.getCustGroup())) {
            resp.setCustGroupName(custGroupUdc.get(resp.getCustGroup()));
        }

        if (!MapUtils.isEmpty(custStatusUdc) && org.apache.commons.lang3.StringUtils.isNotBlank(resp.getCustStatus())) {
            resp.setCustStatusName(custStatusUdc.get(resp.getCustStatus()));
        }

        if (!MapUtils.isEmpty(custLevelUdc) && org.apache.commons.lang3.StringUtils.isNotBlank(resp.getCustLevel())) {
            resp.setCustLevelName(custLevelUdc.get(resp.getCustLevel()));
        }

        if (!MapUtils.isEmpty(custRegion2Udc) && org.apache.commons.lang3.StringUtils.isNotBlank(resp.getRegion())) {
            resp.setRegionName(custRegion2Udc.get(resp.getRegion()));
        }

        if (!MapUtils.isEmpty(taxpayerTypeUdc) && org.apache.commons.lang3.StringUtils.isNotBlank(resp.getTaxpayerType())) {
            resp.setTaxpayerTypeName(taxpayerTypeUdc.get(resp.getTaxpayerType()));
        }

        if (!MapUtils.isEmpty(invTypeUdc) && org.apache.commons.lang3.StringUtils.isNotBlank(resp.getInvType())) {
            resp.setInvTypeName(invTypeUdc.get(resp.getInvType()));
        }

        if (!MapUtils.isEmpty(paymentTermUdc) && org.apache.commons.lang3.StringUtils.isNotBlank(resp.getPaymentTerm())) {
            resp.setPaymentTermName(paymentTermUdc.get(resp.getPaymentTerm()));
        }

    }

    public Map<String, String> getCurr(Set<String> list) {
        list.removeAll(Collections.singleton(null));
        if (!CollectionUtils.isEmpty(list)) {
            ApiResult<List<SysCurrencyRespDTO>> res = rmiSysService.listByCodes(list);
            if (!Objects.isNull(res) && res.isSuccess() && !CollectionUtils.isEmpty(res.getData())) {
                List<SysCurrencyRespDTO> resp = res.getData();
                return resp.stream().collect(Collectors.toMap(SysCurrencyRespDTO::getCurrCode, SysCurrencyRespDTO::getCurrName));
            }
        }
        return new HashMap<>();
    }

    public Optional<CrmCustExtendDO> findCustByCustCode(String custCode) {
        QCrmCustExtendDO qCrmCustExtendDO = QCrmCustExtendDO.crmCustExtendDO;
        BooleanExpression e = qCrmCustExtendDO.custCode.eq(custCode).and(qCrmCustExtendDO.deleteFlag.eq(0));
        return crmCustExtendRepo.findOne(e);
    }

    public OrgAddressRpcDTO getDefaultOrgAddr(List<OrgAddressRpcDTO> addrs){
        List<OrgAddressRpcDTO> list = new ArrayList<>();
        list.addAll(
                addrs.stream().filter(a -> StringUtil.isNotBlank(a.getAddressType())
                        && !ObjectUtils.isEmpty(a.getDefaultFlag())
                        && a.getDefaultFlag().equals(Boolean.TRUE)
                        && a.getAddressType().equals("DEFAULT")).collect(Collectors.toList())
        );

        if(!CollectionUtils.isEmpty(list)){
            return list.get(0);
        }
        return null;
    }

    public Map<Long,List<OrgAddressRpcDTO>> getAddrs(List<Long> addrNos){
        if (!CollectionUtils.isEmpty(addrNos)){
            OrgAddressRpcDtoParam orgAddressRpcDtoParam = new OrgAddressRpcDtoParam();
            orgAddressRpcDtoParam.setAddrNos(addrNos);
            List<OrgAddressRpcDTO>  addrs = rmiOrgAddrService.findAddrAddressListByParam(orgAddressRpcDtoParam);
            if(!CollectionUtils.isEmpty(addrs)){
                return addrs.stream().collect(Collectors.groupingBy(OrgAddressRpcDTO :: getAddrNo));
            }
        }
        return new HashMap<>();
    }

    public Map<String,SysEmployeeDetailDTO> getEmpMap(List<String> empCodes){
        Map<String,SysEmployeeDetailDTO> empMap = new HashMap<>();
        Set<String> set = new HashSet<>(empCodes);
        ApiResult<List<SysEmployeeDetailDTO>> apiResult = employeeRpcService.getDetailListByCode(set);
        if(apiResult.isSuccess() && !ObjectUtils.isEmpty(apiResult.getData()) && !CollectionUtils.isEmpty(apiResult.getData())){
            empMap = apiResult.getData().stream().collect(Collectors.toMap(SysEmployeeDetailDTO :: getCode, t->t , (t1,t2) -> t1));
        }
        return empMap;
    }


    public Map<Long,SalesmanInfoDO> getSalesmanMap(List<Long> agentEmpIds){
        Map<Long,SalesmanInfoDO> salesmanMap = new HashMap<>();
        List<SalesmanInfoDO> salesmanInfos = salesmanInfoRepo.findAllById(agentEmpIds);
        if(!CollectionUtils.isEmpty(salesmanInfos)){
            salesmanMap = salesmanInfos.stream().collect(Collectors.toMap(SalesmanInfoDO :: getId,t->t,(t1,t2) ->t1));
        }
        return salesmanMap;
    }



    @Override
    public List<LmSaveCustRespVO> getCustInfoByParam(CustAddrFindParam param) {
        return crmCustRepoProc.getCustInfoByParam(param);
    }

    @Override
    public CrmCustSimpleVO getCustSimple(String userName) {
        CustAccountVO custAccount = custAccountRepoproc.getAccountByUserName(userName);
        if(!ObjectUtils.isEmpty(custAccount) && !StringUtil.isBlank(custAccount.getCustCode())){
            CrmCustDO cust = crmCustRepoProc.getDoByCustCode(custAccount.getCustCode());
            CrmCustSimpleVO respVO = CrmCustConvert.INSTANCE.do2SimpleVo(cust);
            return respVO;
        }
        return null;
    }

    @Override
    public CrmCustSimpleVO getCustSimpleByUserId(Long userId) {
        CustAccountVO custAccount = custAccountRepoproc.getAccountByUserId(userId);
        if(!ObjectUtils.isEmpty(custAccount) && !StringUtil.isBlank(custAccount.getCustCode())){
            CrmCustDO cust = crmCustRepoProc.getDoByCustCode(custAccount.getCustCode());
            CrmCustSimpleVO respVO = CrmCustConvert.INSTANCE.do2SimpleVo(cust);
            return respVO;
        }
        return null;
    }


/*    @Override
    public Long saveCustAddr(List<CrmCustAddrSaveVO> addrList) {
        SysUserDTO sysUser = rmiSysUserService.currentUser();
        if(Objects.isNull(sysUser)){
            throw new BusinessException("获取当前用户信息失败");
        }
        String userName = sysUser.getUsername();
        //查询客户编号  通过客户编号查询地址号  通过地址号查询地址信息
        CustAccountVO custAccount = custAccountRepoproc.getAccountByUserName(userName);
        Long addrNo = crmCustRepoProc.getAddrNo(custAccount.getCustCode());
        String custName = crmCustRepoProc.getCustName(custAccount.getCustCode());


        OrgAddrRpcSaveParam param = new OrgAddrRpcSaveParam();
        //批量处理地址簿信息
        CrmCustConvert crmCustConvert = INSTANCE;
        param.setAddrNo(addrNo);
        param.setAddrName(custName);
        param.setAddrType(UdcEnum.ORG_ADDR_TYPE_CUST.getValueCode());
        param.setDataSources(Collections.singletonList(UdcEnum.ORG_ADDR_TYPE_CUST.getValueCode()));
        if (!CollectionUtils.isEmpty(addrList)) {
            List<CrmCustAddrSaveVO> custAddrSaveVOS = addrList;
            List<OrgAddrAddressRpcSaveParam> addrAddressRpcSaveParams = custAddrSaveVOS.stream().map(add -> {
                OrgAddrAddressRpcSaveParam orgAddrAddress = crmCustConvert.saveVoToAddrRpc(add);
                orgAddrAddress.setMobile(add.getContMobile());
                orgAddrAddress.setTel(add.getContTel());
                orgAddrAddress.setFax(add.getContFax());
                orgAddrAddress.setEmail(add.getContEmail());
                orgAddrAddress.setDetailAddr(add.getDetailaddr());
                orgAddrAddress.setDataSource(UdcEnum.ORG_ADDR_TYPE_CUST.getValueCode());
                return orgAddrAddress;
            }).collect(Collectors.toList());
            param.setOrgAddrAddressSaveParams(addrAddressRpcSaveParams);
        }
        ApiResult<Long> addrNo1 = rmiOrgAddrService.orgAddrSaveOrUpdateReturnAddrNo(param);
        Assert.isFalse(!addrNo1.isSuccess(), addrNo1.getMsg());
        return addrNo1.getData();
    }*/

//    @Override
//    public String getMdmCustCode(String taxRegNo) {
//        HttpHeaders headers = new HttpHeaders();
//        RestTemplate restTemplate = new RestTemplate();
//        headers.add("Accept", "application/json");
//        headers.add("Content-Type", "application/json;charset=UTF-8");
//        if (IF_PRODUCTION.equals("true")) {
////            restTemplate.getInterceptors().add(new BasicAuthenticationInterceptor(USERNAME_SOA,PASSWORD_SOA));
//            headers.add("authorization",
//                    "Basic " +
//                            Base64.encode((USERNAME_SOA + ":" + PASSWORD_SOA).getBytes()));
//        }
//        // 判断是否是正式环境(是否走SOA还是REST)
//        if (IF_PRODUCTION.equals("true")) {
//            DISTRIBUTIONMDMURL = DISTRIBUTIONMDMURL_SOA;
//            IMPORTMDMURL = IMPORTMDMURL_SOA;
//        } else {
//            DISTRIBUTIONMDMURL = DISTRIBUTIONMDMURL_REST;
//            IMPORTMDMURL = IMPORTMDMURL_REST;
//        }
//            DateTimeFormatter dtf = DateTimeFormatter.ofPattern(DATEFORMAT);
//            SimpleDateFormat sdf = new SimpleDateFormat(DATEFORMAT2);
//            String requestID = sdf.format(new Date());
//            //第一次请求数据主体
//            CrmCustMdmSyncDataParamVO crmCustMdmSyncDataParamVO = new CrmCustMdmSyncDataParamVO();
//            crmCustMdmSyncDataParamVO.setApplicationCode(APPLICATION_CODE);
//            crmCustMdmSyncDataParamVO.setIfaceCode(IFACECODE_FIND);
//            crmCustMdmSyncDataParamVO.setStartTime(LocalDateTime.now().minusMonths(12).format(dtf));
//            crmCustMdmSyncDataParamVO.setEndTime(LocalDateTime.now().format(dtf));
//            crmCustMdmSyncDataParamVO.setPageNumber(0);
//            String requestJson = JSON.toJSONString(crmCustMdmSyncDataParamVO);
//            //第一次请求数据
//            String firstRequestData = Base64.encode(requestJson);
//            CrmCustMdmSyncParamVO crmCustMdmSyncParamVO = new CrmCustMdmSyncParamVO();
//            crmCustMdmSyncParamVO.setApplicationCode(APPLICATION_CODE);
//            crmCustMdmSyncParamVO.setIfaceCode(IFACECODE_FIND);
//            crmCustMdmSyncParamVO.setAuth(AUTH);
//            crmCustMdmSyncParamVO.setRequestID(requestID);
//            crmCustMdmSyncParamVO.setRequestData(firstRequestData);
//
//            //第一次发起请求
//            CrmCustSyncFirstRespVO crmCustSyncFirstRespVO = null;
//            //发请求数据
//            try {
//                String json = objectMapper.writeValueAsString(crmCustMdmSyncParamVO);
//                log.info("mdm第一次请求数据{}", json);
//                crmCustSyncFirstRespVO = new RestTemplate().postForEntity(DISTRIBUTIONMDMURL, new HttpEntity<>(json, headers), CrmCustSyncFirstRespVO.class).getBody();
//                log.info("mdm第一次请求结果{}", crmCustSyncFirstRespVO);
//            } catch (Exception e) {
//                // 打印异常日志
//                log.error("---请求MDM的restTemplate打印异常日志---:" + e.getMessage());
//                throw new BusinessException("mdm建立连接调用异常" + e);
//            }
//            if (!ObjectUtils.isEmpty(crmCustSyncFirstRespVO) && crmCustSyncFirstRespVO.getCode().equals("0")) {
//                String firstResponse = crmCustSyncFirstRespVO.getData();
//                String str = Base64.decodeStr(firstResponse);
//                CrmCustSyncFirstDataRespVO custSyncFirstDataRespVO = JSON.parseObject(str, CrmCustSyncFirstDataRespVO.class);
//                crmCustMdmSyncDataParamVO.setBatchHistory(custSyncFirstDataRespVO.getBatchHistory());
//                crmCustMdmSyncDataParamVO.setBatch(custSyncFirstDataRespVO.getBatch());
//                crmCustMdmSyncDataParamVO.setLicenseNo2(taxRegNo);
//                String queryJson = JSON.toJSONString(crmCustMdmSyncDataParamVO);
//                //第一次请求数据
//                String requestData = Base64.encode(queryJson);
//                crmCustMdmSyncParamVO.setRequestData(requestData);
//                crmCustMdmSyncParamVO.setBatch(custSyncFirstDataRespVO.getBatch());
//                //第二次请求
//                //发请求数据
//                CrmCustMdmSyncRespVO crmCustMdmSyncRespVO = null;
//                try {
//                    String json = objectMapper.writeValueAsString(crmCustMdmSyncParamVO);
//                    log.info("mdm第二次请求数据{}", json);
//                    crmCustMdmSyncRespVO = new RestTemplate().postForEntity(DISTRIBUTIONMDMURL, new HttpEntity<>(json, headers), CrmCustMdmSyncRespVO.class).getBody();
//                    log.info("mdm第二次请求结果{}", crmCustMdmSyncRespVO);
//                } catch (Exception e) {
//                    log.info("mdm查询数据调用异常" + e.getMessage());
//                    throw new BusinessException("mdm查询数据调用异常" + e);
//                }
//
//                if (!ObjectUtils.isEmpty(crmCustSyncFirstRespVO) && crmCustSyncFirstRespVO.getCode().equals("0")){
//                    String queryResponse = crmCustMdmSyncRespVO.getData();
//                    String str1 = Base64.decodeStr(queryResponse);
//                    CrmCustResponseDataRespVO parseObject = JSON.parseObject(str1, CrmCustResponseDataRespVO.class);
//                    List<CrmCustMasterDataRespVO> custMasterDataIntfList = parseObject.getCustMasterDataIntfList();
//                    Optional<CrmCustMasterDataRespVO> masterDataRespVO = custMasterDataIntfList.stream().filter(cust -> taxRegNo.equals(cust.getLicenseNo2())).findFirst();
//                   if (masterDataRespVO.isPresent()) {
//                        return masterDataRespVO.get().getCustNo();
//                    }else{
//                       throw new BusinessException("MDM不存在,无法获取相关的外部客户编码");
//                   }
//                }else{
//                   throw new BusinessException("mdm第二次查询数据调用异常");
//                }
//            }else {
//                throw new BusinessException("mdm第一次查询数据调用异常");
//            }
//    }

    /**
     * 处理客户导入信息
     **/
    private ApiResult<List<CrmCustImportSaveVO>> checkAndHandleImportData(List<CrmCustImportSaveVO> parseData) {
        if (CollectionUtils.isEmpty(parseData)) {
            return ApiResult.ok();
        }
        // 通过客户编码、客户名称、税务登记号分组处理找到重复数据
        List<CrmCustImportSaveVO> custImportSaveVOS = parseData.stream().filter(data -> !ObjectUtils.isEmpty(data.getCustCode()) && !ObjectUtils.isEmpty(data.getCustName()) && !ObjectUtils.isEmpty(data.getTaxRegNo()))
                .collect(Collectors.toList());
        Map<String, List<CrmCustImportSaveVO>> custCodeMaps = custImportSaveVOS.stream().collect(Collectors.groupingBy(CrmCustImportSaveVO::getCustCode));
        Map<String, List<CrmCustImportSaveVO>> custNameMaps = custImportSaveVOS.stream().collect(Collectors.groupingBy(CrmCustImportSaveVO::getCustName));
        Map<String, List<CrmCustImportSaveVO>> taxRegNoMaps = custImportSaveVOS.stream().collect(Collectors.groupingBy(CrmCustImportSaveVO::getTaxRegNo));

        StringBuilder custCodeMsg = new StringBuilder();
        StringBuilder custNameMsg = new StringBuilder();
        StringBuilder taxRegNoMag = new StringBuilder();
        for (String custCode : custCodeMaps.keySet()) {
            List<CrmCustImportSaveVO> crmCustImportSaveVOS = custCodeMaps.get(custCode);
            if (crmCustImportSaveVOS.size() > 1) {
                custCodeMsg.append("【" + custCode + "】,");
            }
        }
        for (String custName : custNameMaps.keySet()) {
            List<CrmCustImportSaveVO> crmCustImportSaveVOS = custNameMaps.get(custName);
            if (crmCustImportSaveVOS.size() > 1) {
                custNameMsg.append("【" + custName + "】,");
            }
        }
        for (String taxRateNo : taxRegNoMaps.keySet()) {
            List<CrmCustImportSaveVO> crmCustImportSaveVOS = taxRegNoMaps.get(taxRateNo);
            if (crmCustImportSaveVOS.size() > 1) {
                taxRegNoMag.append("【" + taxRateNo + "】,");
            }
        }
        if (custCodeMsg.length() > 0) {
            throw new BusinessException("导入的多条数据,客户编码为:" + custCodeMsg + "数据重复");
        }
        if (custNameMsg.length() > 0) {
            throw new BusinessException("导入的多条数据,客户名称为:" + custNameMsg + "数据重复");
        }
        if (taxRegNoMag.length() > 0) {
            throw new BusinessException("导入的多条数据,税务登记号为:" + taxRegNoMag + "数据重复");
        }

        //udc反查(因为导入的数据udc部分为汉字所以这里需要后端手动的进行校验和翻译)
        this.udcHandle(parseData);
        //为了防止数据有空，或者集合为空要进行数据处理，防止dubbo调用方法时报错
        List<String> buCodes = parseData.stream().map(CrmCustImportSaveVO::getBuCode).filter(Objects::nonNull).distinct().collect(Collectors.toList());
        List<String> ouNames = parseData.stream().map(CrmCustImportSaveVO::getOuName).filter(Objects::nonNull).distinct().collect(Collectors.toList());
        List<String> ouCustNames = parseData.stream().filter(crm -> UdcEnum.CRM_CUST_TYPE2_C.getValueCode().equals(crm.getCustType2())).map(CrmCustImportSaveVO::getCustName).distinct().collect(Collectors.toList());
        List<String> agentEmpCodes = parseData.stream().map(CrmCustImportSaveVO::getAgentEmpCode).filter(Objects::nonNull).distinct().collect(Collectors.toList());
        ouNames.addAll(ouCustNames);
        ouNames = ouNames.stream().distinct().collect(Collectors.toList());
        OrgBuRpcDtoParam orgBuRpcDtoParam = new OrgBuRpcDtoParam();
        List<OrgBuRpcDTO> buDtoByParam = new ArrayList<>();
        if (!CollectionUtils.isEmpty(buCodes)) {
            orgBuRpcDtoParam.setBuCodes(buCodes);
            buDtoByParam = rmiOrgBuService.findBuDtoByParam(orgBuRpcDtoParam);
        }
        OrgEmpRpcDtoParam orgEmpRpcDtoParam = new OrgEmpRpcDtoParam();
        List<OrgEmpRpcDTO> orgEmpRpcDTOS = new ArrayList<>();
        if (!CollectionUtils.isEmpty(agentEmpCodes)) {
            orgEmpRpcDtoParam.setEmpCodes(agentEmpCodes);

            orgEmpRpcDTOS = rmiOrgEmpService.findEmpListByParam(orgEmpRpcDtoParam);

        }
        //先查询一波公司通过
        OrgOuRpcDtoParam orgOuRpcDtoParam = new OrgOuRpcDtoParam();
        List<OrgOuRpcDTO> ouDtoByParam = new ArrayList<>();
        if (!CollectionUtils.isEmpty(ouNames)) {
            orgOuRpcDtoParam.setOuNames(ouNames);
            ouDtoByParam = rmiOrgOuService.findOuDtoListByParam(orgOuRpcDtoParam);
        }
        List<OrgBuRpcDTO> finalBuDtoByParam = buDtoByParam;
        List<OrgOuRpcDTO> finalOuDtoByParam = ouDtoByParam;
        List<OrgEmpRpcDTO> finalOrgEmpRpcDtoS = orgEmpRpcDTOS;
        for (CrmCustImportSaveVO importVo : parseData) {//必填校验
            Assert.isFalse(StringUtils.isEmpty(importVo.getCustName()), "excel中存在数据客户名称为空");
            Assert.isFalse(StringUtils.isEmpty(importVo.getBuCode()), "客户名称为" + importVo.getCustName() + "的数据销售组织为空");
            Assert.isFalse(StringUtils.isEmpty(importVo.getOuName()), "客户名称为" + importVo.getCustName() + "的数据公司名称为空");
            Assert.isFalse(StringUtils.isEmpty(importVo.getOuCode()), "客户名称为" + importVo.getCustName() + "的数据公司为空");
            Assert.isFalse(StringUtils.isEmpty(importVo.getRegion()), "客户名称为" + importVo.getCustName() + "的数据区域为空");
            Assert.isFalse(StringUtils.isEmpty(importVo.getAgentEmpCode()), "客户名称为" + importVo.getCustName() + "的数据业务员编码为空");
            Assert.isFalse(StringUtils.isEmpty(importVo.getAgentEmpName()), "客户名称为" + importVo.getCustName() + "的数据业务员名称为空");
            Assert.isFalse(StringUtils.isEmpty(importVo.getCustType()), "客户名称为" + importVo.getCustName() + "的数据客户分类为空");
            Assert.isFalse(StringUtils.isEmpty(importVo.getCustStatus()), "客户名称为" + importVo.getCustName() + "的数据客户状态为空");
            Assert.isFalse(StringUtils.isEmpty(importVo.getCustType2()), "客户名称为" + importVo.getCustName() + "的数据客户归类为空");
            Assert.isFalse(StringUtils.isEmpty(importVo.getTaxRegNo()), "客户名称为" + importVo.getCustName() + "的数据税务登记码为空");
            Assert.isFalse(StringUtils.isEmpty(importVo.getInvType()), "客户名称为" + importVo.getCustName() + "的数据开票类型为空");
            Assert.isFalse(StringUtils.isEmpty(importVo.getCustGroup2()), "客户名称为" + importVo.getCustName() + "的数据大B/小B为空");
//            if (importVo.getCustGroup2().equals(UdcEnum.CRM_CUST_GROUP2_10.getValueCode()) && ObjectUtils.isEmpty(importVo.getCustCode2())) {
//                throw new BusinessException("客户名称为:" + importVo.getCustName() + "的数据外部系统客户编码为空");
//            }
            Assert.isFalse(StringUtils.isEmpty(importVo.getFinancialAttribute()), "导入数据财务属性1为空");
            Assert.isFalse((!UdcEnum.CRM_FINANCIAL_ATTRIBUTE_50.getValueCode().equals(importVo.getFinancialAttribute()) && !UdcEnum.CRM_FINANCIAL_ATTRIBUTE_60.getValueCode().equals(importVo.getFinancialAttribute()))
                    && StringUtils.isEmpty(importVo.getFinancialAttribute2()), " 当财务属性1不为（50车船户,60批发户时）财务属性2必填");
            Assert.isFalse((UdcEnum.CRM_FINANCIAL_ATTRIBUTE_20.getValueCode().equals(importVo.getFinancialAttribute()) || UdcEnum.CRM_FINANCIAL_ATTRIBUTE_30.getValueCode().equals(importVo.getFinancialAttribute())
                    || UdcEnum.CRM_FINANCIAL_ATTRIBUTE_40.getValueCode().equals(importVo.getFinancialAttribute()) || UdcEnum.CRM_FINANCIAL_ATTRIBUTE_50.getValueCode().equals(importVo.getFinancialAttribute()))
                    && StringUtils.isEmpty(importVo.getFinancialAttribute3()), " 当财务属性1为（20车船户,30批发户,40公福户时,50车船户）财务属性3必填");
            Assert.isFalse((UdcEnum.CRM_FINANCIAL_ATTRIBUTE_20.getValueCode().equals(importVo.getFinancialAttribute()) || UdcEnum.CRM_FINANCIAL_ATTRIBUTE_30.getValueCode().equals(importVo.getFinancialAttribute())
                    || UdcEnum.CRM_FINANCIAL_ATTRIBUTE_40.getValueCode().equals(importVo.getFinancialAttribute()))
                    && StringUtils.isEmpty(importVo.getFinancialAttribute4()), " 当财务属性1为（20车船户,30批发户,40公服户时）财务属性4必填");
            //校验开票信息
            Assert.isFalse((UdcEnum.COM_INV_TYPE_VANA.getValueCode().equals(importVo.getInvType())) && (StringUtils.isEmpty(importVo.getInvTitle())
                    || StringUtils.isEmpty(importVo.getTaxerNo())), "当开票类型为增值税普票时,开票抬头和税号必填");
            Assert.isFalse((UdcEnum.COM_INV_TYPE_VATS.getValueCode().equals(importVo.getInvType())) && (StringUtils.isEmpty(importVo.getInvTitle())
                    || StringUtils.isEmpty(importVo.getTaxerNo()) || StringUtils.isEmpty(importVo.getInvAddress())
                    || StringUtils.isEmpty(importVo.getInvTel()) || StringUtils.isEmpty(importVo.getInvBankName())
                    || StringUtils.isEmpty(importVo.getInvBankAcc()) || StringUtils.isEmpty(importVo.getInvPicName())
                    || StringUtils.isEmpty(importVo.getInvPicPhone())), "当开票类型为增值税专票时,开票抬头、税号、开票地址、开票电话、开户银行、银行账户、联系人、联系人电话必填");

            //如果是内部客户,则将对应的公司编码作为客户编码
            if (UdcEnum.CRM_CUST_TYPE2_C.getValueCode().equals(importVo.getCustType2())) {
                String ouCode = finalOuDtoByParam.stream().filter(ou -> ou.getOuName().equals(importVo.getCustName()))
                        .findFirst()
                        .orElseThrow(
                                new BusinessException("客户名称为【" + importVo.getCustName() + "】的数据,为内部公司客户,客户名称不存在")
                        )
                        .getOuCode();
                if (StringUtils.isEmpty(importVo.getCustCode())) {
                    importVo.setCustCode(ouCode);
                } else if (!ouCode.equals(importVo.getCustCode())) {
                    throw new BusinessException("客户名称为【" + importVo.getCustName() + "】的数据,为内部公司客户,客户名称和客户编码不一致");
                }
            }
            //如果是外部用户当客户编码不存在时通过发号器生成
            if (StringUtils.isEmpty(importVo.getCustCode())) {
                String custCode = rmiSysNextNumberService.generateCode("yst-sale","C", new ArrayList<>());
                importVo.setCustCode(custCode);
            }
            //验证客户编码是否重复
            Boolean exists = crmCustRepoProc.exists(importVo.getCustName(), null);
            Assert.isFalse(exists, "客户名称为【" + importVo.getCustName() + "】的数据" + "客户名称已存在");
            //验证税务编码是否重复
            if (!StringUtils.isEmpty(importVo.getTaxRegNo())) {
                Boolean existsTaxRegNo = crmCustRepoProc.existsTaxRegNo(importVo.getTaxRegNo(), null,null);
                Assert.isFalse(existsTaxRegNo, "客户名称为【" + importVo.getCustName() + "】的数据" + "税务登记号已存在");
            }

            // 大B，外部客户编码必填
//            if ("大B".equals(importVo.getCustGroup2()) && StringUtils.isEmpty(importVo.getCustCode2())) {
//                throw new BusinessException("客户名称为【" + importVo.getCustName() + "】的数据" + "如果是大B，外部客户编码必填");
//            }

            // 校验外部客户的编码规则
            if (UdcEnum.CRM_CUST_TYPE2_A.getValueCode().equals(importVo.getCustType2())){
                Assert.isTrue(importVo.getCustCode().matches("C\\d{10}"),"客户名称为【" + importVo.getCustName() + "】的数据，"+"客户编码必须是字母C加10位数字！");
            }

            OrgBuRpcDTO orgBuRpcDTO = finalBuDtoByParam.stream().filter(bu -> bu.getBuCode().equals(importVo.getBuCode()))
                    .findFirst()
                    .orElseThrow(
                            new BusinessException("客户名称为【" + importVo.getCustName() + "】的数据,销售组织不存在，请检查")
                    );

            importVo.setBuId(orgBuRpcDTO.getId());
            importVo.setBuName(orgBuRpcDTO.getBuName());

            Long ouId = finalOuDtoByParam.stream().filter(ou -> ou.getOuCode().equals(importVo.getOuCode()))
                    .findFirst()
                    .orElseThrow(
                            new BusinessException("客户名称为【" + importVo.getCustName() + "】的数据,公司不存在，请检查")
                    ).getId();
            importVo.setOuId(ouId);
            Long id = finalOrgEmpRpcDtoS.stream().filter(emp -> emp.getEmpCode().equals(importVo.getAgentEmpCode()) && emp.getEmpName().equals(importVo.getAgentEmpName()))
                    .findFirst()
                    .orElseThrow(
                            new BusinessException("客户名称为【" + importVo.getCustName() + "】的数据,业务员编码或者业务员名称不存在，请检查")
                    ).getId();
            importVo.setAgentEmpId(id);
        }
        return ApiResult.ok(parseData);
    }

    /**
     * udc处理，udc部分提出来而已
     */
    private void udcHandle(List<CrmCustImportSaveVO> parseData) {

//        List<SysUdcComboVO> gasScaleUdcList = sysUdcService.listCodeCombos("CRM", "GAS_SCALE");
//        List<SysUdcComboVO> custGroup2UdcList = sysUdcService.listCodeCombos("CRM", "CUST_GROUP2");
//        List<SysUdcComboVO> custTypeUdcList = sysUdcService.listCodeCombos("CRM", "CUST_TYPE");
//        List<SysUdcComboVO> custType2UdcList = sysUdcService.listCodeCombos("CRM", "CUST_TYPE2");
//        List<SysUdcComboVO> invTypeUdcList = sysUdcService.listCodeCombos("CRM", "INV_TYPE");
//        List<SysUdcComboVO> ardaysCheckType = sysUdcService.listCodeCombos("CRM", "ARDAYS_CHECK_TYPE");
//        List<SysUdcComboVO> creditCheckType = sysUdcService.listCodeCombos("CRM", "CREDIT_CHECK_TYPE");
//        List<SysUdcComboVO> custStatusUdcList = sysUdcService.listCodeCombos("CRM", "CUST_STATUS");
//        List<SysUdcComboVO> custSourceUdcList = sysUdcService.listCodeCombos("CRM", "CUST_SOURCE");
//        List<SysUdcComboVO> salRegionUdcList = sysUdcService.listCodeCombos("ORG", "OU_REGION");
//        List<SysUdcComboVO> custGroupUdcList = sysUdcService.listCodeCombos("CRM", "CUST_GROUP");
//        List<SysUdcComboVO> industryUdcList = sysUdcService.listCodeCombos("COM", "INDUSTRY");
//        List<SysUdcComboVO> paymentTermUdcList = sysUdcService.listCodeCombos("ORG", "PAYMENT_TERM");
//
//        List<SysUdcComboVO> financialList = sysUdcService.listCodeCombos("CRM", "FINANCIAL_ATTRIBUTE");
//        List<SysUdcComboVO> financial2List = sysUdcService.listCodeCombos("CRM", "FINANCIAL_ATTRIBUTE2");
//        List<SysUdcComboVO> financial3List = sysUdcService.listCodeCombos("CRM", "FINANCIAL_ATTRIBUTE3");
//        List<SysUdcComboVO> financial4List = sysUdcService.listCodeCombos("CRM", "FINANCIAL_ATTRIBUTE4");
//
//        List<SysUdcComboVO> financial32List = sysUdcService.listCodeCombos("CRM", "FINANCIAL_ATTRIBUTE32");
//        List<SysUdcComboVO> financial33List = sysUdcService.listCodeCombos("CRM", "FINANCIAL_ATTRIBUTE33");
//        List<SysUdcComboVO> financial34List = sysUdcService.listCodeCombos("CRM", "FINANCIAL_ATTRIBUTE34");
//        List<SysUdcComboVO> financial35List = sysUdcService.listCodeCombos("CRM", "FINANCIAL_ATTRIBUTE35");
//        List<SysUdcComboVO> financial42List = sysUdcService.listCodeCombos("CRM", "FINANCIAL_ATTRIBUTE42");
//        List<SysUdcComboVO> financial43List = sysUdcService.listCodeCombos("CRM", "FINANCIAL_ATTRIBUTE43");
//        List<SysUdcComboVO> financial44List = sysUdcService.listCodeCombos("CRM", "FINANCIAL_ATTRIBUTE44");
//
//
//        for (CrmCustImportSaveVO importVo : parseData) {//因为是先转udc，防止客户名称不存在导致报错信息客户名称为null
//            Assert.isFalse(StringUtils.isEmpty(importVo.getCustName()), "excel中存在数据客户名称为空");
//            if (!StringUtils.isEmpty(importVo.getCustType())) {
//                String udcvalue = this.udcHandleCom(custTypeUdcList, importVo.getCustType(), "客户分类", importVo.getCustName());
//                importVo.setCustType(udcvalue);
//            }
//            if (!StringUtils.isEmpty(importVo.getCustLevel())) {
//                String udcvalue = this.udcHandleCom(custGroupUdcList, importVo.getCustLevel(), "客户等级", importVo.getCustName());
//                importVo.setCustLevel(udcvalue);
//            }
//            if (!StringUtils.isEmpty(importVo.getCustIndustry())) {
//                String udcvalue = this.udcHandleCom(industryUdcList, importVo.getCustIndustry(), "客户行业", importVo.getCustName());
//                importVo.setCustIndustry(udcvalue);
//            }
//            if (!StringUtils.isEmpty(importVo.getPaymentTerm())) {
//                String udcvalue = this.udcHandleCom(paymentTermUdcList, importVo.getPaymentTerm(), "付款条款", importVo.getCustName());
//                importVo.setPaymentTerm(udcvalue);
//            }
//            if (!StringUtils.isEmpty(importVo.getCustStatus())) {
//                String udcvalue = this.udcHandleCom(custStatusUdcList, importVo.getCustStatus(), "客户状态", importVo.getCustName());
//                importVo.setCustStatus(udcvalue);
//            }
//            if (!StringUtils.isEmpty(importVo.getCustType2())) {
//                String udcvalue = this.udcHandleCom(custType2UdcList, importVo.getCustType2(), "客户归类", importVo.getCustName());
//                importVo.setCustType2(udcvalue);
//            }
//            if (!StringUtils.isEmpty(importVo.getInvType())) {
//                String udcvalue = this.udcHandleCom(invTypeUdcList, importVo.getInvType(), "开票类型", importVo.getCustName());
//                importVo.setInvType(udcvalue);
//            }
//
//            if (!StringUtils.isEmpty(importVo.getArdaysCheckType())) {
//                String udcvalue = this.udcHandleCom(ardaysCheckType, importVo.getArdaysCheckType(), "账期检查类型", importVo.getCustName());
//                importVo.setArdaysCheckType(udcvalue);
//            }
//            if (!StringUtils.isEmpty(importVo.getCustGroup2())) {
//                String udcvalue = this.udcHandleCom(custGroup2UdcList, importVo.getCustGroup2(), "大B/小B", importVo.getCustName());
//                importVo.setCustGroup2(udcvalue);
//            }
//            if (!StringUtils.isEmpty(importVo.getCreditCheckType())) {
//                String udcvalue = this.udcHandleCom(creditCheckType, importVo.getCreditCheckType(), "信贷检查类型", importVo.getCustName());
//                if (importVo.getCreditCheckType().equals(UdcEnum.CRM_CREDIT_CHECK_TYPE_A.getValueCodeName()) && StringUtils.isEmpty(importVo.getCreditLimit())) {
//                    throw new BusinessException("客户名称为【" + importVo.getCustName() + "】的数据,信贷检查类型为检查时,信贷额度必须存在，请检查");
//                }
//                importVo.setCreditCheckType(udcvalue);
//            }
//            if (!StringUtils.isEmpty(importVo.getCustSource())) {
//                String udcvalue = this.udcHandleCom(custSourceUdcList, importVo.getCustSource(), "客户来源", importVo.getCustName());
//                importVo.setCustSource(udcvalue);
//            }
//            if (!StringUtils.isEmpty(importVo.getRegion())) {
//                String udcvalue = this.udcHandleCom(salRegionUdcList, importVo.getRegion(), "销售区域", importVo.getCustName());
//                importVo.setRegion(udcvalue);
//            }
//            if (!StringUtils.isEmpty(importVo.getFinancialAttribute())) {
//                String udcvalue = this.udcHandleCom(financialList, importVo.getFinancialAttribute(), "财务属性1", importVo.getCustName());
//                importVo.setFinancialAttribute(udcvalue);
//            }
//            if (!StringUtils.isEmpty(importVo.getFinancialAttribute2())) {
//                String udcvalue = this.udcHandleCom(financial2List, importVo.getFinancialAttribute2(), "财务属性2", importVo.getCustName());
//                importVo.setFinancialAttribute2(udcvalue);
//            }
//            if (!StringUtils.isEmpty(importVo.getFinancialAttribute3())) {
//
//                String udc32List = financial32List.stream().map(SysUdcComboVO::getValDesc).collect(Collectors.toList()).toString();
//                String udc33List = financial33List.stream().map(SysUdcComboVO::getValDesc).collect(Collectors.toList()).toString();
//                String udc34List = financial34List.stream().map(SysUdcComboVO::getValDesc).collect(Collectors.toList()).toString();
//                String udc35List = financial35List.stream().map(SysUdcComboVO::getValDesc).collect(Collectors.toList()).toString();
//
//                if (UdcEnum.CRM_FINANCIAL_ATTRIBUTE_20.getValueCode().equals(importVo.getFinancialAttribute())) {
//                    String udcvalue = this.udcRelatedHandleCom(financial32List, importVo.getFinancialAttribute3(), "工业户", "财务属性3", udc32List, importVo.getCustName());
//                    importVo.setFinancialAttribute3(udcvalue);
//                } else if (UdcEnum.CRM_FINANCIAL_ATTRIBUTE_30.getValueCode().equals(importVo.getFinancialAttribute())) {
//                    String udcvalue = this.udcRelatedHandleCom(financial33List, importVo.getFinancialAttribute3(), "商业户", "财务属性3", udc33List, importVo.getCustName());
//                    importVo.setFinancialAttribute3(udcvalue);
//                } else if (UdcEnum.CRM_FINANCIAL_ATTRIBUTE_40.getValueCode().equals(importVo.getFinancialAttribute())) {
//                    String udcvalue = this.udcRelatedHandleCom(financial34List, importVo.getFinancialAttribute3(), "公福户", "财务属性3", udc34List, importVo.getCustName());
//                    importVo.setFinancialAttribute3(udcvalue);
//                } else if (UdcEnum.CRM_FINANCIAL_ATTRIBUTE_50.getValueCode().equals(importVo.getFinancialAttribute())) {
//                    String udcvalue = this.udcRelatedHandleCom(financial35List, importVo.getFinancialAttribute3(), "车船户", "财务属性3", udc35List, importVo.getCustName());
//                    importVo.setFinancialAttribute3(udcvalue);
//                } else {
//                    String udcvalue = this.udcHandleCom(financial3List, importVo.getFinancialAttribute3(), "财务属性3", importVo.getCustName());
//                    importVo.setFinancialAttribute3(udcvalue);
//                }
//            }
//            if (!StringUtils.isEmpty(importVo.getFinancialAttribute4())) {
//
//                String udc42List = financial42List.stream().map(SysUdcComboVO::getValDesc).collect(Collectors.toList()).toString();
//                String udc43List = financial43List.stream().map(SysUdcComboVO::getValDesc).collect(Collectors.toList()).toString();
//                String udc44List = financial44List.stream().map(SysUdcComboVO::getValDesc).collect(Collectors.toList()).toString();
//
//                if (UdcEnum.CRM_FINANCIAL_ATTRIBUTE_20.getValueCode().equals(importVo.getFinancialAttribute())) {
//                    String udcvalue = this.udcRelatedHandleCom(financial42List, importVo.getFinancialAttribute4(), "工业户", "财务属性4", udc42List, importVo.getCustName());
//                    importVo.setFinancialAttribute4(udcvalue);
//                } else if (UdcEnum.CRM_FINANCIAL_ATTRIBUTE_30.getValueCode().equals(importVo.getFinancialAttribute())) {
//                    String udcvalue = this.udcRelatedHandleCom(financial43List, importVo.getFinancialAttribute4(), "商业户", "财务属性4", udc43List, importVo.getCustName());
//                    importVo.setFinancialAttribute4(udcvalue);
//                } else if (UdcEnum.CRM_FINANCIAL_ATTRIBUTE_40.getValueCode().equals(importVo.getFinancialAttribute())) {
//                    String udcvalue = this.udcRelatedHandleCom(financial44List, importVo.getFinancialAttribute4(), "公福户", "财务属性4", udc44List, importVo.getCustName());
//                    importVo.setFinancialAttribute4(udcvalue);
//                } else {
//                    String udcvalue = this.udcHandleCom(financial4List, importVo.getFinancialAttribute4(), "财务属性4", importVo.getCustName());
//                    importVo.setFinancialAttribute4(udcvalue);
//                }
//            }
//
//        }
    }

    /**
     * udc处理，只是把公共部分提出来而已
     */
    private String udcHandleCom(List<SysUdcComboVO> udcComboVOList, String udcDesc, String handleDate, String custName) {
        return udcComboVOList.stream().filter(udc -> udc.getValDesc().equals(udcDesc)).findFirst()
                .orElseThrow(new BusinessException("客户名称为【" + custName + "】的数据," + handleDate + "不存在，请检查"))
                .getUdcVal();
    }

    /**
     * 关联udc,统一处理查找报错
     */
    private String udcRelatedHandleCom(List<SysUdcComboVO> udcComboVOList, String udcDesc, String handleDate1, String handleDate2, String handleDate3, String custName) {
        return udcComboVOList.stream().filter(udc -> udc.getValDesc().equals(udcDesc)).findFirst()
                .orElseThrow(new BusinessException("客户名称为【" + custName + "】的数据,当财务属性1为" + handleDate1 + "时," + handleDate2 + "应该取" + handleDate3 + ",所填写" + handleDate2 + "不存在"))
                .getUdcVal();
    }

    /**
     * 处理客户地址导入信息
     **/
    private ApiResult<List<CrmAddrImplSaveVO>> checkAndHandleAddrImportData(List<CrmAddrImplSaveVO> parseData) {
        Assert.notNull(parseData, "保存信息为空");
        //udc反查
//        List<SysUdcComboVO> custTypeUdcList;
//        try {
//            custTypeUdcList = sysUdcService.listCodeCombos("ORG", "ADDRESS_TYPE");
//        } catch (Exception e) {
//            log.error("dubbo服务调用系统域UDC接口出错：" + e.getMessage());
//            throw new BusinessException("dubbo服务调用系统域UDC接口出错");
//        }
//        //国家省市区匹配
//        List<String> areaNames = new ArrayList<>();
//        List<String> countys = parseData.stream().map(CrmAddrImplSaveVO::getCounty).filter(Objects::nonNull).distinct().collect(Collectors.toList());
//        List<String> citys = parseData.stream().map(CrmAddrImplSaveVO::getCity).filter(Objects::nonNull).distinct().collect(Collectors.toList());
//        List<String> provinces = parseData.stream().map(CrmAddrImplSaveVO::getProvince).filter(Objects::nonNull).distinct().collect(Collectors.toList());
//        //处理数据自治区转为简称如(广西壮族自治区转为广西(数据库存))
////        List<String> newProvinces = this.switchProvince(provinces);
//        areaNames.addAll(countys);
//        areaNames.addAll(citys);
//        areaNames.addAll(provinces);
//        List<String> areaNames1 = areaNames.stream().distinct().collect(Collectors.toList());
//        ComCityCodeRpcDtoParam comCityCodeRpcDto = new ComCityCodeRpcDtoParam();
//        List<ComCityCodeRpcDTO> cityCodeListByParam = new ArrayList<>();
//        if (!CollectionUtils.isEmpty(areaNames1)) {
//            comCityCodeRpcDto.setAreaNames(areaNames1);
//            cityCodeListByParam = rmiCityCodeService.findCityCodeListByParam(comCityCodeRpcDto);
//
//        }
//        List<SysUdcComboVO> finalCustTypeUdcList = custTypeUdcList;
//        List<ComCityCodeRpcDTO> finalCityCodeListByParam = cityCodeListByParam;
//        parseData.forEach(importVo -> {
//            Assert.isFalse(StringUtils.isEmpty(importVo.getCustCode()), "导入数据客户编码为空");
//            Assert.isFalse(StringUtils.isEmpty(importVo.getAddressName()), "导入数据地址类型为空");
//            Assert.isFalse(StringUtils.isEmpty(importVo.getAddressType()), "导入数据地址名称为空");
//            Assert.isFalse(StringUtils.isEmpty(importVo.getCountry()), "导入数据国家为空");
//            Assert.isFalse(StringUtils.isEmpty(importVo.getStreet()), "导入数据乡镇/街道为空");
//            Assert.isFalse(StringUtils.isEmpty(importVo.getProvince()), "导入数据省为空");
//            Assert.isFalse(StringUtils.isEmpty(importVo.getCity()), "导入数据市为空");
//            Assert.isFalse(StringUtils.isEmpty(importVo.getCounty()), "导入数据县/区为空");
//            Assert.isFalse(StringUtils.isEmpty(importVo.getDetailAddr()), "导入数据详细地址为空");
//            Assert.isFalse(StringUtils.isEmpty(importVo.getContPerson()), "导入数据联系人为空");
//            Assert.isFalse(StringUtils.isEmpty(importVo.getTel()), "导入数据联系人电话为空");
//            Assert.isFalse(StringUtils.isEmpty(importVo.getMobile()), "导入数据联系人手机为空");
//            Assert.isFalse(StringUtils.isEmpty(importVo.getEmail()), "导入数据邮箱为空");
//
//            String cTudcVal = finalCustTypeUdcList.stream().filter(cust -> cust.getValDesc().equals(importVo.getAddressType()))
//                    .findFirst().orElseThrow(
//                            new BusinessException("客户编码为【" + importVo.getCustCode() + "】的数据,数据地址类型不存在,请检查")
//                    ).getUdcVal();
//            importVo.setAddressType(cTudcVal);
//            String province = finalCityCodeListByParam.stream().filter(pro -> pro.getAreaName().equals(importVo.getProvince()))
//                    .findFirst().orElseThrow(
//                            new BusinessException("客户编码为【" + importVo.getCustCode() + "】的数据,省名称不存在或者不规范请加上省,请检查")
//                    ).getAreaCode();
//            importVo.setProvince(province);
//            String city = finalCityCodeListByParam.stream().filter(pro -> pro.getAreaName().equals(importVo.getCity()))
//                    .findFirst().orElseThrow(
//                            new BusinessException("客户编码为【" + importVo.getCustCode() + "】的数据,市名称不存在或者不规范请输入市全名,请检查")
//                    ).getAreaCode();
//            importVo.setCity(city);
//            String county = finalCityCodeListByParam.stream().filter(pro -> pro.getAreaName().equals(importVo.getCounty()))
//                    .findFirst().orElseThrow(
//                            new BusinessException("客户编码为【" + importVo.getCustCode() + "】的数据,(县/区)名称不存在或者不规范请加上(县/区),请检查")
//                    ).getAreaCode();
//            importVo.setCounty(county);
//        });
        return ApiResult.ok(parseData);
    }

    /**
     * 对省字段数据处理，因为其自治区与数据库数据不一致
     */
    private List<String> switchProvince(List<String> provinces) {
        List<String> newProvince = new ArrayList<>();
        provinces.forEach(pro -> {
            if (pro.contains("新疆")) {
                newProvince.add("新疆");
            } else if (pro.contains("广西")) {
                newProvince.add("广西");
            } else if (pro.contains("宁夏")) {
                newProvince.add("宁夏");
            } else if (pro.contains("西藏")) {
                newProvince.add("西藏");
            } else if (pro.contains("内蒙古")) {
                newProvince.add("内蒙古");
            } else {
                newProvince.add(pro);
            }
        });
        return newProvince;
    }

    /**
     * 根据客户id集合查询客户
     **/
    private List<CrmCustDetailRespVO> findIdBatch(List<Long> ids) {
        List<CrmCustDetailRespVO> custDetailRespVOS = crmCustRepo.findAllById(ids).stream().map(
                INSTANCE::doToDetailRespVO
        ).collect(Collectors.toList());
        custDetailRespVOS.forEach(this::translateDetail);
        return custDetailRespVOS;
    }

    /**
     * 保存数据集校验
     **/
    private void checkForSave(CrmCustSaveVO saveVO) {
        Assert.notNull(saveVO, "保存信息为空");
        Assert.isFalse(StringUtils.isEmpty(saveVO.getCustName()), "保存数据客户名称为空");

        //验证客户名称是否重复
//        if (!StringUtils.isEmpty(saveVO.getCustName())) {
//            Boolean exists = crmCustRepoProc.exists(saveVO.getCustName(), saveVO.getId());
//            Assert.isFalse(exists, "客户名称已存在,请在查询界面查询此客户");
//        }
//        if (!StringUtils.isEmpty(saveVO.getOuId())) {
//            Boolean exists = crmCustOuRepoProc.existsCodeAndOuId(saveVO.getCustCode(), saveVO.getOuId());
//            Assert.isFalse(exists, "客户该公司已存在拓展表中,请在拓展表中删除后再修改");
//        }
        if(!StringUtils.isEmpty(saveVO.getCustCode2())){
            Boolean exists = crmCustRepoProc.existsCustCode2(saveVO.getCustCode2(), saveVO.getId());
            Assert.isFalse(exists, "客户号已经存在,请在查询页面查看");
        }
//        if (!StringUtils.isEmpty(saveVO.getTaxRegNo())) {
//            Boolean exists = crmCustRepoProc.existsTaxRegNo(saveVO.getTaxRegNo(), saveVO.getId(),saveVO.getBusinessTypeCust());
//            Assert.isFalse(exists, "该税务号所属客户已存在正式客户表中,请在查询页面查看");
//        }
        //验证客户编码是否重复
        if (!StringUtils.isEmpty(saveVO.getCustCode())) {
            Boolean exists1 = crmCustRepoProc.existsCode(saveVO.getCustCode(), saveVO.getId());
            Assert.isFalse(exists1, "客户编码已存在,请在查询界面查询此客户");
        }


    }

    private CrmCustDO saveVoDo(CrmCustSaveVO saveVO) {
        CrmCustDO crmCustDO = saveVO.getId() == null ? new CrmCustDO() : crmCustRepo.findById(saveVO.getId()).orElseThrow();
        INSTANCE.copyVoToDo(saveVO, crmCustDO);

        return crmCustDO;
    }

    private Page<CrmCustDO> searching(CrmCustQueryParamVO queryParamVO) {

        Predicate predicate = qCrmCustDO.isNotNull();
        //客户编码
        if (!StringUtils.isEmpty(queryParamVO.getCustCode())) {
            predicate = ExpressionUtils.and(predicate, qCrmCustDO.custCode.like("%" + queryParamVO.getCustCode() + "%"));
        }
        //客户状态
        if (!StringUtils.isEmpty(queryParamVO.getCustStatus())) {
            predicate = ExpressionUtils.and(predicate, qCrmCustDO.custStatus.eq(queryParamVO.getCustStatus()));
        }

        //数据同步状态
//        if (!StringUtils.isEmpty(queryParamVO.getIntfStatus())) {
//            predicate = ExpressionUtils.and(predicate, qCrmCustDO.intfStatus.eq(queryParamVO.getIntfStatus()));
//        }
        //参保信息

        //客户分类
        if (!StringUtils.isEmpty(queryParamVO.getCustType())) {
            predicate = ExpressionUtils.and(predicate, qCrmCustDO.custType.eq(queryParamVO.getCustType()));
        }
        //客户归类
        if (!StringUtils.isEmpty(queryParamVO.getCustType2())) {
            predicate = ExpressionUtils.and(predicate, qCrmCustDO.custType2.eq(queryParamVO.getCustType2()));
        }
        //客户等级
        if (!StringUtils.isEmpty(queryParamVO.getCustLevel())) {
            predicate = ExpressionUtils.and(predicate, qCrmCustDO.custLevel.eq(queryParamVO.getCustLevel()));
        }
        //税务登记号
        if (!StringUtils.isEmpty(queryParamVO.getTaxRegNo())) {
            predicate = ExpressionUtils.and(predicate, qCrmCustDO.taxRegNo.like("%" + queryParamVO.getTaxRegNo() + "%"));
        }
        //客户编码集合
        if (!CollectionUtils.isEmpty(queryParamVO.getCustCodes())) {
            predicate = ExpressionUtils.and(predicate, qCrmCustDO.custCode.in(queryParamVO.getCustCodes()));
        }
        //客户id集合
        if (!CollectionUtils.isEmpty(queryParamVO.getCustIds())) {
            predicate = ExpressionUtils.and(predicate, qCrmCustDO.id.in(queryParamVO.getCustIds()));
        }
        //客户英文名称
//        if (!StringUtils.isEmpty(queryParamVO.getCustCode2())) {
//            predicate = ExpressionUtils.and(predicate, qCrmCustDO.custCode2.like("%" + queryParamVO.getCustCode2() + "%"));
//        }
        //业务员id
        if (!StringUtils.isEmpty(queryParamVO.getAgentEmpId())) {
            //通过公司Id查询客户公司拓展表,查到所有的客户编码
            CrmCustOuParamVO crmCustOuParamVO = new CrmCustOuParamVO();
            crmCustOuParamVO.setAgentEmpId(queryParamVO.getAgentEmpId());
            crmCustOuParamVO.setIfTrans(false);
            List<CrmCustOuSaveVO> custOuSaveVOS = crmCustOuService.search(crmCustOuParamVO);
            if (!CollectionUtils.isEmpty(custOuSaveVOS)) {
                List<String> custCodes = custOuSaveVOS.stream().map(CrmCustOuSaveVO::getCustCode).distinct().collect(Collectors.toList());
                if (!CollectionUtils.isEmpty(custCodes)) {
                    predicate = ExpressionUtils.and(predicate, qCrmCustDO.custCode.in(custCodes).or(qCrmCustDO.agentEmpId.eq(queryParamVO.getAgentEmpId())));
                } else {
                    predicate = ExpressionUtils.and(predicate, qCrmCustDO.agentEmpId.eq(queryParamVO.getAgentEmpId()));
                }
            } else {
                predicate = ExpressionUtils.and(predicate, qCrmCustDO.agentEmpId.eq(queryParamVO.getAgentEmpId()));
            }
        }
        //公司id
        // 筛选条件拓展公司信息
        List<String> custCodes = new ArrayList<>();
        if (!StringUtils.isEmpty(queryParamVO.getOuId())) {
            //通过公司Id查询客户公司拓展表,查到所有的客户编码
            CrmCustOuParamVO crmCustOuParamVO = new CrmCustOuParamVO();
            crmCustOuParamVO.setOuId(queryParamVO.getOuId());
            crmCustOuParamVO.setIfTrans(false);
            List<CrmCustOuSaveVO> custOuSaveVOS = crmCustOuService.search(crmCustOuParamVO);
            if (!CollectionUtils.isEmpty(custOuSaveVOS)) {
                custCodes = custOuSaveVOS.stream().map(CrmCustOuSaveVO::getCustCode).distinct().collect(Collectors.toList());
                if (!CollectionUtils.isEmpty(custCodes)) {
                    predicate = ExpressionUtils.and(predicate, qCrmCustDO.custCode.in(custCodes).or(qCrmCustDO.ouId.eq(queryParamVO.getOuId())));
                } else {
                    predicate = ExpressionUtils.and(predicate, qCrmCustDO.ouId.eq(queryParamVO.getOuId()));
                }
            } else {
                predicate = ExpressionUtils.and(predicate, qCrmCustDO.ouId.eq(queryParamVO.getOuId()));
            }
        }
        // 筛选当前登录人公司拓展信息
        /** zzh 2022 1/20 修改 begin
         * 修改点 : 1.获得当前登录人的公司,拿获取到的公司去查拓展表中的客户编码拼接sql , 只有当前端页面公司条件没值或者有值和当前登录人所属公司一致时，结果才获取
         * **/
        List<String> custCodes2 = new ArrayList<>();
        CurrentUserDTO currentUserDTO = UserService.currentUser();
        if (!ObjectUtils.isEmpty(currentUserDTO)){
            OrgUserEmpInfoRpcDTO userEmpInfo = rmiOrgEmpService.findUserEmpInfo(currentUserDTO.getUserId());
            if (!ObjectUtils.isEmpty(userEmpInfo) && !ObjectUtils.isEmpty(userEmpInfo.getOuId())) {
                CrmCustOuParamVO crmCustOuParamVO = new CrmCustOuParamVO();
                crmCustOuParamVO.setOuId(userEmpInfo.getOuId());
                crmCustOuParamVO.setIfTrans(false);
                List<CrmCustOuSaveVO> custOuSaveVOS = crmCustOuService.search(crmCustOuParamVO);
                if (!CollectionUtils.isEmpty(custOuSaveVOS)) {
                    if (ObjectUtils.isEmpty(queryParamVO.getOuId()) || queryParamVO.getOuId().equals(userEmpInfo.getOuId())){
                        custCodes2 = custOuSaveVOS.stream().map(CrmCustOuSaveVO::getCustCode).distinct().collect(Collectors.toList());
                    }
                }
            }
        }
        /** zzh 2022 1/20 修改 end **/
        //组织id
        if (!StringUtils.isEmpty(queryParamVO.getBuId())) {
            predicate = ExpressionUtils.and(predicate, qCrmCustDO.buId.eq(queryParamVO.getBuId()));
        }
        //客户名称
        if (!StringUtils.isEmpty(queryParamVO.getCustName())) {
            predicate = ExpressionUtils.and(predicate, qCrmCustDO.custName.like("%" + queryParamVO.getCustName() + "%"));
        }
        //客户简称
        if (!StringUtils.isEmpty(queryParamVO.getCustAbbr())) {
            predicate = ExpressionUtils.and(predicate, qCrmCustDO.custAbbr.like("%" + queryParamVO.getCustAbbr() + "%"));
        }
        //客户地址号
        if (!CollectionUtils.isEmpty(queryParamVO.getAddrNos())) {
            predicate = ExpressionUtils.and(predicate, qCrmCustDO.addrNo.in(queryParamVO.getAddrNos()));
        }
        //客户类型
        if (!StringUtils.isEmpty(queryParamVO.getInnerFlag())) {
            if (queryParamVO.getInnerFlag().equals(Boolean.TRUE)) {
                predicate = ExpressionUtils.and(predicate, qCrmCustDO.custType2.eq(UdcEnum.CRM_CUST_TYPE2_C.getValueCode()));
                predicate = ExpressionUtils.or(predicate, qCrmCustDO.custType2.eq(UdcEnum.CRM_CUST_TYPE2_D.getValueCode()));
            } else {
                predicate = ExpressionUtils.and(predicate, qCrmCustDO.custType2.ne(UdcEnum.CRM_CUST_TYPE2_C.getValueCode()));
                predicate = ExpressionUtils.and(predicate, qCrmCustDO.custType2.ne(UdcEnum.CRM_CUST_TYPE2_D.getValueCode()));
            }
        }
        predicate = ExpressionUtils.and(predicate, qCrmCustDO.deleteFlag.ne(ConstantsSale.COMMON_DELETE_YSE));
        // 添加权限信息
        /** zzh 2022 1/20 修改 begin
         *  修改点 : 先拿到条件查询所获取到的客户编码集合(可空) 和 当前用户查到的取全集后去重后使用
         *  这部分数据和权限数据并列sql条件，使用or连接 再与主sql and 连接
         **/
        // 拓展公司查询用客户集合
        custCodes.addAll(custCodes2);
        List<String> custList = custCodes.stream().distinct().collect(Collectors.toList());
        Predicate predicate2 = qCrmCustDO.isNotNull();
        if (!CollectionUtils.isEmpty(custList)){
            predicate2 = ExpressionUtils.and(predicate2,qCrmCustDO.custCode.in(custCodes)
                    .or(DataAuthJpaUtil.dataAuthJpaPredicate(qCrmCustDO.getMetadata())));
            predicate = ExpressionUtils.and(predicate,predicate2);
        }else {
            predicate = ExpressionUtils.and(predicate, DataAuthJpaUtil.dataAuthJpaPredicate(qCrmCustDO.getMetadata()));
        }
        /** zzh 2022 1/20 修改 end **/
        return crmCustRepo.findAll(predicate, wrapperPageRequest(queryParamVO.getPageRequest(), null));

    }

    // 用于后端调用没有paging
    private List<CrmCustDO> searching1(CrmCustQueryParamVO queryParamVO) {

        Predicate predicate = qCrmCustDO.isNotNull();
        //客户编码
        if (!StringUtils.isEmpty(queryParamVO.getCustCode())) {
            predicate = ExpressionUtils.and(predicate, qCrmCustDO.custCode.like("%" + queryParamVO.getCustCode() + "%"));
        }
        //客户状态
        if (!StringUtils.isEmpty(queryParamVO.getCustStatus())) {
            predicate = ExpressionUtils.and(predicate, qCrmCustDO.custStatus.eq(queryParamVO.getCustStatus()));
        }

        //数据同步状态
//        if (!StringUtils.isEmpty(queryParamVO.getIntfStatus())) {
//            predicate = ExpressionUtils.and(predicate, qCrmCustDO.intfStatus.eq(queryParamVO.getIntfStatus()));
//        }
        //客户分类
        if (!StringUtils.isEmpty(queryParamVO.getCustType())) {
            predicate = ExpressionUtils.and(predicate, qCrmCustDO.custType.eq(queryParamVO.getCustType()));
        }
        //客户归类
        if (!StringUtils.isEmpty(queryParamVO.getCustType2())) {
            predicate = ExpressionUtils.and(predicate, qCrmCustDO.custType2.eq(queryParamVO.getCustType2()));
        }
        //客户等级
        if (!StringUtils.isEmpty(queryParamVO.getCustLevel())) {
            predicate = ExpressionUtils.and(predicate, qCrmCustDO.custLevel.eq(queryParamVO.getCustLevel()));
        }
        //税务登记号
        if (!StringUtils.isEmpty(queryParamVO.getTaxRegNo())) {
            predicate = ExpressionUtils.and(predicate, qCrmCustDO.taxRegNo.like("%" + queryParamVO.getTaxRegNo() + "%"));
        }
        //客户编码集合
        if (!CollectionUtils.isEmpty(queryParamVO.getCustCodes())) {
            predicate = ExpressionUtils.and(predicate, qCrmCustDO.custCode.in(queryParamVO.getCustCodes()));
        }
        //客户id集合
        if (!CollectionUtils.isEmpty(queryParamVO.getCustIds())) {
            predicate = ExpressionUtils.and(predicate, qCrmCustDO.id.in(queryParamVO.getCustIds()));
        }
        //客户英文名称
//        if (!StringUtils.isEmpty(queryParamVO.getCustCode2())) {
//            predicate = ExpressionUtils.and(predicate, qCrmCustDO.custCode2.like("%" + queryParamVO.getCustCode2() + "%"));
//        }
        //业务员id
        if (!StringUtils.isEmpty(queryParamVO.getAgentEmpId())) {
            predicate = ExpressionUtils.and(predicate, qCrmCustDO.agentEmpId.eq(queryParamVO.getAgentEmpId()));
        }
        //公司id
        if (!StringUtils.isEmpty(queryParamVO.getOuId())) {
            //通过公司Id查询客户公司拓展表,查到所有的客户编码
            CrmCustOuParamVO crmCustOuParamVO = new CrmCustOuParamVO();
            crmCustOuParamVO.setOuId(queryParamVO.getOuId());
            crmCustOuParamVO.setIfTrans(false);
            List<CrmCustOuSaveVO> custOuSaveVOS = crmCustOuService.search(crmCustOuParamVO);
            if (!CollectionUtils.isEmpty(custOuSaveVOS)) {
                List<String> custCodes = custOuSaveVOS.stream().map(CrmCustOuSaveVO::getCustCode).distinct().collect(Collectors.toList());
                if (!CollectionUtils.isEmpty(custCodes)) {
                    predicate = ExpressionUtils.and(predicate, qCrmCustDO.custCode.in(custCodes).or(qCrmCustDO.ouId.eq(queryParamVO.getOuId())));
                } else {
                    predicate = ExpressionUtils.and(predicate, qCrmCustDO.ouId.eq(queryParamVO.getOuId()));
                }
            } else {
                predicate = ExpressionUtils.and(predicate, qCrmCustDO.ouId.eq(queryParamVO.getOuId()));
            }
        }
        //组织id
        if (!StringUtils.isEmpty(queryParamVO.getBuId())) {
            predicate = ExpressionUtils.and(predicate, qCrmCustDO.buId.eq(queryParamVO.getBuId()));
        }
        //客户名称
        if (!StringUtils.isEmpty(queryParamVO.getCustName())) {
            predicate = ExpressionUtils.and(predicate, qCrmCustDO.custName.like("%" + queryParamVO.getCustName() + "%"));
        }
        //客户简称
        if (!StringUtils.isEmpty(queryParamVO.getCustAbbr())) {
            predicate = ExpressionUtils.and(predicate, qCrmCustDO.custAbbr.like("%" + queryParamVO.getCustAbbr() + "%"));
        }
        //客户地址号
        if (!CollectionUtils.isEmpty(queryParamVO.getAddrNos())) {
            predicate = ExpressionUtils.and(predicate, qCrmCustDO.addrNo.in(queryParamVO.getAddrNos()));
        }
        //客户类型
        if (!StringUtils.isEmpty(queryParamVO.getInnerFlag())) {
            if (queryParamVO.getInnerFlag().equals(Boolean.TRUE)) {
                predicate = ExpressionUtils.and(predicate, qCrmCustDO.custType2.eq(UdcEnum.CRM_CUST_TYPE2_C.getValueCode()));
                predicate = ExpressionUtils.or(predicate, qCrmCustDO.custType2.eq(UdcEnum.CRM_CUST_TYPE2_D.getValueCode()));
            } else {
                predicate = ExpressionUtils.and(predicate, qCrmCustDO.custType2.ne(UdcEnum.CRM_CUST_TYPE2_C.getValueCode()));
                predicate = ExpressionUtils.and(predicate, qCrmCustDO.custType2.ne(UdcEnum.CRM_CUST_TYPE2_D.getValueCode()));
            }
        }
        predicate = ExpressionUtils.and(predicate, qCrmCustDO.deleteFlag.ne(ConstantsSale.COMMON_DELETE_YSE));

        Iterable<CrmCustDO> crmCustRepoAll = crmCustRepo.findAll(predicate);
        List<CrmCustDO> crmCustDOS = new ArrayList<>();
        crmCustRepoAll.forEach(crmCustDOS::add);
        return crmCustDOS;

    }
}
