package com.elitesland.yst.production.sale.service;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.lang.Assert;
import com.elitescloud.boot.auth.cas.model.AuthUserDTO;
import com.elitescloud.boot.auth.util.SecurityContextUtil;
import com.elitescloud.boot.core.support.verifycode.common.VerifyCodeManager;
import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.security.entity.GeneralUserDetails;
import com.elitescloud.cloudt.system.dto.req.UserCreateDTO;
import com.elitescloud.cloudt.system.vo.SysUserDTO;
import com.elitesland.yst.production.sale.api.service.CustAccountService;
import com.elitesland.yst.production.sale.api.vo.resp.crm.CustAccountVO;
import com.elitesland.yst.production.sale.api.vo.save.CheckKapchaParam;
import com.elitesland.yst.production.sale.api.vo.save.CustAccountEnableVO;
import com.elitesland.yst.production.sale.api.vo.save.CustAccountUpdateVO;
import com.elitesland.yst.production.sale.entity.CustAccountDO;
import com.elitesland.yst.production.sale.repo.CrmCustRepo;
import com.elitesland.yst.production.sale.repo.CustAccountRepo;
import com.elitesland.yst.production.sale.repo.CustAccountRepoProc;
import com.elitesland.yst.production.sale.rmi.ystsystem.RmiSysUserService;
import jodd.util.StringUtil;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.ObjectUtils;

import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;


@Service
@Slf4j
public class CustAccountServiceImpl implements CustAccountService {

    @Autowired
    private  CustAccountRepo custAccountRepo;

    @Autowired
    private  RmiSysUserService rmiSysUserService;

    @Autowired
    private  CrmCustRepo crmCustRepo;

    @Autowired
    private  CustAccountRepoProc custAccountRepoProc;

    @Autowired
    private VerifyCodeManager verifyCodeManager;

//    @Autowired
//    private CasUserClientHelper casUserClientHelper;



    public static final String PWD_MATCHES = "(?=.*[0-9])(?=.*[a-zA-Z]).{6,}";

    private final static String BUSINESS_TYPE_RETRIEVE_PWD = "yst_sale_retrieve_pwd";


    @Override
    public List<AuthUserDTO> createUser(List<String> custCodes) {
        if(CollectionUtil.isEmpty(custCodes)){
            throw new BusinessException("请选择需要生成用户的数据");
        }
        List<AuthUserDTO> res = new ArrayList<>();
      //  List<Long> res = new ArrayList<>();
        custCodes.forEach(custCode ->{
            CustAccountDO account = custAccountRepoProc.getByCustCode(custCode);
            if(Boolean.TRUE.equals(account.getIsOpenAccount())){
                throw new BusinessException(custCode + "已经开通过账号");
            }
            this.checkUserName(account.getUserName());
            AuthUserDTO authUser = this.excuteUserInfo(account);
            res.add(authUser);
       //     Long userId = casUserClientHelper.onUpsert(authUser);
          //  UserCreateDTO userCreateDTO = this.excuteUserParam(account);
            //Long userId = rmiSysUserService.createUser(userCreateDTO);
            //更新账户表用户ID和创建时间
//            account.setUserId(userId);
//            custAccountRepo.save(account);
//            res.add(userId);

        });
        return res;
    }

    public void checkUserName(String userName){
        //账号重复校验
        List<CustAccountVO> custAccount = custAccountRepoProc.getAccountListByUserName(userName);
        if(!CollectionUtil.isEmpty(custAccount) && custAccount.size() >= 1){
            throw new BusinessException("此账号已经存在！");
        }
    }

    public AuthUserDTO excuteUserInfo(CustAccountDO custAccountDO){
        AuthUserDTO authUser = new AuthUserDTO();
        authUser.setUsername(custAccountDO.getUserName());
        authUser.setPassword(custAccountDO.getPwd());
        authUser.setMobile(custAccountDO.getMobile());
        authUser.setEnabled(true);
        return authUser;
    }

    @Override
    public ApiResult<SysUserDTO> updatePwd(CustAccountUpdateVO custAccountUpdate) {
        //获取当前用户
        GeneralUserDetails userDetails = SecurityContextUtil.currentUser();
        if(Objects.isNull(userDetails) || Objects.isNull(userDetails.getUser())){
            return ApiResult.fail("获取当前用户信息失败");
        }
        SysUserDTO sysUser = userDetails.getUser();
        //SysUserDTO sysUser = rmiSysUserService.currentUser();
        if(ObjectUtils.isEmpty(sysUser)){
            return ApiResult.fail("用户信息获取失败");
        }
        String mobile = sysUser.getMobile();
        String verify = verifyCodeManager.verify(BUSINESS_TYPE_RETRIEVE_PWD, mobile, custAccountUpdate.getKaptcha());
        if (!org.springframework.util.ObjectUtils.isEmpty(verify)){
            return ApiResult.fail(verify);
        }
        CustAccountVO custAccount = custAccountRepoProc.getAccountByUserId(sysUser.getId());
//        if(sysUser.getUserType().equals("STORE")){
//            custAccount = custAccountRepoProc.getAccountByUserName(sysUser.getUsername());
//        }else {
//            custAccount = custAccountRepoProc.getAccountByMobile(sysUser.getUsername());
//        }
//        CustAccountVO custAccount = custAccountRepoProc.getAccountByUserName(sysUser.getUsername());

        ApiResult<SysUserDTO> check = this.checkPwd(custAccountUpdate,custAccount);
        if(!check.isSuccess()){
           return check;
        }
//        Long userId = casUserClientHelper.onUpdatePassword(sysUser.getId(),custAccountUpdate.getNewPwd());
  //      Long userId = rmiSysUserService.updatePwd(sysUser.getId(),custAccountUpdate.getNewPwd());
        //更新账户表里面的密码
      //  this.updateCustAccount(custAccount,custAccountUpdate);
        return ApiResult.ok(sysUser);
    }

    @Override
    public ApiResult<String> checkKaptcha(CheckKapchaParam param) {
        if(StringUtil.isEmpty(param.getMobile()) || StringUtil.isEmpty(param.getKaptcha())){
            return ApiResult.fail("参数不能为空！");
        }
        String verify = verifyCodeManager.verify(BUSINESS_TYPE_RETRIEVE_PWD, param.getMobile(), param.getKaptcha());
        if (!org.springframework.util.ObjectUtils.isEmpty(verify)){
            return ApiResult.fail(verify);
        }
        return ApiResult.ok();
    }


    @Override
    public void updateCustAccount(CustAccountVO custAccountVO,CustAccountUpdateVO custAccountUpdate){
        CustAccountDO custAccountDO = new CustAccountDO();
        BeanUtils.copyProperties(custAccountVO,custAccountDO);
        custAccountDO.setPwd(custAccountUpdate.getNewPwd());
        custAccountDO.setUpdatePwdTime(LocalDateTime.now());
        custAccountRepo.save(custAccountDO);
    }

    @Override
    public void updateAccountPwd(Long userId, CustAccountUpdateVO custAccountUpdate) {
        CustAccountDO account = custAccountRepoProc.getByUserId(userId);
        account.setPwd(custAccountUpdate.getNewPwd());
        account.setUpdatePwdTime(LocalDateTime.now());
        account.setIsModifyPwd(Boolean.TRUE);
        custAccountRepo.save(account);
    }

    @Override
    public List<CustAccountVO> getByCustCodes(CustAccountEnableVO custAccountEnableVO) {
        if(Objects.isNull(custAccountEnableVO)){
            throw new BusinessException("参数为空！");
        }
        Assert.notNull(custAccountEnableVO.getCustCodes(),"客户编号不能为空！");
        Assert.notNull(custAccountEnableVO.getEnable(),"状态不能为空！");
        List<CustAccountVO> res = custAccountRepoProc.getAccountByCustCode(custAccountEnableVO.getCustCodes());
        return res;
    }

    @Override
    public List<CustAccountVO> getByUserName(List<String> userNames) {
        Assert.notNull(userNames,"客户手机号不能为空！");
        return custAccountRepoProc.getAccountByUserNames(userNames);
    }

    @Override
    public List<CustAccountVO> getByUserNameAndSource(List<String> userNames,List<String> dealerTypes,String businessTypeCust) {
        Assert.notNull(userNames,"客户手机号不能为空！");
        return custAccountRepoProc.getAccountByUserNamesAndSource(userNames,dealerTypes,businessTypeCust);
    }

    @Override
    public List<CustAccountVO> getByCustCodes(List<String> custCodes) {
        Assert.notNull(custCodes,"客户编号不能为空！");
        return custAccountRepoProc.getAccountByCustCode(custCodes);
    }



    public List<CustAccountVO> getByCustCodesAndUserName(String custCode,String userName,List<String> dealerTypes) {
        Assert.notNull(custCode,"客户编号不能为空！");
        return custAccountRepoProc.getByCustCodesAndUserName(custCode,userName,dealerTypes);
    }
    @Override
    public List<Long> updateAccountEnable(List<Long> accountIds, Boolean enable) {
        List<CustAccountDO> list = custAccountRepo.findAllById(accountIds);
        List<Long> res = new ArrayList<>();
        list.forEach(l ->{
            l.setEnable(enable);
            res.add(l.getId());
        });
        custAccountRepo.saveAll(list);
        return res;
    }

    @Override
    public void deleteAccount(List<Long> ids) {
        List<CustAccountDO> list = custAccountRepo.findAllById(ids);
        list.forEach(l ->{
            l.setDeleteFlag(1);
        });
        custAccountRepo.saveAll(list);
    }




    public ApiResult<SysUserDTO> checkPwd(CustAccountUpdateVO custAccountUpdateVO,CustAccountVO custAccount){
        if(ObjectUtils.isEmpty(custAccountUpdateVO)){
            return ApiResult.fail("密码信息为空");
        }
        if(!custAccountUpdateVO.getNewPwd().equals(custAccountUpdateVO.getConfirmPwd())){
            return ApiResult.fail("密码不一致！");
        }
        if(ObjectUtils.isEmpty(custAccount)){
            return ApiResult.fail("查询账户信息失败！");
        }
        String pwd = custAccount.getPwd();
            if(!custAccountUpdateVO.getOldPwd().equals(pwd)){
            return ApiResult.fail("旧密码不匹配！");
        }
        if(!custAccountUpdateVO.getNewPwd().matches(PWD_MATCHES)){
            return ApiResult.fail("密码必须包含数字字母不能少于6位");
        }
        return ApiResult.ok();
    }


    public UserCreateDTO excuteUserParam(CustAccountDO custAccountDO){
        UserCreateDTO userCreateDTO = new UserCreateDTO();
        userCreateDTO.setEnabled(true);
        userCreateDTO.setUsername(custAccountDO.getUserName());
        userCreateDTO.setPassword(custAccountDO.getPwd());
        userCreateDTO.setMobile(custAccountDO.getMobile());
        return userCreateDTO;
    }


}
