package com.elitesland.yst.production.sale.service;

import com.elitescloud.boot.excel.common.DataExport;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.yst.production.sale.api.service.CrmCustService;
import com.elitesland.yst.production.sale.api.vo.param.crm.CustPredictionParamVO;
import com.elitesland.yst.production.sale.api.vo.resp.crm.CustSalePredictionVO;
import lombok.RequiredArgsConstructor;
import org.springframework.stereotype.Component;

@Component
@RequiredArgsConstructor
public class CustPredictionExportService implements DataExport<CustSalePredictionVO, CustPredictionParamVO> {


    private final CrmCustService crmCustService;

    @Override
    public String getTmplCode() {
        return "cust_prediction_export";
    }


    @Override
    public PagingVO<CustSalePredictionVO> executeExport(CustPredictionParamVO queryParam) {
        return crmCustService.queryCustSalePrediction(queryParam);
    }
}
