package com.elitesland.yst.production.sale.service.shop;

import cn.hutool.core.collection.IterUtil;
import cn.hutool.core.lang.Assert;
import com.alibaba.fastjson.JSON;
import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.cloudt.common.annotation.SysCodeProc;
import com.elitescloud.cloudt.common.base.ApiCode;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.yst.production.sale.api.service.shop.BipCouponService;
import com.elitesland.yst.production.sale.api.service.shop.BipOrderService;
import com.elitesland.yst.production.sale.api.vo.param.shop.BipCouponIndexImgVO;
import com.elitesland.yst.production.sale.api.vo.param.shop.BipCouponOrderVO;
import com.elitesland.yst.production.sale.api.vo.param.shop.BipCouponQueryParamVO;
import com.elitesland.yst.production.sale.api.vo.resp.shop.BipCouPonIndexShowVO;
import com.elitesland.yst.production.sale.api.vo.resp.shop.BipCouponVO;
import com.elitesland.yst.production.sale.api.vo.save.shop.BipCouponSaveVO;
import com.elitesland.yst.production.sale.api.vo.save.shop.BipItemVO;
import com.elitesland.yst.production.sale.api.vo.save.shop.BipMessageSaveVO;
import com.elitesland.yst.production.sale.common.model.CurrentUserDTO;
import com.elitesland.yst.production.sale.convert.shop.BipCouponConvert;
import com.elitesland.yst.production.sale.convert.shop.BipMessageConvert;
import com.elitesland.yst.production.sale.core.service.UserService;
import com.elitesland.yst.production.sale.entity.*;
import com.elitesland.yst.production.sale.repo.shop.*;
import com.elitesland.yst.production.sale.rmi.ystsystem.RmiSysNextNumberService;
import com.elitesland.yst.production.support.provider.org.dto.OrgUserEmpInfoRpcDTO;
import com.elitesland.yst.production.support.provider.org.service.OrgEmpRpcService;
import com.google.common.collect.Lists;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.dsl.BooleanExpression;
import jodd.util.StringUtil;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import lombok.val;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.StringUtils;

import java.time.Duration;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;

import static com.elitesland.yst.production.sale.common.constant.UdcEnum.*;

/**
 * <p>
 * 优惠卷业务实现
 * </p>
 *
 * @author Shadow
 * @since 2021-08-11 09:17:11
 */
@Slf4j
@Service
@RequiredArgsConstructor
public class BipCouponServiceImpl implements BipCouponService {

    private final BipCouponRepo bipCouponRepo;

    private final BipCouponRepoProc bipCouponRepoProc;

    private final BipCouponItemRepo bipCouponItemRepo;

    private final RmiSysNextNumberService nextNumberService;

    private final BipCustUserBindRepoProc bipCustUserBindRepoProc;

    @Autowired
    private  BipOrderService bipOrderService;

    private final BipCouponCustRepo bipCouponCustRepo;

    private final BipCouponCustRepoProc bipCouponCustRepoProc;

    private final OrgEmpRpcService orgEmpRpcService;

    private final BipCouponIndexImgRepo bipCouponIndexImgRepo;

    private final BipMessageRepo bipMessageRepo;

    private final BipMessageRepoProc bipMessageRepoProc;

    private final BipCustUserBindRepo bipCustUserBindRepo;


    @Override
    public BipCouponIndexImgVO searchBackImg() {
        OrgUserEmpInfoRpcDTO empInfo = getCurrentEmpInfo();
        if(null != empInfo.getOuId()){
            QBipCouponIndexImgDO qBipCouponIndexImgDO = QBipCouponIndexImgDO.bipCouponIndexImgDO;
            BooleanExpression expression = qBipCouponIndexImgDO.ouId.eq(empInfo.getOuId()).and(qBipCouponIndexImgDO.deleteFlag.eq(0));
            Optional<BipCouponIndexImgDO> optional = bipCouponIndexImgRepo.findOne(expression);
            if(optional.isPresent()){
                BipCouponIndexImgDO imgDO = optional.get();
                BipCouponIndexImgVO vo = new BipCouponIndexImgVO();
                BeanUtils.copyProperties(imgDO,vo);
                return vo;
            }
        }
        return null;
    }

    @Override
    public Long delBackImg() {
        OrgUserEmpInfoRpcDTO empInfo = getCurrentEmpInfo();
        if(null == empInfo || null == empInfo.getUserId() || null == empInfo.getOuId()){
            throw new BusinessException("未找到用户信息");
        }
        QBipCouponIndexImgDO qBipCouponIndexImgDO = QBipCouponIndexImgDO.bipCouponIndexImgDO;
        BooleanExpression expression = qBipCouponIndexImgDO.ouId.eq(empInfo.getOuId()).and(qBipCouponIndexImgDO.deleteFlag.eq(0));
        Optional<BipCouponIndexImgDO> optional = bipCouponIndexImgRepo.findOne(expression);
        if(optional.isPresent()){
            BipCouponIndexImgDO imgDO = optional.get();
            imgDO.setDeleteFlag(1);
            bipCouponIndexImgRepo.save(imgDO);
            return imgDO.getId();
        }
        return null;
    }

    @Override
    public Long saveBackImg(BipCouponIndexImgVO bipCouponIndexImgVO) {
        OrgUserEmpInfoRpcDTO empInfo = getCurrentEmpInfo();
        if(null == bipCouponIndexImgVO.getId()){
            //新增
            BipCouponIndexImgDO bipCouponIndexImgDO = new BipCouponIndexImgDO();
            BeanUtils.copyProperties(bipCouponIndexImgVO,bipCouponIndexImgDO);
            bipCouponIndexImgDO.setOuId(empInfo.getOuId());
            bipCouponIndexImgDO.setOuName(empInfo.getOuName());
            bipCouponIndexImgRepo.save(bipCouponIndexImgDO);
        }else {
//            QBipCouponIndexImgDO qBipCouponIndexImgDO = QBipCouponIndexImgDO.bipCouponIndexImgDO;
//            BooleanExpression expression = qBipCouponIndexImgDO.id.eq(bipCouponIndexImgVO.getId()).and(qBipCouponIndexImgDO.deleteFlag.eq(0)).and(qBipCouponIndexImgDO.ouId.eq(empInfo.getOuId()));
            Optional<BipCouponIndexImgDO> optional = bipCouponIndexImgRepo.findById(bipCouponIndexImgVO.getId());
            if(optional.isPresent()){
                BipCouponIndexImgDO imgDO = optional.get();
                imgDO.setDeleteFlag(1);
                bipCouponIndexImgRepo.save(imgDO);
                BipCouponIndexImgDO bipCouponIndexImgDO = new BipCouponIndexImgDO();
                BeanUtils.copyProperties(bipCouponIndexImgVO,bipCouponIndexImgDO);
                bipCouponIndexImgDO.setOuId(empInfo.getOuId());
                bipCouponIndexImgDO.setOuName(empInfo.getOuName());
                bipCouponIndexImgDO.setId(null);
                bipCouponIndexImgRepo.save(bipCouponIndexImgDO);

            }
        }
        return null;
    }

    @Override
    @SysCodeProc
    public BipCouPonIndexShowVO findHomeCoupon() {
        //CurrentUserDTO currentUser = UserService.currentUser();
        Long ouId = getCurrentOuIdInfo();
        //是否支付过，新人券是要没支付过的用户领取
        CurrentUserDTO currentUser = UserService.currentUser();
        log.info("查询首页优惠券：ouId:"+ouId+" userId:"+currentUser.getUserId());

        Boolean isPay = bipOrderService.isFirstOrder(currentUser.getUserId(),"ps");
        if (null == ouId) {
            return null;
        }
        QBipCouponDO qBipCouponDO = QBipCouponDO.bipCouponDO;
        BooleanExpression expression = qBipCouponDO.ouId.eq(ouId)
                .and(qBipCouponDO.deleteFlag.eq(0))
                .and(qBipCouponDO.state.eq(SAL_COUPON_STATE_ACTIVE.getValueCode()))
                .and(qBipCouponDO.totalNum.gt(0))
                .and(qBipCouponDO.specialAreaStime.loe(LocalDateTime.now()))
                .and(qBipCouponDO.specialAreaEtime.goe(LocalDateTime.now()));
        //是否弹出
        expression = expression.and(qBipCouponDO.indexPageShow.eq("1"));
        //是否新用户 支付过是老用户 0不是  1是
        if (isPay) {
            expression = expression.and(qBipCouponDO.newCustShow.eq("0"));
        }
        Iterable<BipCouponDO> iterables = bipCouponRepo.findAll(expression);
        List<BipCouponVO> resList = new ArrayList<>();
        if (!IterUtil.isEmpty(iterables)) {
            List<BipCouponDO> list = Lists.newArrayList(iterables);
            for (BipCouponDO l : list) {
                BipCouponVO bipCouponVO = new BipCouponVO();
                BeanUtils.copyProperties(l, bipCouponVO);
                resList.add(bipCouponVO);
            }
        }

        BipCouPonIndexShowVO vo = new BipCouPonIndexShowVO();
        vo.setOuId(ouId);
        vo.setUserId(currentUser.getUserId());

        if(!resList.isEmpty()){
            // 过滤已领取
            Long userId = UserService.currentUser().getUserId();
            List<BipCouponVO> collect = resList.stream().filter(c -> {
                if (bipCouponCustRepoProc.isReceived(c.getCouponCode(), userId)) {
                    return false;
                }
                return true;
            }).limit(3).collect(Collectors.toList());
            vo.setBipCouponList(collect);

            //查询优惠券背景图 通过ouId查询公司上传的优惠券背景图
            BipCouponIndexImgDO d = getIndexImgByOuId(ouId);
            BipCouponIndexImgVO bipCouponIndexImgVO = new BipCouponIndexImgVO();
            BeanUtils.copyProperties(d,bipCouponIndexImgVO);
            vo.setBipCouponIndexImgVO(bipCouponIndexImgVO);

        }else {
            vo.setBipCouponList(Collections.emptyList());
        }

        // 每次进入首页创建优惠券过期提醒消息
        createWillInvalidMessage();

        log.info("优惠券："+ JSON.toJSONString(vo));

        return vo;
    }

    /**
     * 创建优惠券过期提醒消息
     */
    private void createWillInvalidMessage(){

        Assert.notNull(UserService.currentUser(),"请先登录!");
        Long userId = UserService.currentUser().getUserId();

        QBipCustUserBindDO qBipCustUserBindDO = QBipCustUserBindDO.bipCustUserBindDO;
        BooleanExpression e = qBipCustUserBindDO.deleteFlag.eq(0).and(qBipCustUserBindDO.userId.eq(userId));
        Optional<BipCustUserBindDO> optionalBind = bipCustUserBindRepo.findOne(e);
        BipCustUserBindDO bipCustUserBindDO = new BipCustUserBindDO();
        if(!optionalBind.isEmpty()){
            bipCustUserBindDO = optionalBind.get();
            if(null == bipCustUserBindDO.getCustId()){
                throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "当前用户未绑定客户，不能领取优惠券");
            }
        }else {
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "当前用户未绑定客户，不能领取优惠券");
        }
        List<BipCouponCustDo> records = bipCouponCustRepoProc.findCouponRecordByUserID(userId,bipCustUserBindDO.getCustId());

        List<BipCouponDO> resList = new ArrayList<>();
        for (BipCouponCustDo record : records) {
            Long couponId = record.getCouponId();
            Optional<BipCouponDO> optional = bipCouponRepo.findById(couponId);
            optional.ifPresent(couponDO -> {
                //提前几天通知
                Integer notifyDays = couponDO.getNotifyDays();
                if (null != notifyDays) {
                    LocalDateTime notifyDateTime = couponDO.getValidEtime();
                    Duration duration = Duration.between(LocalDateTime.now(), notifyDateTime);
                    long days = duration.toDays();
                    if (days <= notifyDays) {
                        resList.add(couponDO);
                    }
                }
            });
        }

        // 创建优惠券过期提醒
        List<BipMessageDO> list = new ArrayList<>();

        for (BipCouponDO couponCustVO : resList) {

            // 检查是否存在
            if (bipMessageRepoProc.checkExist(couponCustVO.getId(),"COUPON",userId)) {
                continue;
            }

            BipMessageSaveVO param = new BipMessageSaveVO();

            param.setTitle("【优惠券即将过期】");
            param.setStatus(MESSAGE_STATUS_NOTREAD.getValueCode());
            param.setToCustId(userId);
            param.setContext("您的优惠券"+couponCustVO.getCouponName()+"即将过期，请尽快使用");
            param.setBusinessId(couponCustVO.getId());
            param.setBusinessType("COUPON");

            BipMessageDO bipMessageDO = BipMessageConvert.INSTANCE.voToDo(param);
            list.add(bipMessageDO);
        }

        bipMessageRepo.saveAll(list);

    }

    @Override
    public BipCouPonIndexShowVO findCouponIndexShow() {
        BipCouPonIndexShowVO vo = new BipCouPonIndexShowVO();
        //CurrentUserDTO currentUser = UserService.currentUser();
        OrgUserEmpInfoRpcDTO empInfo = getCurrentEmpInfo();
        Long ouId = empInfo.getOuId();
        //是否支付过，新人券是要没支付过的用户领取
        CurrentUserDTO currentUser = UserService.currentUser();
        Boolean isPay = bipOrderService.isFirstOrder(currentUser.getUserId(),"ps");
        if (null == ouId) {
            return null;
        }
        QBipCouponDO qBipCouponDO = QBipCouponDO.bipCouponDO;
        BooleanExpression expression = qBipCouponDO.ouId.eq(ouId).and(qBipCouponDO.indexPageShow.eq("1")).and(qBipCouponDO.deleteFlag.eq(0)).and(qBipCouponDO.state.eq(SAL_COUPON_STATE_ACTIVE.getValueCode())).and(qBipCouponDO.totalNum.gt(0)).and(qBipCouponDO.specialAreaStime.gt(LocalDateTime.now())).and(qBipCouponDO.specialAreaEtime.lt(LocalDateTime.now()));
        //是否新用户 支付过是老用户
        if (isPay) {
            expression = expression.and(qBipCouponDO.newCustShow.eq("0"));
        }
        Iterable<BipCouponDO> iterables = bipCouponRepo.findAll(expression);
        List<BipCouponVO> resList = new ArrayList<>();
        if (!IterUtil.isEmpty(iterables)) {
            List<BipCouponDO> list = Lists.newArrayList(iterables);
            list.stream().forEach(l -> {
                BipCouponVO bipCouponVO = new BipCouponVO();
                BeanUtils.copyProperties(l, bipCouponVO);
                resList.add(bipCouponVO);
            });
        }
        if(null != resList && !resList.isEmpty()){
            vo.setBipCouponList(resList);
            //查询优惠券背景图 通过ouId查询公司上传的优惠券背景图
            BipCouponIndexImgDO d = getIndexImgByOuId(ouId);
            BipCouponIndexImgVO bipCouponIndexImgVO = new BipCouponIndexImgVO();
            BeanUtils.copyProperties(d,bipCouponIndexImgVO);
            vo.setBipCouponIndexImgVO(bipCouponIndexImgVO);
        }
        return vo;
    }

    public BipCouponIndexImgDO getIndexImgByOuId(Long ouId){
        QBipCouponIndexImgDO qBipCouponIndexImgDO = QBipCouponIndexImgDO.bipCouponIndexImgDO;
        BooleanExpression expression = qBipCouponIndexImgDO.ouId.eq(ouId).and(qBipCouponIndexImgDO.deleteFlag.eq(0));
        Optional<BipCouponIndexImgDO> optional = bipCouponIndexImgRepo.findOne(expression);
        if(optional.isPresent()){
            return optional.get();
        }
        return null;
    }

    @Override
    public void delCoupon(List<Long> ids) {
        if (null != ids && !ids.isEmpty()) {
            ids.stream().forEach(id -> {
                Optional<BipCouponDO> optional = bipCouponRepo.findById(id);
                if(optional.isPresent()){
                    BipCouponDO bipCouponDO = optional.get();
                    bipCouponDO.setDeleteFlag(1);
                    bipCouponRepo.save(bipCouponDO);
                    QBipCouponItemDO qBipCouponItemDO = QBipCouponItemDO.bipCouponItemDO;
                    BooleanExpression expression = qBipCouponItemDO.couponId.eq(id);
                    Iterable<BipCouponItemDO> items = bipCouponItemRepo.findAll(expression);
                    if (!IterUtil.isEmpty(items)) {
                        List<BipCouponItemDO> list = Lists.newArrayList(items);
                        list.stream().forEach(l ->{
                            l.setDeleteFlag(1);
                            bipCouponItemRepo.save(l);
                        });
                    }
                }
            });
        }
    }

    @Override
    public void disableCoupon(List<Long> ids) {
        if (null != ids && !ids.isEmpty()) {
            ids.stream().forEach(id -> {
                Optional<BipCouponDO> optional = bipCouponRepo.findById(id);
                if (optional.isPresent()) {
                    BipCouponDO bipCouponDO = optional.get();
                    bipCouponDO.setState(SAL_COUPON_STATE_DISABLE.getValueCode());
                    bipCouponRepo.save(bipCouponDO);
                }
            });
        }
    }

    @Override
    public void activeCoupon(List<Long> ids) {
        if (null != ids && !ids.isEmpty()) {
            ids.stream().forEach(id -> {
                Optional<BipCouponDO> optional = bipCouponRepo.findById(id);
                if (optional.isPresent()) {
                    BipCouponDO bipCouponDO = optional.get();
                    bipCouponDO.setState(SAL_COUPON_STATE_ACTIVE.getValueCode());
                    bipCouponRepo.save(bipCouponDO);
                }
            });
        }
    }

    @Override
    public Boolean checkRepeatCouponItem(Long ouId, Long couponId) {
        BipCouponDO bipCouponDO = getCouponById(couponId);
        if(null != bipCouponDO && StringUtil.isNotBlank(bipCouponDO.getIndexPageShow()) && bipCouponDO.getIndexPageShow().equals("1")){
            //查询公司下优惠券首页弹出激活数量
            Long couponActiveNum = getCouponActivePageShowNum(ouId);
            if(couponActiveNum > 2){
                throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "公司下激活首页弹出优惠券数量不能大于3");
            }
        }
        if(null != bipCouponDO && StringUtil.isNotBlank(bipCouponDO.getNewCustShow()) && bipCouponDO.getNewCustShow().equals("1")){
            //新人券不能超过7  是否新人专享 0不是  1是
            //查询公司下新人券激活数量  newCustShow
            Long couponNewCustActiveNum = getCouponNewCustActiveNum(ouId);
            if(couponNewCustActiveNum > 6){
                throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "公司下激活新人专享优惠券数量不能大于7");
            }
        }
        //查询公司下所有优惠券skuId
        List<Long> allSkuIds = getAllSkuIdByCouponId(ouId);
        //查询这个优惠券下面的skuId
        List<Long> couponSkuId = getByCouponId(couponId);
        //交集  如果不为空的话就说明有重复
        List<Long> intersection = allSkuIds.stream().filter(item -> couponSkuId.contains(item)).collect(Collectors.toList());
        if(null == intersection || intersection.isEmpty() ){
            return true;
        }
        return false;
    }


    public BipCouponDO getCouponById(Long couponId){
        Optional<BipCouponDO> optional = bipCouponRepo.findById(couponId);
        if(optional.isPresent()){
            return optional.get();
        }
        return null;
    }



    public Long getCouponNewCustActiveNum(Long ouId){
        QBipCouponDO qBipCouponDO = QBipCouponDO.bipCouponDO;
        BooleanExpression expression = qBipCouponDO.deleteFlag.eq(0).and(qBipCouponDO.newCustShow.eq("1")).and(qBipCouponDO.ouId.eq(ouId)).and(qBipCouponDO.state.eq(SAL_COUPON_STATE_ACTIVE.getValueCode()));
        return bipCouponRepo.count(expression);
    }



    public Long getCouponActivePageShowNum(Long ouId){
        QBipCouponDO qBipCouponDO = QBipCouponDO.bipCouponDO;
        BooleanExpression expression = qBipCouponDO.deleteFlag.eq(0).and(qBipCouponDO.indexPageShow.eq("1")).and(qBipCouponDO.ouId.eq(ouId)).and(qBipCouponDO.state.eq(SAL_COUPON_STATE_ACTIVE.getValueCode()));
        return bipCouponRepo.count(expression);
    }

    /**
     * 查询某个优惠券下面的商品
     * @param couponId
     * @return
     */
    public List<Long> getByCouponId(Long couponId){
        QBipCouponItemDO qBipCouponItemDO = QBipCouponItemDO.bipCouponItemDO;
        BooleanExpression expression = qBipCouponItemDO.couponId.eq(couponId).and(qBipCouponItemDO.deleteFlag.eq(0));
        Iterable<BipCouponItemDO> iterables = bipCouponItemRepo.findAll(expression);
        if(!IterUtil.isEmpty(iterables)){
            List<BipCouponItemDO> list = Lists.newArrayList(iterables);
            return list.stream().map(BipCouponItemDO :: getSkuId).collect(Collectors.toList());
        }
        return null;
    }

    /**
     * 查询公司下所有优惠券商品
     * @param ouId
     * @return
     */
    public List<Long> getAllSkuIdByCouponId(Long ouId){
        List<Long> skuIdList = new ArrayList<>();
        QBipCouponDO qBipCouponDO = QBipCouponDO.bipCouponDO;
        QBipCouponItemDO qBipCouponItemDO = QBipCouponItemDO.bipCouponItemDO;
//        BooleanExpression e = qBipCouponDO.ouId.eq(ouId).and(qBipCouponDO.state.eq(UdcEnum.SAL_COUPON_STATE_ACTIVE.getValueCode())).and(qBipCouponDO.validStime.lt(LocalDateTime.now())).and(qBipCouponDO.validEtime.gt(LocalDateTime.now())).and(qBipCouponDO.deleteFlag.eq(0));
        BooleanExpression e = qBipCouponDO.ouId.eq(ouId).and(qBipCouponDO.state.eq(SAL_COUPON_STATE_ACTIVE.getValueCode())).and(qBipCouponDO.deleteFlag.eq(0));
        Iterable<BipCouponDO> iterables = bipCouponRepo.findAll(e);
        if(!IterUtil.isEmpty(iterables)){
            List<BipCouponDO> list = Lists.newArrayList(iterables);
            list.stream().forEach(l ->{
                BooleanExpression expression = qBipCouponItemDO.couponId.eq(l.getId()).and(qBipCouponItemDO.deleteFlag.eq(0));
                Iterable<BipCouponItemDO> iters = bipCouponItemRepo.findAll(expression);
                if(!IterUtil.isEmpty(iters)){
                    List<BipCouponItemDO> itemList = Lists.newArrayList(iters);
                    List<Long> skuIds = itemList.stream().map(BipCouponItemDO :: getSkuId).collect(Collectors.toList());
                    skuIdList.addAll(skuIds);
                }
            });
        }
        return skuIdList;
    }



    @Override
    @SysCodeProc
    public BipCouponSaveVO findById(Long id) {
        BipCouponSaveVO bipCouponSaveVO = new BipCouponSaveVO();
        List<BipItemVO> resList = new ArrayList<>();
        Optional<BipCouponDO> optional = bipCouponRepo.findById(id);
        if (optional.isPresent()) {
            BeanUtils.copyProperties(optional.get(), bipCouponSaveVO);
            QBipCouponItemDO qBipCouponItemDO = QBipCouponItemDO.bipCouponItemDO;
            BooleanExpression expression = qBipCouponItemDO.couponId.eq(id);
            Iterable<BipCouponItemDO> iterables = bipCouponItemRepo.findAll(expression);
            if (!IterUtil.isEmpty(iterables)) {
                List<BipCouponItemDO> list = Lists.newArrayList(iterables);
                list.stream().forEach(l -> {
                    BipItemVO bipItemVO = new BipItemVO();
                    BeanUtils.copyProperties(l, bipItemVO);
                    resList.add(bipItemVO);
                });
            }
            bipCouponSaveVO.setItemList(resList);
            QBipCouponCustDo qBipCouponCustDo = QBipCouponCustDo.bipCouponCustDo;
            //已领取数量
//            BooleanExpression expr = qBipCouponCustDo.couponId.eq(id);
//            Long count = bipCouponCustRepo.count(expr);
            bipCouponSaveVO.setReceiveNum(Long.valueOf(optional.get().getReceiveNum()));
            //已使用数量
            BooleanExpression exp = qBipCouponCustDo.couponId.eq(id).and(qBipCouponCustDo.useStatus.eq(SAL_COUPON_USE_STATUS_USED.getValueCode()));
            Long useCount = bipCouponCustRepo.count(exp);
            bipCouponSaveVO.setUseNum(useCount);
        }
        return bipCouponSaveVO;
    }

    @Override
    @SysCodeProc
    public PagingVO<BipCouponVO> search(BipCouponQueryParamVO param) {
//        OrgUserEmpInfoRpcDTO empInfo = getCurrentEmpInfo();
//        if(null == empInfo.getOuId()){
//            return new PagingVO<>();
//        }
//        param.setOuId(empInfo.getOuId());
        val ret = bipCouponRepo.findAll(bipCouponRepoProc.where(param), param.getPageRequest());
        val vos = ret.getContent().stream().map(BipCouponConvert.INSTANCE::doToVO).collect(Collectors.toList());
        return PagingVO.<BipCouponVO>builder()
                .total(ret.getTotalElements())
                .records(vos)
                .build();
    }


    @Override
    @SysCodeProc
    public PagingVO<BipCouponVO> searchAll(BipCouponQueryParamVO param) {
//        OrgUserEmpInfoRpcDTO empInfo = getCurrentEmpInfo();
//        if(null == empInfo.getOuId()){
//            return new PagingVO<>();
//        }
//        param.setOuId(empInfo.getOuId());
        val ret = bipCouponRepo.findAll(bipCouponRepoProc.whereAll(param), param.getPageRequest());
        val vos = ret.getContent().stream().map(BipCouponConvert.INSTANCE::doToVO).collect(Collectors.toList());
        return PagingVO.<BipCouponVO>builder()
                .total(ret.getTotalElements())
                .records(vos)
                .build();
    }



    @Override
    public PagingVO<BipCouponVO> sortingSearch(BipCouponOrderVO param) {
        //查询修改优惠券过期状态
        modifyCouponExceedState();
        BipCouponQueryParamVO paramVO = new BipCouponQueryParamVO();

        paramVO.setType(param.getType());
        paramVO.setOuId(currentOuId());
        paramVO.setState("ACTIVE");

        val ret = bipCouponRepo.findAll(bipCouponRepoProc.where(paramVO), param.getPageRequest());
        val vos =  ret.getContent().stream().map(BipCouponConvert.INSTANCE::doToVO).collect(Collectors.toList());

        for (BipCouponVO vo : vos) {
            vo.setReceiveStatus(!checkReceive(vo));
        }

        return PagingVO.<BipCouponVO>builder()
                .total(ret.getTotalElements())
                .records(vos)
                .build();
    }


    /**
     * 查询修改优惠券过期状态
     */
    public void modifyCouponExceedState(){
        QBipCouponDO qBipCouponDO = QBipCouponDO.bipCouponDO;
        BooleanExpression expression = qBipCouponDO.ouId.eq(getCurrentOuIdInfo()).and(qBipCouponDO.deleteFlag.eq(0))
                .and(qBipCouponDO.state.eq(SAL_COUPON_STATE_ACTIVE.getValueCode()))
                .and(qBipCouponDO.receiveValidEtime.lt(LocalDateTime.now()));
        Iterable<BipCouponDO> iterables = bipCouponRepo.findAll(expression);
        if(!IterUtil.isEmpty(iterables)){
            List<BipCouponDO> list = Lists.newArrayList(iterables);
            list.stream().forEach(l ->{
                l.setState(SAL_COUPON_STATE_DISABLE.getValueCode());
                bipCouponRepo.save(l);
            });
        }
    }


    /**
     * 检查优惠券领取状态
     * @param bipCouponVO 优惠券
     * @return true:未领取 false:领取
     */
    boolean checkReceive(BipCouponVO bipCouponVO){
        List<BipCouponCustDo> couponCustDos = bipCouponCustRepo.findAllByCouponIdAndUserId(bipCouponVO.getId(), UserService.currentUser().getUserId());
        return !(couponCustDos.size()>0);
    }

    private Long currentOuId() {
        CurrentUserDTO currentUserDTO = UserService.currentUser();

        //获取当前登录人信息和客户信息
        BipCustUserBindDO bipCustUserBindDO = null;

        if (currentUserDTO == null || currentUserDTO.getUserId() == null) {
            throw new BusinessException(ApiCode.AUTHENTICATION_EXCEPTION,"请先登录!");
        }

        bipCustUserBindDO = bipCustUserBindRepoProc.getByUserId(currentUserDTO.getUserId());

        if (bipCustUserBindDO == null) {
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION,"请绑定公司信息!");
        }

        return bipCustUserBindDO.getOuId();
    }


    @Override
    @Transactional
    public Long createOne(BipCouponSaveVO param) {
        BipCouponDO bipCouponDO = BipCouponConvert.INSTANCE.paramToDo(param);
        String couponCode = nextNumberService.generateCode("yst-sale","COUPON_CODE", new ArrayList<>());
        bipCouponDO.setCouponCode(couponCode);
        if (StringUtils.isEmpty(param.getState())) {
            bipCouponDO.setState(SAL_COUPON_STATE_NOT_ACTIVE.getValueCode());
        }
        OrgUserEmpInfoRpcDTO empInfo = getCurrentEmpInfo();
        bipCouponDO.setSecBuId(empInfo.getBuId());
        bipCouponDO.setSecOuId(empInfo.getOuId());
        bipCouponDO.setSecUserId(empInfo.getUserId());
        bipCouponDO.setReceiveValidStime(param.getSpecialAreaStime());
        bipCouponDO.setReceiveValidEtime(param.getSpecialAreaEtime());
//        if (null != empInfo.getOuId()) {
//            bipCouponDO.setOuId(empInfo.getOuId());
//            bipCouponDO.setOuName(empInfo.getOuName());
//        }
        BipCouponDO coupon = bipCouponRepo.save(bipCouponDO);
        List<BipItemVO> itemList = param.getItemList();
        if (null != itemList && !itemList.isEmpty()) {
            itemList.stream().forEach(item -> {
                BipCouponItemDO bipCouponItemDO = new BipCouponItemDO();
                BeanUtils.copyProperties(item, bipCouponItemDO);
                bipCouponItemDO.setCouponId(coupon.getId());
                bipCouponItemDO.setOuId(param.getOuId());
                bipCouponItemDO.setOuName(param.getOuName());
//                if (null != empInfo.getOuId()) {
//                    bipCouponItemDO.setOuId(empInfo.getOuId());
//                    bipCouponItemDO.setOuName(empInfo.getOuName());
//
//                }
                bipCouponItemRepo.save(bipCouponItemDO);
            });
        }
        return coupon.getId();
    }

    @Override
    @Transactional
    public List<Long> createBatch(List<BipCouponSaveVO> list) {
        List<BipCouponDO> dos = list.stream().map(BipCouponConvert.INSTANCE::paramToDo).collect(Collectors.toList());
        return bipCouponRepo.saveAll(dos).stream().map(BipCouponDO::getId).collect(Collectors.toList());
    }

    @Override
    @Transactional
    public void update(BipCouponSaveVO param) {
        //  BipCouponDO objDo = BipCouponConvert.INSTANCE.paramToDo(param);
        Optional<BipCouponDO> optional = bipCouponRepo.findById(param.getId());
        if (optional.isPresent()) {
            BipCouponDO objDo = optional.get();
            BeanUtils.copyProperties(param,objDo);
            objDo.setReceiveValidStime(param.getSpecialAreaStime());
            objDo.setReceiveValidEtime(param.getSpecialAreaEtime());
            BipCouponDO coupon = bipCouponRepo.save(objDo);
            List<BipItemVO> itemList = param.getItemList();
            if (null != itemList && !itemList.isEmpty()) {
                //先删除
                QBipCouponItemDO qBipCouponItemDO = QBipCouponItemDO.bipCouponItemDO;
                BooleanExpression expression = qBipCouponItemDO.couponId.eq(coupon.getId());
                Iterable<BipCouponItemDO> items = bipCouponItemRepo.findAll(expression);
                if (!IterUtil.isEmpty(items)) {
                    bipCouponItemRepo.deleteAll(items);
                }
                itemList.stream().forEach(item -> {
                    BipCouponItemDO bipCouponItemDO = new BipCouponItemDO();
                    BeanUtils.copyProperties(item, bipCouponItemDO);
                    bipCouponItemDO.setCouponId(coupon.getId());
                    bipCouponItemDO.setOuId(param.getOuId());
                    bipCouponItemDO.setOuName(param.getOuName());
                    bipCouponItemRepo.save(bipCouponItemDO);
                });
            }
        } else {
            throw new BusinessException(ApiCode.FAIL, "修改失败，数据不存在" + param.getId());
        }
    }

    @Override
    @Transactional
    public void updateDeleteFlag(Long id) {
        val jpaQDo = QBipCouponDO.bipCouponDO;
        Predicate predicate = jpaQDo.isNotNull();
        predicate = ExpressionUtils.and(predicate, jpaQDo.id.eq(id));
        Optional<BipCouponDO> optionalItem = bipCouponRepo.findOne(predicate);
        if (optionalItem.isPresent()) {
            BipCouponDO do1 = optionalItem.get();
            do1.setDeleteFlag(1);
            bipCouponRepo.save(do1);
        } else {
            throw new BusinessException(ApiCode.FAIL, "修改失败，数据不存在" + id);
        }
    }

    @Override
    @Transactional
    public void deleteBatch(List<Long> list) {
        list.forEach(this::updateDeleteFlag);
    }


    private OrgUserEmpInfoRpcDTO getCurrentEmpInfo() {
        CurrentUserDTO currentUser = UserService.currentUser();
        if (currentUser == null) {
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "当前用户已失效,请重登录重试");
        }
        OrgUserEmpInfoRpcDTO userEmpInfo = orgEmpRpcService.findUserEmpInfo(currentUser.getUserId());
        if (userEmpInfo == null) {
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "无法获取当前用户信息");
        }
        return userEmpInfo;
    }

    private Long getCurrentOuIdInfo() {
        CurrentUserDTO currentUser = UserService.currentUser();
        if (currentUser == null) {
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "当前用户已失效,请重登录重试");
        }
        BipCustUserBindDO bipCustUserBindDO = bipCustUserBindRepoProc.getByUserId(currentUser.getUserId());

        if (bipCustUserBindDO == null || bipCustUserBindDO.getOuId() ==null ) {
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "当前用户未绑定公司");
        }


        return bipCustUserBindDO.getOuId();
    }

}


