package com.elitesland.yst.production.sale.service.shop;

import cn.hutool.core.lang.Assert;
import com.alibaba.fastjson.JSON;
import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.cloudt.common.annotation.SysCodeProc;
import com.elitescloud.cloudt.common.base.ApiCode;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.external.nuonuo.core.dto.req.BillingNewInvoiceDetailReqDTO;
import com.elitesland.external.nuonuo.core.dto.req.BillingNewOrderReqDTO;
import com.elitesland.external.nuonuo.core.dto.req.BillingNewReqDTO;
import com.elitesland.external.nuonuo.core.dto.resp.QueryInvoiceResultRespDTO;
import com.elitesland.yst.production.sale.api.dto.BipInvItemDTO;
import com.elitesland.yst.production.sale.api.service.ComSaleFileInfoService;
import com.elitesland.yst.production.sale.api.service.PriSalePriceService;
import com.elitesland.yst.production.sale.api.service.shop.*;
import com.elitesland.yst.production.sale.api.vo.param.shop.BipInvCreateParam;
import com.elitesland.yst.production.sale.api.vo.param.shop.BipInvQueryParam;
import com.elitesland.yst.production.sale.api.vo.param.shop.BipInvViewAndDownParam;
import com.elitesland.yst.production.sale.api.vo.resp.com.ComSaleFileComVO;
import com.elitesland.yst.production.sale.api.vo.resp.shop.BipInvVO;
import com.elitesland.yst.production.sale.common.model.CurrentUserDTO;
import com.elitesland.yst.production.sale.convert.shop.BipInvConvert;
import com.elitesland.yst.production.sale.core.service.BaseServiceImpl;
import com.elitesland.yst.production.sale.core.service.UserService;
import com.elitesland.yst.production.sale.entity.BipInvDO;
import com.elitesland.yst.production.sale.entity.BipOrderDO;
import com.elitesland.yst.production.sale.entity.QBipInvDO;
import com.elitesland.yst.production.sale.repo.SalInvApplydRepoProc;
import com.elitesland.yst.production.sale.repo.shop.BipInvRepo;
import com.elitesland.yst.production.sale.repo.shop.BipInvRepoProc;
import com.elitesland.yst.production.sale.repo.shop.BipOrderDRepo;
import com.elitesland.yst.production.sale.repo.shop.BipOrderRepo;
import com.elitesland.yst.production.sale.rmi.ystorder.RmiOrderSalSoDService;
import com.elitesland.yst.production.sale.rmi.ystsupport.RmiOrgOuService;
import com.elitesland.yst.production.sale.rmi.ystsystem.RmiSettingService;
import com.elitesland.yst.production.sale.rmi.ystsystem.RmiSysNextNumberService;
import com.elitesland.yst.production.support.provider.org.dto.OrgOuRpcDTO;
import com.elitesland.yst.production.support.provider.org.service.OrgEmpRpcService;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.jpa.impl.JPAQuery;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.data.domain.PageRequest;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;


/**
 * <p>
 * 功能说明
 * </p>
 *
 * @author Joker (Xing Shixiang)
 * @since 2021-09-06 14:06:53
 */
@Service
@RequiredArgsConstructor
@Slf4j
public class BipInvServiceImpl extends BaseServiceImpl implements BipInvService {

    private final BipInvRepo bipInvRepo;

    private final BipInvRepoProc bipInvRepoProc;
    private final PriSalePriceService priSalePriceService;
    private final BipOrderDService bipOrderDService;
 //   private final RmiMsgCarrierDubboService rmiMsgCarrierDubboService;
    private final RmiOrgOuService rmiOrgOuService;
    private final BipOrderService bipOrderService;
//    private final RmiNuoNuoDubboService rmiNuoNuoDubboService;
    private static final QBipInvDO qBipInvDO = QBipInvDO.bipInvDO;
    private final RmiSysNextNumberService rmiSysNextNumberService;
//    @Autowired
//    private RmiItemService rmiItemService;
    private final ComSaleFileInfoService comSaleFileInfoService;
    private final BipOrderDRepo bipOrderDRepo;
    private final BipOrderRepo bipOrderRepo;
    private final BipCustUserBindService bipCustUserBindService;
    private final BipCompanyManageService bipCompanyManageService;
    private final OrgEmpRpcService orgEmpRpcService;
    private final String taxnum="339901999999516";
    private final RmiOrderSalSoDService rmiOrderSalSoDService;
//    private final RmiOrderSalSoService rmiOrderSalSoService;
    private final SalInvApplydRepoProc salInvApplydRepoProc;
    private final RmiSettingService rmiSettingService;

    /**
     * 创建一个单据
     * 开票金额=订单总金额
     * 现在只能将发票信息保存到数据库还没有对接开票接口
     *
     * @param param 开发票入参
     * @return 发票ID
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public ApiResult<List<String>> createInv(BipInvCreateParam param) {


        // 数据信息补充
//        List<BillingNewReqDTO> billingNewReqDTOS = this.suppleBillInformation(param);
//        log.info("诺诺开票传参"+ JSON.toJSONString(billingNewReqDTOS));
//        // 开票申请
//        if (CollectionUtils.isEmpty(billingNewReqDTOS)) {
//            throw new BusinessException("开票单据商品明细为空,请检查!!!  原因:所有商品允许退货数量都小于1或者都找不到SKUCode");
//        }
//
//        // 根据订单号获得该订单的信息
//        List<BipOrderDRespVO> bipOrderDRespVOS = bipOrderDService.fingOrderDByorderId(param.getOrderId());
//
//        Assert.isTrue(bipOrderDRespVOS!=null && bipOrderDRespVOS.size()>0,"订单明细不存在！");
//
//        String docNo = bipOrderDRespVOS.get(0).getOrderDocNo();
//        var ordersByDoc = salInvApplydRepoProc.findBySoCode(docNo);
//        if (ordersByDoc!=null&&ordersByDoc.size()>0){
//            throw new BusinessException("该订单已开票！");
//        }
//
//        // 获得所有发票申请单据的流水号并绑定到每条订单明细
//        List<String> serialNum = new ArrayList<>();
//        for (BillingNewReqDTO billingNewReqDTO : billingNewReqDTOS) {
//            //补充发票总金额
//            BigDecimal totalAmt = BigDecimal.ZERO;
//            for (BillingNewInvoiceDetailReqDTO b : billingNewReqDTOS.get(0).getOrder().getInvoiceDetail()) {
//                String taxExcludedAmountStr = b.getTaxExcludedAmount();
//                String taxStr = b.getTax();
//                BigDecimal taxExcludedAmount = new BigDecimal(taxExcludedAmountStr);
//                BigDecimal tax = new BigDecimal(taxStr);
//                //计算一条明细的价格
//                BigDecimal amt = taxExcludedAmount.add(tax).setScale(4, RoundingMode.HALF_UP);
//                //累加计算该发票下的商品明细总价
//                totalAmt = totalAmt.add(amt);
//            }
//            param.setTotalAmt(totalAmt);
//            //发票流水号
////            param.setInvSerialNum(billingNewRespDTO.getResult().getInvoiceSerialNum());
//            //发票类型
//            param.setInvType(billingNewReqDTO.getOrder().getInvoiceLine());
//            //抬头
//            param.setInvTitle(billingNewReqDTO.getOrder().getBuyerName());
//            //税率
//            String taxRate = billingNewReqDTO.getOrder().getInvoiceDetail().get(0).getTaxRate();
//            param.setTaxRate(new BigDecimal(taxRate));
//            //税号
//            param.setTaxNo(billingNewReqDTO.getOrder().getBuyerTaxNum());
//            //查询订单主表获取公司ID
//            Long ouId = queryItemByOrderId(param.getOrderId());
//            List<Long> ouIds = new ArrayList<>();
//            ouIds.add(ouId);
//            List<OrgOuRpcDTO> ouDtoList = rmiOrgOuService.findOuDtoList(ouIds, null);
//            if (CollectionUtils.isEmpty(ouDtoList)) {
//                throw new BusinessException("销售方公司数据未找到,请检查!!!");
//            }
//            OrgOuRpcDTO orgOuRpcDTO = ouDtoList.get(0);
//            param.setOwnedCompany(orgOuRpcDTO.getOuName());
//            this.saveInv(param);
//        }
//
//        // 开票之后回写oms
//        SalSoQueryDTO salSoQueryDTO = new SalSoQueryDTO();
//        salSoQueryDTO.setDocNo(docNo);
//        List<SalSoItemRespDTO> omsSoDs = rmiOrderSalSoService.queryItemByDocNo(salSoQueryDTO).getData();
//        Map<String, SalSoItemRespDTO> sodMap = omsSoDs.stream().collect(Collectors.toMap(SalSoItemRespDTO::getItemCode, so -> so, (s1, s2) -> s1));
//        Assert.notNull(sodMap,"未在订单中心查询到该订单！");
//        log.info("小程序开票时在OMS查询的订单信息：{}", JSON.toJSONString(sodMap));
//
//        List<SalSoDUpdateDTO> salSoDUpdateDTOS = new ArrayList<>();
//        for (BipOrderDRespVO dRespVO : bipOrderDRespVOS) {
//            String skuCode = dRespVO.getSkuCode();
//            SalSoItemRespDTO dto = sodMap.get(skuCode);
//            Assert.notNull(dto,"该订单明细【"+dRespVO.getId()+"】不存在于订单中心！");
//
//            SalSoDUpdateDTO salSoDUpdateDTO = new SalSoDUpdateDTO();
//            salSoDUpdateDTO.setSodId(dto.getSoDId());
//            salSoDUpdateDTO.setInvedQty(BigDecimal.valueOf(dRespVO.getBuyQty()));
//            salSoDUpdateDTO.setInvedAmt(dRespVO.getPayDoneAmt());
//            salSoDUpdateDTO.setNoinvQty(BigDecimal.ZERO);
//            salSoDUpdateDTO.setNoinvAmt(BigDecimal.ZERO);
//
//            salSoDUpdateDTOS.add(salSoDUpdateDTO);
//        }
//
//        log.info("小程序开票修改OMS订单信息：{}", JSON.toJSONString(salSoDUpdateDTOS));
//        rmiOrderSalSoDService.querySalSoDetail(salSoDUpdateDTOS);
//
//        //更新每个订单主表是否开发票状态
//        updateItemOrderD(param.getOrderId(), true, 0);
//        return ApiResult.ok(serialNum);
        return null;
    }

    @Transactional(rollbackFor = Exception.class)
    public ApiResult<List<QueryInvoiceResultRespDTO.QueryInvoiceResultResultDTO>> nuoNuoEleQueryInvoiceResult(List<String> serialNos, List<BipInvDO> bipInvDOS) {
        //查询订单主表获取公司ID
        Long ouId = queryItemByOrderId(bipInvDOS.get(0).getOrderId());
        List<Long> ouIds = new ArrayList<>();
        ouIds.add(ouId);
        List<OrgOuRpcDTO> ouDtoList = rmiOrgOuService.findOuDtoList(ouIds, null);
        if (CollectionUtils.isEmpty(ouDtoList)) {
            throw new BusinessException("销售方公司数据未找到,请检查!!!");
        }

        //todo :获得销方税号
        String taxerCode = ouDtoList.get(0).getTaxerCode();
        //QueryInvoiceResultRespDTO queryInvoiceResultRespDTO = rmiNuoNuoDubboService.nuoNuoEleQueryInvoiceResult(serialNos,taxerCode);
//        if (!queryInvoiceResultRespDTO.getCode().equals("E0000")) {
//            return ApiResult.fail(queryInvoiceResultRespDTO.getCode() + "," + queryInvoiceResultRespDTO.getDescribe());
//        }
//        List<QueryInvoiceResultRespDTO.QueryInvoiceResultResultDTO> queryInvoiceResultResultDTOS = queryInvoiceResultRespDTO.getResult();
//        //针对于多张发票先保存然后获得明细行id,明细行id和附件地址保存到数据库
//        //此处是针对于发票单流水号进行分组,每一组发票信息绑定对应的发票(因为商品数量原因同一张流水单号可能会有多张单子)
//        Map<String, List<QueryInvoiceResultRespDTO.QueryInvoiceResultResultDTO>> listMap = queryInvoiceResultResultDTOS.stream().collect(Collectors.groupingBy(QueryInvoiceResultRespDTO.QueryInvoiceResultResultDTO::getSerialNo));
        // 需要看开票失败返回的出参是什么，再定如何修改
        List<String> paperPdUrls = new ArrayList<>();
//        for (String key : listMap.keySet()) {
//            List<QueryInvoiceResultRespDTO.QueryInvoiceResultResultDTO> invoiceResultResultDTOS = listMap.get(key);
//            QueryInvoiceResultRespDTO.QueryInvoiceResultResultDTO queryInvoiceResultResultDTO = invoiceResultResultDTOS.get(0);
//            BipInvCreateParam bipInvCreateParam = new BipInvCreateParam();
//            //如果已经存在单子进行修改
//            bipInvDOS.stream().filter(bipInv -> bipInv.getInvSerialNum().equals(key))
//                    .findFirst().ifPresent(bip -> {
//                        bipInvCreateParam.setId(bip.getId());
//                        bipInvCreateParam.setInvTitleType(bip.getInvTitleType());
//                        ArrayList<String> docNos = new ArrayList<>();
//                        docNos.add(bip.getDocNo());
//                        bipInvCreateParam.setDocNos(docNos);
//                        bipInvCreateParam.setCustAccountId(bip.getCustAccountId());
//                        bipInvCreateParam.setBankAccount(bip.getBankAccount());
//                        bipInvCreateParam.setBank(bip.getBank());
//                        bipInvCreateParam.setOrderTime(bip.getOrderTime());
//                        bipInvCreateParam.setTotalAmt(bip.getTotalAmt());
//                        bipInvCreateParam.setTotalAmt(bip.getTotalAmt());
//                        bipInvCreateParam.setOwnedCompany(bip.getOwnedCompany());
//                        bipInvCreateParam.setOrderId(bip.getOrderId());
//                        bipInvCreateParam.setInvMultipleTax(bip.getInvMultipleTax());
//                        bipInvCreateParam.setRedInvSerialNum(bip.getRedInvSerialNum());
//                        bipInvCreateParam.setIsRed(bip.getIsRed());
//                        //发票类型
//                        bipInvCreateParam.setInvType(bip.getInvType());
//                    });
//            //发票流水号
//            bipInvCreateParam.setInvSerialNum(key);
//            //发票代码
//            bipInvCreateParam.setInvNo(queryInvoiceResultResultDTO.getInvoiceNo());
//            //发票编码
//            bipInvCreateParam.setInvCode(queryInvoiceResultResultDTO.getInvoiceCode());
//
//            //抬头
//            bipInvCreateParam.setInvTitle(queryInvoiceResultResultDTO.getPayerName());
//            //税号
//            bipInvCreateParam.setTaxNo(queryInvoiceResultResultDTO.getPayerTaxNo());
//            //开户银行
//            bipInvCreateParam.setBank(queryInvoiceResultResultDTO.getBankAccount());
//            //单位地址
//            bipInvCreateParam.setCompanyAddress(queryInvoiceResultResultDTO.getAddress());
//            //开户电话
//            bipInvCreateParam.setCompanyTel(queryInvoiceResultResultDTO.getTelephone());
//            //开户电话
//            bipInvCreateParam.setStatus(queryInvoiceResultResultDTO.getStatus());
//
//            Long bipInvId = this.saveInv(bipInvCreateParam);
//            List<ComSaleFileComVO> comSaleFileComVOs = invoiceResultResultDTOS.stream().map(inv -> {
//                ComSaleFileComVO comSaleFileComVO = new ComSaleFileComVO();
//                comSaleFileComVO.setBusinessType("B-INV");
//                comSaleFileComVO.setBusinessId(bipInvId);
//                comSaleFileComVO.setFileCode(inv.getPdfUrl());
//                comSaleFileComVO.setOriginalName(inv.getImgUrls());
//                paperPdUrls.add(inv.getPdfUrl());
//                return comSaleFileComVO;
//            }).collect(Collectors.toList());
//            comSaleFileInfoService.comSaleFileHardSave("B-INV", bipInvId, comSaleFileComVOs);
//        }
      //  return ApiResult.ok(queryInvoiceResultResultDTOS);
        return ApiResult.ok(null);
    }

    /**
     * 补充诺诺接口发票信息
     *
     * @param param param
     * @return BillingNewReqDTO
     */
    @SysCodeProc
    private List<BillingNewReqDTO> suppleBillInformation(BipInvCreateParam param) {
        BillingNewReqDTO billingNewReqDTO = new BillingNewReqDTO();

        //根据订单号获得该订单的信息
        List<BipInvItemDTO> bipInvItemFromOrderD = queryItemNumByOrderID(param.getOrderId());

        addFareItem(bipInvItemFromOrderD, param.getOrderId());

        //根据订单里商品价格表id获取商品信息
        List<String> skuCodes = bipInvItemFromOrderD.stream().map(BipInvItemDTO::getSkuCode).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(skuCodes)) {
            throw new BusinessException("该订单商品没有skuCodes");
        }
//        List<ItmItemRpcDTO> itemServiceItemList = rmiItemService.findItemList(null, skuCodes);
//        List<BipInvItemDTO> bipInvItemFromSale = queryItemBySkuCodes(skuCodes);
//
//        List<BipInvItemDTO> collect = new ArrayList<>();
//        for (BipInvItemDTO b : bipInvItemFromSale) {
//            for (BipInvItemDTO bipInvItemDTO : bipInvItemFromOrderD) {
//                if (bipInvItemDTO.getSkuCode().equals(b.getItemCode())) {
//                    b.setBuyQty(bipInvItemDTO.getAllowBackNum());
//                    BigDecimal payAmt = bipInvItemDTO.getBuyAmt();
//                    b.setPrice(payAmt);
//                    b.setItemSpec(bipInvItemDTO.getItemSpec());
//                    b.setItemName(bipInvItemDTO.getItemName());
//                    b.setAllowBackNum(bipInvItemDTO.getAllowBackNum());
//                    collect.add(b);
//                }
//            }
//        }

        //查询订单主表获取公司ID
        Long ouId = queryItemByOrderId(param.getOrderId());
        Optional<BipOrderDO> orderOPT = bipOrderRepo.findById(param.getOrderId());
        if (!orderOPT.isPresent()){
            throw new BusinessException("订单不存在");
        }
        BillingNewOrderReqDTO billingNewOrderReqDTO = new BillingNewOrderReqDTO();
        List<Long> ouIds = new ArrayList<>();
        ouIds.add(ouId);
        List<OrgOuRpcDTO> ouDtoList = rmiOrgOuService.findOuDtoList(ouIds, null);
        if (CollectionUtils.isEmpty(ouDtoList)) {
            throw new BusinessException("销售方公司数据未找到,请检查!!!");
        }
        OrgOuRpcDTO orgOuRpcDTO = ouDtoList.get(0);
        //开票申请号,开票金额
//        String generateCode = rmiSysNextNumberService.generateCode("yst-sale","AP", null);
        billingNewOrderReqDTO.setOrderNo(orderOPT.get().getDocNo());
        //推送方式--手机邮箱
        billingNewOrderReqDTO.setPushMode(param.getPushMode());
        billingNewOrderReqDTO.setBuyerPhone(param.getBuyerPhone());
        billingNewOrderReqDTO.setEmail(param.getEmail());
        //购买方名称
        billingNewOrderReqDTO.setBuyerName(param.getInvTitle());
        if (!StringUtils.isEmpty(param.getTaxNo())) {
            //购买方税号
            billingNewOrderReqDTO.setBuyerTaxNum(param.getTaxNo());
            //购买方电话--专票必填
            billingNewOrderReqDTO.setBuyerTel(param.getCompanyTel());
            //购买方地址--专票必填
            billingNewOrderReqDTO.setBuyerAddress(param.getCompanyAddress());
            //购买方银行账户及开户行地址
            billingNewOrderReqDTO.setBuyerAccount(param.getBank() + param.getBankAccount());
        }
        //销售方税号
//        billingNewOrderReqDTO.setSalerTaxNum(taxnum);
        //todo:真实环境用下面这个税号
        billingNewOrderReqDTO.setSalerTaxNum(orgOuRpcDTO.getTaxerCode());
        //销售方银行账户和开户行地址
        billingNewOrderReqDTO.setSalerAccount(orgOuRpcDTO.getInvBankAcc());
        //销方电话
        billingNewOrderReqDTO.setSalerTel(orgOuRpcDTO.getInvPicPhone());
        //销方地址
        billingNewOrderReqDTO.setSalerAddress(orgOuRpcDTO.getInvAddress());
        //开票员---orgOuRpcDTO.getxxx
        billingNewOrderReqDTO.setClerk(orgOuRpcDTO.getInvPicName());

        //开票类型--(1.蓝票,2.红票)--默认蓝票
//        billingNewOrderReqDTO.setInvoiceType(param.getInvoiceType());
        billingNewOrderReqDTO.setInvoiceType("1");
        //发票类型--(=>p:普通发票电票,c:普票发票(纸票);s,专用发票;e,收购发票(电票);f,收购发票(纸质);r,普通发票(卷式);b,增值税电子专用发票;j,机动车销售统一发票)
        billingNewOrderReqDTO.setInvoiceLine(param.getInvoiceLine());
        //订单日期
        billingNewOrderReqDTO.setInvoiceDate(param.getOrderTime().format(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss")));

        //***发票明细*** invoiceDetail  （通过商品id查？）
        // 获取的商品明细
        List<BillingNewReqDTO> billingNewReqDTOS = new ArrayList<>();
        // 如果统一标识INV_MULTIPLE_TAX为1时,开票可以选择不同税率的商品同时开票(系统配置标识如何获取暂定)

        List<BillingNewInvoiceDetailReqDTO> billingNewInvoiceDetailReqDTOS = buildInvoiceDetail(bipInvItemFromOrderD);
        log.info("诺诺开票发票明细"+ JSON.toJSONString(billingNewInvoiceDetailReqDTOS));
        Assert.notNull(param.getInvMultipleTax(),"税率分组不能为空");
        if (param.getInvMultipleTax() == 1) {
            billingNewOrderReqDTO.setInvoiceDetail(billingNewInvoiceDetailReqDTOS);
            billingNewReqDTO.setOrder(billingNewOrderReqDTO);
            billingNewReqDTOS.add(billingNewReqDTO);
        } else {
            // 如果统一标识INV_MULTIPLE_TAX不为1时,开票要将数据通过税率进行分组开票
            Map<String, List<BillingNewInvoiceDetailReqDTO>> stringListMap = billingNewInvoiceDetailReqDTOS.stream()
                    .collect(Collectors.groupingBy(BillingNewInvoiceDetailReqDTO::getTaxRate));
            for (String key : stringListMap.keySet()) {
                billingNewOrderReqDTO.setInvoiceDetail(stringListMap.get(key));
                billingNewReqDTO.setOrder(billingNewOrderReqDTO);
                billingNewReqDTOS.add(billingNewReqDTO);
            }
        }
        return billingNewReqDTOS;
    }

    /**
     * 小程序开票添加运费商品
     * @param bipInvItemFromOrderD 订单明细
     * @param orderId 订单ID
     */
    private void addFareItem(List<BipInvItemDTO> bipInvItemFromOrderD, Long orderId) {
//        Optional<BipOrderDO> orderOPT = bipOrderRepo.findById(orderId);
//        BipOrderDO bipOrderDO = orderOPT.orElseThrow(()-> new BusinessException("订单ID【"+orderId+"】不存在"));
//
//        if (bipOrderDO.getFareAmt().compareTo(BigDecimal.ZERO) <= 0){
//            return;
//        }
//
//        Assert.notNull(orderId,"订单ID为空！");
//        BipInvItemDTO itemOfFare = new BipInvItemDTO();
//        SysSettingVO settingByCode = rmiSettingService.findSettingByCode(ITEM_OF_FEE);
//        String fareCode = settingByCode.getSettingVal();
//        Assert.notBlank(fareCode,"系统未设置运费商品！请联系SA！");
//        itemOfFare.setSkuCode(fareCode);
//
//        List<ItmItemRpcDTO> itemList = rmiItemService.findItemList(null, Collections.singletonList(fareCode));
//        Assert.isFalse(itemList==null || itemList.size()==0,"支撑域不存在运费商品【"+fareCode+"】");
//        ItmItemRpcDTO itemRpcDTO = itemList.get(0);
//        itemOfFare.setItemName(itemRpcDTO.getItemName());
//
//        Map<String, String> uomMap = convertUdc(COM_UOM_BX);
//        itemOfFare.setUomName(uomMap.get(itemRpcDTO.getUom()));
//
//        itemOfFare.setBuyAmt(bipOrderDO.getFareAmt());
//        itemOfFare.setAllowBackNum(1L);
//
//        bipInvItemFromOrderD.add(itemOfFare);
    }


    @Override
    public PagingVO<BipInvVO> appFindAll(BipInvQueryParam param) {
        Long userId = checkUser().getUserId();
        JPAQuery<BipInvVO> jpaQuery = bipInvRepoProc.findAllByUserId(userId);
        long count = jpaQuery.fetchCount();
        PageRequest pageRequest = wrapperPageRequest(param.getPageRequest(), null);
        appendPageAndSort(jpaQuery, pageRequest, qBipInvDO);
        return PagingVO.<BipInvVO>builder().total(count).records(jpaQuery.fetch()).build();
    }

    @Override
    public ApiResult<Long> sendEmail(String to, Long invId) {
        CurrentUserDTO currentUserDTO = checkUser();
        String userName = currentUserDTO.getDetail().getUsername();
        List<ComSaleFileComVO> fileByBusinessId = comSaleFileInfoService.findFileByBusinessId("B-INV", invId);
        List<String> fileCodes = fileByBusinessId.stream().map(ComSaleFileComVO::getFileCode).collect(Collectors.toList());
        StringBuilder html = new StringBuilder();
        for (String fileCode : fileCodes) {
            html.append("<a href=\"").append(fileCode).append("\">发票</a><br>");
        }
//        GeneralDubboCarrier generalDubboCarrier = new GeneralDubboCarrier();
//        String[] tos = {to};
//        generalDubboCarrier.setTos(tos);
//        generalDubboCarrier.setSubject("用户：" + userName + "的发票");
//        generalDubboCarrier.setPureContent("发票请点击" + html);
//        generalDubboCarrier.setTransType("MAIL");
//        ArrayList<GeneralDubboCarrier> generalDubboCarriers = new ArrayList<>();
//        generalDubboCarriers.add(generalDubboCarrier);
//        rmiMsgCarrierDubboService.generalSend(generalDubboCarriers);
        return ApiResult.ok(invId);
    }

    @Override
    @SysCodeProc
    @Transactional
    public BipInvVO findByInvId(Long invId) {
//        String status = null;
//        int statusNo = -1;
//        Optional<BipInvDO> byId = bipInvRepo.findById(invId);
//        if (byId.isPresent()) {
//            BipInvDO bipInvDO = byId.get();
//            String invSerialNum = bipInvDO.getInvSerialNum();
//            List<String> serialNos = new ArrayList<>();
//            List<BipInvDO> bipInvDOS = new ArrayList<>();
//            serialNos.add(invSerialNum);
//            bipInvDOS.add(bipInvDO);
//            ApiResult<List<QueryInvoiceResultRespDTO.QueryInvoiceResultResultDTO>> listApiResult = this.nuoNuoEleQueryInvoiceResult(serialNos, bipInvDOS);
//            if (!listApiResult.isSuccess()) {
//                throw new BusinessException(listApiResult.getMsg());
//            }
//            QueryInvoiceResultRespDTO.QueryInvoiceResultResultDTO resultDTO = listApiResult.getData().get(0);
//            status = resultDTO.getStatusMsg();
//            statusNo = Integer.parseInt(resultDTO.getStatus());
//            if ("22".equals(resultDTO.getStatus()) || "24".equals(resultDTO.getStatus())) {
//                log.warn("开票状态信息:" + resultDTO.getStatusMsg() + "  " + resultDTO.getFailCause());
//                //更新每个订单主表是否开发票状态
//                bipOrderRepo.findById(bipInvDO.getOrderId()).ifPresent(
//                        o -> updateItemOrderD(bipInvDO.getOrderId(), false, o.getOffFlag())
//                );
//                bipInvDO.setStatus(resultDTO.getStatus());
//                bipInvRepo.save(bipInvDO);
//                //bipOrderRepo.updateOrderInvoice(bipInvDO.getOrderId(), Boolean.FALSE ,0);
//                throw new BusinessException("开票状态信息:" + resultDTO.getStatusMsg() + "  " + resultDTO.getFailCause() + "开票失败请联系管理员");
//            }
//        }
//        JPAQuery<BipInvVO> jpaQuery = bipInvRepoProc.findByinvId(invId);
//        BipInvVO result = jpaQuery.fetch().get(0);
//        //先从orderd中查询订单中的商品的数量
//        List<BipInvItemDTO> bipInvItemFromOrderD = queryItemNumByOrderID(result.getOrderId());
//        if (CollectionUtils.isEmpty(bipInvItemFromOrderD)) {
//            throw new BusinessException("该订单号下没有商品数量信息");
//        }
//        //从销售价格服务查询商品其他信息
//        //从订单表中获得skuIds
//        List<String> skuCodes = bipInvItemFromOrderD.stream().map(BipInvItemDTO::getSkuCode).collect(Collectors.toList());
//
//        List<ItmItemRpcDTO> itemServiceItemList = rmiItemService.findItemList(null,skuCodes);
//
//        //根据skuCodes在价格表查找bipInvItemFromSale
//        //List<BipInvItemDTO> bipInvItemFromSale = queryItemBySkuCodes(skuCodes);
//        if (CollectionUtils.isEmpty(itemServiceItemList)) {
//            throw new BusinessException("该订单号下没有商品信息");
//        }
//        List<BipInvItemDTO> bipInvItemList = new ArrayList<>();
//        //将商品数量放入bipInvItemFromSale得到新的集合bipInvItemList
//
//
//        for (BipInvItemDTO bipInvItemDTO : bipInvItemFromOrderD) {
//            for (ItmItemRpcDTO r : itemServiceItemList) {
//                if (bipInvItemDTO.getSkuCode().equals(r.getItemCode())) {
//                    bipInvItemDTO.setItemSpec(r.getSpec());
//                    bipInvItemDTO.setTaxRate(r.getTaxRate());
//                    //税额
//                    BigDecimal netPrice = bipInvItemDTO.getBuyAmt().divide(BigDecimal.ONE.add(r.getTaxRate()), 8, RoundingMode.HALF_UP);
//                    BigDecimal tax = netPrice.multiply(r.getTaxRate());
//                    bipInvItemDTO.setTax(tax);
//                    //含税
//                    bipInvItemDTO.setNetPrice(netPrice);
//                    //未税价格
//                    bipInvItemDTO.setPrice(bipInvItemDTO.getBuyAmt());
//                    bipInvItemList.add(bipInvItemDTO);
//                }
//            }
//
//        }
//        //将bipInvItemList放入result
//        result.setBipInvItemDTO(bipInvItemList);
//        //根据id查询发票PDF文件编码
//        List<ComSaleFileComVO> files = comSaleFileInfoService.findFileByBusinessId("B-INV", invId);
//        List<String> fileCodes = files.stream().map(ComSaleFileComVO::getFileCode).collect(Collectors.toList());
//        List<String> imgCodes = files.stream().map(ComSaleFileComVO::getOriginalName).collect(Collectors.toList());
//        result.setFileCodes(fileCodes);
//        result.setFiles(files);
//        result.setImgCodes(imgCodes);
//        result.setStatus(status);
//        result.setStatusNo(statusNo);
//        return result;
        return null;
    }

    @Override
    public PagingVO<BipInvVO> findAllByParam(BipInvQueryParam param) {
        if (param == null) {
            throw new BusinessException("查询条件不能为Null");
        }
        JPAQuery<BipInvVO> jpaQuery = bipInvRepoProc.select(param);
        long total = jpaQuery.fetchCount();
        PageRequest pageRequest = wrapperPageRequest(param.getPageRequest(), null);
        appendPageAndSort(jpaQuery, pageRequest, qBipInvDO);
        return PagingVO.<BipInvVO>builder()
                .total(total)
                .records(jpaQuery.fetch())
                .build();
    }

    @Override
    public List<BipInvVO> findInvByOrderId(Long orderId) {
        List<BipInvVO> fetch = jpaQueryFactory.select(Projections.bean(BipInvVO.class,qBipInvDO.id)).from(qBipInvDO).where(qBipInvDO.orderId.eq(orderId)).fetch();
        List<BipInvVO> results = fetch.stream().map(b -> findByInvId(b.getId())).collect(Collectors.toList());
        for (BipInvVO result : results) {
            List<BipInvItemDTO> bipInvItemDTO = result.getBipInvItemDTO();
            BigDecimal tax =BigDecimal.ZERO;
            for (BipInvItemDTO invItemDTO : bipInvItemDTO) {
                tax = tax.add(invItemDTO.getTax());
            }
            if ("p".equals(result.getInvType())) {
                result.setInvType("普通发票(电票)");
            }
            result.setTax(tax);
            result.setTaxRate(bipInvItemDTO.get(0).getTaxRate());
        }
        return results;
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public ApiResult<List<String>> viewAndDownload(BipInvViewAndDownParam bipInvViewAndDownParam) {
        BipInvQueryParam bipInvQueryParam = new BipInvQueryParam();
        if (!CollectionUtils.isEmpty(bipInvViewAndDownParam.getInvSerialNums())) {
            bipInvQueryParam.setInvSerialNums(bipInvViewAndDownParam.getInvSerialNums());
        } else {
            bipInvQueryParam.setOrderNos(bipInvViewAndDownParam.getInvSerialNums());
        }
        List<BipInvDO> bipInvDOS = this.selectInvByDocNosOrOrderId(bipInvQueryParam);
        List<String> serialNums = bipInvDOS.stream().map(BipInvDO::getInvSerialNum).collect(Collectors.toList());
        ApiResult<List<QueryInvoiceResultRespDTO.QueryInvoiceResultResultDTO>> result = this.nuoNuoEleQueryInvoiceResult(serialNums, bipInvDOS);
        for (QueryInvoiceResultRespDTO.QueryInvoiceResultResultDTO resultDTO : result.getData()) {
            log.info("开票状态信息" + resultDTO.getStatusMsg());
            if ("22".equals(resultDTO.getStatus()) || "24".equals(resultDTO.getStatus())) {
                log.warn("开票状态信息" + resultDTO.getStatusMsg() + "  " + resultDTO.getFailCause());
                return ApiResult.fail(resultDTO.getStatusMsg() + "  " + resultDTO.getFailCause());
            }
        }
        if (result.getCode() != 200) {
            throw new BusinessException("查询发票异常,异常信息为:" + result.getMsg());
        }
        List<QueryInvoiceResultRespDTO.QueryInvoiceResultResultDTO> data = result.getData();
        List<String> collect = data.stream().map(QueryInvoiceResultRespDTO.QueryInvoiceResultResultDTO::getPdfUrl).collect(Collectors.toList());
        return ApiResult.ok(collect);
    }

    @Override
    @Deprecated
    public ApiResult<String> findInvByInvSerialNum(String invSerialNum) {
//        ArrayList<String> invSerialNums = new ArrayList<>();
//        invSerialNums.add(invSerialNum);
//        QueryInvoiceResultRespDTO queryInvoiceResultRespDTO = rmiNuoNuoDubboService.nuoNuoEleQueryInvoiceResult(invSerialNums,taxnum);
//        QueryInvoiceResultRespDTO.QueryInvoiceResultResultDTO result = queryInvoiceResultRespDTO.getResult().get(0);
//        if ("22".equals(result.getStatus()) || "24".equals(result.getStatus())) {
//            log.warn("开票状态信息：" + result.getStatusMsg() + "  " + result.getFailCause());
//            return ApiResult.fail(result.getStatusMsg() + "  " + result.getFailCause());
//        }
//        log.info("开票状态信息：" + result.getStatusMsg());
//        return ApiResult.ok(result.getPdfUrl());
        return ApiResult.ok();
    }

    /**
     * 构建发票明细
     *
     * @return List<BipInvItemDTO>--订单中的商品信息  --数量和Code
     */
    @SysCodeProc
    public List<BillingNewInvoiceDetailReqDTO> buildInvoiceDetail(List<BipInvItemDTO> bipInvItemFromSale) {
//        List<String> itemCodes = bipInvItemFromSale.stream().map(BipInvItemDTO::getSkuCode).distinct().filter(Objects::nonNull).collect(Collectors.toList());
//        List<ItmItemRpcDTO> itemServiceItemList = rmiItemService.findItemList(null, itemCodes);
//        log.info("诺诺开票support"+ JSON.toJSONString(itemServiceItemList));
//        // 查询udc
//        //Map<String, String> codeMap = sysUdcService.getCodeMap("COM", "TAX_CLASS_CODE");
//        return bipInvItemFromSale.stream().map(b -> {
//            ItmItemRpcDTO itmItemRpc=null;
//            for (ItmItemRpcDTO itmItemRpcDTO : itemServiceItemList) {
//                if (itmItemRpcDTO.getItemCode().equals(b.getSkuCode())) {
//                    itmItemRpc=itmItemRpcDTO;
//                    b.setItemSpec(itmItemRpcDTO.getSpec());
//                    b.setTaxRate(itmItemRpcDTO.getTaxRate());
//                    b.setTaxRateNo(itmItemRpcDTO.getTaxType());
//                    //b.setUomName(itmItemRpcDTO.uo);
//                    //b.setUomName(itmItemRpcDTO.getUom());
//
//                }
//            }
//            BillingNewInvoiceDetailReqDTO billingNewInvoiceDetailReqDTO = new BillingNewInvoiceDetailReqDTO();
//            //商品名称
//            billingNewInvoiceDetailReqDTO.setGoodsName(b.getItemName());
//            //税率
//            billingNewInvoiceDetailReqDTO.setTaxRate(b.getTaxRate().toString());
//            //规格型号
//            billingNewInvoiceDetailReqDTO.setSpecType(b.getItemSpec());
//
//            //单位
//            billingNewInvoiceDetailReqDTO.setUnit(b.getUomName());
//            //发票行性质 [invoiceLineProperty]  ---默认
//            billingNewInvoiceDetailReqDTO.setInvoiceLineProperty("0");
//            //单价含税标志
//            billingNewInvoiceDetailReqDTO.setWithTaxFlag("1");
//            //不含税金额 [taxExcludedAmount]
///*            不含税金额。红票为负。不含税金额、税
//            额、含税金额任何一个不传时，会根据传
//            入的单价，数量进行计算，可能和实际数
//            值存在误差，建议都传入*/
//            BigDecimal taxExcludedAmount = b.getBuyAmt().divide(new BigDecimal(1).add(b.getTaxRate()), 8, RoundingMode.HALF_UP).multiply(new BigDecimal(b.getAllowBackNum()));
//            //BigDecimal taxExcludedAmount = b.getBuyAmt().divide(new BigDecimal(1).add(b.getTaxRate()), 8, RoundingMode.HALF_UP);
//            billingNewInvoiceDetailReqDTO.setTaxExcludedAmount(taxExcludedAmount.toString());
//
//            //含税金额
//            BigDecimal includedAmount = b.getBuyAmt().multiply(new BigDecimal(b.getAllowBackNum()));
//            billingNewInvoiceDetailReqDTO.setTaxIncludedAmount(includedAmount.toString());
//            /*          税额=getPrice含税价格-不含税金额
//            税额，[不含税金额] * [税率] = [税额]；税
//            额允许误差为 0.06。红票为负。不含税金
//            额、税额、含税金额任何一个不传时，会
//            根据传入的单价，数量进行计算，可能和
//            实际数值存在误差，建议都传入*/
//            BigDecimal tax = includedAmount.subtract(taxExcludedAmount);
//            billingNewInvoiceDetailReqDTO.setTax(tax.toString());
//            //税收分类码
//            //单价 [price]  --getPrice含税价格--待确认
//            BigDecimal price = b.getBuyAmt();
//            billingNewInvoiceDetailReqDTO.setPrice(price.toString());
//            billingNewInvoiceDetailReqDTO.setNum(b.getAllowBackNum().toString());
//            billingNewInvoiceDetailReqDTO.setUnit(b.getUomName());
//            billingNewInvoiceDetailReqDTO.setGoodsCode(itmItemRpc.getTaxType());
//            billingNewInvoiceDetailReqDTO.setGoodsName(itmItemRpc.getItemName());
//
//            //税收分类码NAME
//            return billingNewInvoiceDetailReqDTO;
//        }).collect(Collectors.toList());
        return null;
    }

    /**
     * 红冲发票  不是作废!!!!!    电子发票只能红冲掉
     *
     * @return List<BipInvItemDTO>--订单中的商品信息  --数量和Code
     */
    @Override
    @Transactional
    public Long creditInv(Long orderId) {

        //根据订单Id查询订单下所有发票的 流水号 发票代码 发票代码
        List<BipInvDO> invByOrderIdList = jpaQueryFactory.select(qBipInvDO).from(qBipInvDO)
                .where(qBipInvDO.orderId
                        .eq(orderId)
                        .and(qBipInvDO.isRed.eq("0")
                                .or(qBipInvDO.isRed.isNull()))).fetch();
        List<String> serialNumS = invByOrderIdList.stream().map(BipInvDO::getInvSerialNum).collect(Collectors.toList());

        //查询订单主表获取公司ID
        Long ouId = queryItemByOrderId(orderId);
        List<Long> ouIds = new ArrayList<>();
        ouIds.add(ouId);
        List<OrgOuRpcDTO> ouDtoList = rmiOrgOuService.findOuDtoList(ouIds, null);
        if (CollectionUtils.isEmpty(ouDtoList)) {
            throw new BusinessException("销售方公司数据未找到,请检查!!!");
        }

        //todo :获得销方税号
        String taxerCode = ouDtoList.get(0).getTaxerCode();
        //去诺诺查该订单下的发票
 //       QueryInvoiceResultRespDTO queryInvoiceResultRespDTO = rmiNuoNuoDubboService.nuoNuoEleQueryInvoiceResult(serialNumS,taxerCode);
        //
  //      List<QueryInvoiceResultRespDTO.QueryInvoiceResultResultDTO> results = queryInvoiceResultRespDTO.getResult();
//        for (QueryInvoiceResultRespDTO.QueryInvoiceResultResultDTO result : results) {
//            BillingNewReqDTO billingNewReqDTO = buildBillingNewOrderReqDTO(result, invByOrderIdList);
//            BillingNewRespDTO billingNewRespDTO = rmiNuoNuoDubboService.nuoNuoEleInvoiceRequest(billingNewReqDTO, taxerCode);
//            if (!"E0000".equals(billingNewRespDTO.getCode())) {
//                log.warn(billingNewRespDTO.getCode() + "," + queryInvoiceResultRespDTO.getDescribe());
//                throw new BusinessException(billingNewRespDTO.getCode() + "," + billingNewRespDTO.getDescribe());
//            }
//            String invoiceSerialNum = billingNewRespDTO.getResult().getInvoiceSerialNum();
//            if (!StringUtils.isEmpty(invoiceSerialNum)) {
//                jpaQueryFactory.update(qBipInvDO)
//                        .set(qBipInvDO.redInvSerialNum, invoiceSerialNum)
//                        .set(qBipInvDO.isRed, "1")
//                        .where(qBipInvDO.invSerialNum.eq(result.getSerialNo())).execute();
//            }
//
//        }
        BipInvDO bipInvDO = invByOrderIdList.get(0);
        BipInvConvert convert = BipInvConvert.INSTANCE;
        BipInvCreateParam param = convert.doToCreatParam(bipInvDO);
        param.setInvTitleType(bipInvDO.getInvTitleType());
        param.setInvTitle(bipInvDO.getInvTitle());
        param.setPushMode("0");
        param.setInvMultipleTax(bipInvDO.getInvMultipleTax());
//        param.setEmail(results.get(0).getNotifyEmail());
        param.setOrderTime(bipInvDO.getOrderTime());
        param.setOrderId(bipInvDO.getOrderId());
        List<String> docNos = new ArrayList<>();
        docNos.add(bipInvDO.getDocNo());
        param.setDocNos(docNos);
        param.setCustAccountId(bipInvDO.getCustAccountId());
        param.setId(null);
        param.setIsRed(null);
        param.setRedInvSerialNum(null);
        log.info("创建新单据");

        createInv(param);
        return orderId;
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public Long uReditInv(Long orderId) {
//        //根据订单Id查询订单下所有发票的 流水号 发票代码 发票代码
//        List<BipInvDO> invByOrderIdList = jpaQueryFactory.select(qBipInvDO).from(qBipInvDO)
//                .where(qBipInvDO.orderId
//                        .eq(orderId)
//                        .and(qBipInvDO.isRed.eq("0")
//                                .or(qBipInvDO.isRed.isNull()))).fetch();
//        List<String> serialNumS = invByOrderIdList.stream().map(BipInvDO::getInvSerialNum).collect(Collectors.toList());
//        //查询订单主表获取公司ID
//        Long ouId = queryItemByOrderId(orderId);
//        List<Long> ouIds = new ArrayList<>();
//        ouIds.add(ouId);
//        List<OrgOuRpcDTO> ouDtoList = rmiOrgOuService.findOuDtoList(ouIds, null);
//        if (CollectionUtils.isEmpty(ouDtoList)) {
//            throw new BusinessException("销售方公司数据未找到,请检查!!!");
//        }
//
//        //todo :获得销方税号
//        String taxerCode = ouDtoList.get(0).getTaxerCode();
//
//        //去诺诺查该订单下的发票
//        QueryInvoiceResultRespDTO queryInvoiceResultRespDTO = rmiNuoNuoDubboService.nuoNuoEleQueryInvoiceResult(serialNumS,taxerCode);
//        //
//        List<QueryInvoiceResultRespDTO.QueryInvoiceResultResultDTO> results = queryInvoiceResultRespDTO.getResult();
//        for (QueryInvoiceResultRespDTO.QueryInvoiceResultResultDTO result : results) {
//            BillingNewReqDTO billingNewReqDTO = buildBillingNewOrderReqDTO(result, invByOrderIdList);
//                jpaQueryFactory.update(qBipInvDO)
//                        .set(qBipInvDO.isRed, "1")
//                        .where(qBipInvDO.invSerialNum.eq(result.getSerialNo())).execute();
//        }
//        //红冲结束,更改标记字段
//        Optional<BipOrderDO> optional = bipOrderRepo.findById(orderId);
//        if (optional.isPresent()) {
//            BipOrderDO orderDO = optional.get();
//            orderDO.setOffFlag(1);
//            orderDO.setInvoice(false);
//            bipOrderRepo.save(orderDO);
//        } else {
//            throw new BusinessException("根据orderId查询不到订单：" + orderId);
//        }
//
//        return orderId;
        return null;
    }

    /**
     * 根据发票流水号查询发票的PDFurl(针对红冲)
     *
     * @param serialNo 发票流水号
     * @return 发票信息
     */
    @Deprecated
    public ApiResult<BipInvVO> findCreditInv(String serialNo) {
//        List<String> serialNumS = new ArrayList<>();
//        serialNumS.add(serialNo);
//        QueryInvoiceResultRespDTO queryInvoiceResultRespDTO = rmiNuoNuoDubboService.nuoNuoEleQueryInvoiceResult(serialNumS,taxnum);
//        QueryInvoiceResultRespDTO.QueryInvoiceResultResultDTO resultDTO = queryInvoiceResultRespDTO.getResult().get(0);
//        log.info("开票状态信息" + resultDTO.getStatusMsg());
//        if ("22".equals(resultDTO.getStatus()) || "24".equals(resultDTO.getStatus())) {
//            log.warn("开票状态信息" + resultDTO.getStatusMsg() + "  " + resultDTO.getFailCause());
//            return ApiResult.fail(resultDTO.getStatusMsg() + "  " + resultDTO.getFailCause());
//        }
//        BipInvVO bipInvVO = new BipInvVO();
//        ArrayList<String> fileCodes = new ArrayList<>();
//        fileCodes.add(resultDTO.getPdfUrl());
//        bipInvVO.setFileCodes(fileCodes);
//        return ApiResult.ok(bipInvVO);
        return ApiResult.ok();
    }


    private BillingNewReqDTO buildBillingNewOrderReqDTO(QueryInvoiceResultRespDTO.QueryInvoiceResultResultDTO result, List<BipInvDO> invByOrderIdList) {
        String serialNo = result.getSerialNo();
        BipInvDO inv = invByOrderIdList.stream().filter(i -> serialNo.equals(i.getInvSerialNum())).collect(Collectors.toList()).get(0);
        //BipInvDO inv = jpaQueryFactory.select(qBipInvDO).from(qBipInvDO).where(qBipInvDO.invSerialNum.eq(serialNo)).fetch().get(0);
        BillingNewReqDTO billingNewReqDTO = new BillingNewReqDTO();
        BillingNewOrderReqDTO billingNewOrderReqDTO = new BillingNewOrderReqDTO();
        billingNewOrderReqDTO.setBuyerName(result.getPayerName());
        billingNewOrderReqDTO.setBuyerTaxNum(result.getPayerTaxNo());
        billingNewOrderReqDTO.setBuyerTel(result.getTelephone());
        billingNewOrderReqDTO.setBuyerAddress(result.getAddress());
        billingNewOrderReqDTO.setBuyerAccount(result.getBankAccount());
        billingNewOrderReqDTO.setSalerTaxNum(result.getSalerTaxNum());
        billingNewOrderReqDTO.setSalerTel(result.getSalerTel());
        billingNewOrderReqDTO.setSalerAddress(result.getSalerAddress());
        billingNewOrderReqDTO.setSalerAccount(result.getSalerAccount());
        billingNewOrderReqDTO.setOrderNo(result.getOrderNo());
        billingNewOrderReqDTO.setInvoiceDate(inv.getOrderTime().format(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss")));
        billingNewOrderReqDTO.setInvoiceCode(result.getInvoiceCode());
        billingNewOrderReqDTO.setInvoiceNum(result.getInvoiceNo());
        billingNewOrderReqDTO.setInvoiceLine("p");
        //billInfoNo  专票必填  --商城只有普票
        billingNewOrderReqDTO.setInvoiceNum(result.getInvoiceNo());
        billingNewOrderReqDTO.setClerk(result.getClerk());
        billingNewOrderReqDTO.setPushMode("0");
        billingNewOrderReqDTO.setEmail(result.getNotifyEmail());
        billingNewOrderReqDTO.setInvoiceType("2");//红票
        List<BillingNewInvoiceDetailReqDTO> details = new ArrayList<>();
        List<QueryInvoiceResultRespDTO.QueryInvoiceResultResultDTO.InvoiceItems> invoiceItems = result.getInvoiceItems();
        for (QueryInvoiceResultRespDTO.QueryInvoiceResultResultDTO.InvoiceItems i : invoiceItems) {
            BillingNewInvoiceDetailReqDTO detail = new BillingNewInvoiceDetailReqDTO();
            detail.setGoodsName(i.getItemName());
            detail.setGoodsCode(i.getItemCode());
            BigDecimal price = new BigDecimal(i.getItemPrice()).setScale(4, RoundingMode.HALF_UP);
            //detail.setPrice(price.toString());
            detail.setWithTaxFlag("1");
            //BigDecimal itemNum = new BigDecimal(i.getItemNum()).setScale(4, RoundingMode.HALF_UP);
            //detail.setNum("-" + itemNum);
            //税额
            BigDecimal tax = new BigDecimal(i.getItemTaxAmount());
            detail.setTax("-" + tax);
            detail.setTaxRate(i.getItemTaxRate());
            BigDecimal taxIncludedAmount = new BigDecimal(i.getItemAmount());
            detail.setTaxIncludedAmount("-" + taxIncludedAmount);

            detail.setTaxExcludedAmount("-" + taxIncludedAmount.subtract(tax));

            detail.setUnit(i.getItemUnit());
            BigDecimal itemAmount = new BigDecimal(i.getItemAmount());
            BigDecimal itemTaxAmount = new BigDecimal(i.getItemTaxAmount());
            BigDecimal taxExcludedAmount = itemAmount
                    .subtract(itemTaxAmount).setScale(4, RoundingMode.HALF_UP);
            detail.setTaxExcludedAmount("-" + taxExcludedAmount.toString());
            detail.setInvoiceLineProperty("0");
            details.add(detail);
        }
        billingNewOrderReqDTO.setInvoiceDetail(details);
        billingNewReqDTO.setOrder(billingNewOrderReqDTO);
        return billingNewReqDTO;

    }


    /**
     * 从订单主表服务查询订单信息
     *
     * @return List<BipInvItemDTO>--订单中的商品信息  --数量和Code
     */
    public Long queryItemByOrderId(Long orderId) {
        return bipOrderService.queryItemByOrderId(orderId);
    }


    /**
     * 开具发票过后新的订单的有关字段
     *
     * @param orderIds 订单ids
     * @param invoice  invoice
     */
    @Transactional(rollbackFor = Exception.class)
    public void updateItemOrderD(Long orderIds, boolean invoice, Integer offFlag) {
        bipOrderService.updateItemOrderD(orderIds, invoice, offFlag);
    }


    /**
     * @param param 开票后保存入参
     * @return Long保存到订单表的ID
     */
    @Transactional(rollbackFor = Exception.class)
    public Long saveInv(BipInvCreateParam param) {
        BipInvConvert convert = BipInvConvert.INSTANCE;
        BipInvDO bipInvDO = convert.creatParamToDo(param);
        //todo check
//        if (param.getId()==null) {
//            CurrentUserDTO currentUser = UserService.currentUser();
//            if (currentUser == null) {
//                throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "当前用户已失效,请重登录重试");
//            }
//            OrgUserEmpInfoRpcDTO userEmpInfo = orgEmpRpcService.findUserEmpInfo(currentUser.getUserId());
//            if (userEmpInfo == null) {
//                throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "无法获取当前用户信息");
//            }
//            List<BipCompanyManageRespVO> manageByOuIds = bipCompanyManageService.findCompanyManageByOuIds(Arrays.asList(userEmpInfo.getOuId()));
//            if (CollectionUtils.isEmpty(manageByOuIds)) {
//                throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "当前用户公司信息为空");
//            }
//            bipInvDO.setSecOuId(userEmpInfo.getOuId());
//            bipInvDO.setSecUserId(userEmpInfo.getUserId());
//            bipInvDO.setSecBuId(manageByOuIds.get(0).getBuId());
//        }
        bipInvDO.setDocNo(param.getDocNos().get(0));
        bipInvDO.setOrderId(param.getOrderId());
        bipInvDO.setInvMultipleTax(param.getInvMultipleTax());
        BipInvDO save = bipInvRepo.save(bipInvDO);
        return save.getId();
    }

    /**
     * 从订单明细服务查询订单明细信息
     *
     * @return List<BipInvItemDTO>--订单中的商品信息  --数量和Code
     */
    public List<BipInvItemDTO> queryItemNumByOrderID(Long orderId) {
        return bipOrderDService.queryItemByOrderId(orderId);
    }

    /**
     * 该方法根据订单号或者订单id的集合查询发票信息
     *
     * @return BipInvDO
     */
    public List<BipInvDO> selectInvByDocNosOrOrderId(BipInvQueryParam bipInvQueryParam) {
        if (ObjectUtils.isEmpty(bipInvQueryParam)) {
            return new ArrayList<>(16);
        }
        Predicate predicate = qBipInvDO.isNotNull();
        if (!CollectionUtils.isEmpty(bipInvQueryParam.getOrderNos())) {
            predicate = ExpressionUtils.and(predicate, qBipInvDO.docNo.in(bipInvQueryParam.getOrderNos()));
        }
        if (!CollectionUtils.isEmpty(bipInvQueryParam.getOrderIds())) {
            predicate = ExpressionUtils.and(predicate, qBipInvDO.orderId.in(bipInvQueryParam.getOrderIds()));
        }
        if (!CollectionUtils.isEmpty(bipInvQueryParam.getInvSerialNums())) {
            predicate = ExpressionUtils.and(predicate, qBipInvDO.invSerialNum.in(bipInvQueryParam.getInvSerialNums()));
        }
        return jpaQueryFactory.select(qBipInvDO).from(qBipInvDO).where(predicate).fetch();
    }

    /**
     * 从销售价格服务查询商品信息  --税率规格等信息*
     *
     * @return List<BipInvItemDTO>--订单中的商品信息 除了数量外的所有信息
     */
    public List<BipInvItemDTO> queryItemBySkuCodes(List<String> skuCodes) {
        return priSalePriceService.queryItemByItemCode(skuCodes);
    }

    /**
     * 检查当前用户并返回用户信息
     *
     * @return CurrentUserDTO--当前用户信息
     */
    private static CurrentUserDTO checkUser() {
        CurrentUserDTO currentUser = UserService.currentUser();
        if (currentUser == null) {
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "无法到获取当前用户,请先登录!");
        }
        return currentUser;
    }

}


