package com.elitesland.yst.production.sale.service.shop;

import cn.hutool.core.lang.Assert;
import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSON;
import com.el.coordinator.boot.fsm.model.vo.FileObjRespVO;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.cloudt.core.security.util.DataAuthJpaUtil;
import com.elitescloud.cloudt.system.provider.dto.SysUserRpcDTO;
import com.elitescloud.cloudt.system.provider.param.SysUserRpcDtoParam;
import com.elitesland.yst.production.sale.api.service.shop.BipItemEvalService;
import com.elitesland.yst.production.sale.api.vo.param.shop.BipItemEvalParmVO;
import com.elitesland.yst.production.sale.api.vo.resp.shop.BipItemEvalRespVO;
import com.elitesland.yst.production.sale.api.vo.resp.shop.BipItemSkuAttrRespVO;
import com.elitesland.yst.production.sale.api.vo.resp.shop.BipItemSkuRespVO;
import com.elitesland.yst.production.sale.api.vo.resp.shop.app.BipItemEvalAppRespVO;
import com.elitesland.yst.production.sale.api.vo.resp.shop.app.BipItemEvalDetailAppRespVO;
import com.elitesland.yst.production.sale.api.vo.save.shop.BipItemEvalDetailSaveVO;
import com.elitesland.yst.production.sale.api.vo.save.shop.BipItemEvalSaveVO;
import com.elitesland.yst.production.sale.api.vo.save.shop.BipItemEvalSimpleSaveVO;
import com.elitesland.yst.production.sale.common.model.CurrentUserDTO;
import com.elitesland.yst.production.sale.convert.shop.BipItemConvert;
import com.elitesland.yst.production.sale.convert.shop.BipItemEvalCovert;
import com.elitesland.yst.production.sale.core.service.BaseServiceImpl;
import com.elitesland.yst.production.sale.core.service.UserService;
import com.elitesland.yst.production.sale.entity.*;
import com.elitesland.yst.production.sale.event.ItemEvalChangeEvent;
import com.elitesland.yst.production.sale.repo.shop.*;
import com.elitesland.yst.production.sale.rmi.ystsystem.RmiSysUserService;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.Predicate;
import com.querydsl.jpa.impl.JPAQueryFactory;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.*;
import java.util.stream.Collectors;

/**
 * Created with IntelliJ IDEA.
 *
 * @Author: wang yinghao
 * @Date: 2021/08/19/15:16
 * @Description:
 */
@Service
@Slf4j
@RequiredArgsConstructor
public class BipItemEvalServiceImpl extends BaseServiceImpl implements BipItemEvalService {
    @Autowired
    private BipItemEvalRepo bipItemEvalRepo;

    @Autowired
    private BipOrderDRepo bipOrderDRepo;

    @Autowired
    private BipItemRepo bipItemRepo;
    @Autowired
    private BipItemEvalRepoProc bipItemEvalRepoProc;
    @Autowired
    private BipOrderRepo bipOrderRepo;
    @Autowired
    private BipOrderRepoProc bipOrderRepoProc;
    @Autowired
    private BipItemSkuRepo bipItemSkuRepo;

    @Autowired
    private BipItemPicRepo bipItemPicRepo;

    @Autowired
    protected JPAQueryFactory jpaQueryFactory;
    @Autowired
    private RmiSysUserService rmiSysUserService;

    @Autowired
    private BipCustUserBindRepoProc bipCustUserBindRepoProc;

    @Autowired
    private BipCompanyManageRepo bipCompanyManageRepo;

    private final QBipItemEvalDo qBipItemEvalDo=QBipItemEvalDo.bipItemEvalDo;
    private final static String REPLACE = "*";
    private final static String REPLACE_CHAR = "星";

    /***
        * @Description: 商品评价分页查询
        * @Param: [bipItemEvalParmVO]
        * @return: com.elitescloud.cloudt.common.base.PagingVO<com.elitesland.sale.entity.BipItemEvalDo>
        * @Author: wangyinghao
        * @Date: 2021/8/19
        */
    @Override
    public PagingVO<BipItemEvalRespVO> findItemEvalPage(BipItemEvalParmVO bipItemEvalParmVO){
        // 添加权限查询
        Predicate predicate = where(bipItemEvalParmVO);
        predicate = ExpressionUtils.and(predicate, DataAuthJpaUtil.dataAuthJpaPredicate(qBipItemEvalDo.getMetadata()));
        Page<BipItemEvalDo> page=bipItemEvalRepo.findAll(predicate,bipItemEvalParmVO.getPageRequest());
        List<BipItemEvalRespVO> list=page.getContent().stream().map(BipItemEvalCovert.INSTANCE::doToRespVO).collect(Collectors.toList());

        // 查询数据
        List<Long> skuIds = list.stream().map(BipItemEvalRespVO::getSkuId).collect(Collectors.toList());
        List<Long> ouIds = list.stream().map(BipItemEvalRespVO::getOuId).collect(Collectors.toList());
        Map<Long, String> skuMap = bipItemSkuRepo.findAllById(skuIds).stream().collect(Collectors.toMap(BipItemSkuDO::getId, BipItemSkuDO::getSkuCode, (t1, t2) -> t1));
        Map<Long, String> ouMap = bipCompanyManageRepo.findAllByOuIdIn(ouIds).stream().collect(Collectors.toMap(BipCompanyManageDO::getOuId, BipCompanyManageDO::getOuName, (t1, t2) -> t1));

        // 补充数据
        for(BipItemEvalRespVO vo:list){

            Long itemId=vo.getItemId();

            if(itemId==null){
                throw new BusinessException("商品Id不能为空!");
            }

            Optional<BipItemDO> optionalBipItemDO=bipItemRepo.findById(itemId);
            if(optionalBipItemDO.isPresent()){
                BipItemDO bipItemDO = optionalBipItemDO.get();
                vo.setScoreEval(bipItemDO.getScoreEval());
                vo.setNumEval(bipItemDO.getNumEval());
                vo.setRateEvalGood(bipItemDO.getRateEvalGood());
                vo.setNumEvalGood(bipItemDO.getNumEvalGood());
            }

            // SKU编号
            vo.setSkuCode(skuMap.get(vo.getSkuId()));
            // 公司
            vo.setOuName(ouMap.get(vo.getOuId()));
            // 评分
            vo.setItemEvalScore(StringUtils.isNotBlank(vo.getItemEvalScore()) ? vo.getItemEvalScore()+REPLACE_CHAR : null);

        }
        return PagingVO.<BipItemEvalRespVO>builder()
                .total(page.getTotalElements())
                .records(list)
                .build();

    }

    /***
     * @Description: APP 商品评价分页查询
     * @Param: [bipItemEvalParmVO]
     * @return: com.elitescloud.cloudt.common.base.PagingVO<com.elitesland.sale.entity.BipItemEvalDo>
     * @Author: wangyinghao
     * @Date: 2021/8/19
     */
    @Override
    public PagingVO<BipItemEvalDetailAppRespVO> findItemEvalAppPage(BipItemEvalParmVO bipItemEvalParmVO){
        Page<BipItemEvalDo> page=bipItemEvalRepo.findAll(where(bipItemEvalParmVO),bipItemEvalParmVO.getPageRequest());
        List<BipItemEvalDetailAppRespVO> list=page.getContent().stream().map(BipItemEvalCovert.INSTANCE::doToAppDetailRespVO).collect(Collectors.toList());

        Map<Long,List<SysUserRpcDTO>> map=findUserInfo(list);

        for(BipItemEvalDetailAppRespVO bipItemEvalDetailAppRespVO:list){
            buildAttr(bipItemEvalDetailAppRespVO);
            Long itemId=bipItemEvalDetailAppRespVO.getItemId();

            if(itemId==null){
                throw new BusinessException("商品Id不能为空!");
            }
            if(itemId!=null){
                BipItemDO bipItemDO=bipItemRepo.findById(itemId).get();
                bipItemEvalDetailAppRespVO.setScoreEval(bipItemDO.getScoreEval());
                bipItemEvalDetailAppRespVO.setNumEval(bipItemDO.getNumEval());
                bipItemEvalDetailAppRespVO.setRateEvalGood(bipItemDO.getRateEvalGood());
                bipItemEvalDetailAppRespVO.setNumEvalGood(bipItemDO.getNumEvalGood());
                bipItemEvalDetailAppRespVO.setItemPicFileCode(bipItemDO.getMainPicFileCode());
            }
            if(!bipItemEvalDetailAppRespVO.getIsPublic()){
                String userName=bipItemEvalDetailAppRespVO.getCustAccountName();
                bipItemEvalDetailAppRespVO.setCustAccountName(hideUserName1(userName));
            }
            List<SysUserRpcDTO> sysUserRpcDTOList=map.get(bipItemEvalDetailAppRespVO.getCustAccountId());
            if(sysUserRpcDTOList!=null&&!sysUserRpcDTOList.isEmpty()){
                SysUserRpcDTO sysUserRpcDTO=sysUserRpcDTOList.get(0);
                bipItemEvalDetailAppRespVO.setAvatarCode(sysUserRpcDTO.getAvatarCode());

            }
            if(StringUtils.isNotBlank(bipItemEvalDetailAppRespVO.getEvalFileCodes())){
                String fileCode=bipItemEvalDetailAppRespVO.getEvalFileCodes();
                List arrayList= Arrays.asList(fileCode.split(","));
               List<FileObjRespVO> fileList= getFile(arrayList);
                bipItemEvalDetailAppRespVO.setFileObjRespVOList(fileList);
            }


        }


        return PagingVO.<BipItemEvalDetailAppRespVO>builder()
                .total(page.getTotalElements())
                .records(list)
                .build();

    }

    /**
     * 获取用户信息
     * @param bipItemEvalDetailAppRespVOS
     * @return
     */
    public Map<Long,List<SysUserRpcDTO>> findUserInfo( List<BipItemEvalDetailAppRespVO> bipItemEvalDetailAppRespVOS){

        List<Long> userIds=bipItemEvalDetailAppRespVOS.stream().map(BipItemEvalDetailAppRespVO::getCustAccountId).distinct().collect(Collectors.toList());

        SysUserRpcDtoParam sysUserRpcDtoParam=new SysUserRpcDtoParam();
        sysUserRpcDtoParam.setUserIds(userIds);
        List<SysUserRpcDTO> sysUserRpcDTOS=rmiSysUserService.findUserRpcDtoByParam(sysUserRpcDtoParam);

        Map<Long,List<SysUserRpcDTO>> map=sysUserRpcDTOS.stream().collect(Collectors.groupingBy(SysUserRpcDTO::getId)
        );
        return map;
    }

    /**
     * 根据订单号查询订单评价
     * @param id
     * @return
     */
    @Override
    public BipItemEvalAppRespVO findItemEvalByOrderId(Long id){
        List<BipItemEvalDo> bipItemEvalDoList=bipItemEvalRepoProc.findItemEvalByOrderId(id);

        List<BipItemEvalDetailAppRespVO> bipItemEvalDetailAppRespVOS=new ArrayList<>();
        BipItemEvalAppRespVO bipItemEvalAppRespVO=new BipItemEvalAppRespVO();

        List<BipItemEvalDetailAppRespVO> bipItemEvalDetailAppRespVOList=bipItemEvalDoList.stream().map(BipItemEvalCovert.INSTANCE::doToAppDetailRespVO).collect(Collectors.toList());
        Map<Long,List<SysUserRpcDTO>> map=findUserInfo(bipItemEvalDetailAppRespVOList);

        for(BipItemEvalDetailAppRespVO bipItemEvalDetailAppRespVO:bipItemEvalDetailAppRespVOList){

            buildAttr(bipItemEvalDetailAppRespVO);
            Long itemId=bipItemEvalDetailAppRespVO.getItemId();

            if(itemId==null){
                throw new BusinessException("商品Id不能为空!");
            }
            if(itemId!=null){
                BipItemDO bipItemDO=bipItemRepo.findById(itemId).get();
                bipItemEvalDetailAppRespVO.setScoreEval(bipItemDO.getScoreEval());
                bipItemEvalDetailAppRespVO.setNumEval(bipItemDO.getNumEval());
                bipItemEvalDetailAppRespVO.setRateEvalGood(bipItemDO.getRateEvalGood());

//                bipItemEvalDetailAppRespVO.setItemPicFileCode(bipItemDO.getMainPicFileCode());
            }
            List<SysUserRpcDTO> sysUserRpcDTOList=map.get(bipItemEvalDetailAppRespVO.getCustAccountId());
            if(sysUserRpcDTOList!=null&&!sysUserRpcDTOList.isEmpty()){
                SysUserRpcDTO sysUserRpcDTO=sysUserRpcDTOList.get(0);
                bipItemEvalDetailAppRespVO.setAvatarCode(sysUserRpcDTO.getAvatarCode());

            }


            if(StringUtils.isNotBlank(bipItemEvalDetailAppRespVO.getEvalFileCodes())){
                String fileCode=bipItemEvalDetailAppRespVO.getEvalFileCodes();
                List arrayList= Arrays.asList(fileCode.split(","));
                List<FileObjRespVO> fileList= getFile(arrayList);
                bipItemEvalDetailAppRespVO.setFileObjRespVOList(fileList);
            }

            bipItemEvalDetailAppRespVOS.add(bipItemEvalDetailAppRespVO);

        }


        BipOrderDO bipOrderDO=bipOrderRepo.findById(id).get();

        bipItemEvalAppRespVO.setLogicEvalScore(bipOrderDO.getLogicEvalScore());
        bipItemEvalAppRespVO.setServerEvalScore(bipOrderDO.getServerEvalScore());
        bipItemEvalAppRespVO.setOrderDocNo(bipOrderDO.getDocNo());
        bipItemEvalAppRespVO.setBipItemEvalDetailAppRespVOS(bipItemEvalDetailAppRespVOS);

        return bipItemEvalAppRespVO;

    }

    /**
     * 构建商品属性
     * @param bipItemEvalDetailAppRespVO
     */
    public void buildAttr(BipItemEvalDetailAppRespVO bipItemEvalDetailAppRespVO){
        Long skuId=bipItemEvalDetailAppRespVO.getSkuId();
        if(skuId==null){
            throw new BusinessException("商品skuID不能为空!");
        }
        BipItemSkuDO bipItemSkuDO=bipItemSkuRepo.findById(skuId).get();
        BipItemSkuRespVO bipItemSkuRespVO= BipItemConvert.INSTANCE.sku2DetailRespVO(bipItemSkuDO);
        bipItemSkuRespVO.setAttrList(convert2List(bipItemSkuDO.getAttr(), BipItemSkuAttrRespVO.class));

        List<BipItemSkuAttrRespVO> attrList=convert2List(bipItemSkuDO.getAttr(), BipItemSkuAttrRespVO.class);

        //属性转换字符串
        List<String> attrStrlist=new ArrayList<>();
        for(int i=0;i<attrList.size();i++){
            BipItemSkuAttrRespVO bipItemSkuAttrRespVO= JSON.parseObject(JSON.toJSONString(attrList.get(0)),BipItemSkuAttrRespVO.class);
            if(bipItemSkuAttrRespVO!=null){
                attrStrlist.add(bipItemSkuAttrRespVO.getName()+":"+bipItemSkuAttrRespVO.getValue());
            }

        }

        String attstr=String.join(";",attrStrlist);
        bipItemEvalDetailAppRespVO.setItemAttr(attstr);
    }

    /**
        * @Description: 商品评价查询
        * @Param: [bipItemEvalParmVO]
        * @return: java.util.List<com.elitesland.sale.entity.BipItemEvalDo>
        * @Author: wangyinghao
        * @Date: 2021/8/19
        */
    @Override
    public List<BipItemEvalRespVO> findItemEval(BipItemEvalParmVO bipItemEvalParmVO){
       List<BipItemEvalDo>list= jpaQueryFactory.
               select(qBipItemEvalDo)
               .from(qBipItemEvalDo)
               .where(where(bipItemEvalParmVO)).fetch();


        List<BipItemEvalRespVO> bipItemEvalRespVOS=list.stream().map(BipItemEvalCovert.INSTANCE::doToRespVO).collect(Collectors.toList());
        return bipItemEvalRespVOS;
    }

    /***
        * @Description: 商品评价保存
        * @Param: [bipItemEvalDo]
        * @return: void
        * @Author: wangyinghao
        * @Date: 2021/8/19
        */
    @Transactional(rollbackFor = Exception.class)
    @Override
    public void saveItemEval(BipItemEvalSaveVO bipItemEvalSaveVO){
        //@TODO 获取当前登录人
        CurrentUserDTO currentUserDTO= UserService.currentUser();

        //获取当前登录人信息和客户信息
        BipCustUserBindDO bipCustUserBindDO=null;

        if(Objects.nonNull(currentUserDTO.getUserId())){
            bipCustUserBindDO=bipCustUserBindRepoProc.getByUserId(currentUserDTO.getUserId());
        }else{
            throw new BusinessException("请先登录!");
        }

        List<BipItemEvalDetailSaveVO>  list=bipItemEvalSaveVO.getBipItemEvalDetailSaveVOS();

        for (BipItemEvalDetailSaveVO bipItemEvalDetailSaveVO:list){
            bipItemEvalDetailSaveVO.setTel(bipCustUserBindDO.getContactPhone());
            bipItemEvalDetailSaveVO.setCustAccountId(bipCustUserBindDO.getUserId());
            bipItemEvalDetailSaveVO.setCustAccountName(bipCustUserBindDO.getUsername());
            bipItemEvalDetailSaveVO.setOuId(bipCustUserBindDO.getOuId());

            BipItemDO itemDO = bipItemRepo.findById(bipItemEvalDetailSaveVO.getItemId()).get();
            bipItemEvalDetailSaveVO.setItemCode(itemDO.getItemCode());

            BipOrderDO orderDO = bipOrderRepo.findById(bipItemEvalDetailSaveVO.getOrderId()).get();
            bipItemEvalDetailSaveVO.setDocNo(orderDO.getDocNo());

        }

        bipItemEvalRepo.saveAll(BipItemEvalCovert.INSTANCE.savaVosToDos(list));

        BipOrderDO bipOrderDO=bipOrderRepo.findById(bipItemEvalSaveVO.getOrderId()).get();
        bipOrderDO.setId(bipItemEvalSaveVO.getOrderId());
        bipOrderDO.setLogicEvalScore(bipItemEvalSaveVO.getLogicEvalScore());
        bipOrderDO.setServerEvalScore(bipItemEvalSaveVO.getServerEvalScore());
        bipOrderDO.setIsEval(true);
        bipOrderDO.setEvalTime(LocalDateTime.now());

        bipOrderRepo.save(bipOrderDO);

        List<Long> itemIdList=list.stream().map(bipItemEvalDetailSaveVO -> { return bipItemEvalDetailSaveVO.getItemId();}).collect(Collectors.toList());


        for(Long itemId:itemIdList){
            publishEventAsync(new ItemEvalChangeEvent(this, itemId));

        }
    }


    /**
     * 更新评价
     * @param bipItemEvalDetailSaveVOList
     */
    @Transactional(rollbackFor = Exception.class)
    @Override
    public void updateItemEval(List<BipItemEvalDetailSaveVO> bipItemEvalDetailSaveVOList){
        //@TODO 获取当前登录人

        List<BipItemEvalDo> bipItemEvalDoList=new ArrayList<>();

        for(BipItemEvalDetailSaveVO bipItemEvalDetailSaveVO:bipItemEvalDetailSaveVOList){

            if( bipItemEvalDetailSaveVO.getId()==null){
                throw new BusinessException("评价id不能为空");
            }
            BipItemEvalDo bipItemEvalDo=bipItemEvalRepo.findById(bipItemEvalDetailSaveVO.getId()).get();
            BipItemEvalCovert.INSTANCE.copySavaVoToDo(bipItemEvalDetailSaveVO,bipItemEvalDo);
            bipItemEvalDoList.add(bipItemEvalDo);
        }

        bipItemEvalRepo.saveAll(bipItemEvalDoList);

    }


    /**
     *
     * @param bipItemEvalSimpleSaveVO
     */
    @Transactional(rollbackFor = Exception.class)
    @Override
    public void updateItemEvalIsShow(BipItemEvalSimpleSaveVO bipItemEvalSimpleSaveVO){

        List<Long> ids=bipItemEvalSimpleSaveVO.getIds();
        boolean isShow=bipItemEvalSimpleSaveVO.getIsShow();

        if(ids==null){
            throw new BusinessException("参数不能为空!");
        }
        bipItemEvalRepoProc.updateItmeEvalShow(ids,isShow);

    }


    /**
     * 删除评价
     * @param ids
     */
    @Transactional(rollbackFor = Exception.class)
    @Override
    public void deleteItemEvalByIds(List<Long> ids){

        bipItemEvalRepo.deleteBipItemEvalDoByIds(ids);

    }


    @Override
    @Transactional(rollbackFor = Exception.class)
    public void replayItemEval(BipItemEvalDetailSaveVO bipItemEvalDetailSaveVO){
        CurrentUserDTO currentUserDTO= UserService.currentUser();
        Assert.notNull(bipItemEvalDetailSaveVO.getId(),"评价表ID为空！");

        bipItemEvalRepo.findById(bipItemEvalDetailSaveVO.getId()).ifPresentOrElse(aDo->{
            aDo.setReplayName(currentUserDTO.getDetail().getFirstName());
            aDo.setReplayUserId(currentUserDTO.getUserId());
            aDo.setReplayTime(LocalDateTime.now());
            aDo.setReplayContext(bipItemEvalDetailSaveVO.getReplayContext());
            aDo.setIsReplay(true);

            bipItemEvalRepo.save(aDo);
        },()->{throw new BusinessException("未找到该评价记录：ID"+bipItemEvalDetailSaveVO.getId());});

    }

    @Override
    public ApiResult<Long> countItemEval(Long itemId, Integer minScore) {
        var count = minScore == null ? bipItemEvalRepoProc.countItemEvalNum(itemId) : bipItemEvalRepoProc.countItemEvalNum(itemId, minScore);
        return ApiResult.ok(count);
    }

    @Override
    public ApiResult<BigDecimal> countItemEvalScore(Long itemId) {
        // 评价次数
        var num = bipItemEvalRepoProc.countItemEvalNum(itemId);
        if (num == 0) {
            return ApiResult.ok(BigDecimal.ZERO);
        }

        // 总星数
        var sum = bipItemEvalRepoProc.sumItemEval(itemId);
        if (sum == null) {
            sum = 0;
        }
        var score = BigDecimal.valueOf(sum * 1.0 / num);
        return ApiResult.ok(score);
    }

    /***
        * @Description: 商品评价查询条件
        * @Param: [bipItemEvalParmVO]
        * @return: com.querydsl.core.types.Predicate
        * @Author: wangyinghao
        * @Date: 2021/8/19
        */
    public Predicate where(BipItemEvalParmVO bipItemEvalParmVO) {
        Predicate predicate=qBipItemEvalDo.isNotNull();
        if(Objects.nonNull(bipItemEvalParmVO)){
            if(StringUtils.isNotBlank(bipItemEvalParmVO.getDocNo())){
                predicate= ExpressionUtils.and(predicate,qBipItemEvalDo.docNo.like("%"+bipItemEvalParmVO.getDocNo()+"%"));
            }

            if(Objects.nonNull(bipItemEvalParmVO.getItemId())){
                predicate= ExpressionUtils.and(predicate,qBipItemEvalDo.itemId.eq(bipItemEvalParmVO.getItemId()));
            }

            if(StringUtils.isNotBlank(bipItemEvalParmVO.getItemCode())){
                predicate= ExpressionUtils.and(predicate,qBipItemEvalDo.itemCode.like("%"+bipItemEvalParmVO.getItemCode()+"%"));
            }

            if(StringUtils.isNotBlank(bipItemEvalParmVO.getOuName())){
                predicate= ExpressionUtils.and(predicate,qBipItemEvalDo.ouName.eq(bipItemEvalParmVO.getOuName()));
            }

            if(StringUtils.isNotBlank(bipItemEvalParmVO.getOuCode())){
                predicate= ExpressionUtils.and(predicate,qBipItemEvalDo.ouCode.eq(bipItemEvalParmVO.getOuCode()));

            }

            if(bipItemEvalParmVO.getItemEvalScore() != null){
                predicate= ExpressionUtils.and(predicate,qBipItemEvalDo.itemEvalScore.eq(bipItemEvalParmVO.getItemEvalScore()));

            }

            if(Objects.nonNull(bipItemEvalParmVO.getOuId())){
                predicate= ExpressionUtils.and(predicate,qBipItemEvalDo.ouId.eq(bipItemEvalParmVO.getOuId()));
            }

            if(Objects.nonNull(bipItemEvalParmVO.getIsShow())){
                predicate= ExpressionUtils.and(predicate,qBipItemEvalDo.isShow.eq(bipItemEvalParmVO.getIsShow()));
            }

//            predicate = ExpressionUtils.and(predicate, DataAuthJpaUtil.dataAuthJpaPredicate(qBipItemEvalDo.getMetadata()));
        }
        return predicate;
    }


    @Override
    public BipItemEvalRespVO findItemEval(Long id){
        BipItemEvalDo bipItemEvalDo=bipItemEvalRepo.findById(id).get();

        BipItemEvalRespVO vo=BipItemEvalCovert.INSTANCE.doToRespVO(bipItemEvalDo);

        // 商品评分
        vo.setItemEvalScore(bipItemEvalDo.getItemEvalScore()+"星");

        // 订单编号
        Optional<BipOrderDO> orderDO = bipOrderRepo.findById(bipItemEvalDo.getOrderId());
        orderDO.ifPresent(order->{
            vo.setDocNo(order.getDocNo());
        });

        // 公司
        List<BipCompanyManageDO> oulist = bipCompanyManageRepo.findAllByOuIdIn(Arrays.asList(bipItemEvalDo.getOuId()));
        if (oulist!=null&&oulist.size()>0){
            vo.setOuName(oulist.get(0).getOuName());
        }

        Optional<BipItemDO> spu = bipItemRepo.findById(bipItemEvalDo.getItemId());
        spu.ifPresent(p->{
            vo.setItemImageCodeUrl(p.getMainPicUrl());
        });

        Optional<BipItemDO> sku = bipItemRepo.findById(bipItemEvalDo.getSkuId());
        sku.ifPresent(k-> vo.setItemSkuImageCode(k.getMainPicId()));

        //评价图片拆成列表
        if(StringUtils.isNotBlank(vo.getEvalFileCodes())){
            String fileCode = vo.getEvalFileCodes();
            List<String> arrayList = Arrays.asList(fileCode.split(","));
            vo.setEvalFileCodeList(arrayList);
        }

        if (vo.getItemId()!=null){
            BipItemPicDO pic = bipItemPicRepo.findFirstByBipItemIdAndPicAndMain(vo.getItemId(),true,true);
            if (pic!=null){
                vo.setItemImageCode(pic.getFileCode());
            } else {
                BipItemPicDO picture = bipItemPicRepo.findFirstByBipItemIdAndPicAndMain(vo.getItemId(),true,false);
                if (picture!=null){
                    vo.setItemImageCode(picture.getFileCode());
                }
            }
        }

        return vo;
    }


    /**
     * 隐藏用户名
     * @param username
     * @return
     */
    public static String hideUserName1(String username) {
        if (StrUtil.isBlank(username) || username.length() < 2) {
            return username;
        }
        int length = username.length();
        if (length == 2) {
            return username.charAt(0) + REPLACE;
        }

        return username.charAt(0) + REPLACE + REPLACE + username.charAt(length - 1);
    }
}
