package com.elitesland.yst.production.sale.task.delay;

import com.alibaba.fastjson.JSON;
import com.elitesland.yst.production.sale.api.service.shop.BipOrderService;
import com.elitesland.yst.production.sale.api.vo.save.shop.BipOrderSaveVO;
import com.elitesland.yst.production.sale.entity.BipOrderDO;
import com.elitesland.yst.production.sale.repo.shop.BipOrderRepo;
import com.elitescloud.cloudt.core.task.delay.DelayTaskHandler;
import com.elitescloud.cloudt.core.task.delay.TaskInfo;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

/**
 * Created with IntelliJ IDEA.
 *
 * @Author: wang yinghao
 * @Date: 2021/10/20/17:31
 * @Description:
 */
@Component
@Slf4j
public class BipOrderCancleTask implements DelayTaskHandler<Long> {

    public static final String TASK_TYPE = "bip_order_cancle";

    private final BipOrderService bipOrderService;

    @Autowired
    private BipOrderRepo bipOrderRepo;

    public BipOrderCancleTask(BipOrderService bipOrderService) {
        this.bipOrderService = bipOrderService;
    }

    @Override
    public String[] supportType() {
        return new String[]{TASK_TYPE};
    }

    @Override
    public boolean execute(TaskInfo<Long> taskInfo) {
        var orderId = taskInfo.getPayload();

        log.info("订单取消--订单id", orderId);

        BipOrderSaveVO bipOrderSaveVO=new BipOrderSaveVO();

        bipOrderSaveVO.setId(orderId);
        bipOrderSaveVO.setStatus("cancelled");
        BipOrderDO bipOrderDO=bipOrderRepo.findById(orderId).get();
     //   if("unpaid".equals(bipOrderDO.getStatus())&&"online".equals(bipOrderDO.getPayMethodName())){
        if("unpaid".equals(bipOrderDO.getStatus())){
            log.info("订单信息--"+ JSON.toJSONString(bipOrderDO));
            bipOrderService.cancleOrder(bipOrderSaveVO);
            log.info("订单取消成功");
        }
        log.info("订单取消成功");
        return true;
    }
}
