package com.elitesland.yst.production.sale.workflow.service.impl;

import cn.hutool.core.collection.CollUtil;
import com.el.coordinator.core.common.exception.BusinessException;
import com.elitesland.yst.production.sale.api.service.SalAcceptanceService;
import com.elitesland.yst.production.sale.common.constant.UdcEnum;
import com.elitesland.yst.production.sale.entity.QSalAcceptanceDO;
import com.elitesland.yst.production.sale.entity.QSalQuotationDO;
import com.elitesland.yst.production.sale.entity.SalAcceptanceDO;
import com.elitesland.yst.production.sale.repo.SalAcceptanceRepo;
import com.elitesland.yst.production.sale.repo.SalAcceptanceRepoProc;
import com.elitesland.yst.production.sale.rmi.ystsystem.RmiSysUserFlowRoleRpcService;
import com.elitesland.yst.production.sale.workflow.service.SalAcceptanceProcessService;
import com.elitesland.workflow.enums.ProcInstStatus;
import com.elitescloud.cloudt.system.param.SysUserIdFlowRoleRpcParam;
import com.querydsl.jpa.impl.JPAQueryFactory;
import com.querydsl.jpa.impl.JPAUpdateClause;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

import java.time.LocalDateTime;
import java.util.*;
import java.util.stream.Collectors;

/**
 * <p>
 *
 * </p>
 *
 * @author zhao.zhi.hao
 * @since 2021/9/1 09:27
 */
@Slf4j
@Service
@RequiredArgsConstructor
public class SalAcceptanceProcessServiceImpl implements SalAcceptanceProcessService {
    private final JPAQueryFactory jpaQueryFactory;
    private final SalAcceptanceRepo salAcceptanceRepo;
    private final SalAcceptanceRepoProc salAcceptanceRepoProc;
    private final SalAcceptanceService salAcceptanceService;

    private final RmiSysUserFlowRoleRpcService rmiSysUserFlowRoleRpcService;
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void processStatusChange(long id, ProcInstStatus procInstStatus) {
        //1,查询单据是否存在
        Optional<SalAcceptanceDO> salAcceptanceDO = salAcceptanceRepo.findById(id);
        if (salAcceptanceDO.isPresent() == false) {
            throw new BusinessException("单据(id:" + id + ")不存在,无法审批");
        }

        QSalAcceptanceDO qSalAcceptanceDO = QSalAcceptanceDO.salAcceptanceDO;

        //2,修改审批状态
        JPAUpdateClause jpaUpdateClause = jpaQueryFactory.update(qSalAcceptanceDO)
                .set(qSalAcceptanceDO.procInstStatus, procInstStatus)
                .where(qSalAcceptanceDO.id.eq(id));

        //3,修改单据状态
        switch (procInstStatus) {
            case NOTSUBMIT: // 未提交
                jpaUpdateClause.set(qSalAcceptanceDO.acStatus, UdcEnum.SAL_AC_STATUS_DRAFT.getValueCode());//待提交
                break;
            case INTERRUPT: // 中断执行
                jpaUpdateClause.set(qSalAcceptanceDO.acStatus, UdcEnum.SAL_AC_STATUS_DRAFT.getValueCode());//待提交
                salAcceptanceRepo.updateProcInstId(id,null);
                break;
            case REJECTED: // 审批拒绝
                jpaUpdateClause.set(qSalAcceptanceDO.acStatus, UdcEnum.SAL_AC_STATUS_REJECTED.getValueCode());//已拒绝
                break;
            case INVALID: // 作废
                jpaUpdateClause.set(qSalAcceptanceDO.acStatus, UdcEnum.SAL_AC_STATUS_CL.getValueCode());//已取消
                break;
            case APPROVING: // 审批中
                jpaUpdateClause.set(qSalAcceptanceDO.acStatus, UdcEnum.SAL_AC_STATUS_APPROVING.getValueCode());//审批中
                break;
            case APPROVED: // 审批通过
                jpaUpdateClause.set(qSalAcceptanceDO.acStatus, UdcEnum.SAL_AC_STATUS_APPROVED.getValueCode())//已审批
                        .set(qSalAcceptanceDO.approvedTime, LocalDateTime.now())//审批完成时间
                ;
                break;
        }
        //执行
        jpaUpdateClause.execute();

        //4,其他业务
        if (procInstStatus.equals(ProcInstStatus.APPROVED)) {
            //todo:流程结束，处理业务
            salAcceptanceService.apprAcc(id,UdcEnum.COM_APPR_STATUS_APPROVED.getValueCode());
        }
        // 考虑库存因素，如果是取消该流程,回退到待提交状态或者是已取消状态时，把对应的库存回退掉
        if (procInstStatus.equals(ProcInstStatus.REJECTED) || procInstStatus.equals(ProcInstStatus.NOTSUBMIT) || procInstStatus.equals(ProcInstStatus.INVALID)) {
            //todo:审批拒绝,处理业务
            salAcceptanceService.apprAcc(id,UdcEnum.COM_APPR_STATUS_REJECTED.getValueCode());
        }
    }

    @Override
    public List<String> taskAssignee(Long businessKey, String customParams) {
        log.info("通过ouId,自定义参数获取用户列表，时间:{},入参:{}",LocalDateTime.now(),businessKey);
        Long ouId = salAcceptanceRepoProc.getOuIdById(Long.valueOf(businessKey));
        try {
            SysUserIdFlowRoleRpcParam sysUserIdFlowRoleRpcParam = new SysUserIdFlowRoleRpcParam();
            sysUserIdFlowRoleRpcParam.setOuIds(Collections.singletonList(ouId));
            List<String> flowRoleCodes = Arrays.asList(customParams.split(","));
            sysUserIdFlowRoleRpcParam.setFlowRoleCodes(flowRoleCodes);
            // 3.通过公司和角色信息,调支撑域接口查用户获取id
            log.info("公司角色查询信息"+ sysUserIdFlowRoleRpcParam);
            List<Long> userIdsByFlowRoles = rmiSysUserFlowRoleRpcService.findUserIdsByFlowRoles(sysUserIdFlowRoleRpcParam).stream().filter(Objects::nonNull).collect(Collectors.toList());
            List<String> userIds = userIdsByFlowRoles.stream().filter(Objects::nonNull).map(Object::toString).collect(Collectors.toList());
            if (!CollectionUtils.isEmpty(userIds)){
                return CollUtil.newArrayList(userIds);
            }
        }catch (Exception e){
            log.error("findUserIdsByFlowRoles error:",e);
            throw new BusinessException("调用支撑域查询审批角色对应审批人异常"+e,e);
        }
        return null;
    }
}
