package com.elitesland.yst.production.sale.workflow.service.impl;

import cn.hutool.core.collection.CollUtil;
import com.el.coordinator.core.common.exception.BusinessException;
import com.elitescloud.cloudt.system.param.SysUserIdFlowRoleRpcParam;
import com.elitescloud.cloudt.system.provider.org.EmployeeGroupRpcService;
import com.elitesland.yst.production.sale.common.constant.UdcEnum;
import com.elitesland.yst.production.sale.entity.QSalQuotationDO;
import com.elitesland.yst.production.sale.entity.SalQuotationDO;
import com.elitesland.yst.production.sale.repo.SalQuotationRepo;
import com.elitesland.yst.production.sale.repo.SalQuotationRepoProc;
import com.elitesland.yst.production.sale.rmi.ystsystem.RmiSysUserFlowRoleRpcService;
import com.elitesland.yst.production.sale.workflow.service.SalQuotationProcessService;
import com.elitesland.workflow.enums.ProcInstStatus;
import com.querydsl.jpa.impl.JPAQueryFactory;
import com.querydsl.jpa.impl.JPAUpdateClause;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

import java.time.LocalDateTime;
import java.util.*;
import java.util.stream.Collectors;

/**
 * <p>
 *
 * </p>
 *
 * @author zhao.zhi.hao
 * @since 2021/8/25 15:49
 */
@Slf4j
@Service
@RequiredArgsConstructor
public class SalQuotationProcessServiceImpl implements SalQuotationProcessService {

    private final JPAQueryFactory jpaQueryFactory;
    private final SalQuotationRepo salQuotationRepo;
    private final SalQuotationRepoProc salQuotationRepoProc;

    private final RmiSysUserFlowRoleRpcService rmiSysUserFlowRoleRpcService;

    private final EmployeeGroupRpcService employeeGroupRpcService;
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void processStatusChange(long id, ProcInstStatus procInstStatus) {
        //1,查询单据是否存在
        Optional<SalQuotationDO> salQuotationDO = salQuotationRepo.findById(id);
        if (salQuotationDO.isPresent() == false) {
            throw new BusinessException("单据(id:" + id + ")不存在,无法审批");
        }

        QSalQuotationDO qSalQuotationDO = QSalQuotationDO.salQuotationDO;

        //2,修改审批状态
        JPAUpdateClause jpaUpdateClause = jpaQueryFactory.update(qSalQuotationDO)
                .set(qSalQuotationDO.procInstStatus, procInstStatus)
                .where(qSalQuotationDO.id.eq(id));

        //3,修改单据状态
        switch (procInstStatus) {
            case NOTSUBMIT: // 未提交
                jpaUpdateClause.set(qSalQuotationDO.quotationStatus, UdcEnum.SAL_QUOTATION_STATUS_DRAFT.getValueCode());//待提交
                break;
            case INTERRUPT: // 中断执行
                jpaUpdateClause.set(qSalQuotationDO.quotationStatus, UdcEnum.SAL_QUOTATION_STATUS_DRAFT.getValueCode());//待提交
                salQuotationRepo.updateProcInstId(id,null);
                break;
            case REJECTED: // 审批拒绝
                jpaUpdateClause.set(qSalQuotationDO.quotationStatus, UdcEnum.SAL_QUOTATION_STATUS_REJECTED.getValueCode());//已拒绝
                break;
            case INVALID: // 作废
                jpaUpdateClause.set(qSalQuotationDO.quotationStatus, UdcEnum.SAL_QUOTATION_STATUS_CL.getValueCode());//已取消
                break;
            case APPROVING: // 审批中
                jpaUpdateClause.set(qSalQuotationDO.quotationStatus, UdcEnum.SAL_QUOTATION_STATUS_APPROVING.getValueCode());//审批中
                break;
            case APPROVED: // 审批通过
                jpaUpdateClause.set(qSalQuotationDO.quotationStatus, UdcEnum.SAL_QUOTATION_STATUS_APPROVED.getValueCode())//已审批
                        .set(qSalQuotationDO.approvedTime, LocalDateTime.now())//审批完成时间
                ;
                break;
        }
        //执行
        jpaUpdateClause.execute();

        //4,其他业务
        if (procInstStatus.equals(ProcInstStatus.APPROVED)) {
            //todo:流程结束，处理业务
        }
    }

    @Override
    public List<String> taskAssignee(Long businessKey, String customParams) {
        log.info("通过ouId,自定义参数获取用户列表，时间:{},入参:{}",LocalDateTime.now(),businessKey);
        Long ouId = salQuotationRepoProc.getOuIdById(Long.valueOf(businessKey));
        try {
            SysUserIdFlowRoleRpcParam sysUserIdFlowRoleRpcParam = new SysUserIdFlowRoleRpcParam();
            sysUserIdFlowRoleRpcParam.setOuIds(Collections.singletonList(ouId));
            List<String> flowRoleCodes = Arrays.asList(customParams.split(","));
            sysUserIdFlowRoleRpcParam.setFlowRoleCodes(flowRoleCodes);
            // 3.通过公司和角色信息,调支撑域接口查用户获取id
            log.info("公司角色查询信息"+ sysUserIdFlowRoleRpcParam);
//            List<Long> userIdsByFlowRoles = rmiSysUserFlowRoleRpcService.findUserIdsByFlowRoles(sysUserIdFlowRoleRpcParam).stream().filter(Objects::nonNull).collect(Collectors.toList());
//            List<Long> userIdsByFlowRoles = rmiSysUserFlowRoleRpcService.findUserIdsByFlowRolesV1(sysUserIdFlowRoleRpcParam).stream().filter(Objects::nonNull).collect(Collectors.toList());
            List<Long> userIdsByFlowRoles = employeeGroupRpcService.getUserIdsByGroupCode(sysUserIdFlowRoleRpcParam.getFlowRoleCodes().get(0)).getData().stream().filter(Objects::nonNull).collect(Collectors.toList());
            List<String> userIds = userIdsByFlowRoles.stream().filter(Objects::nonNull).map(Object::toString).collect(Collectors.toList());
            if (!CollectionUtils.isEmpty(userIds)){
                return CollUtil.newArrayList(userIds);
            }

        }catch (Exception e){
            log.error("findUserIdsByFlowRoles error:",e);
            throw new BusinessException("调用支撑域查询审批角色对应审批人异常"+e,e);
        }
        return null;
//        return new ArrayList<>();
    }
}
