/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.yst.production.sale.controller.crm;

import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.yst.production.sale.api.service.ComSaleFileInfoService;
import com.elitesland.yst.production.sale.api.service.CrmCustService;
import com.elitesland.yst.production.sale.api.service.DeCustAccountService;
import com.elitesland.yst.production.sale.api.vo.param.crm.CustAccountQueryParam;
import com.elitesland.yst.production.sale.api.vo.param.crm.CustUpdateVO;
import com.elitesland.yst.production.sale.api.vo.resp.com.ComSaleFileComVO;
import com.elitesland.yst.production.sale.api.vo.resp.crm.CustAccountVO;
import com.elitesland.yst.production.sale.api.vo.resp.crm.RemarkCustPwdVO;
import com.elitesland.yst.production.sale.api.vo.save.CustAccountUpdateVO;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"dealer/account"}, produces={"application/json"})
@Api(tags={"\u7ecf\u9500\u5546\u8d26\u6237"})
public class DeCustAccountController {
    private static final Logger log = LoggerFactory.getLogger(DeCustAccountController.class);
    @Autowired
    private DeCustAccountService deCustAccountService;
    @Autowired
    private ComSaleFileInfoService comSaleFileInfoService;
    @Autowired
    private CrmCustService crmCustService;

    @PostMapping(value={"/create"})
    @ApiOperation(value="\u521b\u5efa\u5b50\u8d26\u6237\u8d26\u53f7")
    public ApiResult<Object> createCustAccount(@RequestBody CustUpdateVO param) {
        try {
            return ApiResult.ok((Object)this.deCustAccountService.createSonUser(param));
        }
        catch (BusinessException e) {
            return ApiResult.fail((String)e.getMessage());
        }
    }

    @PostMapping(value={"/search"})
    @ApiOperation(value="\u67e5\u8be2\u5f53\u524d\u7528\u6237\u4e0b\u7684\u5b50\u8d26\u53f7")
    public ApiResult<PagingVO<CustAccountVO>> searchCustAccount(@RequestBody CustAccountQueryParam param) {
        try {
            return ApiResult.ok((Object)this.deCustAccountService.searchCustAccount(param));
        }
        catch (BusinessException e) {
            return ApiResult.fail((String)e.getMessage());
        }
    }

    @PostMapping(value={"/updateAccount"})
    @ApiOperation(value="\u4fee\u6539\u5b50\u8d26\u6237\u4fe1\u606f")
    public ApiResult<Object> updateCustAccount(@RequestBody CustUpdateVO param) {
        try {
            return ApiResult.ok((Object)this.deCustAccountService.updateSonAccount(param));
        }
        catch (BusinessException e) {
            return ApiResult.fail((String)e.getMessage());
        }
    }

    @PutMapping(value={"/updatePwd"})
    @ApiOperation(value="\u5fd8\u8bb0\u5bc6\u7801")
    public ApiResult<Object> remakePwd(@RequestBody CustAccountUpdateVO custAccountUpdate) {
        try {
            return ApiResult.ok((Object)this.deCustAccountService.remakePwd(custAccountUpdate));
        }
        catch (BusinessException e) {
            return ApiResult.fail((String)e.getMessage());
        }
    }

    @PostMapping(value={"/delSonAccount"})
    @ApiOperation(value="\u5220\u9664\u5b50\u8d26\u53f7")
    public ApiResult<Object> delSonAccount(@RequestBody List<Long> accountIds) {
        try {
            return ApiResult.ok((Object)this.deCustAccountService.delSonAccount(accountIds));
        }
        catch (BusinessException e) {
            return ApiResult.fail((String)e.getMessage());
        }
    }

    @PostMapping(value={"/updateImage"})
    @ApiOperation(value="\u4fee\u6539\u9644\u4ef6")
    public ApiResult<Object> updateComFile(@RequestBody ComSaleFileComVO param) {
        try {
            return ApiResult.ok((Object)this.comSaleFileInfoService.updateComFile(param));
        }
        catch (BusinessException e) {
            return ApiResult.fail((String)e.getMessage());
        }
    }

    @GetMapping(value={"/findCustInfo/{userId}"})
    @ApiOperation(value="\u67e5\u8be2\u5ba2\u6237\u4fe1\u606f")
    public ApiResult<Object> findCustInfo(@PathVariable Long userId) {
        try {
            return ApiResult.ok((Object)this.crmCustService.getCustSimpleByUserId(userId));
        }
        catch (BusinessException e) {
            return ApiResult.fail((String)e.getMessage());
        }
    }

    @GetMapping(value={"/sendVerificationCode/{phone}"})
    @ApiOperation(value="\u624b\u673a\u53d1\u9001\u9a8c\u8bc1\u7801")
    public ApiResult<String> sendSms(@PathVariable String phone) {
        try {
            return this.deCustAccountService.sendSms(phone);
        }
        catch (BusinessException e) {
            return ApiResult.fail((String)e.getMessage());
        }
    }

    @GetMapping(value={"/sendVerificationCode2/{phone}"})
    @ApiOperation(value="\u624b\u673a\u53d1\u9001\u9a8c\u8bc1\u7801")
    public ApiResult<List<RemarkCustPwdVO>> sendSms2(@PathVariable String phone) {
        try {
            return this.deCustAccountService.sendSms2(phone);
        }
        catch (BusinessException e) {
            return ApiResult.fail((String)e.getMessage());
        }
    }

    @GetMapping(value={"/isModifyPwd/{userName}"})
    public ApiResult<Boolean> isModifyPwd(@PathVariable String userName) {
        return ApiResult.ok((Object)this.deCustAccountService.isModifyPwd(userName));
    }

    @GetMapping(value={"/modifyPwdStatus/{userId}"})
    public ApiResult<String> modifyPwdStatus(@PathVariable Long userId) {
        return this.deCustAccountService.modifyPwdStatus(userId);
    }

    @GetMapping(value={"/isModifyPwdByUserId/{userId}"})
    public ApiResult<Boolean> isModifyPwdByUserId(@PathVariable Long userId) {
        return ApiResult.ok((Object)this.deCustAccountService.isModifyPwdByUserId(userId));
    }
}

