/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.yst.production.sale.event.listener;

import cn.hutool.core.lang.Assert;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitesland.yst.production.sale.api.service.shop.BipItemEvalService;
import com.elitesland.yst.production.sale.api.service.shop.BipItemMngService;
import com.elitesland.yst.production.sale.event.ItemEvalChangeEvent;
import java.math.BigDecimal;
import java.util.concurrent.CompletableFuture;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationListener;
import org.springframework.stereotype.Component;

@Component
public class ItemEvalNumListener
implements ApplicationListener<ItemEvalChangeEvent> {
    private static final Logger log = LoggerFactory.getLogger(ItemEvalNumListener.class);
    private final BipItemEvalService itemEvalService;
    private final BipItemMngService itemMngService;

    public ItemEvalNumListener(BipItemEvalService itemEvalService, BipItemMngService itemMngService) {
        this.itemEvalService = itemEvalService;
        this.itemMngService = itemMngService;
    }

    public void onApplicationEvent(ItemEvalChangeEvent event) {
        if (event.getBipItemId() == null) {
            log.error("\u76d1\u542c\u5230\u5546\u54c1\u8bc4\u4ef7\u53d8\u66f4\u4e8b\u4ef6\uff0c\u4f46\u5546\u54c1ID\u4e3a\u7a7a");
            return;
        }
        log.debug("\u76d1\u542c\u5230\u5546\u54c1\u3010{}\u3011\u7684\u8bc4\u4ef7\u53d8\u66f4", (Object)event.getBipItemId());
        CompletableFuture.runAsync(() -> this.updateItemEvalNum(event.getBipItemId())).exceptionally(e -> {
            log.error("\u66f4\u65b0\u5546\u54c1\u3010" + event.getBipItemId() + "\u3011\u8bc4\u4ef7\u6570\u91cf\u53d1\u751f\u5f02\u5e38", e);
            return null;
        });
    }

    private void updateItemEvalNum(Long bipItemId) {
        ApiResult totalResult = this.itemEvalService.countItemEval(bipItemId, null);
        Assert.isTrue((boolean)totalResult.isSuccess(), (String)totalResult.getMsg(), (Object[])new Object[0]);
        ApiResult goodResult = this.itemEvalService.countItemEval(bipItemId, Integer.valueOf(5));
        Assert.isTrue((boolean)goodResult.isSuccess(), (String)goodResult.getMsg(), (Object[])new Object[0]);
        this.itemMngService.updateEval(bipItemId, (Long)totalResult.getData(), (Long)goodResult.getData());
        ApiResult scoreResult = this.itemEvalService.countItemEvalScore(bipItemId);
        Assert.isTrue((boolean)scoreResult.isSuccess(), (String)scoreResult.getMsg(), (Object[])new Object[0]);
        this.itemMngService.updateEvalScore(bipItemId, (BigDecimal)scoreResult.getData());
    }
}

