/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.yst.production.sale.repo;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.core.security.util.DataAuthJpaUtil;
import com.elitesland.yst.production.sale.api.vo.param.zone.ZoneSettingPageParam;
import com.elitesland.yst.production.sale.api.vo.resp.zone.ZoneSettingVO;
import com.elitesland.yst.production.sale.entity.QZoneSettingDDO;
import com.elitesland.yst.production.sale.entity.QZoneSettingDO;
import com.elitesland.yst.production.sale.entity.ZoneSettingDDO;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.PathMetadata;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.core.types.dsl.EntityPathBase;
import com.querydsl.jpa.impl.JPAQuery;
import com.querydsl.jpa.impl.JPAQueryFactory;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Component;

@Component
public class ZoneSettingRepoProc {
    private final JPAQueryFactory jpaQueryFactory;
    private final QZoneSettingDO qZoneSettingDO = QZoneSettingDO.zoneSettingDO;
    private final QZoneSettingDDO qZoneSettingDDO = QZoneSettingDDO.zoneSettingDDO;

    public PagingVO<ZoneSettingVO> findPagingResult(ZoneSettingPageParam param) {
        JPAQuery<ZoneSettingVO> query = this.selectFromWhere(ZoneSettingVO.class, param);
        param.setPaging(query);
        param.fillOrders(query, (EntityPathBase)this.qZoneSettingDO);
        return PagingVO.builder().total(query.fetchCount()).records(query.fetch()).build();
    }

    private <T> JPAQuery<T> selectFromWhere(Class<T> cls, ZoneSettingPageParam param) {
        return (JPAQuery)((JPAQuery)this.jpaQueryFactory.select((Expression)Projections.bean(cls, (Expression[])new Expression[]{this.qZoneSettingDO.id, this.qZoneSettingDO.zoneCode, this.qZoneSettingDO.zoneName, this.qZoneSettingDO.status, this.qZoneSettingDO.sort, this.qZoneSettingDO.modifyTime, this.qZoneSettingDO.createTime, this.qZoneSettingDO.createUserId, this.qZoneSettingDO.ouId, this.qZoneSettingDO.ouName, this.qZoneSettingDO.creator, this.qZoneSettingDO.remark})).from((EntityPath)this.qZoneSettingDO)).where(this.where(param));
    }

    public Predicate where(ZoneSettingPageParam param) {
        ArrayList<Object> predicate = new ArrayList<Object>();
        if (null != param.getOuId()) {
            predicate.add(this.qZoneSettingDO.ouId.eq((Object)param.getOuId()));
        } else {
            predicate.add(DataAuthJpaUtil.dataAuthJpaPredicate((PathMetadata)this.qZoneSettingDO.getMetadata()));
        }
        if (StringUtils.isNotBlank((CharSequence)param.getStatus())) {
            predicate.add(this.qZoneSettingDO.status.eq((Object)param.getStatus()));
        }
        if (StringUtils.isNotBlank((CharSequence)param.getZoneCode())) {
            predicate.add(this.qZoneSettingDO.zoneCode.like("%" + param.getZoneCode() + "%"));
        }
        if (StringUtils.isNotBlank((CharSequence)param.getZoneName())) {
            predicate.add(this.qZoneSettingDO.zoneName.like("%" + param.getZoneName() + "%"));
        }
        predicate.add(this.qZoneSettingDO.deleteFlag.isNull().or((Predicate)this.qZoneSettingDO.deleteFlag.eq((Object)0)));
        return ExpressionUtils.allOf(predicate);
    }

    public List<ZoneSettingDDO> findZoneDByZOId(Long zoneId, Long ouId) {
        return ((JPAQuery)((JPAQuery)((JPAQuery)this.jpaQueryFactory.select((Expression)this.qZoneSettingDDO).from((EntityPath)this.qZoneSettingDDO)).where((Predicate)this.qZoneSettingDDO.zoneId.eq((Object)zoneId).and((Predicate)this.qZoneSettingDDO.ouId.eq((Object)ouId)).and((Predicate)this.qZoneSettingDDO.state.eq((Object)"SHELF")))).limit(6L)).fetch();
    }

    public ZoneSettingRepoProc(JPAQueryFactory jpaQueryFactory) {
        this.jpaQueryFactory = jpaQueryFactory;
    }
}

