/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.yst.production.sale.repo.shop;

import com.elitesland.yst.production.sale.api.vo.save.shop.BipOrderSaveVO;
import com.elitesland.yst.production.sale.entity.BipOrderDO;
import com.elitesland.yst.production.sale.entity.QBipOrderDO;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.dsl.BooleanExpression;
import com.querydsl.jpa.impl.JPAQuery;
import com.querydsl.jpa.impl.JPAQueryFactory;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.List;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

@Repository
public class BipOrderRepoProc {
    private final JPAQueryFactory jpaQueryFactory;

    @Transactional
    public boolean updateSignStatus(Long orderId, String status) {
        QBipOrderDO qBipOrderDO = QBipOrderDO.bipOrderDO;
        BooleanExpression predicate = qBipOrderDO.isNotNull();
        return this.jpaQueryFactory.update((EntityPath)qBipOrderDO).set((Path)qBipOrderDO.status, (Object)status).set(qBipOrderDO.signTime, (Object)LocalDateTime.now()).where(new Predicate[]{qBipOrderDO.id.eq((Object)orderId)}).execute() == 1L;
    }

    @Transactional
    public boolean updateOrderAllowStatus(Long orderId, String status) {
        QBipOrderDO qBipOrderDO = QBipOrderDO.bipOrderDO;
        BooleanExpression predicate = qBipOrderDO.isNotNull();
        return this.jpaQueryFactory.update((EntityPath)qBipOrderDO).set((Path)qBipOrderDO.status, (Object)status).where(new Predicate[]{qBipOrderDO.id.eq((Object)orderId)}).execute() == 1L;
    }

    @Transactional
    public boolean updatStatus(BipOrderSaveVO bipOrderSaveVO) {
        QBipOrderDO qBipOrderDO = QBipOrderDO.bipOrderDO;
        BooleanExpression predicate = qBipOrderDO.isNotNull();
        return this.jpaQueryFactory.update((EntityPath)qBipOrderDO).set((Path)qBipOrderDO.status, (Object)bipOrderSaveVO.getStatus()).where(new Predicate[]{qBipOrderDO.id.eq((Object)bipOrderSaveVO.getId())}).execute() == 1L;
    }

    @Transactional
    public boolean updatStatusByIdAndStatus(Long id, String status) {
        QBipOrderDO qBipOrderDO = QBipOrderDO.bipOrderDO;
        BooleanExpression predicate = qBipOrderDO.isNotNull();
        return this.jpaQueryFactory.update((EntityPath)qBipOrderDO).set((Path)qBipOrderDO.status, (Object)status).where(new Predicate[]{qBipOrderDO.id.eq((Object)id)}).execute() == 1L;
    }

    @Transactional
    public boolean updateOrderPayStatus(String payStatus, String docNo, String status, String txsn, LocalDateTime payTime, BigDecimal payAmt) {
        QBipOrderDO qBipOrderDO = QBipOrderDO.bipOrderDO;
        BooleanExpression predicate = qBipOrderDO.isNotNull();
        return this.jpaQueryFactory.update((EntityPath)qBipOrderDO).set((Path)qBipOrderDO.status, (Object)status).set((Path)qBipOrderDO.payStatus, (Object)payStatus).set((Path)qBipOrderDO.txsn, (Object)txsn).set(qBipOrderDO.payTime, (Object)payTime).set(qBipOrderDO.payDoneAmt, (Object)payAmt).where(new Predicate[]{qBipOrderDO.docNo.eq((Object)docNo)}).execute() == 1L;
    }

    public BipOrderDO findOrderByDocNo(String docNo) {
        QBipOrderDO qBipOrderDO = QBipOrderDO.bipOrderDO;
        return (BipOrderDO)((JPAQuery)((JPAQuery)this.jpaQueryFactory.select((Expression)qBipOrderDO).from((EntityPath)qBipOrderDO)).where((Predicate)qBipOrderDO.docNo.eq((Object)docNo))).fetchOne();
    }

    public List<BipOrderDO> findOrderByAuSignDays(Long days) {
        QBipOrderDO qBipOrderDO = QBipOrderDO.bipOrderDO;
        return ((JPAQuery)((JPAQuery)this.jpaQueryFactory.select((Expression)qBipOrderDO).from((EntityPath)qBipOrderDO)).where((Predicate)qBipOrderDO.status.eq((Object)"shipping").and((Predicate)qBipOrderDO.payTime.isNotNull().and((Predicate)qBipOrderDO.payTime.before((Comparable)LocalDateTime.now().minusDays(days)))).and((Predicate)qBipOrderDO.deleteFlag.ne((Object)1)))).fetch();
    }

    @Transactional
    public boolean updateOrderIsSend(List<String> orderCodes) {
        QBipOrderDO qBipOrderDO = QBipOrderDO.bipOrderDO;
        BooleanExpression predicate = qBipOrderDO.isNotNull();
        return this.jpaQueryFactory.update((EntityPath)qBipOrderDO).set((Path)qBipOrderDO.isSend, (Object)true).where(new Predicate[]{qBipOrderDO.docNo.in(orderCodes)}).execute() == 1L;
    }

    public BipOrderRepoProc(JPAQueryFactory jpaQueryFactory) {
        this.jpaQueryFactory = jpaQueryFactory;
    }
}

