/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.yst.production.sale.service;

import cn.hutool.core.util.StrUtil;
import com.elitesland.yst.production.sale.api.service.ComSaleFileInfoService;
import com.elitesland.yst.production.sale.api.vo.resp.com.ComSaleFileComVO;
import com.elitesland.yst.production.sale.convert.ComSaleFileInfoConvert;
import com.elitesland.yst.production.sale.entity.ComSaleFileInfoDO;
import com.elitesland.yst.production.sale.entity.QComSaleFileInfoDO;
import com.elitesland.yst.production.sale.repo.ComSaleFileInfoRepo;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Predicate;
import com.querydsl.jpa.impl.JPAQuery;
import com.querydsl.jpa.impl.JPAQueryFactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class ComSaleFileInfoServiceImpl
implements ComSaleFileInfoService {
    private static final Logger log = LoggerFactory.getLogger(ComSaleFileInfoServiceImpl.class);
    private final ComSaleFileInfoRepo crmCustFileInfoRepo;
    private final JPAQueryFactory jpaQueryFactory;
    private final QComSaleFileInfoDO comSaleFileInfoDO = QComSaleFileInfoDO.comSaleFileInfoDO;

    @Transactional(rollbackFor={Exception.class})
    public void comSaleFileHardSave(String businessType, String qualifyNo, List<ComSaleFileComVO> params) {
        if (qualifyNo == null) {
            return;
        }
        this.crmCustFileInfoRepo.deleteByBusinessTypeAndQualifyNo(businessType, qualifyNo);
        if (CollectionUtils.isEmpty(params)) {
            return;
        }
        List<ComSaleFileInfoDO> crmCustFileInfoDOS = params.stream().map(ComSaleFileInfoConvert.INSTANCE::saveVoToDo).collect(Collectors.toList());
        crmCustFileInfoDOS.forEach(c -> c.setBusinessType(businessType));
        this.crmCustFileInfoRepo.saveAll(crmCustFileInfoDOS);
    }

    @Transactional(rollbackFor={Exception.class})
    public void comSaleFileHardSave(String businessType, Long businessId, List<ComSaleFileComVO> params) {
        if (StrUtil.isNotBlank((CharSequence)businessType) && Objects.nonNull(businessId)) {
            this.crmCustFileInfoRepo.deleteByBusinessTypeAndBusinessId(businessType, businessId);
            if (CollectionUtils.isNotEmpty(params)) {
                List<ComSaleFileInfoDO> comSaleFileInfoDOS = params.stream().map(ComSaleFileInfoConvert.INSTANCE::saveVoToDo).collect(Collectors.toList());
                comSaleFileInfoDOS.forEach(c -> {
                    c.setBusinessId(businessId);
                    c.setBusinessType(businessType);
                });
                this.crmCustFileInfoRepo.saveAll(comSaleFileInfoDOS);
            }
        }
    }

    @Transactional(rollbackFor={Exception.class})
    public void comSaleFileHardSaveNotDelete(String businessType, Long businessId, List<ComSaleFileComVO> params) {
        if (StrUtil.isNotBlank((CharSequence)businessType) && Objects.nonNull(businessId) && CollectionUtils.isNotEmpty(params)) {
            List<ComSaleFileInfoDO> comSaleFileInfoDOS = params.stream().map(ComSaleFileInfoConvert.INSTANCE::saveVoToDo).collect(Collectors.toList());
            comSaleFileInfoDOS.forEach(c -> {
                c.setBusinessId(businessId);
                c.setBusinessType(businessType);
            });
            this.crmCustFileInfoRepo.saveAll(comSaleFileInfoDOS);
        }
    }

    public List<ComSaleFileComVO> findFileByBusinessId(String businessType, Long businessId) {
        if (Objects.isNull(businessId)) {
            return null;
        }
        JPAQuery jpaQuery = (JPAQuery)this.jpaQueryFactory.selectFrom((EntityPath)this.comSaleFileInfoDO).where((Predicate)this.comSaleFileInfoDO.businessId.eq((Object)businessId).and((Predicate)this.comSaleFileInfoDO.businessType.eq((Object)businessType)));
        List comSaleFileComDOS = jpaQuery.fetch();
        if (!CollectionUtils.isEmpty((Collection)comSaleFileComDOS)) {
            List<ComSaleFileComVO> comSaleFileComVOS = comSaleFileComDOS.stream().map(ComSaleFileInfoConvert.INSTANCE::doToSaveVo).collect(Collectors.toList());
            return comSaleFileComVOS;
        }
        return new ArrayList<ComSaleFileComVO>(0);
    }

    @Transactional(rollbackFor={Exception.class})
    public Object updateComFile(ComSaleFileComVO param) {
        if (param == null) {
            return null;
        }
        this.comSaleFileHardSave(param.getBusinessType(), param.getBusinessId(), Collections.singletonList(param));
        return null;
    }

    public List<ComSaleFileComVO> findFileByQualifyNos(String businessType, List<String> qualifyNos) {
        if (CollectionUtils.isEmpty(qualifyNos)) {
            return null;
        }
        List<ComSaleFileInfoDO> comSaleFileInfoDOS = this.findData(qualifyNos);
        List<Object> comSaleFileComVOS = new ArrayList<ComSaleFileComVO>();
        if (!CollectionUtils.isEmpty(comSaleFileInfoDOS)) {
            comSaleFileComVOS = comSaleFileInfoDOS.stream().map(ComSaleFileInfoConvert.INSTANCE::doToSaveVo).collect(Collectors.toList());
        }
        return comSaleFileComVOS;
    }

    private List<ComSaleFileInfoDO> findData(List<String> qualifyNos) {
        return ((JPAQuery)this.jpaQueryFactory.selectFrom((EntityPath)this.comSaleFileInfoDO).where((Predicate)this.comSaleFileInfoDO.qualifyNo.in(qualifyNos).and((Predicate)this.comSaleFileInfoDO.deleteFlag.isNull().or((Predicate)this.comSaleFileInfoDO.deleteFlag.eq((Object)0))))).fetch();
    }

    public ComSaleFileInfoServiceImpl(ComSaleFileInfoRepo crmCustFileInfoRepo, JPAQueryFactory jpaQueryFactory) {
        this.crmCustFileInfoRepo = crmCustFileInfoRepo;
        this.jpaQueryFactory = jpaQueryFactory;
    }
}

