/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.yst.production.sale.service;

import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.boot.model.entity.BaseModel;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitesland.yst.production.sale.api.service.DeCustAccountService;
import com.elitesland.yst.production.sale.api.vo.param.crm.CrmCustAccountParam;
import com.elitesland.yst.production.sale.api.vo.resp.crm.CustAccountVO;
import com.elitesland.yst.production.sale.dto.ModifyStoreMobile;
import com.elitesland.yst.production.sale.dto.StoreAccountSaveRpcDTO;
import com.elitesland.yst.production.sale.dto.param.StoreAccountSaveRpcParam;
import com.elitesland.yst.production.sale.entity.CustAccountDO;
import com.elitesland.yst.production.sale.entity.QCustAccountDO;
import com.elitesland.yst.production.sale.repo.CustAccountRepo;
import com.elitesland.yst.production.sale.repo.CustAccountRepoProc;
import com.elitesland.yst.production.sale.service.CrmCustAccountRpcService;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.dsl.BooleanExpression;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import jodd.util.StringUtil;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Service
@RestController
@RequestMapping(value={"/rpc/cloudt/sale/custaccount"})
public class CrmCustAccountRpcServiceImpl
implements CrmCustAccountRpcService {
    private static final Logger log = LoggerFactory.getLogger(CrmCustAccountRpcServiceImpl.class);
    private final DeCustAccountService deCustAccountService;
    private final CustAccountRepoProc custAccountRepoProc;
    private final CustAccountRepo custAccountRepo;

    public CustAccountVO getCustAccountByUserId(Long userId) {
        return this.deCustAccountService.getCustAccountByUserId(userId);
    }

    public List<CustAccountVO> getCustAccountBycustCode(List<String> custCodes) {
        if (CollectionUtils.isEmpty(custCodes)) {
            throw new BusinessException("\u5ba2\u6237\u7f16\u53f7\u4e3a\u7a7a");
        }
        List<CustAccountVO> accountByCustCodeList = this.custAccountRepoProc.getAccountByCustCode(custCodes);
        ArrayList<CustAccountVO> list = new ArrayList<CustAccountVO>();
        if (CollectionUtils.isNotEmpty(accountByCustCodeList)) {
            Map<String, List<CustAccountVO>> listMap = accountByCustCodeList.stream().collect(Collectors.groupingBy(CustAccountVO::getCustCode));
            listMap.entrySet().forEach(i -> ((List)i.getValue()).stream().max(Comparator.comparing(BaseModel::getId)).ifPresent(v -> list.add((CustAccountVO)v)));
        }
        return list;
    }

    public ApiResult<List<StoreAccountSaveRpcDTO>> saveStoreAccount(List<StoreAccountSaveRpcParam> param) {
        if (CollectionUtils.isEmpty(param)) {
            return ApiResult.ok();
        }
        List data = param.stream().map(this::saveStoreAccountQuietLy).collect(Collectors.toList());
        return ApiResult.ok(data);
    }

    public ApiResult<String> modifyStoreMobile(ModifyStoreMobile modifyStoreMobile) {
        if (Objects.isNull(modifyStoreMobile) || StringUtil.isBlank((CharSequence)modifyStoreMobile.getUserName()) || StringUtil.isBlank((CharSequence)modifyStoreMobile.getMobile())) {
            throw new BusinessException("\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        QCustAccountDO qCustAccountDO = QCustAccountDO.custAccountDO;
        BooleanExpression e = qCustAccountDO.userName.eq((Object)modifyStoreMobile.getUserName()).and((Predicate)qCustAccountDO.deleteFlag.eq((Object)0));
        Optional optional = this.custAccountRepo.findOne((Predicate)e);
        if (optional.isPresent()) {
            CustAccountDO custAccountDO = (CustAccountDO)optional.get();
            custAccountDO.setMobile(modifyStoreMobile.getMobile());
            this.custAccountRepo.save(custAccountDO);
            return ApiResult.ok((Object)custAccountDO.getCustCode());
        }
        return null;
    }

    private StoreAccountSaveRpcDTO saveStoreAccountQuietLy(StoreAccountSaveRpcParam param) {
        StoreAccountSaveRpcDTO resp = new StoreAccountSaveRpcDTO();
        resp.setStoreCode(param.getStoreCode());
        resp.setUserName(param.getStoreCode());
        resp.setFailureFlag(Boolean.FALSE);
        try {
            this.saveStoreAccount(param);
        }
        catch (Exception e) {
            log.warn("========>\u4fdd\u5b58\u95e8\u5e97\u8d26\u53f7\u51fa\u9519:{}", (Object)e.getMessage(), (Object)e);
            resp.setFailureFlag(Boolean.TRUE);
            resp.setFailureMsg(e.getMessage());
        }
        return resp;
    }

    private void saveStoreAccount(StoreAccountSaveRpcParam param) {
        CrmCustAccountParam createUserParam = new CrmCustAccountParam();
        String storeCode = param.getStoreCode();
        createUserParam.setCustCode(storeCode);
        createUserParam.setCustName(param.getStoreName());
        createUserParam.setMobile(param.getStoreContPhone());
        createUserParam.setUserName(storeCode);
        createUserParam.setDealerType("STORE");
        createUserParam.setBusinessType("ADMIN");
        createUserParam.setEnable(Objects.isNull(param.getEnable()) || param.getEnable() != false ? Boolean.TRUE : Boolean.FALSE);
        createUserParam.setSubAcFlag(Boolean.FALSE);
        createUserParam.setCreateFlag(this.notExists(createUserParam.getUserName()));
        this.deCustAccountService.createUser(createUserParam);
    }

    private Boolean notExists(String userName) {
        return this.custAccountRepoProc.exists(userName, null, "") == false;
    }

    public CrmCustAccountRpcServiceImpl(DeCustAccountService deCustAccountService, CustAccountRepoProc custAccountRepoProc, CustAccountRepo custAccountRepo) {
        this.deCustAccountService = deCustAccountService;
        this.custAccountRepoProc = custAccountRepoProc;
        this.custAccountRepo = custAccountRepo;
    }
}

