/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.yst.production.sale.service;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.text.CharSequenceUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.elitescloud.boot.core.base.UdcProvider;
import com.elitescloud.boot.core.support.udc.support.SysUdcProxyService;
import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.boot.model.entity.BaseModel;
import com.elitescloud.cloudt.common.annotation.SysCodeProc;
import com.elitescloud.cloudt.common.base.ApiCode;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.yst.production.sale.api.service.ExectRecordService;
import com.elitesland.yst.production.sale.api.service.TaskInfoDtlService;
import com.elitesland.yst.production.sale.api.service.TaskInfoService;
import com.elitesland.yst.production.sale.api.vo.param.com.FileParamVO;
import com.elitesland.yst.production.sale.api.vo.param.taskinfo.ExectRecordDtlTempQueryParam;
import com.elitesland.yst.production.sale.api.vo.param.taskinfo.ExecutRecordQueryParam;
import com.elitesland.yst.production.sale.api.vo.param.taskinfo.FileInfoQueryVO;
import com.elitesland.yst.production.sale.api.vo.resp.taskinfo.ExectRecordDtlTempRespVO;
import com.elitesland.yst.production.sale.api.vo.resp.taskinfo.ExecutRecordDtlRespVO;
import com.elitesland.yst.production.sale.api.vo.resp.taskinfo.ExecutRecordExportVO;
import com.elitesland.yst.production.sale.api.vo.resp.taskinfo.ExecutRecordRespVO;
import com.elitesland.yst.production.sale.api.vo.resp.taskinfo.FileInfoRespVO;
import com.elitesland.yst.production.sale.api.vo.resp.taskinfo.TaskInfoDtlRespVO;
import com.elitesland.yst.production.sale.api.vo.resp.taskinfo.TaskInfoRespVO;
import com.elitesland.yst.production.sale.api.vo.save.ExectRecordDtlTempSaveVO;
import com.elitesland.yst.production.sale.api.vo.save.ExecutRecordDtlSaveVO;
import com.elitesland.yst.production.sale.api.vo.save.ExecutRecordSaveVO;
import com.elitesland.yst.production.sale.api.vo.save.FileInfoSaveVO;
import com.elitesland.yst.production.sale.api.vo.save.TaskExecutionRecordSaveVO;
import com.elitesland.yst.production.sale.common.constant.UdcEnum;
import com.elitesland.yst.production.sale.convert.ExectRecordConvert;
import com.elitesland.yst.production.sale.convert.ExectRecordDtlConvert;
import com.elitesland.yst.production.sale.convert.ExectRecordDtlTempConvert;
import com.elitesland.yst.production.sale.convert.FileinfoConvert;
import com.elitesland.yst.production.sale.entity.ExectRecordDtlTempDO;
import com.elitesland.yst.production.sale.entity.ExecutRecordDO;
import com.elitesland.yst.production.sale.entity.ExecutRecordDtlDO;
import com.elitesland.yst.production.sale.entity.FileInfoDO;
import com.elitesland.yst.production.sale.entity.SalesmanInfoDO;
import com.elitesland.yst.production.sale.entity.SalesmanRegionDO;
import com.elitesland.yst.production.sale.repo.ExectRecordDtlTempRepo;
import com.elitesland.yst.production.sale.repo.ExectRecordDtlTempRepoProc;
import com.elitesland.yst.production.sale.repo.ExecutRecordDtlRepo;
import com.elitesland.yst.production.sale.repo.ExecutRecordDtlRepoProc;
import com.elitesland.yst.production.sale.repo.ExecutRecordRepo;
import com.elitesland.yst.production.sale.repo.ExecutRecordRepoProc;
import com.elitesland.yst.production.sale.repo.FileInfoRepo;
import com.elitesland.yst.production.sale.repo.FileInfoRepoProc;
import com.elitesland.yst.production.sale.repo.SalesmanInfoRepo;
import com.elitesland.yst.production.sale.repo.SalesmanRegionRepo;
import com.elitesland.yst.production.sale.rmi.ystsystem.RmiSysNextNumberService;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service
public class ExectRecordServiceImpl
implements ExectRecordService {
    private static final Logger log = LoggerFactory.getLogger(ExectRecordServiceImpl.class);
    private final ExecutRecordRepo executRecordRepo;
    private final ExecutRecordRepoProc executRecordRepoProc;
    private final ExecutRecordDtlRepo executRecordDtlRepo;
    private final ExecutRecordDtlRepoProc executRecordDtlRepoProc;
    private final ExectRecordDtlTempRepo exectRecordDtlTempRepo;
    private final ExectRecordDtlTempRepoProc exectRecordDtlTempRepoProc;
    private final SalesmanInfoRepo salesmanInfoRepo;
    private final SalesmanRegionRepo salesmanRegionRepo;
    private final RmiSysNextNumberService rmiSysNextNumberService;
    private final SysUdcProxyService sysUdcProxyService;
    private final UdcProvider udcProvider;
    private final FileInfoRepoProc fileInfoRepoProc;
    private final FileInfoRepo fileInfoRepo;
    private final TaskInfoDtlService taskInfoDtlService;
    private final TaskInfoService taskInfoService;
    @Value(value="${file.upload.url}")
    private String fileServerUrl;

    @Transactional
    public Long save(ExecutRecordSaveVO saveVO) {
        List tempDtlSaveVOS;
        List fileInfoSaveVOS;
        log.info("\u6267\u884c\u8bb0\u5f55\u5165\u53c2:" + JSON.toJSONString((Object)saveVO));
        String orderNo = null;
        if (saveVO.getId() != null && saveVO.getId() != 0L) {
            if (!UdcEnum.EXECT_RECORD_STATUS_DR.getValueCode().equals(saveVO.getState()) && !UdcEnum.EXECT_RECORD_STATUS_ARN.getValueCode().equals(saveVO.getState())) {
                throw new BusinessException(ApiCode.FAIL, "\u975e\u8349\u7a3f\uff0c\u5ba1\u6838\u62d2\u7edd\u72b6\u6001\u4e0d\u5141\u8bb8\u7f16\u8f91");
            }
            this.executRecordDtlRepo.deleteByMasId(saveVO.getId());
            this.fileInfoRepoProc.sourceDel(Arrays.asList(saveVO.getId()));
            this.exectRecordDtlTempRepoProc.sourceDel(Arrays.asList(saveVO.getId()));
        } else {
            orderNo = this.rmiSysNextNumberService.generateCode("yst-sale", "RCD", new ArrayList<String>());
            log.info("\u6267\u884c\u8bb0\u5f55\u53d1\u53f7\uff1a" + JSON.toJSONString((Object)orderNo));
        }
        saveVO.setState(UdcEnum.EXECT_RECORD_STATUS_DR.getValueCode());
        saveVO.setCode(StringUtils.isEmpty((CharSequence)orderNo) ? saveVO.getCode() : orderNo);
        ExecutRecordDO executRecordDO = ExectRecordConvert.INSTANCE.voToDO(saveVO);
        Long id = ((ExecutRecordDO)((Object)this.executRecordRepo.save((Object)executRecordDO))).getId();
        List executRecordDtlSaveVOS = saveVO.getExecutRecordDtlSaveVOS();
        if (!CollectionUtils.isEmpty((Collection)executRecordDtlSaveVOS)) {
            List collect = executRecordDtlSaveVOS.stream().map(t -> {
                ExecutRecordDtlDO executRecordDtlDO = ExectRecordDtlConvert.INSTANCE.voToDO((ExecutRecordDtlSaveVO)t);
                executRecordDtlDO.setMasId(id);
                return executRecordDtlDO;
            }).collect(Collectors.toList());
            this.executRecordDtlRepo.saveAll(collect);
        }
        if (!CollectionUtils.isEmpty((Collection)(fileInfoSaveVOS = saveVO.getFileInfoSaveVOS()))) {
            List collect = fileInfoSaveVOS.stream().map(t -> {
                FileInfoDO fileInfoDO = FileinfoConvert.INSTANCE.voToDO((FileInfoSaveVO)t);
                fileInfoDO.setSourceId(id);
                return fileInfoDO;
            }).collect(Collectors.toList());
            this.fileInfoRepo.saveAll(collect);
        }
        if (!CollectionUtils.isEmpty((Collection)(tempDtlSaveVOS = saveVO.getTempDtlSaveVOS()))) {
            List collect = tempDtlSaveVOS.stream().map(t -> {
                ExectRecordDtlTempDO exectRecordDtlTempDO = ExectRecordDtlTempConvert.INSTANCE.voToDO((ExectRecordDtlTempSaveVO)t);
                exectRecordDtlTempDO.setRecordId(id);
                return exectRecordDtlTempDO;
            }).collect(Collectors.toList());
            this.exectRecordDtlTempRepo.saveAll(collect);
        }
        if (saveVO.getId() == null || saveVO.getId() == 0L) {
            saveVO.setId(id);
            this.updateTask(saveVO, "SAVE");
        }
        return id;
    }

    @SysCodeProc
    public PagingVO<ExecutRecordRespVO> query(ExecutRecordQueryParam param) {
        log.info("\u6267\u884c\u8bb0\u5f55\u5206\u9875\u5165\u53c2" + JSON.toJSONString((Object)param));
        PagingVO<ExecutRecordRespVO> page = this.executRecordRepoProc.page(param);
        this.setJurisdictionName(page.getRecords());
        return page;
    }

    private void setJurisdictionName(List<ExecutRecordRespVO> records) {
        if (!CollectionUtils.isEmpty(records)) {
            List<String> salesmanNos = records.stream().map(ExecutRecordRespVO::getExecutUserCode).filter(CharSequenceUtil::isNotEmpty).distinct().collect(Collectors.toList());
            if (CollectionUtils.isEmpty(salesmanNos)) {
                return;
            }
            List<SalesmanInfoDO> bySalesmanNoIn = this.salesmanInfoRepo.findBySalesmanNoIn(salesmanNos);
            if (CollectionUtils.isEmpty(bySalesmanNoIn)) {
                return;
            }
            List<Long> salesmanIds = bySalesmanNoIn.stream().map(BaseModel::getId).collect(Collectors.toList());
            List<SalesmanRegionDO> regionDOS = this.salesmanRegionRepo.findByMasIdIn(salesmanIds);
            if (CollUtil.isNotEmpty(regionDOS)) {
                Map<Long, List<SalesmanRegionDO>> map = regionDOS.stream().collect(Collectors.groupingBy(SalesmanRegionDO::getMasId));
                Map regionMap = this.udcProvider.getValueMapByUdcCode("yst-supp", "REGION");
                records.forEach(i -> {
                    if (StringUtils.isNotEmpty((CharSequence)i.getExecutUserCode())) {
                        i.setExecutUserId((Long)bySalesmanNoIn.stream().filter(salesmanInfoDO -> salesmanInfoDO.getSalesmanNo().equals(i.getExecutUserCode())).map(BaseModel::getId).findAny().orElse(null));
                    }
                    if (!CollectionUtils.isEmpty((Collection)((Collection)map.get(i.getExecutUserId())))) {
                        String jurisdictionName = ((List)map.get(i.getExecutUserId())).stream().map(SalesmanRegionDO::getRegionCode).filter(StringUtils::isNotEmpty).map(regionCode -> (String)regionMap.get(regionCode)).filter(StringUtils::isNotEmpty).collect(Collectors.joining(","));
                        i.setJurisdictionName(jurisdictionName);
                    }
                });
            }
        }
    }

    @SysCodeProc
    public ExecutRecordRespVO queryDtl(ExecutRecordQueryParam param) {
        log.info("\u6267\u884c\u8bb0\u5f55\u660e\u7ec6\u5165\u53c2" + JSON.toJSONString((Object)param));
        if (param.getId() == null || param.getId() == 0L) {
            throw new BusinessException(ApiCode.FAIL, "id\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\uff01");
        }
        ExecutRecordRespVO executRecordRespVO = this.executRecordRepoProc.get(param.getId());
        List<ExecutRecordDtlRespVO> exectRecordTempDtlRespVOS = this.executRecordDtlRepoProc.getByMasId(param.getId());
        TaskInfoDtlRespVO taskInfoDtlRespVO = this.taskInfoDtlService.findById(executRecordRespVO.getTaskDtlId());
        exectRecordTempDtlRespVOS.forEach(x -> {
            x.setBusinessCode(taskInfoDtlRespVO.getBusinessCode());
            x.setBusinessName(taskInfoDtlRespVO.getBusinessName());
            x.setDealerCode(taskInfoDtlRespVO.getDealerCode());
            x.setDealerName(taskInfoDtlRespVO.getDealerName());
        });
        executRecordRespVO.setExecutRecordDtlRespVOS(exectRecordTempDtlRespVOS);
        this.setJurisdictionName(List.of(executRecordRespVO));
        FileInfoQueryVO fileInfoQueryVO = new FileInfoQueryVO();
        fileInfoQueryVO.setSourceId(param.getId());
        List<FileInfoRespVO> list = this.fileInfoRepoProc.getList(fileInfoQueryVO);
        executRecordRespVO.setFileInfoRespVOS(list);
        ExectRecordDtlTempQueryParam exectRecordTempRespVO = new ExectRecordDtlTempQueryParam();
        exectRecordTempRespVO.setRecordId(param.getId());
        List<ExectRecordDtlTempRespVO> tempRespVOS = this.exectRecordDtlTempRepoProc.getList(exectRecordTempRespVO);
        this.sysUdcProxyService.translate(tempRespVOS);
        executRecordRespVO.setRecordDtlTempRespVOS(tempRespVOS);
        if (StringUtils.isNotEmpty((CharSequence)executRecordRespVO.getTaskCode())) {
            TaskInfoRespVO byCode = this.taskInfoService.findByCode(executRecordRespVO.getTaskCode());
            executRecordRespVO.setForceSignFlag(byCode.getForceSignFlag());
            executRecordRespVO.setExecutTemplateCode(byCode.getExecutTemplateCode());
        }
        return executRecordRespVO;
    }

    private void updateTempUrl(List<ExectRecordDtlTempRespVO> tempRespVOS) {
        tempRespVOS.forEach(s -> {
            if (StringUtils.isNotBlank((CharSequence)s.getVal()) && (UdcEnum.TEMP_FILE_UPLOAD.getValueCode().equals(s.getType()) || UdcEnum.TEMP_IMAGE_UPLOAD.getValueCode().equals(s.getType()))) {
                JSONArray jsonArray = JSON.parseArray((String)s.getVal());
                Object[] array = jsonArray.stream().toArray();
                ArrayList<FileParamVO> fileParamVOS = new ArrayList<FileParamVO>();
                for (int i = 0; i < array.length; ++i) {
                    FileParamVO fileParamVO = (FileParamVO)JSON.parseObject((String)String.valueOf(array[i]), FileParamVO.class);
                    if (StringUtils.isNotBlank((CharSequence)fileParamVO.getFilePath())) {
                        fileParamVO.setUrl(this.fileServerUrl + fileParamVO.getFilePath());
                    }
                    fileParamVOS.add(fileParamVO);
                }
                s.setVal(JSON.toJSONString(fileParamVOS));
            }
        });
    }

    @SysCodeProc
    public ExecutRecordRespVO queryByLast(ExecutRecordQueryParam param) {
        log.info("\u6267\u884c\u8bb0\u5f55\u660e\u7ec6\u5165\u53c2" + JSON.toJSONString((Object)param));
        if (param.getId() == null || param.getId() == 0L) {
            throw new BusinessException(ApiCode.FAIL, "\u4e3b\u8868id\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\uff01");
        }
        ExecutRecordRespVO executRecordRespVO = this.executRecordRepoProc.get(param.getId());
        if (StringUtils.isEmpty((CharSequence)executRecordRespVO.getTaskType()) || StringUtils.isEmpty((CharSequence)executRecordRespVO.getBusinessCode())) {
            throw new BusinessException(ApiCode.FAIL, "\u4efb\u52a1\u7c7b\u578b/\u4e1a\u52a1\u7f16\u7801\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5");
        }
        List<ExecutRecordRespVO> executRecordRespVOS = this.executRecordRepoProc.queryBylast(executRecordRespVO.getTaskType(), executRecordRespVO.getBusinessCode());
        if (CollectionUtils.isEmpty(executRecordRespVOS)) {
            return null;
        }
        this.sysUdcProxyService.translate(executRecordRespVOS);
        ExecutRecordQueryParam executRecordQueryParam = new ExecutRecordQueryParam();
        executRecordQueryParam.setId(executRecordRespVOS.get(0).getId());
        return this.queryDtl(executRecordQueryParam);
    }

    @Transactional
    public Long approved(ExecutRecordSaveVO saveVO) {
        ExecutRecordRespVO executRecordRespVO = this.approvedCheck(saveVO);
        executRecordRespVO.setState(UdcEnum.EXECT_RECORD_STATUS_CPD.getValueCode());
        executRecordRespVO.setAuditDesc(saveVO.getAuditDesc());
        ExecutRecordDO executRecordDO = ExectRecordConvert.INSTANCE.respToDO(executRecordRespVO);
        Long id = ((ExecutRecordDO)((Object)this.executRecordRepo.save((Object)executRecordDO))).getId();
        ExecutRecordSaveVO executRecordSaveVO = new ExecutRecordSaveVO();
        executRecordSaveVO.setTaskDtlId(executRecordRespVO.getTaskDtlId());
        executRecordSaveVO.setId(id);
        executRecordSaveVO.setCode(executRecordRespVO.getCode());
        this.updateTask(executRecordSaveVO, "PASS");
        return id;
    }

    @Transactional
    public Long refuse(ExecutRecordSaveVO saveVO) {
        ExecutRecordRespVO executRecordRespVO = this.approvedCheck(saveVO);
        executRecordRespVO.setState(UdcEnum.EXECT_RECORD_STATUS_ARN.getValueCode());
        executRecordRespVO.setAuditDesc(saveVO.getAuditDesc());
        ExecutRecordDO executRecordDO = ExectRecordConvert.INSTANCE.respToDO(executRecordRespVO);
        Long id = ((ExecutRecordDO)((Object)this.executRecordRepo.save((Object)executRecordDO))).getId();
        ExecutRecordSaveVO executRecordSaveVO = new ExecutRecordSaveVO();
        executRecordSaveVO.setTaskDtlId(executRecordRespVO.getTaskDtlId());
        executRecordSaveVO.setId(id);
        executRecordSaveVO.setCode(executRecordRespVO.getCode());
        this.updateTask(executRecordSaveVO, "REFUSE");
        return id;
    }

    @Transactional
    public Long submit(ExecutRecordSaveVO saveVO) {
        this.check(saveVO);
        Long save = this.save(saveVO);
        this.executRecordRepoProc.updateById(save, UdcEnum.EXECT_RECORD_STATUS_WAT.getValueCode());
        this.updateTask(saveVO, "SUBMIT");
        return save;
    }

    public List<ExecutRecordRespVO> queryByCodes(List<String> codes) {
        log.info("\u6267\u884c\u8bb0\u5f55\u660e\u7ec6\u5165\u53c2" + JSON.toJSONString(codes));
        if (CollectionUtils.isEmpty(codes)) {
            return null;
        }
        List<ExecutRecordRespVO> executRecordRespVOS = this.executRecordRepoProc.queryByCodes(codes);
        return executRecordRespVOS;
    }

    @Transactional
    public Long close(List<String> code) {
        log.info("\u6267\u884c\u8bb0\u5f55\u72b6\u6001\u5173\u95ed\u5165\u53c2" + JSON.toJSONString(code));
        if (CollectionUtils.isEmpty(code)) {
            throw new BusinessException(ApiCode.FAIL, "\u5165\u53c2\u4e3a\u7a7a");
        }
        Long aLong = this.executRecordRepoProc.updateByCode(code, UdcEnum.EXECT_RECORD_STATUS_CSD.getValueCode());
        return aLong;
    }

    @Transactional
    public Long filterClose(List<String> codes) {
        log.info("\u6267\u884c\u8bb0\u5f55\u72b6\u6001\u8fc7\u6ee4\u975e\u5ba1\u6838\u901a\u8fc7\u5165\u53c2" + JSON.toJSONString(codes));
        if (CollectionUtils.isEmpty(codes)) {
            throw new BusinessException(ApiCode.FAIL, "\u5165\u53c2\u4e3a\u7a7a");
        }
        List<ExecutRecordRespVO> executRecordRespVOS = this.executRecordRepoProc.queryByCodes(codes);
        if (CollectionUtils.isEmpty(executRecordRespVOS)) {
            return null;
        }
        List collect = executRecordRespVOS.stream().filter(t -> !t.getState().equals(UdcEnum.EXECT_RECORD_STATUS_CPD.getValueCode())).collect(Collectors.toList());
        Long aLong = null;
        if (!CollectionUtils.isEmpty(collect)) {
            aLong = this.close(collect.stream().map(ExecutRecordRespVO::getCode).collect(Collectors.toList()));
        }
        return aLong;
    }

    @Transactional
    public Long complete(List<String> codes) {
        log.info("\u6267\u884c\u8bb0\u5f55\u72b6\u6001\u5b8c\u6210\u5165\u53c2" + JSON.toJSONString(codes));
        if (CollectionUtils.isEmpty(codes)) {
            throw new BusinessException(ApiCode.FAIL, "\u5165\u53c2\u4e3a\u7a7a");
        }
        Long aLong = this.executRecordRepoProc.updateByCode(codes, UdcEnum.EXECT_RECORD_STATUS_CPD.getValueCode());
        return aLong;
    }

    @SysCodeProc
    public PagingVO<ExecutRecordExportVO> pageExport(ExecutRecordQueryParam param) {
        PagingVO<ExecutRecordExportVO> executRecordExportVOPagingVO = this.executRecordRepoProc.pageExport(param);
        this.setJurisdictionNameExport(executRecordExportVOPagingVO.getRecords());
        return executRecordExportVOPagingVO;
    }

    private void setJurisdictionNameExport(List<ExecutRecordExportVO> records) {
        if (!CollectionUtils.isEmpty(records)) {
            List<String> salesmanNos = records.stream().map(ExecutRecordExportVO::getExecutUserCode).filter(CharSequenceUtil::isNotEmpty).distinct().collect(Collectors.toList());
            if (CollectionUtils.isEmpty(salesmanNos)) {
                return;
            }
            List<SalesmanInfoDO> bySalesmanNoIn = this.salesmanInfoRepo.findBySalesmanNoIn(salesmanNos);
            if (CollectionUtils.isEmpty(bySalesmanNoIn)) {
                return;
            }
            List<Long> salesmanIds = bySalesmanNoIn.stream().map(BaseModel::getId).collect(Collectors.toList());
            List<SalesmanRegionDO> regionDOS = this.salesmanRegionRepo.findByMasIdIn(salesmanIds);
            if (CollUtil.isNotEmpty(regionDOS)) {
                Map<Long, List<SalesmanRegionDO>> map = regionDOS.stream().collect(Collectors.groupingBy(SalesmanRegionDO::getMasId));
                Map regionMap = this.udcProvider.getValueMapByUdcCode("yst-supp", "REGION");
                records.forEach(i -> {
                    if (StringUtils.isNotEmpty((CharSequence)i.getExecutUserCode())) {
                        i.setExecutUserId((Long)bySalesmanNoIn.stream().filter(salesmanInfoDO -> salesmanInfoDO.getSalesmanNo().equals(i.getExecutUserCode())).map(BaseModel::getId).findAny().orElse(null));
                    }
                    if (!CollectionUtils.isEmpty((Collection)((Collection)map.get(i.getExecutUserId())))) {
                        String jurisdictionName = ((List)map.get(i.getExecutUserId())).stream().map(SalesmanRegionDO::getRegionCode).filter(StringUtils::isNotEmpty).map(regionCode -> (String)regionMap.get(regionCode)).filter(StringUtils::isNotEmpty).collect(Collectors.joining(","));
                        i.setJurisdictionName(jurisdictionName);
                    }
                });
            }
        }
    }

    public ExecutRecordRespVO approvedCheck(ExecutRecordSaveVO saveVO) {
        if (saveVO.getId() == null || saveVO.getId() == 0L) {
            throw new BusinessException(ApiCode.FAIL, "id\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5");
        }
        if (saveVO.getAuditDesc() == null) {
            throw new BusinessException(ApiCode.FAIL, "\u5ba1\u6838\u539f\u56e0\u5185\u5bb9\u5fc5\u586b\uff0c\u8bf7\u68c0\u67e5\uff01");
        }
        ExecutRecordRespVO executRecordRespVO = this.executRecordRepoProc.get(saveVO.getId());
        if (Objects.isNull(executRecordRespVO)) {
            throw new BusinessException(ApiCode.FAIL, "\u5355\u636e\u4e0d\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5\uff01");
        }
        if (!UdcEnum.EXECT_RECORD_STATUS_WAT.getValueCode().equals(executRecordRespVO.getState())) {
            throw new BusinessException(ApiCode.FAIL, "\u975e\u5f85\u5ba1\u6838\u72b6\u6001\u4e0d\u5141\u8bb8\u5ba1\u6838");
        }
        return executRecordRespVO;
    }

    private void check(ExecutRecordSaveVO saveVO) {
        if (saveVO.getTaskType() == null) {
            throw new BusinessException(ApiCode.FAIL, "\u4efb\u52a1\u7c7b\u578b\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\uff01");
        }
        if (CollectionUtils.isEmpty((Collection)saveVO.getExecutRecordDtlSaveVOS())) {
            throw new BusinessException(ApiCode.FAIL, "\u6267\u884c\u8bb0\u5f55\u660e\u7ec6\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\uff01");
        }
        saveVO.getExecutRecordDtlSaveVOS().stream().forEach(t -> {
            if (t.getEntryTime() == null) {
                throw new BusinessException(ApiCode.FAIL, "\u8fdb\u5e97\u65f6\u95f4\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\uff01");
            }
            if (t.getLeaveTime() == null) {
                throw new BusinessException(ApiCode.FAIL, "\u79bb\u5e97\u65f6\u95f4\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\uff01");
            }
        });
    }

    private void updateTask(ExecutRecordSaveVO saveVO, String type) {
        log.info("\u8c03\u7528\u4efb\u52a1\u63a5\u53e3\u5165\u53c2:" + JSON.toJSONString((Object)saveVO) + "," + JSON.toJSONString((Object)type));
        if (saveVO.getTaskDtlId() == 0L || saveVO.getTaskDtlId() == null) {
            return;
        }
        TaskExecutionRecordSaveVO taskExecutionRecordSaveVO = new TaskExecutionRecordSaveVO();
        taskExecutionRecordSaveVO.setExecuteType(type);
        taskExecutionRecordSaveVO.setTaskDtlId(saveVO.getTaskDtlId());
        taskExecutionRecordSaveVO.setExecutRecordId(saveVO.getId());
        taskExecutionRecordSaveVO.setExecutRecordCode(saveVO.getCode());
        this.taskInfoDtlService.executionRecordCallback(taskExecutionRecordSaveVO);
    }

    public ExectRecordServiceImpl(ExecutRecordRepo executRecordRepo, ExecutRecordRepoProc executRecordRepoProc, ExecutRecordDtlRepo executRecordDtlRepo, ExecutRecordDtlRepoProc executRecordDtlRepoProc, ExectRecordDtlTempRepo exectRecordDtlTempRepo, ExectRecordDtlTempRepoProc exectRecordDtlTempRepoProc, SalesmanInfoRepo salesmanInfoRepo, SalesmanRegionRepo salesmanRegionRepo, RmiSysNextNumberService rmiSysNextNumberService, SysUdcProxyService sysUdcProxyService, UdcProvider udcProvider, FileInfoRepoProc fileInfoRepoProc, FileInfoRepo fileInfoRepo, TaskInfoDtlService taskInfoDtlService, TaskInfoService taskInfoService) {
        this.executRecordRepo = executRecordRepo;
        this.executRecordRepoProc = executRecordRepoProc;
        this.executRecordDtlRepo = executRecordDtlRepo;
        this.executRecordDtlRepoProc = executRecordDtlRepoProc;
        this.exectRecordDtlTempRepo = exectRecordDtlTempRepo;
        this.exectRecordDtlTempRepoProc = exectRecordDtlTempRepoProc;
        this.salesmanInfoRepo = salesmanInfoRepo;
        this.salesmanRegionRepo = salesmanRegionRepo;
        this.rmiSysNextNumberService = rmiSysNextNumberService;
        this.sysUdcProxyService = sysUdcProxyService;
        this.udcProvider = udcProvider;
        this.fileInfoRepoProc = fileInfoRepoProc;
        this.fileInfoRepo = fileInfoRepo;
        this.taskInfoDtlService = taskInfoDtlService;
        this.taskInfoService = taskInfoService;
    }
}

