/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.yst.production.sale.service;

import cn.hutool.core.collection.IterUtil;
import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.cloudt.common.annotation.SysCodeProc;
import com.elitescloud.cloudt.common.base.ApiCode;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.yst.production.sale.api.service.LogisticsTemplateService;
import com.elitesland.yst.production.sale.api.vo.param.logistics.LogisticsTemplateDetailSaveParam;
import com.elitesland.yst.production.sale.api.vo.param.logistics.LogisticsTemplateParam;
import com.elitesland.yst.production.sale.api.vo.param.logistics.LogisticsTemplateSaveParam;
import com.elitesland.yst.production.sale.api.vo.param.logistics.TemplateDetailComputeParam;
import com.elitesland.yst.production.sale.api.vo.resp.logistics.BaseAreaVO;
import com.elitesland.yst.production.sale.api.vo.resp.logistics.LogisticsTemplateDVO;
import com.elitesland.yst.production.sale.api.vo.resp.logistics.LogisticsTemplateVO;
import com.elitesland.yst.production.sale.common.constant.UdcEnum;
import com.elitesland.yst.production.sale.common.model.CurrentUserDTO;
import com.elitesland.yst.production.sale.core.service.UserService;
import com.elitesland.yst.production.sale.entity.BaseAreaDO;
import com.elitesland.yst.production.sale.entity.LogisticsTemplateDDO;
import com.elitesland.yst.production.sale.entity.LogisticsTemplateDO;
import com.elitesland.yst.production.sale.entity.QBaseAreaDO;
import com.elitesland.yst.production.sale.entity.QLogisticsTemplateDDO;
import com.elitesland.yst.production.sale.repo.BaseAreaRepo;
import com.elitesland.yst.production.sale.repo.LogisticsTemplateDRepo;
import com.elitesland.yst.production.sale.repo.LogisticsTemplateRepo;
import com.elitesland.yst.production.sale.repo.LogisticsTemplateRepoProc;
import com.elitesland.yst.production.sale.rmi.ystsystem.RmiSysNextNumberService;
import com.elitesland.yst.production.support.provider.org.dto.OrgUserEmpInfoRpcDTO;
import com.elitesland.yst.production.support.provider.org.service.OrgBuRpcService;
import com.elitesland.yst.production.support.provider.org.service.OrgEmpRpcService;
import com.google.common.collect.Lists;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.dsl.BooleanExpression;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class LogisticsTemplateServiceImpl
implements LogisticsTemplateService {
    private static final Logger log = LoggerFactory.getLogger(LogisticsTemplateServiceImpl.class);
    private final OrgBuRpcService orgBuRpcService;
    private final LogisticsTemplateRepoProc logisticsTemplateRepoProc;
    private final LogisticsTemplateRepo logisticsTemplateRepo;
    private final RmiSysNextNumberService rmiSysNextNumberService;
    private final LogisticsTemplateDRepo logisticsTemplateDRepo;
    private final OrgEmpRpcService orgEmpRpcService;
    private final BaseAreaRepo baseAreaRepo;

    @SysCodeProc
    public LogisticsTemplateVO findCouponById(Long id) {
        Optional optional = this.logisticsTemplateRepo.findById(id);
        if (optional.isPresent()) {
            LogisticsTemplateDO logisticsTemplateDO = (LogisticsTemplateDO)optional.get();
            LogisticsTemplateVO logisticsTemplateVO = new LogisticsTemplateVO();
            BeanUtils.copyProperties((Object)logisticsTemplateDO, (Object)logisticsTemplateVO);
            QLogisticsTemplateDDO qLogisticsTemplateDDO = QLogisticsTemplateDDO.logisticsTemplateDDO;
            BooleanExpression expr = qLogisticsTemplateDDO.templateId.eq((Object)id).and((Predicate)qLogisticsTemplateDDO.deleteFlag.eq((Object)0));
            Iterable iterables = this.logisticsTemplateDRepo.findAll((Predicate)expr);
            ArrayList resList = new ArrayList();
            if (!IterUtil.isEmpty((Iterable)iterables)) {
                ArrayList list = Lists.newArrayList((Iterable)iterables);
                list.stream().forEach(l -> {
                    LogisticsTemplateDVO logisticsTemplateDVO = new LogisticsTemplateDVO();
                    BeanUtils.copyProperties((Object)l, (Object)logisticsTemplateDVO);
                    resList.add(logisticsTemplateDVO);
                });
                logisticsTemplateVO.setList(resList);
            }
            return logisticsTemplateVO;
        }
        return null;
    }

    @SysCodeProc
    public PagingVO<LogisticsTemplateVO> findPagingResult(LogisticsTemplateParam logisticsTemplateParam) {
        PagingVO<LogisticsTemplateVO> list = this.logisticsTemplateRepoProc.findPagingResult(logisticsTemplateParam);
        return list;
    }

    @Transactional(rollbackFor={Exception.class})
    public ApiResult<Object> saveLogistics(LogisticsTemplateSaveParam logisticsTemplateParam) {
        if (null != logisticsTemplateParam) {
            List detailList = logisticsTemplateParam.getList();
            if (null != detailList && !detailList.isEmpty()) {
                List cityList = detailList.stream().map(LogisticsTemplateDetailSaveParam::getCityCode).collect(Collectors.toList());
                HashSet citySet = new HashSet(cityList);
                if (cityList.size() != citySet.size()) {
                    return ApiResult.fail((String)"\u5e02\u4e0d\u80fd\u91cd\u590d");
                }
            }
            OrgUserEmpInfoRpcDTO empInfo = this.getCurrentEmpInfo();
            LogisticsTemplateDO logisticsTemplateDO = new LogisticsTemplateDO();
            if (null == logisticsTemplateParam.getId()) {
                BeanUtils.copyProperties((Object)logisticsTemplateParam, (Object)logisticsTemplateDO);
                logisticsTemplateDO.setStatus(UdcEnum.LOGISTICS_TEMPLATE_STATUS_DISABLE.getValueCode());
                String logisticsCode = this.rmiSysNextNumberService.generateCode("yst-sale", "LOGISTICS_TEMPLATE", new ArrayList<String>());
                logisticsTemplateDO.setLogisticsCode(logisticsCode);
                logisticsTemplateDO.setSecBuId(empInfo.getBuId());
                logisticsTemplateDO.setSecOuId(empInfo.getOuId());
                logisticsTemplateDO.setSecUserId(empInfo.getUserId());
            } else {
                Optional optional = this.logisticsTemplateRepo.findById(logisticsTemplateParam.getId());
                logisticsTemplateDO = (LogisticsTemplateDO)optional.get();
                logisticsTemplateDO.setLogisticsCode(logisticsTemplateParam.getLogisticsCode());
                logisticsTemplateDO.setLogisticsName(logisticsTemplateParam.getLogisticsName());
                logisticsTemplateDO.setLogisticDesc(logisticsTemplateParam.getLogisticDesc());
                logisticsTemplateDO.setProvinceName(logisticsTemplateParam.getProvinceName());
                logisticsTemplateDO.setCityName(logisticsTemplateParam.getCityName());
                logisticsTemplateDO.setProvinceCode(logisticsTemplateParam.getProvinceCode());
                logisticsTemplateDO.setCityCode(logisticsTemplateParam.getCityCode());
                logisticsTemplateDO.setOuId(logisticsTemplateParam.getOuId());
                logisticsTemplateDO.setOuName(logisticsTemplateParam.getOuName());
            }
            logisticsTemplateDO = (LogisticsTemplateDO)this.logisticsTemplateRepo.save(logisticsTemplateDO);
            List list = logisticsTemplateParam.getList();
            if (!list.isEmpty()) {
                QLogisticsTemplateDDO qLogisticsTemplateDDO = QLogisticsTemplateDDO.logisticsTemplateDDO;
                BooleanExpression expression = qLogisticsTemplateDDO.templateId.eq((Object)logisticsTemplateDO.getId()).and((Predicate)qLogisticsTemplateDDO.deleteFlag.eq((Object)0));
                Iterable iterables = this.logisticsTemplateDRepo.findAll((Predicate)expression);
                if (!IterUtil.isEmpty((Iterable)iterables)) {
                    ArrayList lists = Lists.newArrayList((Iterable)iterables);
                    lists.stream().forEach(l -> {
                        l.setDeleteFlag(1);
                        this.logisticsTemplateDRepo.save(l);
                    });
                }
                LogisticsTemplateDO finalLogisticsTemplateDO = logisticsTemplateDO;
                list.stream().forEach(l -> {
                    LogisticsTemplateDDO logisticsTemplateDDO = new LogisticsTemplateDDO();
                    int max = this.getMaxLineNo(finalLogisticsTemplateDO.getId());
                    BeanUtils.copyProperties((Object)l, (Object)logisticsTemplateDDO);
                    logisticsTemplateDDO.setLinNo(max + 1);
                    logisticsTemplateDDO.setTemplateId(finalLogisticsTemplateDO.getId());
                    logisticsTemplateDDO.setOuId(finalLogisticsTemplateDO.getOuId());
                    logisticsTemplateDDO.setOuName(finalLogisticsTemplateDO.getOuName());
                    this.logisticsTemplateDRepo.save(logisticsTemplateDDO);
                });
            }
        }
        return ApiResult.ok();
    }

    public String getNameByCode(String code) {
        if (StringUtils.isNotBlank((CharSequence)code)) {
            QBaseAreaDO qBaseAreaDO = QBaseAreaDO.baseAreaDO;
            BooleanExpression expression = qBaseAreaDO.id.eq((Object)Long.parseLong(code));
            Optional optional = this.baseAreaRepo.findOne((Predicate)expression);
            if (optional.isPresent()) {
                return ((BaseAreaDO)optional.get()).getName();
            }
        }
        return "";
    }

    public Integer getMaxLineNo(Long templateId) {
        QLogisticsTemplateDDO qLogisticsTemplateDDO = QLogisticsTemplateDDO.logisticsTemplateDDO;
        BooleanExpression expression = qLogisticsTemplateDDO.templateId.eq((Object)templateId);
        Iterable iterables = this.logisticsTemplateDRepo.findAll((Predicate)expression);
        if (!IterUtil.isEmpty((Iterable)iterables)) {
            ArrayList list = Lists.newArrayList((Iterable)iterables);
            int max = list.stream().mapToInt(l -> l.getLinNo()).max().getAsInt();
            return max;
        }
        return 0;
    }

    public ApiResult<Object> delLogistics(List<Long> ids) {
        if (null != ids && !ids.isEmpty()) {
            QLogisticsTemplateDDO qLogisticsTemplateDDO = QLogisticsTemplateDDO.logisticsTemplateDDO;
            ids.stream().forEach(id -> {
                BooleanExpression expression = qLogisticsTemplateDDO.templateId.eq(id).and((Predicate)qLogisticsTemplateDDO.deleteFlag.eq((Object)0));
                Iterable iterables = this.logisticsTemplateDRepo.findAll((Predicate)expression);
                if (null != iterables) {
                    this.logisticsTemplateDRepo.deleteAll(iterables);
                }
                this.logisticsTemplateRepo.deleteById(id);
            });
        }
        return ApiResult.ok();
    }

    public ApiResult<Object> openLogistics(List<Long> ids) {
        if (null != ids && !ids.isEmpty()) {
            ids.stream().forEach(id -> {
                Optional optional = this.logisticsTemplateRepo.findById(id);
                if (optional.isPresent()) {
                    LogisticsTemplateDO logisticsTemplateDO = (LogisticsTemplateDO)optional.get();
                    logisticsTemplateDO.setStatus(UdcEnum.LOGISTICS_TEMPLATE_STATUS_ENABLE.getValueCode());
                    this.logisticsTemplateRepo.save(logisticsTemplateDO);
                }
            });
        }
        return ApiResult.ok();
    }

    public ApiResult<Object> stopLogistics(List<Long> ids) {
        if (null != ids && !ids.isEmpty()) {
            ids.stream().forEach(id -> {
                Optional optional = this.logisticsTemplateRepo.findById(id);
                if (optional.isPresent()) {
                    LogisticsTemplateDO logisticsTemplateDO = (LogisticsTemplateDO)optional.get();
                    logisticsTemplateDO.setStatus(UdcEnum.LOGISTICS_TEMPLATE_STATUS_DISABLE.getValueCode());
                    this.logisticsTemplateRepo.save(logisticsTemplateDO);
                }
            });
        }
        return ApiResult.ok();
    }

    public List<BaseAreaVO> getProvince() {
        QBaseAreaDO qBaseAreaDO = QBaseAreaDO.baseAreaDO;
        BooleanExpression expression = qBaseAreaDO.pid.eq((Object)0L).and((Predicate)qBaseAreaDO.id.notIn((Object[])new Long[]{1L})).and((Predicate)qBaseAreaDO.deleteFlag.eq((Object)0));
        Iterable iterables = this.baseAreaRepo.findAll((Predicate)expression);
        if (!IterUtil.isEmpty((Iterable)iterables)) {
            ArrayList<BaseAreaVO> resList = new ArrayList<BaseAreaVO>();
            ArrayList list = Lists.newArrayList((Iterable)iterables);
            list.stream().forEach(l -> {
                BaseAreaVO baseAreaVO = new BaseAreaVO();
                BeanUtils.copyProperties((Object)l, (Object)baseAreaVO);
                resList.add(baseAreaVO);
            });
            return resList;
        }
        return null;
    }

    public List<BaseAreaVO> getCityByProvince(Long id) {
        QBaseAreaDO qBaseAreaDO = QBaseAreaDO.baseAreaDO;
        BooleanExpression expression = qBaseAreaDO.pid.eq((Object)id).and((Predicate)qBaseAreaDO.deleteFlag.eq((Object)0));
        Iterable iterables = this.baseAreaRepo.findAll((Predicate)expression);
        if (!IterUtil.isEmpty((Iterable)iterables)) {
            ArrayList<BaseAreaVO> resList = new ArrayList<BaseAreaVO>();
            ArrayList list = Lists.newArrayList((Iterable)iterables);
            list.stream().forEach(l -> {
                BaseAreaVO baseAreaVO = new BaseAreaVO();
                BeanUtils.copyProperties((Object)l, (Object)baseAreaVO);
                resList.add(baseAreaVO);
            });
            return resList;
        }
        return null;
    }

    public LogisticsTemplateDVO getTemplateDetail(TemplateDetailComputeParam templateDetailComputeParam) {
        QLogisticsTemplateDDO qLogisticsTemplateDDO = QLogisticsTemplateDDO.logisticsTemplateDDO;
        BooleanExpression templateDetailExpr = qLogisticsTemplateDDO.templateId.eq((Object)templateDetailComputeParam.getTemplateId()).and((Predicate)qLogisticsTemplateDDO.deleteFlag.eq((Object)0)).and((Predicate)qLogisticsTemplateDDO.cityCode.eq((Object)templateDetailComputeParam.getCityCode()));
        Optional optional = this.logisticsTemplateDRepo.findOne((Predicate)templateDetailExpr);
        if (optional.isPresent()) {
            LogisticsTemplateDVO logisticsTemplateDVO = new LogisticsTemplateDVO();
            BeanUtils.copyProperties(optional.get(), (Object)logisticsTemplateDVO);
            return logisticsTemplateDVO;
        }
        return null;
    }

    private OrgUserEmpInfoRpcDTO getCurrentEmpInfo() {
        CurrentUserDTO currentUser = UserService.currentUser();
        if (currentUser == null) {
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u5f53\u524d\u7528\u6237\u5df2\u5931\u6548,\u8bf7\u91cd\u767b\u5f55\u91cd\u8bd5");
        }
        OrgUserEmpInfoRpcDTO userEmpInfo = this.orgEmpRpcService.findUserEmpInfo(currentUser.getUserId());
        if (userEmpInfo == null) {
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u65e0\u6cd5\u83b7\u53d6\u5f53\u524d\u7528\u6237\u4fe1\u606f");
        }
        return userEmpInfo;
    }

    public LogisticsTemplateServiceImpl(OrgBuRpcService orgBuRpcService, LogisticsTemplateRepoProc logisticsTemplateRepoProc, LogisticsTemplateRepo logisticsTemplateRepo, RmiSysNextNumberService rmiSysNextNumberService, LogisticsTemplateDRepo logisticsTemplateDRepo, OrgEmpRpcService orgEmpRpcService, BaseAreaRepo baseAreaRepo) {
        this.orgBuRpcService = orgBuRpcService;
        this.logisticsTemplateRepoProc = logisticsTemplateRepoProc;
        this.logisticsTemplateRepo = logisticsTemplateRepo;
        this.rmiSysNextNumberService = rmiSysNextNumberService;
        this.logisticsTemplateDRepo = logisticsTemplateDRepo;
        this.orgEmpRpcService = orgEmpRpcService;
        this.baseAreaRepo = baseAreaRepo;
    }
}

