/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.yst.production.sale.service.shop;

import cn.hutool.core.collection.IterUtil;
import cn.hutool.core.lang.Assert;
import com.alibaba.fastjson.JSON;
import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.boot.model.entity.BaseModel;
import com.elitescloud.cloudt.common.annotation.SysCodeProc;
import com.elitescloud.cloudt.common.base.ApiCode;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.yst.production.sale.api.service.shop.BipCouponService;
import com.elitesland.yst.production.sale.api.service.shop.BipOrderService;
import com.elitesland.yst.production.sale.api.vo.param.shop.BipCouponIndexImgVO;
import com.elitesland.yst.production.sale.api.vo.param.shop.BipCouponOrderVO;
import com.elitesland.yst.production.sale.api.vo.param.shop.BipCouponQueryParamVO;
import com.elitesland.yst.production.sale.api.vo.resp.shop.BipCouPonIndexShowVO;
import com.elitesland.yst.production.sale.api.vo.resp.shop.BipCouponVO;
import com.elitesland.yst.production.sale.api.vo.save.shop.BipCouponSaveVO;
import com.elitesland.yst.production.sale.api.vo.save.shop.BipItemVO;
import com.elitesland.yst.production.sale.api.vo.save.shop.BipMessageSaveVO;
import com.elitesland.yst.production.sale.common.constant.UdcEnum;
import com.elitesland.yst.production.sale.common.model.CurrentUserDTO;
import com.elitesland.yst.production.sale.convert.shop.BipCouponConvert;
import com.elitesland.yst.production.sale.convert.shop.BipMessageConvert;
import com.elitesland.yst.production.sale.core.service.UserService;
import com.elitesland.yst.production.sale.entity.BipCouponCustDo;
import com.elitesland.yst.production.sale.entity.BipCouponDO;
import com.elitesland.yst.production.sale.entity.BipCouponIndexImgDO;
import com.elitesland.yst.production.sale.entity.BipCouponItemDO;
import com.elitesland.yst.production.sale.entity.BipCustUserBindDO;
import com.elitesland.yst.production.sale.entity.BipMessageDO;
import com.elitesland.yst.production.sale.entity.QBipCouponCustDo;
import com.elitesland.yst.production.sale.entity.QBipCouponDO;
import com.elitesland.yst.production.sale.entity.QBipCouponIndexImgDO;
import com.elitesland.yst.production.sale.entity.QBipCouponItemDO;
import com.elitesland.yst.production.sale.entity.QBipCustUserBindDO;
import com.elitesland.yst.production.sale.repo.shop.BipCouponCustRepo;
import com.elitesland.yst.production.sale.repo.shop.BipCouponCustRepoProc;
import com.elitesland.yst.production.sale.repo.shop.BipCouponIndexImgRepo;
import com.elitesland.yst.production.sale.repo.shop.BipCouponItemRepo;
import com.elitesland.yst.production.sale.repo.shop.BipCouponRepo;
import com.elitesland.yst.production.sale.repo.shop.BipCouponRepoProc;
import com.elitesland.yst.production.sale.repo.shop.BipCustUserBindRepo;
import com.elitesland.yst.production.sale.repo.shop.BipCustUserBindRepoProc;
import com.elitesland.yst.production.sale.repo.shop.BipMessageRepo;
import com.elitesland.yst.production.sale.repo.shop.BipMessageRepoProc;
import com.elitesland.yst.production.sale.rmi.ystsystem.RmiSysNextNumberService;
import com.elitesland.yst.production.support.provider.org.dto.OrgUserEmpInfoRpcDTO;
import com.elitesland.yst.production.support.provider.org.service.OrgEmpRpcService;
import com.google.common.collect.Lists;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.dsl.BooleanExpression;
import java.time.Duration;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import jodd.util.StringUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.StringUtils;

@Service
public class BipCouponServiceImpl
implements BipCouponService {
    private static final Logger log = LoggerFactory.getLogger(BipCouponServiceImpl.class);
    private final BipCouponRepo bipCouponRepo;
    private final BipCouponRepoProc bipCouponRepoProc;
    private final BipCouponItemRepo bipCouponItemRepo;
    private final RmiSysNextNumberService nextNumberService;
    private final BipCustUserBindRepoProc bipCustUserBindRepoProc;
    @Autowired
    private BipOrderService bipOrderService;
    private final BipCouponCustRepo bipCouponCustRepo;
    private final BipCouponCustRepoProc bipCouponCustRepoProc;
    private final OrgEmpRpcService orgEmpRpcService;
    private final BipCouponIndexImgRepo bipCouponIndexImgRepo;
    private final BipMessageRepo bipMessageRepo;
    private final BipMessageRepoProc bipMessageRepoProc;
    private final BipCustUserBindRepo bipCustUserBindRepo;

    public BipCouponIndexImgVO searchBackImg() {
        OrgUserEmpInfoRpcDTO empInfo = this.getCurrentEmpInfo();
        if (null != empInfo.getOuId()) {
            QBipCouponIndexImgDO qBipCouponIndexImgDO = QBipCouponIndexImgDO.bipCouponIndexImgDO;
            BooleanExpression expression = qBipCouponIndexImgDO.ouId.eq((Object)empInfo.getOuId()).and((Predicate)qBipCouponIndexImgDO.deleteFlag.eq((Object)0));
            Optional optional = this.bipCouponIndexImgRepo.findOne((Predicate)expression);
            if (optional.isPresent()) {
                BipCouponIndexImgDO imgDO = (BipCouponIndexImgDO)optional.get();
                BipCouponIndexImgVO vo = new BipCouponIndexImgVO();
                BeanUtils.copyProperties((Object)imgDO, (Object)vo);
                return vo;
            }
        }
        return null;
    }

    public Long delBackImg() {
        OrgUserEmpInfoRpcDTO empInfo = this.getCurrentEmpInfo();
        if (null == empInfo || null == empInfo.getUserId() || null == empInfo.getOuId()) {
            throw new BusinessException("\u672a\u627e\u5230\u7528\u6237\u4fe1\u606f");
        }
        QBipCouponIndexImgDO qBipCouponIndexImgDO = QBipCouponIndexImgDO.bipCouponIndexImgDO;
        BooleanExpression expression = qBipCouponIndexImgDO.ouId.eq((Object)empInfo.getOuId()).and((Predicate)qBipCouponIndexImgDO.deleteFlag.eq((Object)0));
        Optional optional = this.bipCouponIndexImgRepo.findOne((Predicate)expression);
        if (optional.isPresent()) {
            BipCouponIndexImgDO imgDO = (BipCouponIndexImgDO)optional.get();
            imgDO.setDeleteFlag(1);
            this.bipCouponIndexImgRepo.save(imgDO);
            return imgDO.getId();
        }
        return null;
    }

    public Long saveBackImg(BipCouponIndexImgVO bipCouponIndexImgVO) {
        OrgUserEmpInfoRpcDTO empInfo = this.getCurrentEmpInfo();
        if (null == bipCouponIndexImgVO.getId()) {
            BipCouponIndexImgDO bipCouponIndexImgDO = new BipCouponIndexImgDO();
            BeanUtils.copyProperties((Object)bipCouponIndexImgVO, (Object)bipCouponIndexImgDO);
            bipCouponIndexImgDO.setOuId(empInfo.getOuId());
            bipCouponIndexImgDO.setOuName(empInfo.getOuName());
            this.bipCouponIndexImgRepo.save(bipCouponIndexImgDO);
        } else {
            Optional optional = this.bipCouponIndexImgRepo.findById(bipCouponIndexImgVO.getId());
            if (optional.isPresent()) {
                BipCouponIndexImgDO imgDO = (BipCouponIndexImgDO)optional.get();
                imgDO.setDeleteFlag(1);
                this.bipCouponIndexImgRepo.save(imgDO);
                BipCouponIndexImgDO bipCouponIndexImgDO = new BipCouponIndexImgDO();
                BeanUtils.copyProperties((Object)bipCouponIndexImgVO, (Object)bipCouponIndexImgDO);
                bipCouponIndexImgDO.setOuId(empInfo.getOuId());
                bipCouponIndexImgDO.setOuName(empInfo.getOuName());
                bipCouponIndexImgDO.setId(null);
                this.bipCouponIndexImgRepo.save(bipCouponIndexImgDO);
            }
        }
        return null;
    }

    @SysCodeProc
    public BipCouPonIndexShowVO findHomeCoupon() {
        Long ouId = this.getCurrentOuIdInfo();
        CurrentUserDTO currentUser = UserService.currentUser();
        log.info("\u67e5\u8be2\u9996\u9875\u4f18\u60e0\u5238\uff1aouId:" + ouId + " userId:" + currentUser.getUserId());
        Boolean isPay = this.bipOrderService.isFirstOrder(currentUser.getUserId(), "ps");
        if (null == ouId) {
            return null;
        }
        QBipCouponDO qBipCouponDO = QBipCouponDO.bipCouponDO;
        BooleanExpression expression = qBipCouponDO.ouId.eq((Object)ouId).and((Predicate)qBipCouponDO.deleteFlag.eq((Object)0)).and((Predicate)qBipCouponDO.state.eq((Object)UdcEnum.SAL_COUPON_STATE_ACTIVE.getValueCode())).and((Predicate)qBipCouponDO.totalNum.gt((Number)0)).and((Predicate)qBipCouponDO.specialAreaStime.loe((Comparable)LocalDateTime.now())).and((Predicate)qBipCouponDO.specialAreaEtime.goe((Comparable)LocalDateTime.now()));
        expression = expression.and((Predicate)qBipCouponDO.indexPageShow.eq((Object)"1"));
        if (isPay.booleanValue()) {
            expression = expression.and((Predicate)qBipCouponDO.newCustShow.eq((Object)"0"));
        }
        Iterable iterables = this.bipCouponRepo.findAll((Predicate)expression);
        ArrayList<BipCouponVO> resList = new ArrayList<BipCouponVO>();
        if (!IterUtil.isEmpty((Iterable)iterables)) {
            ArrayList list = Lists.newArrayList((Iterable)iterables);
            for (BipCouponDO l : list) {
                BipCouponVO bipCouponVO = new BipCouponVO();
                BeanUtils.copyProperties((Object)l, (Object)bipCouponVO);
                resList.add(bipCouponVO);
            }
        }
        BipCouPonIndexShowVO vo = new BipCouPonIndexShowVO();
        vo.setOuId(ouId);
        vo.setUserId(currentUser.getUserId());
        if (!resList.isEmpty()) {
            Long userId = UserService.currentUser().getUserId();
            List collect = resList.stream().filter(c -> !this.bipCouponCustRepoProc.isReceived(c.getCouponCode(), userId)).limit(3L).collect(Collectors.toList());
            vo.setBipCouponList(collect);
            BipCouponIndexImgDO d = this.getIndexImgByOuId(ouId);
            BipCouponIndexImgVO bipCouponIndexImgVO = new BipCouponIndexImgVO();
            BeanUtils.copyProperties((Object)d, (Object)bipCouponIndexImgVO);
            vo.setBipCouponIndexImgVO(bipCouponIndexImgVO);
        } else {
            vo.setBipCouponList(Collections.emptyList());
        }
        this.createWillInvalidMessage();
        log.info("\u4f18\u60e0\u5238\uff1a" + JSON.toJSONString((Object)vo));
        return vo;
    }

    private void createWillInvalidMessage() {
        Assert.notNull((Object)UserService.currentUser(), (String)"\u8bf7\u5148\u767b\u5f55!", (Object[])new Object[0]);
        Long userId = UserService.currentUser().getUserId();
        QBipCustUserBindDO qBipCustUserBindDO = QBipCustUserBindDO.bipCustUserBindDO;
        BooleanExpression e = qBipCustUserBindDO.deleteFlag.eq((Object)0).and((Predicate)qBipCustUserBindDO.userId.eq((Object)userId));
        Optional optionalBind = this.bipCustUserBindRepo.findOne((Predicate)e);
        BipCustUserBindDO bipCustUserBindDO = new BipCustUserBindDO();
        if (!optionalBind.isEmpty()) {
            bipCustUserBindDO = (BipCustUserBindDO)optionalBind.get();
            if (null == bipCustUserBindDO.getCustId()) {
                throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u5f53\u524d\u7528\u6237\u672a\u7ed1\u5b9a\u5ba2\u6237\uff0c\u4e0d\u80fd\u9886\u53d6\u4f18\u60e0\u5238");
            }
        } else {
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u5f53\u524d\u7528\u6237\u672a\u7ed1\u5b9a\u5ba2\u6237\uff0c\u4e0d\u80fd\u9886\u53d6\u4f18\u60e0\u5238");
        }
        List<BipCouponCustDo> records = this.bipCouponCustRepoProc.findCouponRecordByUserID(userId, bipCustUserBindDO.getCustId());
        ArrayList resList = new ArrayList();
        for (BipCouponCustDo record : records) {
            Long couponId = record.getCouponId();
            Optional optional = this.bipCouponRepo.findById(couponId);
            optional.ifPresent(couponDO -> {
                Integer notifyDays = couponDO.getNotifyDays();
                if (null != notifyDays) {
                    LocalDateTime notifyDateTime = couponDO.getValidEtime();
                    Duration duration = Duration.between(LocalDateTime.now(), notifyDateTime);
                    long days = duration.toDays();
                    if (days <= (long)notifyDays.intValue()) {
                        resList.add(couponDO);
                    }
                }
            });
        }
        ArrayList<BipMessageDO> list = new ArrayList<BipMessageDO>();
        for (BipCouponDO couponCustVO : resList) {
            if (this.bipMessageRepoProc.checkExist(couponCustVO.getId(), "COUPON", userId)) continue;
            BipMessageSaveVO param = new BipMessageSaveVO();
            param.setTitle("\u3010\u4f18\u60e0\u5238\u5373\u5c06\u8fc7\u671f\u3011");
            param.setStatus(UdcEnum.MESSAGE_STATUS_NOTREAD.getValueCode());
            param.setToCustId(userId);
            param.setContext("\u60a8\u7684\u4f18\u60e0\u5238" + couponCustVO.getCouponName() + "\u5373\u5c06\u8fc7\u671f\uff0c\u8bf7\u5c3d\u5feb\u4f7f\u7528");
            param.setBusinessId(couponCustVO.getId());
            param.setBusinessType("COUPON");
            BipMessageDO bipMessageDO = BipMessageConvert.INSTANCE.voToDo(param);
            list.add(bipMessageDO);
        }
        this.bipMessageRepo.saveAll(list);
    }

    public BipCouPonIndexShowVO findCouponIndexShow() {
        BipCouPonIndexShowVO vo = new BipCouPonIndexShowVO();
        OrgUserEmpInfoRpcDTO empInfo = this.getCurrentEmpInfo();
        Long ouId = empInfo.getOuId();
        CurrentUserDTO currentUser = UserService.currentUser();
        Boolean isPay = this.bipOrderService.isFirstOrder(currentUser.getUserId(), "ps");
        if (null == ouId) {
            return null;
        }
        QBipCouponDO qBipCouponDO = QBipCouponDO.bipCouponDO;
        BooleanExpression expression = qBipCouponDO.ouId.eq((Object)ouId).and((Predicate)qBipCouponDO.indexPageShow.eq((Object)"1")).and((Predicate)qBipCouponDO.deleteFlag.eq((Object)0)).and((Predicate)qBipCouponDO.state.eq((Object)UdcEnum.SAL_COUPON_STATE_ACTIVE.getValueCode())).and((Predicate)qBipCouponDO.totalNum.gt((Number)0)).and((Predicate)qBipCouponDO.specialAreaStime.gt((Comparable)LocalDateTime.now())).and((Predicate)qBipCouponDO.specialAreaEtime.lt((Comparable)LocalDateTime.now()));
        if (isPay.booleanValue()) {
            expression = expression.and((Predicate)qBipCouponDO.newCustShow.eq((Object)"0"));
        }
        Iterable iterables = this.bipCouponRepo.findAll((Predicate)expression);
        ArrayList resList = new ArrayList();
        if (!IterUtil.isEmpty((Iterable)iterables)) {
            ArrayList list = Lists.newArrayList((Iterable)iterables);
            list.stream().forEach(l -> {
                BipCouponVO bipCouponVO = new BipCouponVO();
                BeanUtils.copyProperties((Object)l, (Object)bipCouponVO);
                resList.add(bipCouponVO);
            });
        }
        if (null != resList && !resList.isEmpty()) {
            vo.setBipCouponList(resList);
            BipCouponIndexImgDO d = this.getIndexImgByOuId(ouId);
            BipCouponIndexImgVO bipCouponIndexImgVO = new BipCouponIndexImgVO();
            BeanUtils.copyProperties((Object)d, (Object)bipCouponIndexImgVO);
            vo.setBipCouponIndexImgVO(bipCouponIndexImgVO);
        }
        return vo;
    }

    public BipCouponIndexImgDO getIndexImgByOuId(Long ouId) {
        QBipCouponIndexImgDO qBipCouponIndexImgDO = QBipCouponIndexImgDO.bipCouponIndexImgDO;
        BooleanExpression expression = qBipCouponIndexImgDO.ouId.eq((Object)ouId).and((Predicate)qBipCouponIndexImgDO.deleteFlag.eq((Object)0));
        Optional optional = this.bipCouponIndexImgRepo.findOne((Predicate)expression);
        if (optional.isPresent()) {
            return (BipCouponIndexImgDO)optional.get();
        }
        return null;
    }

    public void delCoupon(List<Long> ids) {
        if (null != ids && !ids.isEmpty()) {
            ids.stream().forEach(id -> {
                Optional optional = this.bipCouponRepo.findById(id);
                if (optional.isPresent()) {
                    BipCouponDO bipCouponDO = (BipCouponDO)optional.get();
                    bipCouponDO.setDeleteFlag(1);
                    this.bipCouponRepo.save(bipCouponDO);
                    QBipCouponItemDO qBipCouponItemDO = QBipCouponItemDO.bipCouponItemDO;
                    BooleanExpression expression = qBipCouponItemDO.couponId.eq(id);
                    Iterable items = this.bipCouponItemRepo.findAll((Predicate)expression);
                    if (!IterUtil.isEmpty((Iterable)items)) {
                        ArrayList list = Lists.newArrayList((Iterable)items);
                        list.stream().forEach(l -> {
                            l.setDeleteFlag(1);
                            this.bipCouponItemRepo.save(l);
                        });
                    }
                }
            });
        }
    }

    public void disableCoupon(List<Long> ids) {
        if (null != ids && !ids.isEmpty()) {
            ids.stream().forEach(id -> {
                Optional optional = this.bipCouponRepo.findById(id);
                if (optional.isPresent()) {
                    BipCouponDO bipCouponDO = (BipCouponDO)optional.get();
                    bipCouponDO.setState(UdcEnum.SAL_COUPON_STATE_DISABLE.getValueCode());
                    this.bipCouponRepo.save(bipCouponDO);
                }
            });
        }
    }

    public void activeCoupon(List<Long> ids) {
        if (null != ids && !ids.isEmpty()) {
            ids.stream().forEach(id -> {
                Optional optional = this.bipCouponRepo.findById(id);
                if (optional.isPresent()) {
                    BipCouponDO bipCouponDO = (BipCouponDO)optional.get();
                    bipCouponDO.setState(UdcEnum.SAL_COUPON_STATE_ACTIVE.getValueCode());
                    this.bipCouponRepo.save(bipCouponDO);
                }
            });
        }
    }

    public Boolean checkRepeatCouponItem(Long ouId, Long couponId) {
        Long couponNewCustActiveNum;
        Long couponActiveNum;
        BipCouponDO bipCouponDO = this.getCouponById(couponId);
        if (null != bipCouponDO && StringUtil.isNotBlank((CharSequence)bipCouponDO.getIndexPageShow()) && bipCouponDO.getIndexPageShow().equals("1") && (couponActiveNum = this.getCouponActivePageShowNum(ouId)) > 2L) {
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u516c\u53f8\u4e0b\u6fc0\u6d3b\u9996\u9875\u5f39\u51fa\u4f18\u60e0\u5238\u6570\u91cf\u4e0d\u80fd\u5927\u4e8e3");
        }
        if (null != bipCouponDO && StringUtil.isNotBlank((CharSequence)bipCouponDO.getNewCustShow()) && bipCouponDO.getNewCustShow().equals("1") && (couponNewCustActiveNum = this.getCouponNewCustActiveNum(ouId)) > 6L) {
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u516c\u53f8\u4e0b\u6fc0\u6d3b\u65b0\u4eba\u4e13\u4eab\u4f18\u60e0\u5238\u6570\u91cf\u4e0d\u80fd\u5927\u4e8e7");
        }
        List<Long> allSkuIds = this.getAllSkuIdByCouponId(ouId);
        List<Long> couponSkuId = this.getByCouponId(couponId);
        List intersection = allSkuIds.stream().filter(item -> couponSkuId.contains(item)).collect(Collectors.toList());
        if (null == intersection || intersection.isEmpty()) {
            return true;
        }
        return false;
    }

    public BipCouponDO getCouponById(Long couponId) {
        Optional optional = this.bipCouponRepo.findById(couponId);
        if (optional.isPresent()) {
            return (BipCouponDO)optional.get();
        }
        return null;
    }

    public Long getCouponNewCustActiveNum(Long ouId) {
        QBipCouponDO qBipCouponDO = QBipCouponDO.bipCouponDO;
        BooleanExpression expression = qBipCouponDO.deleteFlag.eq((Object)0).and((Predicate)qBipCouponDO.newCustShow.eq((Object)"1")).and((Predicate)qBipCouponDO.ouId.eq((Object)ouId)).and((Predicate)qBipCouponDO.state.eq((Object)UdcEnum.SAL_COUPON_STATE_ACTIVE.getValueCode()));
        return this.bipCouponRepo.count((Predicate)expression);
    }

    public Long getCouponActivePageShowNum(Long ouId) {
        QBipCouponDO qBipCouponDO = QBipCouponDO.bipCouponDO;
        BooleanExpression expression = qBipCouponDO.deleteFlag.eq((Object)0).and((Predicate)qBipCouponDO.indexPageShow.eq((Object)"1")).and((Predicate)qBipCouponDO.ouId.eq((Object)ouId)).and((Predicate)qBipCouponDO.state.eq((Object)UdcEnum.SAL_COUPON_STATE_ACTIVE.getValueCode()));
        return this.bipCouponRepo.count((Predicate)expression);
    }

    public List<Long> getByCouponId(Long couponId) {
        QBipCouponItemDO qBipCouponItemDO = QBipCouponItemDO.bipCouponItemDO;
        BooleanExpression expression = qBipCouponItemDO.couponId.eq((Object)couponId).and((Predicate)qBipCouponItemDO.deleteFlag.eq((Object)0));
        Iterable iterables = this.bipCouponItemRepo.findAll((Predicate)expression);
        if (!IterUtil.isEmpty((Iterable)iterables)) {
            ArrayList list = Lists.newArrayList((Iterable)iterables);
            return list.stream().map(BipCouponItemDO::getSkuId).collect(Collectors.toList());
        }
        return null;
    }

    public List<Long> getAllSkuIdByCouponId(Long ouId) {
        ArrayList<Long> skuIdList = new ArrayList<Long>();
        QBipCouponDO qBipCouponDO = QBipCouponDO.bipCouponDO;
        QBipCouponItemDO qBipCouponItemDO = QBipCouponItemDO.bipCouponItemDO;
        BooleanExpression e = qBipCouponDO.ouId.eq((Object)ouId).and((Predicate)qBipCouponDO.state.eq((Object)UdcEnum.SAL_COUPON_STATE_ACTIVE.getValueCode())).and((Predicate)qBipCouponDO.deleteFlag.eq((Object)0));
        Iterable iterables = this.bipCouponRepo.findAll((Predicate)e);
        if (!IterUtil.isEmpty((Iterable)iterables)) {
            ArrayList list = Lists.newArrayList((Iterable)iterables);
            list.stream().forEach(l -> {
                BooleanExpression expression = qBipCouponItemDO.couponId.eq((Object)l.getId()).and((Predicate)qBipCouponItemDO.deleteFlag.eq((Object)0));
                Iterable iters = this.bipCouponItemRepo.findAll((Predicate)expression);
                if (!IterUtil.isEmpty((Iterable)iters)) {
                    ArrayList itemList = Lists.newArrayList((Iterable)iters);
                    List skuIds = itemList.stream().map(BipCouponItemDO::getSkuId).collect(Collectors.toList());
                    skuIdList.addAll(skuIds);
                }
            });
        }
        return skuIdList;
    }

    @SysCodeProc
    public BipCouponSaveVO findById(Long id) {
        BipCouponSaveVO bipCouponSaveVO = new BipCouponSaveVO();
        ArrayList resList = new ArrayList();
        Optional optional = this.bipCouponRepo.findById(id);
        if (optional.isPresent()) {
            BeanUtils.copyProperties(optional.get(), (Object)bipCouponSaveVO);
            QBipCouponItemDO qBipCouponItemDO = QBipCouponItemDO.bipCouponItemDO;
            BooleanExpression expression = qBipCouponItemDO.couponId.eq((Object)id);
            Iterable iterables = this.bipCouponItemRepo.findAll((Predicate)expression);
            if (!IterUtil.isEmpty((Iterable)iterables)) {
                ArrayList list = Lists.newArrayList((Iterable)iterables);
                list.stream().forEach(l -> {
                    BipItemVO bipItemVO = new BipItemVO();
                    BeanUtils.copyProperties((Object)l, (Object)bipItemVO);
                    resList.add(bipItemVO);
                });
            }
            bipCouponSaveVO.setItemList(resList);
            QBipCouponCustDo qBipCouponCustDo = QBipCouponCustDo.bipCouponCustDo;
            bipCouponSaveVO.setReceiveNum(Long.valueOf(((BipCouponDO)optional.get()).getReceiveNum().intValue()));
            BooleanExpression exp = qBipCouponCustDo.couponId.eq((Object)id).and((Predicate)qBipCouponCustDo.useStatus.eq((Object)UdcEnum.SAL_COUPON_USE_STATUS_USED.getValueCode()));
            Long useCount = this.bipCouponCustRepo.count((Predicate)exp);
            bipCouponSaveVO.setUseNum(useCount);
        }
        return bipCouponSaveVO;
    }

    @SysCodeProc
    public PagingVO<BipCouponVO> search(BipCouponQueryParamVO param) {
        Page ret = this.bipCouponRepo.findAll(this.bipCouponRepoProc.where(param), (Pageable)param.getPageRequest());
        List vos = ret.getContent().stream().map(BipCouponConvert.INSTANCE::doToVO).collect(Collectors.toList());
        return PagingVO.builder().total(ret.getTotalElements()).records(vos).build();
    }

    @SysCodeProc
    public PagingVO<BipCouponVO> searchAll(BipCouponQueryParamVO param) {
        Page ret = this.bipCouponRepo.findAll(this.bipCouponRepoProc.whereAll(param), (Pageable)param.getPageRequest());
        List vos = ret.getContent().stream().map(BipCouponConvert.INSTANCE::doToVO).collect(Collectors.toList());
        return PagingVO.builder().total(ret.getTotalElements()).records(vos).build();
    }

    public PagingVO<BipCouponVO> sortingSearch(BipCouponOrderVO param) {
        this.modifyCouponExceedState();
        BipCouponQueryParamVO paramVO = new BipCouponQueryParamVO();
        paramVO.setType(param.getType());
        paramVO.setOuId(this.currentOuId());
        paramVO.setState("ACTIVE");
        Page ret = this.bipCouponRepo.findAll(this.bipCouponRepoProc.where(paramVO), (Pageable)param.getPageRequest());
        List vos = ret.getContent().stream().map(BipCouponConvert.INSTANCE::doToVO).collect(Collectors.toList());
        Iterator iterator = vos.iterator();
        while (iterator.hasNext()) {
            BipCouponVO vo;
            vo.setReceiveStatus(Boolean.valueOf(!this.checkReceive(vo = (BipCouponVO)iterator.next())));
        }
        return PagingVO.builder().total(ret.getTotalElements()).records(vos).build();
    }

    public void modifyCouponExceedState() {
        QBipCouponDO qBipCouponDO = QBipCouponDO.bipCouponDO;
        BooleanExpression expression = qBipCouponDO.ouId.eq((Object)this.getCurrentOuIdInfo()).and((Predicate)qBipCouponDO.deleteFlag.eq((Object)0)).and((Predicate)qBipCouponDO.state.eq((Object)UdcEnum.SAL_COUPON_STATE_ACTIVE.getValueCode())).and((Predicate)qBipCouponDO.receiveValidEtime.lt((Comparable)LocalDateTime.now()));
        Iterable iterables = this.bipCouponRepo.findAll((Predicate)expression);
        if (!IterUtil.isEmpty((Iterable)iterables)) {
            ArrayList list = Lists.newArrayList((Iterable)iterables);
            list.stream().forEach(l -> {
                l.setState(UdcEnum.SAL_COUPON_STATE_DISABLE.getValueCode());
                this.bipCouponRepo.save(l);
            });
        }
    }

    boolean checkReceive(BipCouponVO bipCouponVO) {
        List<BipCouponCustDo> couponCustDos = this.bipCouponCustRepo.findAllByCouponIdAndUserId(bipCouponVO.getId(), UserService.currentUser().getUserId());
        return couponCustDos.size() <= 0;
    }

    private Long currentOuId() {
        CurrentUserDTO currentUserDTO = UserService.currentUser();
        BipCustUserBindDO bipCustUserBindDO = null;
        if (currentUserDTO == null || currentUserDTO.getUserId() == null) {
            throw new BusinessException(ApiCode.AUTHENTICATION_EXCEPTION, "\u8bf7\u5148\u767b\u5f55!");
        }
        bipCustUserBindDO = this.bipCustUserBindRepoProc.getByUserId(currentUserDTO.getUserId());
        if (bipCustUserBindDO == null) {
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u8bf7\u7ed1\u5b9a\u516c\u53f8\u4fe1\u606f!");
        }
        return bipCustUserBindDO.getOuId();
    }

    @Transactional
    public Long createOne(BipCouponSaveVO param) {
        BipCouponDO bipCouponDO = BipCouponConvert.INSTANCE.paramToDo(param);
        String couponCode = this.nextNumberService.generateCode("yst-sale", "COUPON_CODE", new ArrayList<String>());
        bipCouponDO.setCouponCode(couponCode);
        if (StringUtils.isEmpty((Object)param.getState())) {
            bipCouponDO.setState(UdcEnum.SAL_COUPON_STATE_NOT_ACTIVE.getValueCode());
        }
        OrgUserEmpInfoRpcDTO empInfo = this.getCurrentEmpInfo();
        bipCouponDO.setSecBuId(empInfo.getBuId());
        bipCouponDO.setSecOuId(empInfo.getOuId());
        bipCouponDO.setSecUserId(empInfo.getUserId());
        bipCouponDO.setReceiveValidStime(param.getSpecialAreaStime());
        bipCouponDO.setReceiveValidEtime(param.getSpecialAreaEtime());
        BipCouponDO coupon = (BipCouponDO)this.bipCouponRepo.save(bipCouponDO);
        List itemList = param.getItemList();
        if (null != itemList && !itemList.isEmpty()) {
            itemList.stream().forEach(item -> {
                BipCouponItemDO bipCouponItemDO = new BipCouponItemDO();
                BeanUtils.copyProperties((Object)item, (Object)bipCouponItemDO);
                bipCouponItemDO.setCouponId(coupon.getId());
                bipCouponItemDO.setOuId(param.getOuId());
                bipCouponItemDO.setOuName(param.getOuName());
                this.bipCouponItemRepo.save(bipCouponItemDO);
            });
        }
        return coupon.getId();
    }

    @Transactional
    public List<Long> createBatch(List<BipCouponSaveVO> list) {
        List dos = list.stream().map(BipCouponConvert.INSTANCE::paramToDo).collect(Collectors.toList());
        return this.bipCouponRepo.saveAll(dos).stream().map(BaseModel::getId).collect(Collectors.toList());
    }

    @Transactional
    public void update(BipCouponSaveVO param) {
        Optional optional = this.bipCouponRepo.findById(param.getId());
        if (optional.isPresent()) {
            BipCouponDO objDo = (BipCouponDO)optional.get();
            BeanUtils.copyProperties((Object)param, (Object)objDo);
            objDo.setReceiveValidStime(param.getSpecialAreaStime());
            objDo.setReceiveValidEtime(param.getSpecialAreaEtime());
            BipCouponDO coupon = (BipCouponDO)this.bipCouponRepo.save(objDo);
            List itemList = param.getItemList();
            if (null != itemList && !itemList.isEmpty()) {
                QBipCouponItemDO qBipCouponItemDO = QBipCouponItemDO.bipCouponItemDO;
                BooleanExpression expression = qBipCouponItemDO.couponId.eq((Object)coupon.getId());
                Iterable items = this.bipCouponItemRepo.findAll((Predicate)expression);
                if (!IterUtil.isEmpty((Iterable)items)) {
                    this.bipCouponItemRepo.deleteAll(items);
                }
                itemList.stream().forEach(item -> {
                    BipCouponItemDO bipCouponItemDO = new BipCouponItemDO();
                    BeanUtils.copyProperties((Object)item, (Object)bipCouponItemDO);
                    bipCouponItemDO.setCouponId(coupon.getId());
                    bipCouponItemDO.setOuId(param.getOuId());
                    bipCouponItemDO.setOuName(param.getOuName());
                    this.bipCouponItemRepo.save(bipCouponItemDO);
                });
            }
        } else {
            throw new BusinessException(ApiCode.FAIL, "\u4fee\u6539\u5931\u8d25\uff0c\u6570\u636e\u4e0d\u5b58\u5728" + param.getId());
        }
    }

    @Transactional
    public void updateDeleteFlag(Long id) {
        QBipCouponDO jpaQDo = QBipCouponDO.bipCouponDO;
        BooleanExpression predicate = jpaQDo.isNotNull();
        Optional optionalItem = this.bipCouponRepo.findOne((Predicate)(predicate = ExpressionUtils.and((Predicate)predicate, (Predicate)jpaQDo.id.eq((Object)id))));
        if (!optionalItem.isPresent()) {
            throw new BusinessException(ApiCode.FAIL, "\u4fee\u6539\u5931\u8d25\uff0c\u6570\u636e\u4e0d\u5b58\u5728" + id);
        }
        BipCouponDO do1 = (BipCouponDO)optionalItem.get();
        do1.setDeleteFlag(1);
        this.bipCouponRepo.save(do1);
    }

    @Transactional
    public void deleteBatch(List<Long> list) {
        list.forEach(this::updateDeleteFlag);
    }

    private OrgUserEmpInfoRpcDTO getCurrentEmpInfo() {
        CurrentUserDTO currentUser = UserService.currentUser();
        if (currentUser == null) {
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u5f53\u524d\u7528\u6237\u5df2\u5931\u6548,\u8bf7\u91cd\u767b\u5f55\u91cd\u8bd5");
        }
        OrgUserEmpInfoRpcDTO userEmpInfo = this.orgEmpRpcService.findUserEmpInfo(currentUser.getUserId());
        if (userEmpInfo == null) {
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u65e0\u6cd5\u83b7\u53d6\u5f53\u524d\u7528\u6237\u4fe1\u606f");
        }
        return userEmpInfo;
    }

    private Long getCurrentOuIdInfo() {
        CurrentUserDTO currentUser = UserService.currentUser();
        if (currentUser == null) {
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u5f53\u524d\u7528\u6237\u5df2\u5931\u6548,\u8bf7\u91cd\u767b\u5f55\u91cd\u8bd5");
        }
        BipCustUserBindDO bipCustUserBindDO = this.bipCustUserBindRepoProc.getByUserId(currentUser.getUserId());
        if (bipCustUserBindDO == null || bipCustUserBindDO.getOuId() == null) {
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u5f53\u524d\u7528\u6237\u672a\u7ed1\u5b9a\u516c\u53f8");
        }
        return bipCustUserBindDO.getOuId();
    }

    public BipCouponServiceImpl(BipCouponRepo bipCouponRepo, BipCouponRepoProc bipCouponRepoProc, BipCouponItemRepo bipCouponItemRepo, RmiSysNextNumberService nextNumberService, BipCustUserBindRepoProc bipCustUserBindRepoProc, BipCouponCustRepo bipCouponCustRepo, BipCouponCustRepoProc bipCouponCustRepoProc, OrgEmpRpcService orgEmpRpcService, BipCouponIndexImgRepo bipCouponIndexImgRepo, BipMessageRepo bipMessageRepo, BipMessageRepoProc bipMessageRepoProc, BipCustUserBindRepo bipCustUserBindRepo) {
        this.bipCouponRepo = bipCouponRepo;
        this.bipCouponRepoProc = bipCouponRepoProc;
        this.bipCouponItemRepo = bipCouponItemRepo;
        this.nextNumberService = nextNumberService;
        this.bipCustUserBindRepoProc = bipCustUserBindRepoProc;
        this.bipCouponCustRepo = bipCouponCustRepo;
        this.bipCouponCustRepoProc = bipCouponCustRepoProc;
        this.orgEmpRpcService = orgEmpRpcService;
        this.bipCouponIndexImgRepo = bipCouponIndexImgRepo;
        this.bipMessageRepo = bipMessageRepo;
        this.bipMessageRepoProc = bipMessageRepoProc;
        this.bipCustUserBindRepo = bipCustUserBindRepo;
    }
}

