package com.elitesland.yst.production.sale.common.constant;

import com.google.common.collect.Lists;

import java.time.LocalTime;
import java.util.List;

/**
 * 销售中心常量类.
 *
 * @author Kaiser（wang shao）
 * @date 2021-05-10
 */
public class ConstantsSale {

    public static final String TIME_FORMAT = "yyyy-MM-dd HH:mm:ss";
    public static final String DATE_FORMAT = "yyyy-MM-dd";

    /**
     * 导出按钮标志
     */
    public static final String SALS0A_EXPORT_MARK = "EXPORT_MARK";

    /**
     * 删除标识
     * 1：已删除，0：未删除
     */
    public static final int COMMON_DELETE_YSE = 1;
    public static final int COMMON_DELETE_NO = 0;

    /**
     * 常用数组分隔符号
     */
    public static final String COMMON_SPLIT_LIST = ";";

    /**
     * 系统域 账号来源, sys： 系统创建；wec：微信创建；oth：其他方式
     */
    public static final String USER_SOURCE_SYS = "sys";
    public static final String USER_SOURCE_WEC = "wec";
    public static final String USER_SOURCE_OTH = "oth";

    /**
     * 保存或提交操作类型
     */
    public static final String SAVE_OPERATION = "SAVE";
    public static final String SUBMIT_OPERATION = "SUBMIT";
    public static final String FIND_OPERATION = "FIND";


    /**
     * 系统设置客户编号
     */
    public static final String CCUSTNO = "C_CUST_NO";
    public static final String BCUSTNO = "B_CUST_NO";
    public static final String STORECUSTNO = "STORE_CUST_NO";

    /**
     * b端订单状态
     */
    public static final String SHIPPING = "shipping";
    public static final String UNPAID = "unpaid";
    public static final String SIGNED = "signed";
    public static final String CANCELLED = "cancelled";

    public static final String ITEM_OF_FEE = "ITEM_OF_FEE";

    public static final String ACCOUNT_PASSWORD = "123456";

    /**
     * 文件保存场景
     */
    public static final String FILE_SCENE = "ACCOUNT_IMAGE";
    /**
     * 发号器的appName
     */
    public static final String YST_SALE = "yst-sale";
    /**
     * UDC
     */
    public static final String YST_SALE_UDC_MODEL = "yst-sale";
    /**
     * 业务员任务管理的任务编码发号器
     */
    public static final String SALESMAN_TASK_CODE = "SALESMAN_TASK_CODE";
    /**
     * 业务员任务明细的导入模板编码
     */
    public static final String SALE_SALESMAN_TASK_DTL_IMPORT = "sale_task_detail_import";
    /**
     * 业务员任务的导出模板编码
     */
    public static final String SALE_SALESMAN_TASK_EXPORT = "sale_salesman_task_export";
    /**
     * 业务员任务管理的重复设置-是
     */
    public static final String SALESMAN_TASK_REPEAT_SET_Y = "Y";
    //public static final String SALESMAN_TASK_REPEAT_SET_NAME_Y = "是";
    /**
     * 业务员任务管理的重复设置-否
     */
    public static final String SALESMAN_TASK_REPEAT_SET_N = "N";
    /**
     * 业务员任务管理的重复设置的重复类型-次
     */
    public static final String SALESMAN_TASK_REPEAT_TYPE_TIMES = "TIMES";
    /**
     * 业务员任务管理的重复设置的重复类型-天
     */
    public static final String SALESMAN_TASK_REPEAT_TYPE_DAY = "DAY";
    /**
     * 业务员任务管理的重复设置的重复类型-周
     */
    public static final String SALESMAN_TASK_REPEAT_TYPE_WEEK = "WEEK";
    /**
     * 业务员任务管理的重复设置的重复类型-月
     */
    public static final String SALESMAN_TASK_REPEAT_TYPE_MONTH = "MONTH";

    /**
     * 任务执行记录更新任务时的业务操作执行类型-保存
     */
    public static final String TASK_EXECUTION_RECORD_SAVE = "SAVE";
    /**
     * 任务执行记录更新任务时的业务操作执行类型-提交
     */
    public static final String TASK_EXECUTION_RECORD_SUBMIT = "SUBMIT";
    /**
     * 任务执行记录更新任务时的业务操作执行类型-审核拒绝
     */
    public static final String TASK_EXECUTION_RECORD_REFUSE = "REFUSE";
    /**
     * 任务执行记录更新任务时的业务操作执行类型-审核通过
     */
    public static final String TASK_EXECUTION_RECORD_PASS = "PASS";
    /**
     * 任务执行记录更新任务时的业务操作执行类型-关闭
     */
    public static final String TASK_EXECUTION_RECORD_CLOSE = "CLOSE";

    /**
     * 业务员任务管理的重复设置的重复类型集合
     */
    public static final List<String> SALESMAN_TASK_REPEAT_TYPE_LIST = Lists.newArrayList(
            SALESMAN_TASK_REPEAT_TYPE_TIMES, SALESMAN_TASK_REPEAT_TYPE_DAY,
            SALESMAN_TASK_REPEAT_TYPE_WEEK, SALESMAN_TASK_REPEAT_TYPE_MONTH
    );

    /**
     * 任务执行记录更新任务时的业务操作执行类型的集合
     */
    public static final List<String> TASK_EXECUTION_RECORD_LIST = Lists.newArrayList(
            TASK_EXECUTION_RECORD_SAVE, TASK_EXECUTION_RECORD_SUBMIT,
            TASK_EXECUTION_RECORD_REFUSE, TASK_EXECUTION_RECORD_PASS,
            TASK_EXECUTION_RECORD_CLOSE
    );

    /**
     * 执行记录模板状态-停用
     */
    public static final String EXECTE_RECORD_TEMP_STATE_1 = "1";

    /**
     * 业务员销售业绩类型-客户
     */
    public static final String SALESMAN_STATISTICS_DEALER_CUST = "CUST";


    /**
     * 门店状态-启用
     */
    public static final String STORE_STATUS_ACTIVE = "ACTIVE";
    /**
     * 销售业绩层级为0
     */
    public static final String STATISTICS_DEALER_DTL_LEVEL_0 = "0";
    public static final String STATISTICS_DEALER_DTL_LEVEL_1 = "1";
    public static final String STATISTICS_DEALER_DTL_LEVEL_2 = "2";
    public static final String STATISTICS_DEALER_DTL_LEVEL_3 = "3";
    public static final String STATISTICS_DEALER_DTL_LEVEL_4 = "4";
    public static final String STATISTICS_DEALER_DTL_LEVEL_5 = "5";

    /**
     * 经销商销售业绩的导出模板编码
     */
    public static final String STATISTICS_DEALER_EXPORT = "sale_statistics_dealer_export";

    /**
     * APP端业务员任务列表查询为已逾期的值
     */
    public static final String SALESMAN_TASK_DELAY_FLAG_OVERDUE = "OVERDUE";

    public static final LocalTime LOCAL_TIME_MAX = LocalTime.of(23,59,59);

    /**
     * 业务员任务管理的明细导入的的业务类型集合
     */
    public static final List<String> SALESMAN_TASK_BUSINESS_TYPE_NAME_LIST = Lists.newArrayList(
            UdcEnum.SALESMAN_TASK_BUSINESS_TYPE_STORE.getValueCodeName(),
            UdcEnum.SALESMAN_TASK_BUSINESS_TYPE_DEALER.getValueCodeName(),
            UdcEnum.SALESMAN_TASK_BUSINESS_TYPE_SALESMAN.getValueCodeName()
    );

    public static final Integer STATISTICS_DEALER_QUERY_FLAG = 1;
}
