package com.elitesland.yst.production.sale.controller.sal;

import com.elitesland.yst.production.sale.api.service.SalCommissionRuleService;
import com.elitesland.yst.production.sale.api.vo.param.sal.SalCommissionBatchParam;
import com.elitesland.yst.production.sale.api.vo.param.sal.SalCommissionRuleCreateParam;
import com.elitesland.yst.production.sale.api.vo.param.sal.SalCommissionRuleImportVO;
import com.elitesland.yst.production.sale.api.vo.param.sal.SalCommissionRuleParam;
import com.elitesland.yst.production.sale.api.vo.resp.sal.SalCommissionRuleVO;
import com.elitesland.yst.production.sale.controller.BaseController;
import com.elitesland.yst.production.sale.core.util.excel.support.ExportColumnParam;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.boot.exception.BusinessException;
import com.github.xiaoymin.knife4j.annotations.ApiOperationSupport;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.*;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.RequiredArgsConstructor;
import lombok.val;
import org.springframework.web.multipart.MultipartFile;

import javax.servlet.http.HttpServletResponse;
import java.util.ArrayList;
import java.util.List;

/**
 * <p>
 * 业绩提成规则
 * </p>
 *
 * @author Shadow
 * @since 2021-11-22 19:33:13
 */
@RestController
@RequestMapping("/commission")
@Api(value = "业绩提成规则", tags = {"业绩提成规则"})
@RequiredArgsConstructor
public class SalCommissionRuleController extends BaseController {

    private final SalCommissionRuleService salCommissionRuleService;

    /**
     * 通过主键查询单条数据
     *
     * @param id 主键
     * @return 单条数据
     */
    @GetMapping("/findIdOne/{id}")
    @ApiOperation("通过ID查询")
    @ApiOperationSupport(order = 1)
    ApiResult<SalCommissionRuleVO> findIdOne(@PathVariable Long id) {
        return salCommissionRuleService.findIdOne(id);
    }

    /**
     * 分页查询
     *
     * @param param 分类查询、分页和排序对象
     * @return 多条数据
     */
    @PostMapping("/search")
    @ApiOperation("分页查询")
    @ApiOperationSupport(order = 2)
    public ApiResult<PagingVO<SalCommissionRuleVO>> search(@RequestBody SalCommissionRuleParam param) {
        val ret = salCommissionRuleService.search(param);
        return ApiResult.ok(ret);
    }

    /**
     * 新增数据
     *
     * @param param 新增数据
     * @return 新增数据情况
     */
    @PostMapping("/createOne")
    @ApiOperation("新增数据")
    @ApiOperationSupport(order = 3)
    public ApiResult<Object> createOne(@RequestBody SalCommissionRuleCreateParam param) {
        return ApiResult.ok(salCommissionRuleService.createOne(param));
    }

    /**
     * 批量新增数据
     *
     * @param param 创建参数
     */
    @PostMapping("/createBatch")
    @ApiOperation("批量新增数据")
    @ApiOperationSupport(order = 4)
    public ApiResult<String> createBatch(@RequestBody SalCommissionBatchParam param) {
        salCommissionRuleService.createBatch(param);
        return ApiResult.ok();
    }

    /**
     * 修改数据
     *
     * @param param 修改对象
     * @return 修改数据详情
     */
    @PutMapping("/update")
    @ApiOperation("修改数据")
    @ApiOperationSupport(order = 5)
    public ApiResult<Object> update(@RequestBody SalCommissionBatchParam param) {
        salCommissionRuleService.update(param);
        return ApiResult.ok();
    }

    /**
     * 逻辑删除
     *
     * @param id 更新数据
     */
    @PutMapping("/updateDeleteFlag/{id}")
    @ApiOperation("逻辑删除")
    @ApiOperationSupport(order = 6)
    public ApiResult<Object> updateDeleteFlag(@PathVariable Long id) {
        salCommissionRuleService.updateDeleteFlag(id);
        return ApiResult.ok();
    }

    /**
     * 批量删除
     *
     * @param ids 删除数据集合
     */
    @DeleteMapping("/deleteBatch")
    @ApiOperation("批量删除")
    @ApiOperationSupport(order = 7)
    public ApiResult<Object> deleteBatch(@RequestBody List<Long> ids) {
        salCommissionRuleService.deleteBatch(ids);
        return ApiResult.ok();
    }

    @PostMapping(value = "/ImportData")
    @ApiOperation(value = "导入数据")
    @ApiOperationSupport(order = 8)
    public ApiResult<String> importCommissionData(MultipartFile file) {
        List<SalCommissionRuleImportVO> parseData = null;
        try {
            parseData = (List<SalCommissionRuleImportVO>) this.importExcel(file, SalCommissionRuleImportVO.class, 2, 2);
        } catch (Exception e) {
            return ApiResult.fail("解析导入文件失败，请严格按照原始模板数据格式进行导入");
        }
        if (!CollectionUtils.isEmpty(parseData)) {
            salCommissionRuleService.importData(parseData);
        }
        return ApiResult.ok();
    }

    @PostMapping(value = "/exportData")
    @ApiOperation(value = "导出数据")
    @ApiOperationSupport(order = 9)
    public void exportRule(HttpServletResponse response, @RequestBody SalCommissionRuleParam pagingParamVO) {
        //导出列
        List<ExportColumnParam> columnParamList = new ArrayList<>(10);
        //确定导出字段
        columnParamList.add(new ExportColumnParam("ouId", "公司ID"));
        columnParamList.add(new ExportColumnParam("ouCode", "公司编号"));
        columnParamList.add(new ExportColumnParam("ouName", "公司名称"));
        columnParamList.add(new ExportColumnParam("cateCodeName", "品类名称"));
        columnParamList.add(new ExportColumnParam("itemCode", "商品编号"));
        columnParamList.add(new ExportColumnParam("itemName", "商品名称"));
        columnParamList.add(new ExportColumnParam("commissionRuleName", "提成规则"));
        columnParamList.add(new ExportColumnParam("percentage", "提成百分比"));
        columnParamList.add(new ExportColumnParam("pieceWage", "计件提成"));
        columnParamList.add(new ExportColumnParam("createDate", "创建日期"));

        try {
            export(response, "提成规则导出数据", columnParamList, salCommissionRuleService::search, pagingParamVO);
        } catch (Exception e) {
            throw new BusinessException("导出失败");
        }
    }

}


