package com.elitesland.yst.production.sale.controller.salesman;


import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.system.dto.SysEmployeeBasicDTO;
import com.elitesland.yst.production.sale.api.service.SalesmanInfoService;
import com.elitesland.yst.production.sale.api.vo.param.salesman.*;
import com.elitesland.yst.production.sale.api.vo.resp.salesman.*;
import com.elitesland.yst.production.sale.api.vo.save.SalesmanInfoSaveVO;
import com.elitesland.yst.production.sale.controller.BaseController;
import com.elitesland.yst.production.sale.core.util.excel.support.ExportColumnParam;
import com.elitesland.yst.production.sale.dto.SalesmanLevelInfoDTO;
import com.elitesland.yst.production.sale.dto.query.SalesmanAPPQueryDTO;
import com.elitesland.yst.production.sale.dto.query.SalesmanInfoAPPRespDTO;
import com.elitesland.yst.production.sale.dto.save.SalesmanUpdateDTO;
import com.elitesland.yst.production.sale.service.SalesmanRpcServiceImpl;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.MediaType;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;
import org.springframework.web.multipart.MultipartFile;

import javax.servlet.http.HttpServletResponse;
import java.util.ArrayList;
import java.util.List;

/**
 * @author Danny.Wang
 * @title SalesmanInfoController
 * @Date2023/2/20 11:27
 */
@RestController
@RequestMapping(value = "/salesmanInfo", produces = MediaType.APPLICATION_JSON_VALUE)
@Api(value = "业务员信息", tags = {"业务员信息"})
public class SalesmanInfoController extends BaseController {

    @Autowired
    private SalesmanInfoService salesmanInfoService;
    @Autowired
    private SalesmanRpcServiceImpl salesmanRpcService;

    @PostMapping(value = "/save")
    @ApiOperation(value = "业务员信息保存更新")
    public ApiResult<Object> save(@RequestBody @Validated SalesmanInfoSaveVO salesmanInfoSaveVO) {
        return salesmanInfoService.save(salesmanInfoSaveVO);
    }

    @PostMapping(value = "/query")
    @ApiOperation(value = "业务员信息查询")
    public ApiResult<PagingVO<SalesmanInfoRespVO>> query(@RequestBody SalesmanInfoQueryVO salesmanInfoQueryVO) {
        return salesmanInfoService.query(salesmanInfoQueryVO);
    }

    @GetMapping(value = "/queryDetail/{id}")
    @ApiOperation(value = "业务员详情信息查询")
    public ApiResult<SalesmanInfoDetailRespVO> queryDetail(@PathVariable("id") Long id) {
        return salesmanInfoService.queryDetail(id);
    }

    @GetMapping(value = "/queryDetailByUserId/{userId}")
    @ApiOperation(value = "通过userId查询业务员")
    public ApiResult<SysEmployeeBasicDTO> queryDetailByUserId(@PathVariable("userId") Long userId) {
        return ApiResult.ok(salesmanInfoService.queryDetailByUserId(userId));
    }

    @PostMapping(value = "/querySubordinate")
    @ApiOperation(value = "业务员下级信息查询")
    public ApiResult<PagingVO<SalesmanInfoRespVO>> querySubordinate(@RequestBody SalesmanSubordinateQueryVO salesmanSubordinateQueryVO) {
        return salesmanInfoService.querySubordinate(salesmanSubordinateQueryVO);
    }

    @PostMapping(value = "/changeStatus")
    @ApiOperation(value = "业务员信息状态更新")
    public ApiResult<Object> changeStatus(@RequestBody @Validated SalesmanInfoChangeVO salesmanInfoChangeVO) {
        return salesmanInfoService.changeStatus(salesmanInfoChangeVO);
    }

    @PostMapping(value = "/querySuperior")
    @ApiOperation(value = "查询业务员上级信息")
    public ApiResult<PagingVO<SalesmanSuperiorRespVO>> querySuperior(@RequestBody @Validated SalesmanSuperiorQueryVO salesmanSuperiorQueryVO) {
        return salesmanInfoService.querySuperior(salesmanSuperiorQueryVO);
    }

    @ApiOperation("业务员信息导入")
    @ApiImplicitParams(@ApiImplicitParam(name = "file", value = "导入数据的文件", required = true))
    @PostMapping("/salesmanImport")
    public ApiResult<Object> salesmanImport(MultipartFile file){
        return salesmanInfoService.salesmanImport(file);
    }

    @ApiOperation("业务员信息导出")
    @PostMapping("/salesmanExport")
    public ApiResult<Object> salesmanExport(HttpServletResponse response, @RequestBody SalesmanInfoQueryVO salesmanInfoQueryVO) {
        //导出列
        List<ExportColumnParam> columnParamList = new ArrayList<>(20);
        //确定导出字段
        columnParamList.add(new ExportColumnParam("salesmanNo", "业务员编号"));
        columnParamList.add(new ExportColumnParam("salesmanType", "业务员类型"));
        columnParamList.add(new ExportColumnParam("jurisdiction", "管辖区域"));
        columnParamList.add(new ExportColumnParam("leaderUserFullName", "上级业务员名称"));
        columnParamList.add(new ExportColumnParam("username", "登录账号"));
        columnParamList.add(new ExportColumnParam("fullName", "姓名"));
        columnParamList.add(new ExportColumnParam("phone", "手机号"));
        columnParamList.add(new ExportColumnParam("email", "邮箱"));
        columnParamList.add(new ExportColumnParam("genderName", "性别"));
        columnParamList.add(new ExportColumnParam("birthDate", "出生日期"));
        columnParamList.add(new ExportColumnParam("idCard", "身份证号"));
        columnParamList.add(new ExportColumnParam("provinceName", "省"));
        columnParamList.add(new ExportColumnParam("cityName", "市"));
        columnParamList.add(new ExportColumnParam("countyName", "区"));
        columnParamList.add(new ExportColumnParam("address", "详细地址"));
        columnParamList.add(new ExportColumnParam("joinTime", "入职日期"));
        columnParamList.add(new ExportColumnParam("ouName", "公司名称"));
        columnParamList.add(new ExportColumnParam("orgName", "组织名称"));
        columnParamList.add(new ExportColumnParam("enableStatusName", "启用状态"));
        try {
            export(response, "业务员导出信息", columnParamList, param -> salesmanInfoService.querySalesmanAllInfo(param).getData(), salesmanInfoQueryVO);
        } catch (Exception e) {
            throw new BusinessException("导出失败");
        }
        return ApiResult.ok();
    }
    @ApiOperation("业务员上级阶级信息查询")
    @GetMapping("/queryLevelInfo/{id}")
    ApiResult<SalesmanLevelInfoDTO> queryLevelInfo(@PathVariable("id") Long id){
        return ApiResult.ok(salesmanInfoService.queryLevelInfo(id));
    }

    @PostMapping(value = "/salesmanTeam")
    @ApiOperation(value = "业务员团队信息查询")
    public ApiResult<List<SalesmanInfoAPPRespDTO>> salesmanTeam(@RequestBody SalesmanAPPQueryDTO salesmanAPPQueryDTO) {
        return salesmanInfoService.salesmanTeam(salesmanAPPQueryDTO);
    }

    @PostMapping(value = "/salesmanTeamAll")
    @ApiOperation(value = "业务员全部团队信息查询")
    public ApiResult<PagingVO<SalesmanInfoAPPRespDTO>> salesmanTeamAll(@RequestBody SalesmanAPPQueryDTO salesmanAPPQueryDTO) {
        return ApiResult.ok(salesmanInfoService.salesmanTeamAll(salesmanAPPQueryDTO));
    }

    @PostMapping("/salesmanInfo/update")
    @ApiOperation(value = "业务员头像手机号信息更新")
    ApiResult<Object> updateSalesmanInfo(@RequestBody @Validated SalesmanUpdateDTO salesmanUpdateDTO){
        return salesmanRpcService.updateSalesmanInfo(salesmanUpdateDTO);
    }

    @GetMapping(value = "/appQueryDetail/{code}")
    @ApiOperation(value = "app业务员个人信息查询")
    public ApiResult<SalesmanInfoAppDetailRespVO> appQueryDetail(@PathVariable("code") String code) {
        return ApiResult.ok(salesmanInfoService.appQueryDetail(code));
    }

    @PostMapping(value = "/queryAllSalemanInfos")
    @ApiOperation(value = "查询本级及全部下级业务员信息")
    public ApiResult<PagingVO<SalesmanInfoStdVO>> queryAllSalemanInfosByAgentEmpId(@RequestBody SalesmanUnderLingQueryVO salesmanUnderLingQueryVO) {
        return ApiResult.ok(salesmanInfoService.queryAllSalemanInfosByAgentEmpId(salesmanUnderLingQueryVO));
    }

}
