package com.elitesland.yst.production.sale.controller.test;

import com.elitesland.yst.production.sale.dto.*;
import com.elitesland.yst.production.sale.dto.param.CrmCustRpcDtoParam;
import com.elitesland.yst.production.sale.dto.query.PriSalePriceReqDTO;
import com.elitesland.yst.production.sale.service.CrmCustRpcServiceImpl;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.github.xiaoymin.knife4j.annotations.ApiOperationSupport;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.MediaType;
import org.springframework.web.bind.annotation.*;

import java.util.List;

/**
 * <p>
 *
 * </p>
 *
 * @author zhao.zhi.hao
 * @since 2021/12/22 17:08
 */
@RestController
@RequestMapping(value = "/nrp/test", produces = MediaType.APPLICATION_JSON_VALUE)
@Api(tags = "对外接口")
@Slf4j
public class doubboTestController {

    @Autowired
    private CrmCustRpcServiceImpl crmCustRpcService;

    @PostMapping(value = "/cust")
    @ApiOperation(value = "客户接口")
    public ApiResult<List<CrmCustRespDTO>> testPrice(@RequestBody CrmCustRpcDtoParam params) {
        return crmCustRpcService.getCustByParam(params);
    }

    @PostMapping(value = "/empCustJudge")
    @ApiOperation(value = "客户接口")
    public ApiResult<Object> testEmpCustJudge(@RequestBody List<CrmCustJudgeDTO> params) {
        return crmCustRpcService.judgeDependEmpAndCust(params);
    }


    @GetMapping(value = "/getCustByUserName")
    @ApiOperation(value = "根据用户名查询客户")
    public ApiResult<List<CrmCustSimpleDTO>> testGetCustByUserName(@RequestParam String userName) {
        return ApiResult.ok(crmCustRpcService.getCustByUserName(userName));
    }


    @GetMapping(value = "/getByUserName/{userName}")
    @ApiOperation(value = "根据用户名查询客户")
    public ApiResult<CrmCustDTO> getByUserName(@PathVariable String userName) {
        return crmCustRpcService.getCustInfo(userName);
    }
}
