package com.elitesland.yst.production.sale.controller.workflow;

import cn.hutool.core.collection.CollUtil;
import com.elitesland.yst.production.sale.workflow.CallBackPathConstant;
import com.elitesland.yst.production.sale.workflow.service.PriSalePriceAlterProcessService;
import com.elitesland.workflow.WorkflowCallBack;
import com.elitesland.workflow.WorkflowConstant;
import com.elitesland.workflow.payload.ProcessStatusChangePayload;
import com.elitesland.workflow.payload.TaskAssigneePayload;
import com.elitesland.workflow.payload.TaskCompletedPayload;
import com.elitesland.workflow.payload.TaskCreatedPayload;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.util.ArrayList;
import java.util.List;

/**
 * @author Danny.Wang
 * @title B2bInSettlePriceWfCallbackController
 * @Date2023/1/3 15:04
 */
@RequiredArgsConstructor
@Slf4j
@RestController
@RequestMapping(CallBackPathConstant.B2B_IN_SETTLE_PRICE)
public class B2bInSettlePriceWfCallbackController implements WorkflowCallBack {

    private final PriSalePriceAlterProcessService priSalePriceAlterProcessService;

    @Override
    @PostMapping(WorkflowConstant.TASK_ASSIGNEE_PATH)
    public ArrayList<String> taskAssignee(@RequestBody TaskAssigneePayload payload) {
        log.info("payload:{}",payload);
        List<String> userIds = priSalePriceAlterProcessService.taskAssignee(getId(payload.getBusinessKey()), payload.getCustomParams());
        return CollUtil.newArrayList(userIds);
    }

    @Override
    @PostMapping(WorkflowConstant.TASK_CREATED_PATH)
    public void taskCreated(@RequestBody TaskCreatedPayload payload) {
        log.info("任务创建后回调:{}",payload.toString());
    }

    @Override
    @PostMapping(WorkflowConstant.TASK_COMPLETED_PATH)
    public void taskCompleted(@RequestBody TaskCompletedPayload payload) {
        log.info("任务完成后回调:{}",payload.toString());
    }

    @Override
    @PostMapping(WorkflowConstant.PROCESS_STATUS_CHANGE_PATH)
    public void processStatusChange(@RequestBody ProcessStatusChangePayload payload) {
        //B端对外销售价格申请单 + B端内部结算价申请单
        log.info("payload:{}",payload);
        priSalePriceAlterProcessService.processStatusChange(getId(payload.getBusinessKey()), payload.getProcInstStatus());
    }

    //从businessKey中提取id
    private Long getId(String businessKey) {
        return Long.valueOf(businessKey);
    }
}
