package com.elitesland.yst.production.sale.entity;


import com.elitescloud.boot.model.entity.BaseModel;
import lombok.Data;
import lombok.experimental.Accessors;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;
import org.hibernate.annotations.Where;
import org.springframework.data.jpa.repository.config.EnableJpaAuditing;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import java.io.Serializable;
import java.math.BigDecimal;

@Entity
@Table(name = "bip_coupon_item", indexes = {
})
@org.hibernate.annotations.Table(appliesTo = "bip_coupon_item", comment = "优惠券关联商品")
@EnableJpaAuditing
@Data
@DynamicInsert
@DynamicUpdate
@Accessors(chain = true)
@Where(clause = "delete_flag = 0 or delete_flag is null")

public class BipCouponItemDO extends BaseModel implements Serializable {

    @Column(name = "coupon_id", columnDefinition = "bigInt(20) not null  comment '优惠券id'")
    private Long couponId;

    @Column(name = "sku_id", columnDefinition = "bigInt(20) not null  comment 'skuid'")
    private Long skuId;

    @Column(name = "bip_item_id", columnDefinition = "bigInt(20) comment '商品id'")
    private Long bipItemId;

    @Column(name = "category_id", columnDefinition = "bigInt(20) comment '商品id'")
    private Long categoryId;

    @Column(name = "category_code", columnDefinition = "varchar(256) comment '商品品类'")
    private String categoryCode;

    @Column(name = "category_name", columnDefinition = "varchar(256) comment '商品品类名称'")
    private String categoryName;

    @Column(name = "item_id", columnDefinition = "bigInt(20) comment '商品id(商品中心)'")
    private Long itemId;

    @Column(name = "item_name", columnDefinition = "varchar(256) comment '商品名称'")
    private String itemName;

    @Column(name = "item_code", columnDefinition = "varchar(256) comment '商品编码'")
    private String itemCode;

    @Column(name = "ou_id", columnDefinition = "bigInt(20) not null  comment '公司id'")
    private Long ouId;

    @Column(name = "ou_name", columnDefinition = "varchar(32)    comment '公司名称'")
    private String ouName;

    @Column(name = "spec", columnDefinition = "varchar(32)    comment '规格'")
    private String spec;

    @Column(name = "uom", columnDefinition = "varchar(32)    comment '计量单位'")
    private String uom;

    @Column(name = "total_amount", columnDefinition = "decimal(20,4)    comment '含税金额'")
    private BigDecimal totalAmount;

}
