package com.elitesland.yst.production.sale.entity;

import com.elitescloud.boot.model.entity.BaseModel;
import lombok.Data;
import lombok.experimental.Accessors;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;
import org.hibernate.annotations.Where;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import java.io.Serializable;

/**
 * Created with IntelliJ IDEA.
 *
 * @Author: wang yinghao
 * @Date: 2021/08/04/13:40
 * @Description:运费模板
 */

@Entity
@Table(name = "bip_fare_tmpl")
@org.hibernate.annotations.Table(appliesTo = "bip_fare_tmpl", comment = "运费模板主表")
@Data
@DynamicInsert
@DynamicUpdate
@Accessors(chain = true)
@Where(clause = "delete_flag = 0 or delete_flag is null")

public class BipFareTmplDo extends BaseModel implements Serializable {


    private static final long serialVersionUID = -5046353006882842284L;

    @Column(name = "fare_tmpl_code", columnDefinition = "varchar(20) comment '运费模板编码'")
    private String fareTmplCode;


    @Column(name = "fare_tmpl_name", columnDefinition = "varchar(20) comment '运费模板名称'")
    private String fareTmpName;

    @Column(name = "fare_tmpl_desc", columnDefinition = "varchar(20) comment '运费模板描述'")
    private String fareTmpDdesc;

    @Column(name = "pcode", columnDefinition = "varchar(20) comment '发货地省编码'")
    private String pcode;

    @Column(name = "ccode", columnDefinition = "varchar(20) comment '发货地市编码'")
    private String ccode;

    @Column(name = "acode", columnDefinition = "varchar(20) comment '发货地区（县）编码'")
    private String acode;


    @Column(name = "scode", columnDefinition = "varchar(20) comment '发货地区乡编码'")
    private String scode;

    @Column(name = "calc_method", columnDefinition = "varchar(20) comment '计价方式'")
    private String calcMethod;

    @Column(name = "enabled", columnDefinition = "varchar(20) comment '是否启用'")
    private String enabled;
}
