package com.elitesland.yst.production.sale.entity;

import com.elitescloud.boot.model.entity.BaseModel;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.experimental.Accessors;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;
import org.hibernate.annotations.Where;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Index;
import javax.persistence.Table;
import java.io.Serializable;
import java.time.LocalDateTime;

/**
 * Created with IntelliJ IDEA.
 *
 * @Author: wang yinghao
 * @Date: 2021/08/04/14:42
 * @Description:商品评价
 */
@Entity
@Table(name = "bip_item_eval", indexes = {
        @Index(name = "idx_bip_item_eval_item_id", columnList = "item_id")
})
@org.hibernate.annotations.Table(appliesTo = "bip_item_eval", comment = "商品评价")
@Data
@DynamicInsert
@DynamicUpdate
@Accessors(chain = true)
@Where(clause = "delete_flag = 0 or delete_flag is null")
@ApiModel(description = "商品评价")
public class BipItemEvalDo extends BaseModel implements Serializable {


    private static final long serialVersionUID = -1561430237473054323L;

    @Column(name = "order_id", columnDefinition = "bigInt(20) comment '订单主表id'")
    @ApiModelProperty("订单主表id")
    private Long orderId;

    @Column(name = "doc_no", columnDefinition = "varchar(32) comment '订单号'")
    @ApiModelProperty("订单号")
    private String docNo;

    @Column(name = "order_d_id", columnDefinition = "bigInt(20) comment '订单明细表id'")
    @ApiModelProperty("订单明细表id")
    private Long orderDId;

    @Column(name = "item_id", columnDefinition = "bigInt(20) comment '商品id'")
    @ApiModelProperty("商品id")
    private Long itemId;

    @Column(name = "item_code", columnDefinition = "varchar(20) comment '商品编码'")
    @ApiModelProperty("商品编码")
    private String itemCode;

    @Column(name = "sku_id", columnDefinition = "bigInt(20) comment '商品skuid'")
    @ApiModelProperty("商品skuid")
    private Long skuId;

    @Column(name = "sku_code", columnDefinition = "varchar(20) comment '商品sku编码'")
    @ApiModelProperty("商品sku编码")
    private String skuCode;

    @Column(name = "item_name", columnDefinition = "varchar(255) comment '商品名称'")
    @ApiModelProperty("商品名称")
    private String itemName;

    @Column(name = "cust_account_id", columnDefinition = "bigint(20) comment '账户id'")
    @ApiModelProperty("账户id")
    private Long custAccountId;

    @Column(name = "cust_account_name", columnDefinition = "varchar(128) comment '账户名称'")
    @ApiModelProperty("账户名称")
    private String custAccountName;

    @Column(name = "tel", columnDefinition = "varchar(20) comment '账户绑定电话'")
    @ApiModelProperty("账户绑定电话")
    private String tel;

    @Column(name = "context", columnDefinition = "varchar(1024) comment '评价内容'")
    @ApiModelProperty("评价内容")
    private String context;

    @Column(name = "ou_id", columnDefinition = "bigInt(20) comment '客户公司id'")
    @ApiModelProperty("客户公司id")
    private Long ouId;

    @Column(name = "ou_code", columnDefinition = "varchar(20) comment '客户公司编码'")
    @ApiModelProperty("客户公司编码")
    private String ouCode;

    @Column(name = "ou_name", columnDefinition = "varchar(20) comment '客户公司名称'")
    @ApiModelProperty("客户公司名称")
    private String ouName;

    @Column(name = "is_replay", columnDefinition = "tinyint(1) default 0 comment  '是否已回复 0 未回复 1 回复'")
    @ApiModelProperty("是否已回复")
    private Boolean isReplay;

    @Column(name = "replay_user_id", columnDefinition = "bigInt(20) comment '回复者id'")
    @ApiModelProperty("回复者id")
    private Long replayUserId;

    @Column(name = "replay_name", columnDefinition = "varchar(20) comment '回复者名称'")
    @ApiModelProperty("回复者名称")
    private String replayName;

    @Column(name = "replay_context", columnDefinition = "varchar(1024) comment '回复内容'")
    @ApiModelProperty("回复内容")
    private String replayContext;

    @Column(name = "replay_time", columnDefinition = "datetime comment '回复时间'")
    @ApiModelProperty("回复时间")
    private LocalDateTime replayTime;


    @Column(name = "item_eval_score", columnDefinition = "int(10) default 0 comment '商品评分'")
    @ApiModelProperty("商品评分")
    private Integer itemEvalScore;


    @Column(name = "logic_eval_score", columnDefinition = "int(10) default 0 comment '物流评分'")
    @ApiModelProperty("物流评分")
    private Integer logicEvalScore;

    @Column(name = "eval_pic_file_codes", columnDefinition = "varchar(1024) comment '评价图片'")
    @ApiModelProperty("评价图片")
    private String evalFileCodes;

    @Column(name = "is_show", columnDefinition = "tinyint(1) default 0 comment '是否显示 0 显示 1 不显示'")
    @ApiModelProperty("是否显示")
    private Boolean isShow;

    @Column(name = "is_public", columnDefinition = "tinyint(1) default 0 comment '是否公开 0 公开 1 不公开'")
    private Boolean isPublic;


}
