package com.elitesland.yst.production.sale.entity;

import com.elitescloud.boot.model.entity.BaseModel;
import lombok.Data;
import lombok.experimental.Accessors;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;
import org.hibernate.annotations.Where;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDateTime;

/**
 * <p>
 *
 * </p>
 *
 * @author zhao.zhi.hao
 * @since 2021/6/27 11:11
 */
@Entity
@Table(name = "crm_cust_ou")
@org.hibernate.annotations.Table(appliesTo = "crm_cust_ou", comment = "客户公司拓展表")
@Data
@DynamicInsert
@DynamicUpdate
@Where(clause = "delete_flag = 0 or delete_flag is null")
@Accessors(chain = true)
public class CrmCustOuDO extends BaseModel implements Serializable {

    private static final long serialVersionUID = -2451455495493073272L;

    @Column(name = "mas_id", columnDefinition = "bigint(18) default null  comment '主表ID'")
    private Long masId;

    @Column(name = "cust_code", columnDefinition = "varchar(40) default null  comment '客户编号'")
    private String custCode;

    @Column(name = "cust_name", columnDefinition = "varchar(200) default null  comment '客户名称'")
    private String custName;

    @Column(name = "ou_id", columnDefinition = "bigint(18) default null  comment '公司ID 所属的公司'")
    private Long ouId;

    @Column(name = "ou_code", columnDefinition = "varchar(40) default null  comment '公司编号'")
    private String ouCode;

    @Column(name = "ou_name", columnDefinition = "varchar(200) default null  comment '公司名称'")
    private String ouName;

    @Column(name = "bu_id", columnDefinition = "bigint(18) default null  comment 'BUID'")
    private Long buId;

    @Column(name = "bu_code", columnDefinition = "varchar(40) default null  comment 'BU编号'")
    private String buCode;

    @Column(name = "bu_name", columnDefinition = "varchar(200) default null  comment 'BU名称'")
    private String buName;

    @Column(name = "agent_emp_id", columnDefinition = "bigint(18) default null  comment '业务员Id'")
    private Long agentEmpId;

    @Column(name = "cust_curr", columnDefinition = "varchar(40) default null  comment '币种'")
    private String custCurr;

    @Column(name = "credit_level", columnDefinition = "varchar(40) default null  comment '信贷级别'")
    private String creditLevel;

    @Column(name = "credit_limit", columnDefinition = "decimal(20,2) default null  comment '信用额度'")
    private BigDecimal creditLimit;

    @Column(name = "credit_bal", columnDefinition = "decimal(20,2) default null  comment '信用余额'")
    private BigDecimal creditBal;

    @Column(name = "credit_check_type", columnDefinition = "varchar(40) default null  comment '信贷检查类型'")
    private String creditCheckType;

    @Column(name = "ardays_check_type", columnDefinition = "varchar(40) default null  comment '账期检查类型'")
    private String ardaysCheckType;

    @Column(name = "payment_term", columnDefinition = "varchar(40) default null  comment '支付条款'")
    private String paymentTrem;

    @Column(name = "tax_rate_no", columnDefinition = "varchar(40) default null  comment '税率编号'")
    private String taxRateNo;

    @Column(name = "tax_rate", columnDefinition = "decimal(20,8) default null  comment '税率'")
    private BigDecimal taxRate;

    @Column(name = "fin_gl_type", columnDefinition = "varchar(40) default null  comment '总账类型'")
    private String finGlType;

//    @Column(name = "intf_status", columnDefinition = "varchar(40) default null  comment '接口状态'")
//    private String intfStatus;

    @Column(name = "intf_time", columnDefinition = "datetime default null  comment '接口处理时间'")
    private LocalDateTime intfTime;

}
