package com.elitesland.yst.production.sale.entity;

import com.elitesland.workflow.enums.ProcInstStatus;
import com.elitescloud.cloudt.common.annotation.Comment;
import com.elitescloud.boot.model.entity.BaseModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;
import org.hibernate.annotations.Where;

import javax.persistence.*;
import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDateTime;

/**
 * <p>
 *
 * </p>
 *
 * @author zhao.zhi.hao
 * @since 2021/6/15 10:40
 */
@Entity
@Table(name = "sal_quotation", indexes = {
        @Index(name = "idx_sal_quotation_doc_no", columnList = "doc_no", unique = true),
})
@org.hibernate.annotations.Table(appliesTo = "sal_quotation", comment = "销售报价单")
@Data
@DynamicInsert
@DynamicUpdate
@Where(clause = "delete_flag = 0 or delete_flag is null")
public class SalQuotationDO extends BaseModel implements Serializable {
    private static final long serialVersionUID = -2647036207075509905L;

    @ApiModelProperty("报价单号")
    @Column(name = "doc_no", columnDefinition = "varchar(40) default null comment '报价单号'")
    private String docNo;

    @ApiModelProperty("客户类型")
    @Column(name = "qt_cust_type", columnDefinition = "varchar(40) default null comment '客户类型'")
    private String qtCustType;

    @ApiModelProperty("客户ID")
    @Column(name = "cust_id", columnDefinition = "bigint(18) default null comment '客户ID'")
    private Long custId;

    @ApiModelProperty("客户编码")
    @Column(name = "cust_code", columnDefinition = "longtext default null comment '客户编码'")
    private String custCode;

    @ApiModelProperty("客户名称")
    @Column(name = "cust_name", columnDefinition = "longtext default null comment '客户名称'")
    private String custName;

    @ApiModelProperty("公司ID")
    @Column(name = "ou_id", columnDefinition = "bigint(18) default null comment '公司ID'")
    private Long ouId;

    @ApiModelProperty("公司编码")
    @Column(name = "ou_code", columnDefinition = "longtext default null comment '公司编号'")
    private String ouCode;

    @ApiModelProperty("销售组织ID")
    @Column(name = "bu_id", columnDefinition = "bigint(18) default null comment '销售组织ID'")
    private Long buId;

    @ApiModelProperty("销售组织编码")
    @Column(name = "bu_code", columnDefinition = "longtext default null comment '销售组织编码'")
    private String buCode;

    @ApiModelProperty("仓库ID")
    @Column(name = "wh_id", columnDefinition = "bigint(18) default null comment '仓库ID'")
    private Long whId;

    @ApiModelProperty("报价人ID")
    @Column(name = "agent_emp_id", columnDefinition = "bigint(18) default null comment '报价人ID'")
    private Long agentEmpId;

    @ApiModelProperty("报价人编码")
    @Column(name = "agent_emp_code", columnDefinition = "longtext default null comment '报价人编码'")
    private String agentEmpCode;

    @ApiModelProperty("本位币币种")
    @Column(name = "home_curr", columnDefinition = "longtext default null comment '本位币币种'")
    private String homeCurr;

    @ApiModelProperty("币种")
    @Column(name = "curr_code", columnDefinition = "longtext default null comment '币种'")
    private String currCode;

    @ApiModelProperty("汇率")
    @Column(name = "curr_rate", columnDefinition = "decimal(20,8) default null comment '汇率'")
    private BigDecimal currRate;

    @ApiModelProperty("报价日期")
    @Column(name = "quotation_date", columnDefinition = "datetime default null comment '报价日期'")
    private LocalDateTime quotationDate;

    @ApiModelProperty("销售区域")
    @Column(name = "sale_region", columnDefinition = "varchar(40) default null comment '销售区域'")
    private String saleRegion;

    @ApiModelProperty("报价单状态")
    @Column(name = "quotation_status", columnDefinition = "varchar(40) default null comment '报价单状态'")
    private String quotationStatus;

//    @ApiModelProperty("审批日期")
//    @Column(name = "appr_time", columnDefinition = "datetime default null comment '审批日期'")
//    private LocalDateTime apprTime;

    @ApiModelProperty("审批人")
    @Column(name = "appr_user_id", columnDefinition = "bigint(18) default null comment '审批人'")
    private Long apprUserId;

    @ApiModelProperty("应税总金额")
    @Column(name = "net_amt", columnDefinition = "decimal(20,8) default null comment '应税总金额'")
    private BigDecimal netAmt;

    @ApiModelProperty("含税总金额")
    @Column(name = "amt", columnDefinition = "decimal(20,8) default null comment '含税总金额'")
    private BigDecimal amt;

    @ApiModelProperty("税额")
    @Column(name = "tax_amt", columnDefinition = "decimal(20,8) default null comment '税额'")
    private BigDecimal taxAmt;

    @ApiModelProperty("付款方式")
    @Column(name = "pay_method", columnDefinition = "varchar(40) default null comment '付款方式'")
    private String payMethod;

//    @ApiModelProperty("审批意见")
//    @Column(name = "appr_comment", columnDefinition = "longtext default null comment '审批意见'")
//    private String apprComment;

    @ApiModelProperty("客户联系人")
    @Column(name = "cust_contact_name", columnDefinition = "varchar(40) default null comment '客户联系人'")
    private String custContactName;

    @ApiModelProperty("客户联系人电话")
    @Column(name = "cust_contact_tel", columnDefinition = "varchar(40) default null comment '客户联系人电话'")
    private String custContactTel;

    @ApiModelProperty("收货地址ID")
    @Column(name = "recv_addr_no", columnDefinition = "bigint(18) default null comment '收货地址ID'")
    private Long recvAddrNo;

    @ApiModelProperty("城市")
    @Column(name = "contract_city", columnDefinition = "varchar(40) comment '城市'")
    private String contractCity;

    @ApiModelProperty("收货详细地址")
    @Column(name = "recv_detailaddr", columnDefinition = "varchar(100) default null comment '收货详细地址'")
    private String recvDetailaddr;

    @ApiModelProperty("配送方式")
    @Column(name = "deliver_method", columnDefinition = "varchar(40) default null comment '配送方式'")
    private String deliverMethod;

    @ApiModelProperty("要求日期")
    @Column(name = "demand_timespan", columnDefinition = "datetime default null comment '要求日期'")
    private LocalDateTime demandTimespan;

    @ApiModelProperty("ED1")
    @Column(name = "ed1", columnDefinition = "datetime default null comment 'ED1'")
    private LocalDateTime ed1;

    @ApiModelProperty("ED2")
    @Column(name = "ed2", columnDefinition = "datetime default null comment 'ED2'")
    private LocalDateTime ed2;

    @ApiModelProperty("ED3")
    @Column(name = "ed3", columnDefinition = "datetime default null comment 'ED3'")
    private LocalDateTime ed3;

    @ApiModelProperty("EN1")
    @Column(name = "en1", columnDefinition = "decimal(20,8) default null comment 'EN1'")
    private BigDecimal en1;

    @ApiModelProperty("EN2")
    @Column(name = "en2", columnDefinition = "decimal(20,8) default null comment 'EN2'")
    private BigDecimal en2;

    @ApiModelProperty("EN3")
    @Column(name = "en3", columnDefinition = "decimal(20,8) default null comment 'EN3'")
    private BigDecimal en3;

    @ApiModelProperty("EN4")
    @Column(name = "en4", columnDefinition = "decimal(20,8) default null comment 'EN4'")
    private BigDecimal en4;

    @ApiModelProperty("EN5")
    @Column(name = "en5", columnDefinition = "decimal(20,8) default null comment 'EN5'")
    private BigDecimal en5;

    @ApiModelProperty("ES1")
    @Column(name = "es1", columnDefinition = "longtext default null comment 'ES1'")
    private String es1;

    @ApiModelProperty("ES2")
    @Column(name = "es2", columnDefinition = "longtext default null comment 'ES2'")
    private String es2;

    @ApiModelProperty("ES3")
    @Column(name = "es3", columnDefinition = "longtext default null comment 'ES3'")
    private String es3;

    @ApiModelProperty("ES4")
    @Column(name = "es4", columnDefinition = "longtext default null comment 'ES4'")
    private String es4;

    @ApiModelProperty("ES5")
    @Column(name = "es5", columnDefinition = "longtext default null comment 'ES5'")
    private String es5;

    @ApiModelProperty("ES6")
    @Column(name = "es6", columnDefinition = "longtext default null comment 'ES6'")
    private String es6;

    @ApiModelProperty("ES7")
    @Column(name = "es7", columnDefinition = "longtext default null comment 'ES7'")
    private String es7;

    @ApiModelProperty("ES8")
    @Column(name = "es8", columnDefinition = "longtext default null comment 'ES8'")
    private String es8;

    @ApiModelProperty("ES9")
    @Column(name = "es9", columnDefinition = "longtext default null comment 'ES9'")
    private String es9;

    @ApiModelProperty("ES10")
    @Column(name = "es10", columnDefinition = "longtext default null comment 'ES1'")
    private String es10;

    @ApiModelProperty("项目ID")
    @Column(name = "proj_id", columnDefinition = "bigint(18) default null comment '项目ID'")
    private Long projId;

    @ApiModelProperty("项目编号")
    @Column(name = "proj_no", columnDefinition = "varchar(40) default null comment '项目编号'")
    private String projNo;

    @ApiModelProperty("项目名称")
    @Column(name = "proj_name", columnDefinition = "varchar(200) default null comment '项目名称'")
    private String projName;

    /**
     * 审批流字段
     */
    @ApiModelProperty("流程实例ID")
    @Column
    @Comment("流程实例ID")
    private String procInstId;

    @ApiModelProperty("流程实例状态")
    @Column
    @Comment("流程实例状态")
    @Enumerated(EnumType.STRING)
    private ProcInstStatus procInstStatus;

    @ApiModelProperty(value = "提交时间")
    @Comment("提交时间")
    @Column
    private LocalDateTime submitTime;

    @ApiModelProperty(value = "审批通过时间")
    @Comment("审批通过时间")
    @Column
    private LocalDateTime approvedTime;
}
