package com.elitesland.yst.production.sale.entity;

import com.elitescloud.boot.model.entity.BaseModel;
import lombok.experimental.Accessors;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import lombok.Data;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import org.hibernate.annotations.Where;


/**
 * @author : WWW
 * @date : 2023-6-1
 * @desc : 销售业绩统计-经销商
 */

@Entity
@Table(name="sale_statistics_dealer")
@org.hibernate.annotations.Table(appliesTo = "sale_statistics_dealer", comment = "销售业绩统计-经销商")
@Data
@DynamicInsert
@DynamicUpdate
@Accessors(chain = true)
@Where(clause = "delete_flag = 0")
public class SaleStatisticsDealerDO extends BaseModel {


    /**
     * 统计时间
     */
    @Column(name = "doc_time", columnDefinition = "datetime(6) comment '统计时间'")
    private LocalDateTime docTime;

    /**
     * 经销商编码
     */
    @Column(name = "dealer_code", columnDefinition = "varchar(255) comment '经销商编码'")
    private String dealerCode;

    /**
     * 经销商名称
     */
    @Column(name = "dealer_name", columnDefinition = "varchar(255) comment '经销商名称'")
    private String dealerName;

    /**
     * 经销商客户号
     */
    @Column(name = "dealer_serial_no", columnDefinition = "varchar(255) comment '经销商客户号'")
    private String dealerSerialNo;

    /**
     * 区域
     */
    @Column(name = "region", columnDefinition = "varchar(255) comment '区域'")
    private String region;

    /**
     * 类型
     */
    @Column(name = "type", columnDefinition = "varchar(255) comment '类型'")
    private String type;

    /**
     * 业务员关系路径
     */
    @Column(name = "salesman_path", columnDefinition = "varchar(2000) comment '业务员关系路径'")
    private String salesmanPath;

    /**
     * 车型
     */
    @Column(name = "vehicle_type", columnDefinition = "varchar(255) comment '车型'")
    private String vehicleType;

    /**
     * 出货量
     */
    @Column(name = "ship_qty", columnDefinition = "decimal(18,2) comment '出货量'")
    private BigDecimal shipQty;

    /**
     * 订货量
     */
    @Column(name = "order_qty", columnDefinition = "decimal(18,2) comment '订货量'")
    private BigDecimal orderQty;

    /**
     * 客户类型
     */
    @Column(name = "cust_type", columnDefinition = "varchar(255) comment '客户类型'")
    private String custType;

    /**
     * 整车类型
     */
    @Column(name = "item_type3", columnDefinition = "varchar(255) comment '整车类型'")
    private String itemType3;

    /**
     * 更新区域失败原因
     */
    @Column(name = "update_region_failure_reason", columnDefinition = "varchar(2000) comment '更新区域失败原因'")
    private String updateRegionFailureReason;

    /**
     * 更新业务员失败原因
     */
    @Column(name = "update_salesman_failure_reason", columnDefinition = "varchar(2000) comment '更新业务员失败原因'")
    private String updateSalesmanFailureReason;
}

