package com.elitesland.yst.production.sale.event;

import org.springframework.context.ApplicationEvent;

/**
 * 商品销量变更事件.
 *
 * @author Kaiser（wang shao）
 * @date 2021/09/02
 */
public class ItemSaleChangeEvent extends ApplicationEvent {
    private static final long serialVersionUID = 877302982348816972L;

    /**
     * 商品ID
     */
    private final Long bipItemId;

    public ItemSaleChangeEvent(Object source, Long bipItemId) {
        super(source);
        this.bipItemId = bipItemId;
    }

    public Long getBipItemId() {
        return bipItemId;
    }
}
