package com.elitesland.yst.production.sale.event;

import org.springframework.context.ApplicationEvent;

/**
 * 商品库存变更事件.
 *
 * @author Kaiser（wang shao）
 * @date 2021/08/31
 */
public class ItemStockUpdateEvent extends ApplicationEvent {
    private static final long serialVersionUID = -6707393938366008872L;

    /**
     * 商品SKU ID
     */
    private final Long bipItemSkuId;

    /**
     * 是否是新增库存
     */
    private final Boolean increment;

    public ItemStockUpdateEvent(Object source, Long bipItemSkuId, Boolean increment) {
        super(source);
        this.bipItemSkuId = bipItemSkuId;
        this.increment = increment;
    }

    public Long getBipItemSkuId() {
        return bipItemSkuId;
    }

    public Boolean getIncrement() {
        return increment;
    }
}
