package com.elitesland.yst.production.sale.repo;

import com.elitesland.yst.production.sale.entity.CrmCustDO;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Modifying;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.querydsl.QuerydslPredicateExecutor;
import org.springframework.transaction.annotation.Transactional;

import java.util.List;

/**
 * .
 *
 * @author Kaiser（wang shao）
 * @date 2021-05-14
 */
public interface CrmCustRepo extends JpaRepository<CrmCustDO, Long>, QuerydslPredicateExecutor<CrmCustDO> {

    @Transactional//事务的注解
    @Modifying//增删改必须有这个注解
    @Query(value = "update crm_cust set agent_emp_id = ?1 where id in ?2", nativeQuery = true)
    void updateCustAgentEmp(Long id, List<Long> custIds);

    CrmCustDO findByCustCode(String custCode);
}
