package com.elitesland.yst.production.sale.repo;

import cn.hutool.core.collection.CollectionUtil;
import com.elitesland.yst.production.sale.api.vo.param.crm.CustAccountQueryParam;
import com.elitesland.yst.production.sale.api.vo.resp.crm.CustAccountVO;
import com.elitesland.yst.production.sale.entity.CustAccountDO;
import com.elitesland.yst.production.sale.entity.QCustAccountDO;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.core.types.QBean;
import com.querydsl.core.types.dsl.BooleanExpression;
import com.querydsl.jpa.impl.JPAQuery;
import com.querydsl.jpa.impl.JPAQueryFactory;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;

@Repository
public class CustAccountRepoProc {

    @Autowired
    private JPAQueryFactory jpaQueryFactory;

    @Autowired
    private CustAccountRepo custAccountRepo;

    private final QCustAccountDO qCustAccountDO = QCustAccountDO.custAccountDO;

    public CustAccountDO getByCustCode(String custCode) {
        BooleanExpression e = qCustAccountDO.custCode.eq(custCode).and(qCustAccountDO.deleteFlag.eq(0));
        Optional<CustAccountDO> optional = custAccountRepo.findOne(e);
        if (optional.isPresent()) {
            return optional.get();
        }
        return new CustAccountDO();
    }

    public CustAccountDO getByUserName(String userName) {
        BooleanExpression e = qCustAccountDO.userName.eq(userName).and(qCustAccountDO.deleteFlag.eq(0));
        Optional<CustAccountDO> optional = custAccountRepo.findOne(e);
        if (optional.isPresent()) {
            return optional.get();
        }
        return new CustAccountDO();
    }

    public CustAccountDO getByUserId(Long userId) {
        BooleanExpression e = qCustAccountDO.userId.eq(userId).and(qCustAccountDO.deleteFlag.eq(0));
        Optional<CustAccountDO> optional = custAccountRepo.findOne(e);
        if (optional.isPresent()) {
            return optional.get();
        }
        return new CustAccountDO();
    }

    public CustAccountDO getByMobileDo(String mobile) {
        BooleanExpression e = qCustAccountDO.mobile.eq(mobile).and(qCustAccountDO.deleteFlag.eq(0));
        Optional<CustAccountDO> optional = custAccountRepo.findOne(e);
        if (optional.isPresent()) {
            return optional.get();
        }
        return new CustAccountDO();
    }

    public CustAccountDO getByMobile(String mobile,List<String> custType) {
        BooleanExpression e = qCustAccountDO.mobile.eq(mobile).and(qCustAccountDO.dealerType.in(custType)).and(qCustAccountDO.deleteFlag.eq(0));
        Optional<CustAccountDO> optional = custAccountRepo.findOne(e);
        if (optional.isPresent()) {
            return optional.get();
        }
        return new CustAccountDO();
    }

    private final QBean<CustAccountVO> custAccountVOQBean = Projections.fields(
            CustAccountVO.class,
            qCustAccountDO.id,
            qCustAccountDO.custCode,
            qCustAccountDO.isOpenAccount,
            qCustAccountDO.createAccountTime,
            qCustAccountDO.balance,
            qCustAccountDO.mobile,
            qCustAccountDO.userName,
            qCustAccountDO.nickName,
            qCustAccountDO.pwd,
            qCustAccountDO.roleId,
            qCustAccountDO.userId,
            qCustAccountDO.roleCode,
            qCustAccountDO.tenantId,
            qCustAccountDO.updatePwdTime,
            qCustAccountDO.dealerType,
            qCustAccountDO.businessType,
            qCustAccountDO.subAcFlag,
            qCustAccountDO.accountType,
            qCustAccountDO.enable,
            qCustAccountDO.isModifyPwd,
            qCustAccountDO.createTime,
            qCustAccountDO.businessTypeCust
    );

    public CustAccountVO getAccountByCustCode(String custCode) {
        return jpaQueryFactory.select(custAccountVOQBean).from(qCustAccountDO)
                .where(qCustAccountDO.deleteFlag.eq(0).and(qCustAccountDO.custCode.eq(custCode)))
                .limit(1)
                .fetchOne();
    }

    public Object delSonAccount(List<Long> accountIds) {
        jpaQueryFactory.delete(qCustAccountDO)
                .where(qCustAccountDO.id.in(accountIds))
                .execute();
        return "SUCCESS";

    }

    public List<CustAccountVO> getAccountByUserNames(List<String> usernames) {
        return jpaQueryFactory.select(custAccountVOQBean).from(qCustAccountDO)
                .where(qCustAccountDO.deleteFlag.eq(0).and(qCustAccountDO.userName.in(usernames)))
                .fetch();
    }

    public List<CustAccountVO> getAccountByUserNamesAndSource(List<String> usernames,List<String> dealerTypes,String businessTypeCust) {
        return jpaQueryFactory.select(custAccountVOQBean).from(qCustAccountDO)
                .where(qCustAccountDO.deleteFlag.eq(0).and(qCustAccountDO.userName.in(usernames)).and(qCustAccountDO.dealerType.in(dealerTypes))
                        .and(qCustAccountDO.businessTypeCust.eq(businessTypeCust)))
                .fetch();
    }

    public List<CustAccountVO> getByCustCodesAndUserName(String custCode,String userName,List<String> dealerTypes) {
        return jpaQueryFactory.select(custAccountVOQBean).from(qCustAccountDO)
                .where(getAccountCust(custCode,userName,dealerTypes))
                .fetch();
    }

    public List<CustAccountVO> getAccountByCustCode(List<String> custCode) {
        return jpaQueryFactory.select(custAccountVOQBean).from(qCustAccountDO)
                .where(qCustAccountDO.deleteFlag.eq(0).and(qCustAccountDO.custCode.in(custCode)))
                .fetch();
    }



    public List<CustAccountVO> getByParentCustCode(String custCode) {
        return jpaQueryFactory.select(custAccountVOQBean).from(qCustAccountDO)
                .where(qCustAccountDO.deleteFlag.eq(0).and(qCustAccountDO.custCode.eq(custCode))
                        .and(qCustAccountDO.subAcFlag.eq(Boolean.FALSE)))
                .fetch();
    }

    public List<CustAccountVO> getAccountPage(CustAccountQueryParam param) {
        JPAQuery<CustAccountVO> vojpaQuery = jpaQueryFactory.select(custAccountVOQBean)
                .from(qCustAccountDO)
                .where(where(param));
        param.setPaging(vojpaQuery);
        param.fillOrders(vojpaQuery, qCustAccountDO);
        return vojpaQuery.fetch();
    }



    public CustAccountVO getAccountByUserName(String userName) {
        return jpaQueryFactory.select(custAccountVOQBean).from(qCustAccountDO)
                .where(qCustAccountDO.deleteFlag.eq(0).and(qCustAccountDO.userName.eq(userName))).limit(1)
                .fetchOne();
    }

    public CustAccountVO getAccountByMobile(String mobile) {
        return jpaQueryFactory.select(custAccountVOQBean).from(qCustAccountDO)
                .where(qCustAccountDO.deleteFlag.eq(0).and(qCustAccountDO.mobile.eq(mobile)).and(qCustAccountDO.dealerType.notEqualsIgnoreCase("STORE"))).limit(1)
                .fetchOne();
    }

    public CustAccountVO getAccountByMobileAndBusinessTypeCust(String mobile,String businessTypeCust) {
        return jpaQueryFactory.select(custAccountVOQBean).from(qCustAccountDO)
                .where(getAccountPredicate(mobile,businessTypeCust)).limit(1)
                .fetchOne();
    }


    private Predicate getAccountCust(String custCode,String userName,List<String> dealerTypes){
        List<Predicate> predicates = new ArrayList<>();
        predicates.add(qCustAccountDO.dealerType.notEqualsIgnoreCase("STORE"));
        if(StringUtils.isNotBlank(custCode)){
            predicates.add(qCustAccountDO.custCode.eq(custCode));
        }
        if(StringUtils.isNotBlank(userName)){
            predicates.add(qCustAccountDO.userName.eq(userName));
        }
        if(CollectionUtil.isNotEmpty(dealerTypes)){
            predicates.add(qCustAccountDO.dealerType.in(dealerTypes));
        }
        return ExpressionUtils.allOf(predicates);
    }
    private Predicate getAccountPredicate(String mobile,String businessTypeCust){
        List<Predicate> predicates = new ArrayList<>();
        predicates.add(qCustAccountDO.deleteFlag.eq(1));
        predicates.add(qCustAccountDO.dealerType.notEqualsIgnoreCase("STORE"));
        if (StringUtils.isNotBlank(mobile)) {
            predicates.add(qCustAccountDO.mobile.eq(mobile));
        }
        if (StringUtils.isNotBlank(businessTypeCust)) {
            predicates.add(qCustAccountDO.businessTypeCust.eq(businessTypeCust));
        }
        return ExpressionUtils.allOf(predicates);
    }

    public CustAccountVO getAccountByUserId(Long userId) {
        return jpaQueryFactory.select(custAccountVOQBean).from(qCustAccountDO)
                .where(qCustAccountDO.deleteFlag.eq(0).and(qCustAccountDO.userId.eq(userId))).limit(1)
                .fetchOne();
    }

    public long getAccountPageCount(CustAccountQueryParam param) {
        var jpaQuery = jpaQueryFactory.select(qCustAccountDO.count())
                .from(qCustAccountDO);
        jpaQuery.where(where(param));
        return jpaQuery.fetchCount();
    }


    public List<CustAccountVO> getAccountListByUserName(String userName) {
        return jpaQueryFactory.select(custAccountVOQBean).from(qCustAccountDO)
                .where(qCustAccountDO.deleteFlag.eq(0).and(qCustAccountDO.userName.eq(userName)).and(qCustAccountDO.isOpenAccount.eq(Boolean.TRUE)))
                .fetch();
    }

    public Boolean exists(String userName, Long id,String source) {
        Predicate predicate = qCustAccountDO.deleteFlag.eq(0).or(qCustAccountDO.deleteFlag.isNull());
        predicate = ObjectUtils.isEmpty(userName) ? predicate : ExpressionUtils.and(predicate, qCustAccountDO.userName.eq(userName));
        predicate = ObjectUtils.isEmpty(id) ? predicate : ExpressionUtils.and(predicate, qCustAccountDO.id.ne(id));
        if(source.equals("CUST")){
            predicate = ExpressionUtils.and(predicate, qCustAccountDO.dealerType.ne("STORE"));
        }
        predicate = ObjectUtils.isEmpty(id) ? predicate : ExpressionUtils.and(predicate, qCustAccountDO.id.ne(id));
        return jpaQueryFactory.select(qCustAccountDO)
                .from(qCustAccountDO)
                .where(predicate)
                .fetchCount() > 0;
    }

    public Boolean existsMobile(String mobile, Long id,String source) {
        Predicate predicate = qCustAccountDO.deleteFlag.eq(0).or(qCustAccountDO.deleteFlag.isNull());
        predicate = ObjectUtils.isEmpty(mobile) ? predicate : ExpressionUtils.and(predicate, qCustAccountDO.mobile.eq(mobile));
        predicate = ObjectUtils.isEmpty(id) ? predicate : ExpressionUtils.and(predicate, qCustAccountDO.id.ne(id));
        if(source.equals("CUST")){
            predicate = ExpressionUtils.and(predicate, qCustAccountDO.dealerType.ne("STORE"));
        }
        predicate = ObjectUtils.isEmpty(id) ? predicate : ExpressionUtils.and(predicate, qCustAccountDO.id.ne(id));
        return jpaQueryFactory.select(qCustAccountDO)
                .from(qCustAccountDO)
                .where(predicate)
                .fetchCount() > 0;
    }

    public Boolean existsMobile2(String mobile, Long id,String source,String businessTypeCust) {
        Predicate predicate = qCustAccountDO.deleteFlag.eq(0).or(qCustAccountDO.deleteFlag.isNull());
        predicate = ObjectUtils.isEmpty(mobile) ? predicate : ExpressionUtils.and(predicate, qCustAccountDO.mobile.eq(mobile));
        predicate = ObjectUtils.isEmpty(id) ? predicate : ExpressionUtils.and(predicate, qCustAccountDO.id.ne(id));
        predicate = ExpressionUtils.and(predicate, qCustAccountDO.dealerType.ne("STORE"));
        predicate = ObjectUtils.isEmpty(id) ? predicate : ExpressionUtils.and(predicate, qCustAccountDO.id.ne(id));
        predicate = ObjectUtils.isEmpty(businessTypeCust) ? predicate : ExpressionUtils.and(predicate,qCustAccountDO.businessTypeCust.eq(businessTypeCust));
        return jpaQueryFactory.select(qCustAccountDO)
                .from(qCustAccountDO)
                .where(predicate)
                .fetchCount() > 0;
    }


    public Boolean exists1(String userName, String custCode,String source,String businessTypeCust) {
        Predicate predicate = qCustAccountDO.deleteFlag.eq(0).or(qCustAccountDO.deleteFlag.isNull());
        predicate = ObjectUtils.isEmpty(userName) ? predicate : ExpressionUtils.and(predicate, qCustAccountDO.mobile.eq(userName));
        predicate = ObjectUtils.isEmpty(custCode) ? predicate : ExpressionUtils.and(predicate, qCustAccountDO.custCode.ne(custCode));
        predicate = ObjectUtils.isEmpty(businessTypeCust) ? predicate : ExpressionUtils.and(predicate,qCustAccountDO.businessTypeCust.eq(businessTypeCust));
        if(source.equals("CUST")){
            predicate = ExpressionUtils.and(predicate, qCustAccountDO.dealerType.ne("STORE"));
        }
        return jpaQueryFactory.select(qCustAccountDO)
                .from(qCustAccountDO)
                .where(predicate)
                .fetchCount() > 0;
    }

    public Boolean existsCustAccount(String mobile, Long id,String source) {
        Predicate predicate = qCustAccountDO.deleteFlag.eq(0).or(qCustAccountDO.deleteFlag.isNull());
        predicate = ObjectUtils.isEmpty(mobile) ? predicate : ExpressionUtils.and(predicate, qCustAccountDO.mobile.eq(mobile));
        predicate = ObjectUtils.isEmpty(id) ? predicate : ExpressionUtils.and(predicate, qCustAccountDO.id.ne(id));
        if(source.equals("CUST")){
            predicate = ExpressionUtils.and(predicate, qCustAccountDO.dealerType.ne("STORE"));
        }
        predicate = ObjectUtils.isEmpty(id) ? predicate : ExpressionUtils.and(predicate, qCustAccountDO.id.ne(id));
        return jpaQueryFactory.select(qCustAccountDO)
                .from(qCustAccountDO)
                .where(predicate)
                .fetchCount() > 0;
    }



    public void saveAccountCust(String custCode, CustAccountVO custAccountVO) {
        CustAccountDO custAccountDO = new CustAccountDO();
        BeanUtils.copyProperties(custAccountVO, custAccountDO);
        custAccountDO.setCustCode(custCode);
        custAccountRepo.save(custAccountDO);
    }

    private Predicate where(CustAccountQueryParam param) {
        Predicate predicate = qCustAccountDO.isNotNull();

        // 任务编码
        if (!ObjectUtils.isEmpty(param.getCustCode())) {
            predicate = ExpressionUtils.and(predicate, qCustAccountDO.custCode.eq(param.getCustCode()));
        }

        if (!ObjectUtils.isEmpty(param.getKeyword())) {
            predicate = ExpressionUtils.and(predicate, qCustAccountDO.nickName.like("%"+param.getKeyword()+"%")
                                        .or(qCustAccountDO.mobile.like("%"+param.getKeyword()+"%")));
        }
        predicate = ExpressionUtils.and(predicate, qCustAccountDO.subAcFlag.eq(Boolean.TRUE));

        return predicate;
    }


}
